/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.event;

import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.UITreeOld;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.model.TreeState;

public class DefaultTreeActionListener
implements ActionListener {
    private static final Log LOG;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$event$DefaultTreeActionListener;

    protected DefaultMutableTreeNode create(FacesContext facesContext) {
        String label = ResourceManagerUtil.getPropertyNotNull(facesContext, "tobago", "treeNodeNew");
        return new DefaultMutableTreeNode(label);
    }

    protected DefaultMutableTreeNode copy(DefaultMutableTreeNode node) {
        return new DefaultMutableTreeNode(node.getUserObject());
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIComponent component = actionEvent.getComponent().getParent();
        if (component instanceof UIPanel) {
            component = component.getParent();
        }
        if (!(component instanceof UITreeOld)) {
            LOG.error((Object)"No tree found!");
            return;
        }
        UITreeOld tree = (UITreeOld)component;
        TreeState treeState = tree.getState();
        DefaultMutableTreeNode marker = treeState.getMarker();
        String command = actionEvent.getComponent().getId();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("marker      " + marker));
            LOG.debug((Object)("lastMarker  " + treeState.getLastMarker()));
            LOG.debug((Object)("root        " + tree.getValue()));
            LOG.debug((Object)("command     " + command));
            LOG.debug((Object)("lastCommand " + treeState.getLastCommand()));
        }
        if (marker != null) {
            boolean isRoot = tree.getValue().equals(marker);
            if ("new".equals(command)) {
                treeState.commandNew(this.create(facesContext));
            } else if ("delete".equals(command)) {
                if (!isRoot) {
                    marker.removeFromParent();
                }
                treeState.setLastMarker(null);
                treeState.setLastCommand(null);
            } else if ("cut".equals(command)) {
                if (!isRoot) {
                    treeState.setLastMarker(marker);
                    treeState.setLastCommand(command);
                }
            } else if ("copy".equals(command)) {
                treeState.setLastMarker(marker);
                treeState.setLastCommand(command);
            } else if ("paste".equals(command)) {
                if (treeState.getLastMarker() != null) {
                    if ("cut".equals(treeState.getLastCommand())) {
                        marker.insert(treeState.getLastMarker(), 0);
                    } else if ("copy".equals(treeState.getLastCommand())) {
                        marker.insert(this.copy(treeState.getLastMarker()), 0);
                    }
                    treeState.setLastMarker(null);
                    treeState.setLastCommand(null);
                }
            } else if ("moveUp".equals(command)) {
                if (!isRoot) {
                    DefaultMutableTreeNode node = marker;
                    MutableTreeNode parent = (MutableTreeNode)node.getParent();
                    int index = parent.getIndex(node);
                    index = Math.max(index - 1, 0);
                    parent.insert(node, index);
                }
                treeState.setLastMarker(null);
                treeState.setLastCommand(null);
            } else if ("moveDown".equals(command)) {
                if (!isRoot) {
                    DefaultMutableTreeNode node = marker;
                    MutableTreeNode parent = (MutableTreeNode)node.getParent();
                    int index = parent.getIndex(node);
                    index = Math.min(index + 1, parent.getChildCount() - 1);
                    parent.insert(node, index);
                }
                treeState.setLastMarker(null);
                treeState.setLastCommand(null);
            }
        }
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$event$DefaultTreeActionListener;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$event$DefaultTreeActionListener = new DefaultTreeActionListener[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }
}

