/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.component.UIViewRoot;
import javax.faces.render.Renderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.context.ResourceManager;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.UserAgent;
import org.apache.myfaces.tobago.renderkit.RendererBase;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceManagerImpl
implements ResourceManager {
    private static final Log LOG;
    private static final String PROPERTY = "property";
    private static final String JSP = "jsp";
    private static final String TAG = "tag";
    private static final Renderer NULL_CACHE_RENDERER;
    private final HashMap<String, String> resourceList;
    private final Map<RendererCacheKey, Renderer> rendererCache = new ConcurrentHashMap(100, 0.75f, 1);
    private final Map<ImageCacheKey, String> imageCache = new ConcurrentHashMap(100, 0.75f, 1);
    private final Map<JspCacheKey, String> jspCache = new ConcurrentHashMap(100, 0.75f, 1);
    private final Map<MiscCacheKey, String[]> miscCache = new ConcurrentHashMap(100, 0.75f, 1);
    private final Map<PropertyCacheKey, CachedString> propertyCache = new ConcurrentHashMap(100, 0.75f, 1);
    private TobagoConfig tobagoConfig;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$context$ResourceManagerImpl;

    public ResourceManagerImpl(TobagoConfig tobagoConfig) {
        this.resourceList = new HashMap();
        this.tobagoConfig = tobagoConfig;
    }

    public void add(String resourceKey) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)new StringBuffer().append("adding resourceKey = '").append(resourceKey).append("'").toString());
        }
        this.resourceList.put(resourceKey, "");
    }

    public void add(String resourceKey, String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)new StringBuffer().append("adding resourceKey = '").append(resourceKey).append("' value='").append(value).append("'").toString());
        }
        this.resourceList.put(resourceKey, value);
    }

    @Override
    public String getImage(UIViewRoot viewRoot, String name) {
        return this.getImage(viewRoot, name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getImage(UIViewRoot viewRoot, String name, boolean ignoreMissing) {
        String result = null;
        if (name != null) {
            CacheKey key;
            ImageCacheKey imageKey;
            int dot = name.lastIndexOf(46);
            if (dot == -1) {
                dot = name.length();
            }
            if ((result = this.imageCache.get(imageKey = new ImageCacheKey(key = this.getCacheKey(viewRoot), name))) == null) {
                try {
                    List paths = this.getPaths(key.getClientPropertyId(), key.getLocale(), "", null, name.substring(0, dot), name.substring(dot), false, true, true, null, true, ignoreMissing);
                    result = paths != null ? (String)paths.get(0) : "";
                    Map<ImageCacheKey, String> map = this.imageCache;
                    synchronized (map) {
                        this.imageCache.put(imageKey, result);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)new StringBuffer().append("name = '").append(name).append("' clientProperties = '").append(key.getClientPropertyId()).append("'").toString(), (Throwable)e);
                }
            }
        }
        if (result == null || result.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)new StringBuffer().append("Can't find image for \"").append(name).append("\"").toString());
            }
            return null;
        }
        return result;
    }

    private CacheKey getCacheKey(UIViewRoot viewRoot) {
        CacheKey key;
        if (viewRoot instanceof org.apache.myfaces.tobago.component.UIViewRoot) {
            key = ((org.apache.myfaces.tobago.component.UIViewRoot)viewRoot).getRendererCacheKey();
        } else {
            String clientPropertyId = ClientProperties.getInstance(viewRoot).getId();
            Locale locale = viewRoot.getLocale();
            key = new CacheKey(clientPropertyId, locale);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJsp(UIViewRoot viewRoot, String name) {
        String result = null;
        if (name != null) {
            CacheKey key = this.getCacheKey(viewRoot);
            JspCacheKey jspKey = new JspCacheKey(key, name);
            result = this.jspCache.get(jspKey);
            if (result == null) {
                try {
                    result = (String)this.getPaths(key.getClientPropertyId(), key.getLocale(), "", JSP, name, "", false, true, true, null, true, false).get(0);
                    Map<JspCacheKey, String> map = this.jspCache;
                    synchronized (map) {
                        this.jspCache.put(jspKey, result);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)new StringBuffer().append("name = '").append(name).append("' clientProperties = '").append(key.getClientPropertyId()).append("'").toString(), (Throwable)e);
                }
            }
            if (result != null && result.length() == 0) {
                return null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProperty(UIViewRoot viewRoot, String bundle, String propertyKey) {
        if (bundle != null && propertyKey != null) {
            CacheKey key = this.getCacheKey(viewRoot);
            PropertyCacheKey propertyCacheKey = new PropertyCacheKey(key, bundle, propertyKey);
            CachedString result = this.propertyCache.get(propertyCacheKey);
            if (result == null) {
                List properties = this.getPaths(key.getClientPropertyId(), key.getLocale(), "", PROPERTY, bundle, "", false, true, false, propertyKey, true, false);
                result = properties != null ? new CachedString((String)properties.get(0)) : new CachedString(null);
                Map<PropertyCacheKey, CachedString> map = this.propertyCache;
                synchronized (map) {
                    this.propertyCache.put(propertyCacheKey, result);
                }
            }
            return result.getValue();
        }
        return null;
    }

    private List getPaths(String clientProperties, Locale locale, String prefix, String subDir, String name, String suffix, boolean reverseOrder, boolean single, boolean returnKey, String key, boolean returnStrings, boolean ignoreMissing) {
        ArrayList matches = new ArrayList();
        StringTokenizer tokenizer = new StringTokenizer(clientProperties, "/");
        String contentType = tokenizer.nextToken();
        Theme theme = this.tobagoConfig.getTheme(tokenizer.nextToken());
        UserAgent browser = UserAgent.getInstanceForId(tokenizer.nextToken());
        List<String> locales = ClientProperties.getLocaleList(locale, false);
        if (this.tobagoConfig.isFixResourceOrder() && this.getLocalPaths(prefix, name, suffix, reverseOrder, single, returnKey, key, returnStrings, matches, locales)) {
            return matches;
        }
        for (Theme themeName : theme.getFallbackList()) {
            for (String resourceDirectory : this.tobagoConfig.getResourceDirs()) {
                for (String browserType : browser.getFallbackList()) {
                    for (String localeSuffix : locales) {
                        String path = this.makePath(resourceDirectory, contentType, themeName, browserType, subDir, name, localeSuffix, suffix, key);
                        if (!this.checkPath(prefix, reverseOrder, single, returnKey, returnStrings, matches, path)) continue;
                        return matches;
                    }
                }
            }
        }
        if (!this.tobagoConfig.isFixResourceOrder() && this.getLocalPaths(prefix, name, suffix, reverseOrder, single, returnKey, key, returnStrings, matches, locales)) {
            return matches;
        }
        if (matches.isEmpty()) {
            if (!ignoreMissing) {
                LOG.error((Object)new StringBuffer().append("Path not found, and no fallback. Using empty string.\nresourceDirs = '").append(this.tobagoConfig.getResourceDirs()).append("' contentType = '").append(contentType).append("' theme = '").append(theme).append("' browser = '").append(browser).append("' subDir = '").append(subDir).append("' name = '").append(name).append("' suffix = '").append(suffix).append("' key = '").append(key).append("'").toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Show stacktrace", (Throwable)new Exception());
                }
            }
            return null;
        }
        return matches;
    }

    private boolean getLocalPaths(String prefix, String name, String suffix, boolean reverseOrder, boolean single, boolean returnKey, String key, boolean returnStrings, List matches, List<String> locales) {
        for (String localeSuffix : locales) {
            String path = this.makePath(name, localeSuffix, suffix, key);
            if (!this.checkPath(prefix, reverseOrder, single, returnKey, returnStrings, matches, path)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkPath(String prefix, boolean reverseOrder, boolean single, boolean returnKey, boolean returnStrings, List matches, String path) {
        if (returnStrings && this.resourceList.containsKey(path)) {
            String result;
            String string = result = returnKey ? new StringBuffer().append(prefix).append(path).toString() : new StringBuffer().append(prefix).append(this.resourceList.get(path)).toString();
            if (reverseOrder) {
                matches.add(0, result);
            } else {
                matches.add(result);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)new StringBuffer().append("testing path: ").append(path).append(" *").toString());
            }
            if (!single) return false;
            return true;
        }
        if (!returnStrings) {
            try {
                path = path.substring(1).replace('/', '.');
                Class<?> clazz = Class.forName(path);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)new StringBuffer().append("testing path: ").append(path).append(" *").toString());
                }
                matches.add(clazz);
                return true;
            }
            catch (ClassNotFoundException e) {
                if (!LOG.isDebugEnabled()) return false;
                LOG.debug((Object)new StringBuffer().append("testing path: ").append(path).toString());
                return false;
            }
        } else {
            if (!LOG.isDebugEnabled()) return false;
            LOG.debug((Object)new StringBuffer().append("testing path: ").append(path).toString());
        }
        return false;
    }

    private String makePath(String project, String language, Theme theme, String browser, String subDir, String name, String localeSuffix, String extension, String key) {
        StringBuffer searchtext = new StringBuffer(64);
        searchtext.append('/');
        searchtext.append(project);
        searchtext.append('/');
        searchtext.append(language);
        searchtext.append('/');
        searchtext.append(theme.getName());
        searchtext.append('/');
        searchtext.append(browser);
        if (subDir != null) {
            searchtext.append('/');
            searchtext.append(subDir);
        }
        searchtext.append('/');
        searchtext.append(name);
        searchtext.append(localeSuffix);
        searchtext.append(extension);
        if (key != null) {
            searchtext.append('/');
            searchtext.append(key);
        }
        return searchtext.toString();
    }

    private String makePath(String name, String localeSuffix, String extension, String key) {
        StringBuffer searchtext = new StringBuffer(32);
        searchtext.append('/');
        searchtext.append(name);
        searchtext.append(localeSuffix);
        searchtext.append(extension);
        if (key != null) {
            searchtext.append('/');
            searchtext.append(key);
        }
        return searchtext.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Renderer getRenderer(UIViewRoot viewRoot, String name) {
        CacheKey key;
        RendererCacheKey rendererKey;
        Renderer renderer = null;
        if (name != null && (renderer = this.rendererCache.get(rendererKey = new RendererCacheKey(key = this.getCacheKey(viewRoot), name))) == null) {
            try {
                name = this.getRendererClassName(name);
                List classes = this.getPaths(key.getClientPropertyId(), key.getLocale(), "", TAG, name, "", false, true, true, null, false, false);
                if (classes != null && !classes.isEmpty()) {
                    Class clazz = (Class)classes.get(0);
                    renderer = (Renderer)clazz.newInstance();
                } else {
                    renderer = NULL_CACHE_RENDERER;
                    LOG.error((Object)new StringBuffer().append("Don't find any RendererClass for ").append(name).append(". Please check you configuration.").toString());
                }
                Map<RendererCacheKey, Renderer> map = this.rendererCache;
                synchronized (map) {
                    this.rendererCache.put(rendererKey, renderer);
                }
            }
            catch (InstantiationException e) {
                LOG.error((Object)new StringBuffer().append("name = '").append(name).append("' clientProperties = '").append(key.getClientPropertyId()).append("'").toString(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)new StringBuffer().append("name = '").append(name).append("' clientProperties = '").append(key.getClientPropertyId()).append("'").toString(), (Throwable)e);
            }
            if (renderer == NULL_CACHE_RENDERER) {
                return null;
            }
        }
        return renderer;
    }

    private String getRendererClassName(String rendererType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)new StringBuffer().append("rendererType = '").append(rendererType).append("'").toString());
        }
        String name = "javax.faces.Text".equals(rendererType) ? "Out" : rendererType;
        if ((name = new StringBuffer().append(name).append("Renderer").toString()).startsWith("javax.faces.")) {
            LOG.warn((Object)new StringBuffer().append("patching renderer from ").append(name).toString());
            name = name.substring("javax.faces.".length());
            LOG.warn((Object)new StringBuffer().append("patching renderer to   ").append(name).toString());
        }
        return name;
    }

    @Override
    public String[] getScripts(UIViewRoot viewRoot, String name) {
        return this.getStrings(viewRoot, name, null);
    }

    @Override
    public String[] getStyles(UIViewRoot viewRoot, String name) {
        return this.getStrings(viewRoot, name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getStrings(UIViewRoot viewRoot, String name, String type) {
        String[] result = null;
        if (name != null) {
            CacheKey key;
            MiscCacheKey miscKey;
            int dot = name.lastIndexOf(46);
            if (dot == -1) {
                dot = name.length();
            }
            if ((result = this.miscCache.get(miscKey = new MiscCacheKey(key = this.getCacheKey(viewRoot), name))) == null) {
                try {
                    List matches = this.getPaths(key.getClientPropertyId(), key.getLocale(), "", type, name.substring(0, dot), name.substring(dot), true, false, true, null, true, false);
                    result = matches.toArray(new String[matches.size()]);
                    Map<MiscCacheKey, String[]> map = this.miscCache;
                    synchronized (map) {
                        this.miscCache.put(miscKey, result);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)new StringBuffer().append("name = '").append(name).append("' clientProperties = '").append(key.getClientPropertyId()).append("'").toString(), (Throwable)e);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getThemeProperty(UIViewRoot viewRoot, String bundle, String propertyKey) {
        if (bundle != null && propertyKey != null) {
            CacheKey key = this.getCacheKey(viewRoot);
            PropertyCacheKey propertyCacheKey = new PropertyCacheKey(key, bundle, propertyKey);
            CachedString result = this.propertyCache.get(propertyCacheKey);
            if (result == null) {
                List properties = this.getPaths(key.getClientPropertyId(), key.getLocale(), "", PROPERTY, bundle, "", false, true, false, propertyKey, true, true);
                result = properties != null ? new CachedString((String)properties.get(0)) : new CachedString(null);
                Map<PropertyCacheKey, CachedString> map = this.propertyCache;
                synchronized (map) {
                    this.propertyCache.put(propertyCacheKey, result);
                }
            }
            return result.getValue();
        }
        return null;
    }

    public static CacheKey getRendererCacheKey(String clientPropertyId, Locale locale) {
        return new CacheKey(clientPropertyId, locale);
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$context$ResourceManagerImpl;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$context$ResourceManagerImpl = new ResourceManagerImpl[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
        NULL_CACHE_RENDERER = new RendererBase();
    }

    public static final class CachedString {
        private String value;

        public CachedString(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedString that = (CachedString)o;
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }

    public static final class CacheKey {
        private final String clientPropertyId;
        private final Locale locale;
        private final int hashCode;

        private CacheKey(String clientPropertyId, Locale locale) {
            this.clientPropertyId = clientPropertyId;
            if (locale == null) {
                LOG.warn((Object)"locale == null");
                locale = Locale.getDefault();
            }
            this.locale = locale;
            this.hashCode = this.calcHashCode();
        }

        public String getClientPropertyId() {
            return this.clientPropertyId;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.clientPropertyId.equals(cacheKey.clientPropertyId) && this.locale.equals(cacheKey.locale);
        }

        private int calcHashCode() {
            int result = this.clientPropertyId.hashCode();
            result = 31 * result + this.locale.hashCode();
            return result;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.clientPropertyId + " + " + this.locale;
        }
    }

    private static final class RendererCacheKey {
        private final CacheKey cacheKey;
        private final String name;
        private final int hashCode;

        private RendererCacheKey(CacheKey cacheKey, String name) {
            this.cacheKey = cacheKey;
            this.name = name;
            this.hashCode = this.calcHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RendererCacheKey that = (RendererCacheKey)o;
            return this.cacheKey.equals(that.cacheKey) && this.name.equals(that.name);
        }

        private int calcHashCode() {
            int result = this.cacheKey.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static final class MiscCacheKey {
        private final CacheKey cacheKey;
        private final String name;
        private final int hashCode;

        private MiscCacheKey(CacheKey cacheKey, String name) {
            this.cacheKey = cacheKey;
            this.name = name;
            this.hashCode = this.calcHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MiscCacheKey that = (MiscCacheKey)o;
            return this.cacheKey.equals(that.cacheKey) && this.name.equals(that.name);
        }

        private int calcHashCode() {
            int result = this.cacheKey.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static final class PropertyCacheKey {
        private final CacheKey cacheKey;
        private final String name;
        private final String key;
        private final int hashCode;

        private PropertyCacheKey(CacheKey cacheKey, String name, String key) {
            this.cacheKey = cacheKey;
            this.name = name;
            this.key = key;
            this.hashCode = this.calcHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyCacheKey that = (PropertyCacheKey)o;
            return this.cacheKey.equals(that.cacheKey) && this.key.equals(that.key) && this.name.equals(that.name);
        }

        private int calcHashCode() {
            int result = this.cacheKey.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.key.hashCode();
            return result;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static final class JspCacheKey {
        private final CacheKey cacheKey;
        private final String name;
        private final int hashCode;

        private JspCacheKey(CacheKey cacheKey, String name) {
            this.cacheKey = cacheKey;
            this.name = name;
            this.hashCode = this.calcHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JspCacheKey that = (JspCacheKey)o;
            return this.cacheKey.equals(that.cacheKey) && this.name.equals(that.name);
        }

        private int calcHashCode() {
            int result = this.cacheKey.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static final class ImageCacheKey {
        private CacheKey cacheKey;
        private String name;
        private int hashCode;

        private ImageCacheKey(CacheKey cacheKey, String name) {
            this.name = name;
            this.cacheKey = cacheKey;
            this.hashCode = this.calcHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageCacheKey that = (ImageCacheKey)o;
            return this.cacheKey.equals(that.cacheKey) && this.name.equals(that.name);
        }

        private int calcHashCode() {
            int result = this.cacheKey.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.cacheKey + " + " + this.name;
        }
    }
}

