/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import net.sf.retrotranslator.runtime.java.lang._String;
import net.sf.retrotranslator.runtime.java.net._URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.context.ResourceManagerImpl;
import org.apache.myfaces.tobago.context.ThemeBuilder;
import org.apache.myfaces.tobago.context.ThemeImpl;
import org.apache.myfaces.tobago.context.ThemeParser;
import org.apache.myfaces.tobago.util.XmlUtils;
import org.xml.sax.SAXException;

class ResourceLocator {
    private static final Log LOG;
    private static final String META_INF_TOBAGO_THEME_XML = "META-INF/tobago-theme.xml";
    private static final String META_INF_RESOURCES = "META-INF/resources";
    private ServletContext servletContext;
    private ResourceManagerImpl resourceManager;
    private ThemeBuilder themeBuilder;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$context$ResourceLocator;

    public ResourceLocator(ServletContext servletContext, ResourceManagerImpl resourceManager, ThemeBuilder themeBuilder) {
        this.servletContext = servletContext;
        this.resourceManager = resourceManager;
        this.themeBuilder = themeBuilder;
    }

    public void locate() throws ServletException {
        this.locateResourcesInWar(this.servletContext, this.resourceManager, "/");
        this.locateResourcesFromClasspath(this.resourceManager);
        this.locateResourcesServlet30Alike(this.resourceManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void locateResourcesInWar(ServletContext servletContext, ResourceManagerImpl resources, String path) throws ServletException {
        Set resourcePaths;
        if (path.startsWith("/WEB-INF/")) {
            return;
        }
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        if ((resourcePaths = servletContext.getResourcePaths(path)) == null || resourcePaths.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Skipping empty resource path: path='" + path + "'"));
            }
            return;
        }
        Iterator i$ = resourcePaths.iterator();
        while (i$.hasNext()) {
            InputStream inputStream;
            String childPath = (String)i$.next();
            if (childPath.endsWith("/")) {
                if (childPath.equals(path)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("childPath dir " + childPath));
                }
                this.locateResourcesInWar(servletContext, resources, childPath);
                continue;
            }
            if (childPath.endsWith(".properties")) {
                inputStream = servletContext.getResourceAsStream(childPath);
                try {
                    this.addProperties(inputStream, resources, childPath, false, 0);
                    continue;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                    continue;
                }
            }
            if (childPath.endsWith(".properties.xml")) {
                inputStream = servletContext.getResourceAsStream(childPath);
                try {
                    this.addProperties(inputStream, resources, childPath, true, 0);
                    continue;
                }
                catch (RuntimeException e) {
                    LOG.error((Object)("childPath = \"" + childPath + "\" "), (Throwable)e);
                    throw e;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                    continue;
                }
            }
            resources.add(childPath);
        }
    }

    private void locateResourcesFromClasspath(ResourceManagerImpl resources) throws ServletException {
        ThemeParser parser = new ThemeParser();
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Searching for META-INF/tobago-theme.xml");
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> urls = classLoader.getResources(META_INF_TOBAGO_THEME_XML);
            while (urls.hasMoreElements()) {
                URL themeUrl = urls.nextElement();
                ThemeImpl theme = parser.parse(themeUrl);
                this.themeBuilder.addTheme(theme);
                String prefix = this.ensureSlash(theme.getResourcePath());
                String protocol = themeUrl.getProtocol();
                if (!("jar".equals(protocol) || "zip".equals(protocol) || "wsjar".equals(protocol))) {
                    LOG.warn((Object)("Unknown protocol '" + themeUrl + "'"));
                }
                this.addResources(resources, themeUrl, prefix, 0);
            }
        }
        catch (IOException e) {
            String msg = "while loading ";
            LOG.error((Object)msg, (Throwable)e);
            throw new ServletException(msg, (Throwable)e);
        }
        catch (SAXException e) {
            String msg = "while loading ";
            LOG.error((Object)msg, (Throwable)e);
            throw new ServletException(msg, (Throwable)e);
        }
    }

    private void locateResourcesServlet30Alike(ResourceManagerImpl resources) throws ServletException {
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Searching for META-INF/resources");
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> urls = classLoader.getResources(META_INF_RESOURCES);
            while (urls.hasMoreElements()) {
                URL resourcesUrl = urls.nextElement();
                LOG.info((Object)("resourcesUrl='" + resourcesUrl + "'"));
                if (!resourcesUrl.toString().matches(".*/WEB-INF/lib/.*\\.jar\\!.*")) {
                    LOG.info((Object)"skip ...");
                    continue;
                }
                LOG.info((Object)"going on ...");
                String protocol = resourcesUrl.getProtocol();
                if (!("jar".equals(protocol) || "zip".equals(protocol) || "wsjar".equals(protocol))) {
                    LOG.warn((Object)("Unknown protocol '" + resourcesUrl + "'"));
                }
                this.addResources(resources, resourcesUrl, "/META-INF/resources", META_INF_RESOURCES.length() + 1);
            }
        }
        catch (IOException e) {
            String msg = "while loading ";
            LOG.error((Object)msg, (Throwable)e);
            throw new ServletException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addResources(ResourceManagerImpl resources, URL themeUrl, String prefix, int skipPrefix) throws IOException, ServletException {
        URL jarFile;
        String fileName = themeUrl.toString();
        int index = fileName.indexOf("!");
        String protocol = themeUrl.getProtocol();
        if (index != -1) {
            fileName = fileName.substring(protocol.length() + 1, index);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Adding resources from fileName='" + fileName + "' prefix='" + prefix + "' skip=" + skipPrefix + ""));
        }
        if (!protocol.equals("vfszip") && fileName.endsWith(META_INF_TOBAGO_THEME_XML)) {
            try {
                URI uri = _URL.toURI((URL)themeUrl);
                File tobagoThemeXml = new File(uri);
                File directoryFile = tobagoThemeXml.getParentFile().getParentFile();
                String resourcePath = "";
                this.resolveTheme(resources, directoryFile, resourcePath, prefix, false);
                return;
            }
            catch (URISyntaxException e) {
                LOG.error((Object)"", (Throwable)e);
            }
            return;
        }
        try {
            if (protocol.equals("vfszip")) {
                fileName = new File(fileName).getParentFile().getParentFile().getPath();
                if (File.separatorChar == '\\' && _String.contains((String)fileName, (CharSequence)"\\")) {
                    fileName = fileName.replace('\\', '/');
                    LOG.info((Object)("Fixed slashes for virtual filesystem protocol on windows system: " + fileName));
                }
            }
            jarFile = new URL(fileName);
        }
        catch (MalformedURLException e) {
            jarFile = new URL("file:" + fileName);
        }
        InputStream stream = null;
        ZipInputStream zipStream = null;
        try {
            stream = jarFile.openStream();
            zipStream = new ZipInputStream(stream);
            while (zipStream.available() > 0) {
                String name;
                ZipEntry nextEntry = zipStream.getNextEntry();
                if (nextEntry == null || nextEntry.isDirectory() || !(name = "/" + nextEntry.getName()).startsWith(prefix)) continue;
                this.addResource(resources, name, skipPrefix);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)stream);
            IOUtils.closeQuietly(zipStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
        IOUtils.closeQuietly((InputStream)zipStream);
    }

    private void resolveTheme(ResourceManagerImpl resources, File directoryFile, String resourcePath, String prefix, boolean inResourcePath) throws ServletException {
        File[] files;
        File[] arr$ = files = directoryFile.listFiles();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            File file = arr$[i$];
            if (file.isDirectory()) {
                String currentResourcePath = resourcePath + File.separator + file.getName();
                if (!inResourcePath && currentResourcePath.startsWith(prefix)) {
                    inResourcePath = true;
                }
                this.resolveTheme(resources, file, currentResourcePath, prefix, inResourcePath);
                continue;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(resourcePath + File.separator + file.getName()));
            }
            if (!inResourcePath) continue;
            this.addResource(resources, resourcePath + File.separator + file.getName(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResource(ResourceManagerImpl resources, String name, int skipPrefix) throws ServletException {
        if (!name.endsWith(".class")) {
            if (name.endsWith(".properties")) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Adding properties from: '" + name.substring(1) + "'"));
                }
                InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(name.substring(1));
                try {
                    this.addProperties(inputStream, resources, name, false, skipPrefix);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            } else if (name.endsWith(".properties.xml")) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Adding properties from: '" + name.substring(1) + "'"));
                }
                InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(name.substring(1));
                try {
                    this.addProperties(inputStream, resources, name, true, skipPrefix);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            } else {
                resources.add(name.substring(skipPrefix));
            }
        }
    }

    private String ensureSlash(String resourcePath) {
        if (!resourcePath.startsWith("/")) {
            resourcePath = '/' + resourcePath;
        }
        if (!resourcePath.endsWith("/")) {
            resourcePath = resourcePath + '/';
        }
        return resourcePath;
    }

    private void addProperties(InputStream stream, ResourceManagerImpl resources, String childPath, boolean xml, int skipPrefix) throws ServletException {
        String directory = childPath.substring(skipPrefix, childPath.lastIndexOf(47));
        String filename = childPath.substring(childPath.lastIndexOf(47) + 1);
        int end = filename.lastIndexOf(46);
        if (xml) {
            end = filename.lastIndexOf(46, end - 1);
        }
        String locale = filename.substring(0, end);
        Properties temp = new Properties();
        try {
            if (xml) {
                XmlUtils.load(temp, stream);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)childPath);
                    LOG.debug((Object)("xml properties: " + temp.size()));
                }
            } else {
                temp.load(stream);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)childPath);
                    LOG.debug((Object)("    properties: " + temp.size()));
                }
            }
        }
        catch (IOException e) {
            String msg = "while loading " + childPath;
            LOG.error((Object)msg, (Throwable)e);
            throw new ServletException(msg, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        Enumeration<?> e = temp.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            resources.add(directory + '/' + locale + '/' + key, temp.getProperty(key));
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)(directory + '/' + locale + '/' + key + "=" + temp.getProperty(key)));
        }
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$context$ResourceLocator;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$context$ResourceLocator = new ResourceLocator[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }
}

