/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.faces.model.ScalarDataModel;
import javax.servlet.jsp.jstl.sql.Result;
import org.apache.myfaces.tobago.component.UIData;

public class UIDataFixTobago931
extends UIData {
    private static final Class OBJECT_ARRAY_CLASS = new Object[0].getClass();
    private int rowIndex = -1;
    private final Map dataModelMap = new HashMap();
    private final Map rowStates = new HashMap();
    private Object initialDescendantComponentState = null;
    private boolean isValidChilds = true;
    private static final DataModel EMPTY_DATA_MODEL = new DataModel(){

        public boolean isRowAvailable() {
            return false;
        }

        public int getRowCount() {
            return 0;
        }

        public Object getRowData() {
            throw new IllegalArgumentException();
        }

        public int getRowIndex() {
            return -1;
        }

        public void setRowIndex(int i) {
            if (i < -1) {
                throw new IllegalArgumentException();
            }
        }

        public Object getWrappedData() {
            return null;
        }

        public void setWrappedData(Object obj) {
            if (obj == null) {
                return;
            }
            throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName() + " UnsupportedOperationException");
        }
    };

    public String getClientId(FacesContext facesContext) {
        String clientId = super.getClientId(facesContext);
        if (this.getRowIndex() >= 0) {
            return clientId + ':' + this.getRowIndex();
        }
        return clientId;
    }

    public void processValidators(FacesContext context) {
        super.processValidators(context);
        if (context.getRenderResponse()) {
            this.isValidChilds = false;
        }
    }

    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        if (context.getRenderResponse()) {
            this.isValidChilds = false;
        }
    }

    public void setValue(Object value) {
        super.setValue(value);
        this.dataModelMap.clear();
        this.rowStates.clear();
        this.isValidChilds = true;
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.equals("value")) {
            this.dataModelMap.clear();
        } else if (name.equals("var") || name.equals("rowIndex")) {
            throw new IllegalArgumentException("You can never set the 'rowIndex' or the 'var' attribute as a value-binding. Set the property directly instead. Name " + name);
        }
        super.setValueBinding(name, binding);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.initialDescendantComponentState = null;
        if (this.isValidChilds && !this.hasErrorMessages(context)) {
            this.dataModelMap.clear();
            this.rowStates.clear();
        }
        super.encodeBegin(context);
    }

    private boolean hasErrorMessages(FacesContext context) {
        Iterator iter = context.getMessages();
        while (iter.hasNext()) {
            FacesMessage message = (FacesMessage)iter.next();
            if (FacesMessage.SEVERITY_ERROR.compareTo((Object)message.getSeverity()) > 0) continue;
            return true;
        }
        return false;
    }

    public boolean isRowAvailable() {
        return this.getDataModel().isRowAvailable();
    }

    public int getRowCount() {
        return this.getDataModel().getRowCount();
    }

    public Object getRowData() {
        return this.getDataModel().getRowData();
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException("rowIndex is less than -1");
        }
        if (this.rowIndex == rowIndex) {
            return;
        }
        FacesContext facesContext = this.getFacesContext();
        if (this.rowIndex == -1) {
            if (this.initialDescendantComponentState == null) {
                this.initialDescendantComponentState = this.saveDescendantComponentStates(this.getChildren().iterator(), false);
            }
        } else {
            this.rowStates.put(this.getClientId(facesContext), this.saveDescendantComponentStates(this.getChildren().iterator(), false));
        }
        this.rowIndex = rowIndex;
        DataModel dataModel = this.getDataModel();
        dataModel.setRowIndex(rowIndex);
        String var = this.getVar();
        if (rowIndex == -1) {
            if (var != null) {
                facesContext.getExternalContext().getRequestMap().remove(var);
            }
        } else if (var != null) {
            if (this.isRowAvailable()) {
                Object rowData = dataModel.getRowData();
                facesContext.getExternalContext().getRequestMap().put(var, rowData);
            } else {
                facesContext.getExternalContext().getRequestMap().remove(var);
            }
        }
        if (this.rowIndex == -1) {
            this.restoreDescendantComponentStates(this.getChildren().iterator(), this.initialDescendantComponentState, false);
        } else {
            Object rowState = this.rowStates.get(this.getClientId(facesContext));
            if (rowState == null) {
                this.restoreDescendantComponentStates(this.getChildren().iterator(), this.initialDescendantComponentState, false);
            } else {
                this.restoreDescendantComponentStates(this.getChildren().iterator(), rowState, false);
            }
        }
    }

    private void restoreDescendantComponentStates(Iterator childIterator, Object state, boolean restoreChildFacets) {
        Iterator descendantStateIterator = null;
        while (childIterator.hasNext()) {
            if (descendantStateIterator == null && state != null) {
                descendantStateIterator = ((Collection)state).iterator();
            }
            UIComponent component = (UIComponent)childIterator.next();
            component.setId(component.getId());
            if (component.isTransient()) continue;
            Object childState = null;
            Object descendantState = null;
            if (descendantStateIterator != null && descendantStateIterator.hasNext()) {
                Object[] object = (Object[])descendantStateIterator.next();
                childState = object[0];
                descendantState = object[1];
            }
            if (component instanceof EditableValueHolder) {
                ((EditableValueHolderState)childState).restoreState((EditableValueHolder)component);
            }
            Iterator childsIterator = restoreChildFacets ? component.getFacetsAndChildren() : component.getChildren().iterator();
            this.restoreDescendantComponentStates(childsIterator, descendantState, true);
        }
    }

    private Object saveDescendantComponentStates(Iterator childIterator, boolean saveChildFacets) {
        ArrayList<Object[]> childStates = null;
        while (childIterator.hasNext()) {
            UIComponent child;
            if (childStates == null) {
                childStates = new ArrayList<Object[]>();
            }
            if ((child = (UIComponent)childIterator.next()).isTransient()) continue;
            Iterator childsIterator = saveChildFacets ? child.getFacetsAndChildren() : child.getChildren().iterator();
            Object descendantState = this.saveDescendantComponentStates(childsIterator, true);
            EditableValueHolderState state = null;
            if (child instanceof EditableValueHolder) {
                state = new EditableValueHolderState((EditableValueHolder)child);
            }
            childStates.add(new Object[]{state, descendantState});
        }
        return childStates;
    }

    private DataModel getDataModel() {
        DataModel dataModel = null;
        String clientID = "";
        UIComponent parent = this.getParent();
        if (parent != null) {
            clientID = parent.getClientId(this.getFacesContext());
        }
        if ((dataModel = (DataModel)this.dataModelMap.get(clientID)) == null) {
            dataModel = this.createDataModel();
            this.dataModelMap.put(clientID, dataModel);
        }
        return dataModel;
    }

    private DataModel createDataModel() {
        Object value = this.getValue();
        if (value == null) {
            return EMPTY_DATA_MODEL;
        }
        if (value instanceof DataModel) {
            return (DataModel)value;
        }
        if (value instanceof List) {
            return new ListDataModel((List)value);
        }
        if (OBJECT_ARRAY_CLASS.isAssignableFrom(value.getClass())) {
            return new ArrayDataModel((Object[])value);
        }
        if (value instanceof ResultSet) {
            return new ResultSetDataModel((ResultSet)value);
        }
        if (value instanceof Result) {
            return new ResultDataModel((Result)value);
        }
        return new ScalarDataModel(value);
    }

    private class EditableValueHolderState {
        private final Object value;
        private final boolean localValueSet;
        private final boolean valid;
        private final Object submittedValue;

        public EditableValueHolderState(EditableValueHolder evh) {
            this.value = evh.getLocalValue();
            this.localValueSet = evh.isLocalValueSet();
            this.valid = evh.isValid();
            this.submittedValue = evh.getSubmittedValue();
        }

        public void restoreState(EditableValueHolder evh) {
            evh.setValue(this.value);
            evh.setLocalValueSet(this.localValueSet);
            evh.setValid(this.valid);
            evh.setSubmittedValue(this.submittedValue);
        }
    }
}

