/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.UIPanel;
import javax.faces.component.UISelectBoolean;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.MethodNotFoundException;
import javax.faces.el.ValueBinding;
import javax.faces.model.DataModel;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UIData;
import org.apache.myfaces.tobago.component.UISelectMany;
import org.apache.myfaces.tobago.component.UISelectOne;
import org.apache.myfaces.tobago.event.SortActionEvent;
import org.apache.myfaces.tobago.model.SheetState;
import org.apache.myfaces.tobago.util.BeanComparator;
import org.apache.myfaces.tobago.util.ComparatorBase;
import org.apache.myfaces.tobago.util.ValueBindingComparator;

public class Sorter
extends MethodBinding {
    private static final Log LOG;
    private Comparator comparator;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$component$Sorter;
    static /* synthetic */ Class class$java$lang$String;

    public Object invoke(FacesContext facesContext, Object[] aobj) throws EvaluationException {
        if (aobj[0] instanceof SortActionEvent) {
            SortActionEvent sortEvent = (SortActionEvent)((Object)aobj[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("sorterId = " + sortEvent.getComponent().getId()));
            }
            UIColumn column = sortEvent.getColumn();
            UIData data = sortEvent.getSheet();
            Object value = data.getValue();
            if (value instanceof DataModel) {
                value = ((DataModel)value).getWrappedData();
            }
            SheetState sheetState = data.getSheetState(facesContext);
            ComparatorBase actualComparator = null;
            if (value instanceof List || value instanceof Object[]) {
                block24: {
                    try {
                        UIComponent child = this.getFirstSortableChild(column.getChildren());
                        if (child != null) {
                            String attributeName = child instanceof UICommand ? "label" : "value";
                            ValueBinding valueBinding = child.getValueBinding(attributeName);
                            if (valueBinding != null) {
                                String var = data.getVar();
                                if (this.isSimpleProperty(valueBinding.getExpressionString())) {
                                    String expressionString = valueBinding.getExpressionString();
                                    if (expressionString.startsWith("#{") && expressionString.endsWith("}")) {
                                        expressionString = expressionString.substring(2, expressionString.length() - 1);
                                    }
                                    String sortProperty = expressionString.substring(var.length() + 1);
                                    actualComparator = new BeanComparator(sortProperty, this.comparator, !sheetState.isAscending());
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)("Sort property is " + sortProperty));
                                    }
                                } else {
                                    actualComparator = new ValueBindingComparator(facesContext, var, valueBinding, !sheetState.isAscending(), this.comparator);
                                }
                            }
                            break block24;
                        }
                        LOG.error((Object)"No sorting performed. Value is not instanceof List or Object[]!");
                        this.unsetSortableAttribute(column);
                        return null;
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error while extracting sortMethod :" + e.getMessage()), (Throwable)e);
                        if (column != null) {
                            this.unsetSortableAttribute(column);
                        }
                        return null;
                    }
                }
                ArrayList selectedDataRows = null;
                if (sheetState.getSelectedRows() != null && sheetState.getSelectedRows().size() > 0) {
                    selectedDataRows = new ArrayList(sheetState.getSelectedRows().size());
                    Iterator<Integer> i$ = sheetState.getSelectedRows().iterator();
                    while (i$.hasNext()) {
                        Integer index = i$.next();
                        Object dataRow = value instanceof List ? ((List)value).get(index) : ((Object[])value)[index];
                        selectedDataRows.add(dataRow);
                    }
                }
                if (value instanceof List) {
                    Collections.sort((List)value, actualComparator);
                } else {
                    Arrays.sort((Object[])value, actualComparator);
                }
                if (selectedDataRows != null) {
                    sheetState.getSelectedRows().clear();
                    Iterator i$ = selectedDataRows.iterator();
                    while (i$.hasNext()) {
                        int i;
                        Object dataRow = i$.next();
                        int index = -1;
                        if (value instanceof List) {
                            for (i = 0; i < ((List)value).size() && index < 0; ++i) {
                                if (dataRow != ((List)value).get(i)) continue;
                                index = i;
                            }
                        } else {
                            for (i = 0; i < ((Object[])value).length && index < 0; ++i) {
                                if (dataRow != ((Object[])value)[i]) continue;
                                index = i;
                            }
                        }
                        if (index < 0) continue;
                        sheetState.getSelectedRows().add(_Integer.valueOf((int)index));
                    }
                }
            } else {
                LOG.warn((Object)("Sorting not supported for type " + (value != null ? value.getClass().toString() : "null")));
            }
        }
        return null;
    }

    boolean isSimpleProperty(String expressionString) {
        if (expressionString.startsWith("#{") && expressionString.endsWith("}")) {
            String[] parts;
            String inner = expressionString.substring(2, expressionString.length() - 1);
            String[] arr$ = parts = StringUtils.split((String)inner, (String)".");
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String part = arr$[i$];
                if (StringUtils.isAlpha((String)part)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void unsetSortableAttribute(UIColumn uiColumn) {
        LOG.warn((Object)("removing attribute sortable from column " + uiColumn.getId()));
        uiColumn.getAttributes().put("sortable", Boolean.FALSE);
    }

    private UIComponent getFirstSortableChild(List children) {
        UIComponent child = null;
        Iterator iter = children.iterator();
        while (iter.hasNext() && ((child = (UIComponent)iter.next()) instanceof UISelectMany || child instanceof UISelectOne || child instanceof UISelectBoolean || child instanceof UICommand && child.getChildren().isEmpty() || child instanceof UIInput && "Hidden".equals(child.getRendererType()) || !(child instanceof UIOutput) && (!(child instanceof javax.faces.component.UICommand) && !(child instanceof UIPanel) || !((child = this.getFirstSortableChild(child.getChildren())) instanceof UIOutput)))) {
        }
        return child;
    }

    public Class getType(FacesContext facescontext) throws MethodNotFoundException {
        Class<?> clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        return clazz;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$component$Sorter;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$component$Sorter = new Sorter[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }
}

