/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.ajax.api;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.ajax.api.AjaxComponent;
import org.apache.myfaces.tobago.ajax.api.AjaxRenderer;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.renderkit.LayoutableRendererBase;
import org.apache.myfaces.tobago.util.ResponseUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxUtils {
    private static final Log LOG;
    public static final String AJAX_COMPONENTS;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$ajax$api$AjaxUtils;

    public static boolean isAjaxRequest(FacesContext facesContext) {
        Map parameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String ajaxComponentIds = (String)parameterMap.get("affectedAjaxComponent");
        return ajaxComponentIds != null;
    }

    public static void checkParamValidity(FacesContext facesContext, UIComponent uiComponent, Class compClass) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext may not be null");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent may not be null");
        }
        if (compClass != null && !compClass.isInstance(uiComponent)) {
            throw new IllegalArgumentException(new StringBuffer().append("uiComponent : ").append(uiComponent.getClass().getName()).append(" is not instance of ").append(compClass.getName()).append(" as it should be").toString());
        }
    }

    public static void encodeAjaxComponent(FacesContext facesContext, UIComponent component) throws IOException {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (!component.isRendered()) {
            return;
        }
        LayoutableRendererBase renderer = ComponentUtil.getRenderer(facesContext, component);
        if (renderer != null && renderer instanceof AjaxRenderer) {
            ((AjaxRenderer)((Object)renderer)).encodeAjax(facesContext, component);
        }
    }

    public static void processAjax(FacesContext facesContext, UIComponent component) throws IOException {
        if (component instanceof AjaxComponent) {
            ((AjaxComponent)component).processAjax(facesContext);
        } else {
            AjaxUtils.processAjaxOnChildren(facesContext, component);
        }
    }

    public static void processActiveAjaxComponent(FacesContext facesContext, UIComponent component) throws IOException {
        if (component instanceof AjaxComponent) {
            org.apache.myfaces.tobago.component.UIViewRoot viewRoot = (org.apache.myfaces.tobago.component.UIViewRoot)facesContext.getViewRoot();
            if (!facesContext.getRenderResponse()) {
                component.processValidators(facesContext);
                viewRoot.broadcastEventsForPhase(facesContext, PhaseId.PROCESS_VALIDATIONS);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Skipping validate");
            }
            if (!facesContext.getRenderResponse()) {
                component.processUpdates(facesContext);
                viewRoot.broadcastEventsForPhase(facesContext, PhaseId.UPDATE_MODEL_VALUES);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Skipping updates");
            }
            if (!facesContext.getRenderResponse()) {
                viewRoot.processApplication(facesContext);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Skipping application");
            }
            ((AjaxComponent)component).encodeAjax(facesContext);
        } else {
            LOG.error((Object)new StringBuffer().append("Can't process non AjaxComponent : \"").append(component.getClientId(facesContext)).append("\" = ").append(component.getClass().getName()).toString());
        }
    }

    public static void processAjaxOnChildren(FacesContext facesContext, UIComponent component) throws IOException {
        Iterator facetsAndChildren = component.getFacetsAndChildren();
        while (facetsAndChildren.hasNext() && !facesContext.getResponseComplete()) {
            AjaxUtils.processAjax(facesContext, (UIComponent)facetsAndChildren.next());
        }
    }

    public static Set<String> getRequestPartialIds(FacesContext facesContext) {
        Map parameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String ajaxComponentIds = (String)parameterMap.get("affectedAjaxComponent");
        if (ajaxComponentIds != null) {
            StringTokenizer tokenizer = new StringTokenizer(ajaxComponentIds, ",");
            HashSet<String> ajaxComponents = new HashSet<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                String ajaxId = tokenizer.nextToken();
                ajaxComponents.add(ajaxId);
            }
            return ajaxComponents;
        }
        return Collections.EMPTY_SET;
    }

    public static Map<String, UIComponent> parseAndStoreComponents(FacesContext facesContext) {
        Map parameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String ajaxComponentIds = (String)parameterMap.get("affectedAjaxComponent");
        if (ajaxComponentIds != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)new StringBuffer().append("ajaxComponentIds = \"").append(ajaxComponentIds).append("\"").toString());
            }
            StringTokenizer tokenizer = new StringTokenizer(ajaxComponentIds, ",");
            HashMap<String, UIComponent> ajaxComponents = new HashMap<String, UIComponent>(tokenizer.countTokens());
            facesContext.getExternalContext().getRequestMap().put(AJAX_COMPONENTS, ajaxComponents);
            UIViewRoot viewRoot = facesContext.getViewRoot();
            while (tokenizer.hasMoreTokens()) {
                String ajaxId = tokenizer.nextToken();
                UIComponent ajaxComponent = viewRoot.findComponent(ajaxId);
                if (ajaxComponent == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)new StringBuffer().append("ajaxComponent for \"").append(ajaxId).append("\" = \"").append(ajaxComponent).append("\"").toString());
                }
                ajaxComponents.put(ajaxId, ajaxComponent);
            }
            return ajaxComponents;
        }
        return null;
    }

    public static Map<String, UIComponent> getAjaxComponents(FacesContext facesContext) {
        return (Map)facesContext.getExternalContext().getRequestMap().get(AJAX_COMPONENTS);
    }

    public static void ensureDecoded(FacesContext facesContext, String clientId) {
        AjaxUtils.ensureDecoded(facesContext, facesContext.getViewRoot().findComponent(clientId));
    }

    public static void ensureDecoded(FacesContext facesContext, UIComponent component) {
        if (component == null) {
            LOG.warn((Object)"Ignore AjaxComponent: null");
            return;
        }
        Map<String, UIComponent> ajaxComponents = AjaxUtils.getAjaxComponents(facesContext);
        if (ajaxComponents != null) {
            for (UIComponent uiComponent : ajaxComponents.values()) {
                for (UIComponent parent = component; parent != null; parent = parent.getParent()) {
                    if (component != uiComponent) continue;
                    return;
                }
            }
            component.processDecodes(facesContext);
        }
    }

    public static boolean redirect(FacesContext facesContext, String url) throws IOException {
        if (!AjaxUtils.isAjaxRequest(facesContext)) {
            return false;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        if (writer == null) {
            RenderKit renderKit = facesContext.getRenderKit();
            if (renderKit == null) {
                RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
                Application application = facesContext.getApplication();
                ViewHandler applicationViewHandler = application.getViewHandler();
                String renderKitId = applicationViewHandler.calculateRenderKitId(facesContext);
                renderKit = renderFactory.getRenderKit(facesContext, renderKitId);
            }
            writer = renderKit.createResponseWriter((Writer)((HttpServletResponse)facesContext.getExternalContext().getResponse()).getWriter(), null, null);
        }
        ResponseUtils.ensureNoCacheHeader(facesContext);
        writer.startElement("redirect", null);
        writer.writeAttribute("url", (Object)url, null);
        writer.endElement("redirect");
        writer.flush();
        facesContext.responseComplete();
        return true;
    }

    public static void redirect(HttpServletResponse response, String url) throws IOException {
        PrintWriter out = response.getWriter();
        out.print("<redirect url=");
        out.print(url);
        out.println("</redirect>");
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$ajax$api$AjaxUtils;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$ajax$api$AjaxUtils = new AjaxUtils[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz2 = class$org$apache$myfaces$tobago$ajax$api$AjaxUtils;
        if (clazz2 == null) {
            clazz2 = class$org$apache$myfaces$tobago$ajax$api$AjaxUtils = new AjaxUtils[0].getClass().getComponentType();
        }
        AJAX_COMPONENTS = stringBuffer.append(clazz2.getName()).append(".AJAX_COMPONENTS").toString();
    }
}

