/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.ajax.api;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.ajax.api.AjaxComponent;
import org.apache.myfaces.tobago.ajax.api.AjaxUtils;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.lifecycle.TobagoLifecycle;
import org.apache.myfaces.tobago.util.Callback;
import org.apache.myfaces.tobago.util.EncodeAjaxCallback;
import org.apache.myfaces.tobago.util.FastStringWriter;
import org.apache.myfaces.tobago.util.JndiUtils;
import org.apache.myfaces.tobago.util.RequestUtils;
import org.apache.myfaces.tobago.util.ResponseUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxResponseRenderer {
    private static final Log LOG;
    public static final String CODE_SUCCESS = "<status code=\"200\"/>";
    public static final String CODE_NOT_MODIFIED = "<status code=\"304\"/>";
    public static final String CODE_RELOAD_REQUIRED = "<status code=\"309\"/>";
    private Callback callback = new EncodeAjaxCallback();
    private String contentType;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$ajax$api$AjaxResponseRenderer;

    public AjaxResponseRenderer() {
        try {
            InitialContext ic = new InitialContext();
            this.contentType = (String)JndiUtils.getJndiProperty(ic, "tobago.ajax.contentType");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (StringUtils.isBlank((String)this.contentType)) {
            this.contentType = "text/html";
        }
    }

    public void renderResponse(FacesContext facesContext) throws IOException {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderFactory.getRenderKit(facesContext, viewRoot.getRenderKitId());
        UIViewRoot incommingViewRoot = (UIViewRoot)facesContext.getExternalContext().getRequestMap().get(TobagoLifecycle.VIEW_ROOT_KEY);
        if (viewRoot != incommingViewRoot) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)new StringBuffer().append("requesting full page reload because of navigation to ").append(viewRoot.getViewId()).append(" from ").append(incommingViewRoot.getViewId()).toString());
            }
            Map sessionMap = facesContext.getExternalContext().getSessionMap();
            sessionMap.put(TobagoLifecycle.VIEW_ROOT_KEY, viewRoot);
            ArrayList<Object[]> messageHolders = new ArrayList<Object[]>();
            Iterator clientIds = facesContext.getClientIdsWithMessages();
            while (clientIds.hasNext()) {
                String clientId = (String)clientIds.next();
                Iterator messages = facesContext.getMessages(clientId);
                while (messages.hasNext()) {
                    Object[] messageHolder = new Object[]{clientId, messages.next()};
                    messageHolders.add(messageHolder);
                }
            }
            if (!messageHolders.isEmpty()) {
                sessionMap.put(TobagoLifecycle.FACES_MESSAGES_KEY, messageHolders);
            }
            this.writeResponseReload(facesContext, renderKit);
        } else {
            ArrayList<FastStringWriter> responseParts = new ArrayList<FastStringWriter>();
            Map<String, UIComponent> ajaxComponents = AjaxUtils.getAjaxComponents(facesContext);
            Iterator<Map.Entry<String, UIComponent>> i$ = ajaxComponents.entrySet().iterator();
            if (i$.hasNext()) {
                Map.Entry<String, UIComponent> entry = i$.next();
                AjaxComponent component = (AjaxComponent)entry.getValue();
                responseParts.add(this.renderComponent(facesContext, renderKit, entry.getKey(), component));
            }
            String state = this.saveState(facesContext, renderKit);
            this.writeResponse(facesContext, renderKit, responseParts, state);
        }
    }

    private FastStringWriter renderComponent(FacesContext facesContext, RenderKit renderKit, String clientId, AjaxComponent component) throws IOException {
        FastStringWriter content = new FastStringWriter();
        ResponseWriter contentWriter = renderKit.createResponseWriter((Writer)content, null, null);
        facesContext.setResponseWriter(contentWriter);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)new StringBuffer().append("write ajax response for ").append(component).toString());
        }
        try {
            ComponentUtil.invokeOnComponent(facesContext, clientId, (UIComponent)component, this.callback);
        }
        catch (EmptyStackException e) {
            LOG.error((Object)new StringBuffer().append(" content = \"").append(content.toString()).append("\"").toString());
            throw e;
        }
        return content;
    }

    private void writeResponse(FacesContext facesContext, RenderKit renderKit, List<FastStringWriter> parts, String state) throws IOException {
        this.writeResponse(facesContext, renderKit, CODE_SUCCESS, parts, state);
    }

    private void writeResponseReload(FacesContext facesContext, RenderKit renderKit) throws IOException {
        this.writeResponse(facesContext, renderKit, CODE_RELOAD_REQUIRED, Collections.EMPTY_LIST, "");
    }

    private FastStringWriter writeState(FacesContext facesContext, RenderKit renderKit, String state) throws IOException {
        FastStringWriter jsfState = new FastStringWriter();
        ResponseWriter stateWriter = renderKit.createResponseWriter((Writer)jsfState, null, null);
        facesContext.setResponseWriter(stateWriter);
        stateWriter.startElement("script", null);
        stateWriter.writeAttribute("type", (Object)"text/javascript", null);
        stateWriter.flush();
        stateWriter.write("Tobago.replaceJsfState(\"");
        stateWriter.write(this.encodeState(state));
        stateWriter.write("\");");
        stateWriter.endElement("script");
        return jsfState;
    }

    private String saveState(FacesContext facesContext, RenderKit renderKit) throws IOException {
        FastStringWriter jsfState = new FastStringWriter();
        ResponseWriter stateWriter = renderKit.createResponseWriter((Writer)jsfState, null, null);
        facesContext.setResponseWriter(stateWriter);
        StateManager stateManager = facesContext.getApplication().getStateManager();
        StateManager.SerializedView serializedView = stateManager.saveSerializedView(facesContext);
        stateManager.writeState(facesContext, serializedView);
        return jsfState.toString();
    }

    private static void ensureContentTypeHeader(FacesContext facesContext, String charset, String contentType) {
        StringBuffer sb = new StringBuffer(contentType);
        if (charset == null) {
            charset = "UTF-8";
        }
        sb.append("; charset=");
        sb.append(charset);
        ResponseUtils.ensureContentTypeHeader(facesContext, sb.toString());
    }

    private void writeResponse(FacesContext facesContext, RenderKit renderKit, String responseCode, List<FastStringWriter> responseParts, String jsfState) throws IOException {
        ExternalContext externalContext;
        RequestUtils.ensureEncoding(facesContext);
        ResponseUtils.ensureNoCacheHeader(facesContext);
        UIPage page = ComponentUtil.findPage(facesContext);
        String charset = page != null ? (String)page.getAttributes().get("charset") : "UTF-8";
        AjaxResponseRenderer.ensureContentTypeHeader(facesContext, charset, this.contentType);
        StringBuffer buffer = new StringBuffer(responseCode);
        for (FastStringWriter part : responseParts) {
            String partStr = part.toString();
            if (partStr.startsWith(responseCode) || partStr.equals(CODE_NOT_MODIFIED)) {
                buffer.setLength(0);
            }
            buffer.append(partStr);
        }
        if (jsfState.length() > 0) {
            buffer.append(this.writeState(facesContext, renderKit, jsfState));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)new StringBuffer().append("\nresponse follows ##############################################################\n").append((Object)buffer).append("\nend response    ##############################################################").toString());
        }
        if ((externalContext = facesContext.getExternalContext()).getResponse() instanceof HttpServletResponse) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)externalContext.getResponse();
            PrintWriter responseWriter = httpServletResponse.getWriter();
            responseWriter.print(buffer.toString());
            responseWriter.flush();
            responseWriter.close();
        }
    }

    private String encodeState(String state) {
        state = StringUtils.replace((String)state, (String)"\"", (String)"\\\"");
        return StringUtils.replace((String)state, (String)"\n", (String)"");
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$ajax$api$AjaxResponseRenderer;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$ajax$api$AjaxResponseRenderer = new AjaxResponseRenderer[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }
}

