/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.webapp;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.util.HtmlWriterUtil;
import org.apache.myfaces.tobago.util.XmlUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TobagoResponseWriterImpl
extends TobagoResponseWriter {
    private static final Log LOG = LogFactory.getLog(TobagoResponseWriterImpl.class);
    private static final Set<String> EMPTY_TAG = new HashSet<String>(Arrays.asList("br", "area", "link", "img", "param", "hr", "input", "col", "base", "meta"));
    private Writer writer;
    private UIComponent component;
    private boolean startStillOpen;
    private String contentType;
    private String characterEncoding;
    private Stack<String> stack;
    private boolean xml;
    private HtmlWriterUtil helper;

    public TobagoResponseWriterImpl(Writer writer, String contentType, String characterEncoding) {
        this.writer = writer;
        this.component = null;
        this.stack = new Stack();
        this.contentType = contentType;
        String string = this.characterEncoding = characterEncoding != null ? characterEncoding : "UTF-8";
        if ("application/xhtml".equals(contentType) || "application/xml".equals(contentType) || "text/xml".equals(contentType)) {
            this.xml = true;
        }
        this.helper = new HtmlWriterUtil(writer, characterEncoding);
    }

    private String findValue(Object value, String property) {
        if (value != null) {
            return value instanceof String ? (String)value : value.toString();
        }
        if (property != null) {
            if (this.component != null) {
                Object object = this.component.getAttributes().get(property);
                if (object != null) {
                    return object instanceof String ? (String)object : object.toString();
                }
                return null;
            }
            String trace = this.getCallingClassStackTraceElementString();
            LOG.error((Object)("Don't know what to do! Property defined, but no component to get a value. " + trace.substring(trace.indexOf(40))));
            LOG.error((Object)"value = 'null'");
            LOG.error((Object)("property = '" + property + "'"));
            return null;
        }
        String trace = this.getCallingClassStackTraceElementString();
        LOG.error((Object)("Don't know what to do! No value and no property defined. " + trace.substring(trace.indexOf(40))));
        LOG.error((Object)"value = 'null'");
        LOG.error((Object)"property = 'null'");
        return null;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    public void write(String string) throws IOException {
        this.closeOpenTag();
        this.writer.write(string);
    }

    public void write(int i) throws IOException {
        this.closeOpenTag();
        this.writer.write(i);
    }

    public void write(char[] chars) throws IOException {
        this.closeOpenTag();
        this.writer.write(chars);
    }

    public void write(String string, int i, int i1) throws IOException {
        this.closeOpenTag();
        this.writer.write(string, i, i1);
    }

    public void close() throws IOException {
        this.closeOpenTag();
        this.writer.close();
    }

    public void flush() throws IOException {
        this.closeOpenTag();
    }

    public void writeText(Object text, String property) throws IOException {
        this.closeOpenTag();
        String value = this.findValue(text, property);
        if (this.xml) {
            this.write(XmlUtils.escape(value));
        } else {
            this.helper.writeText(value);
        }
    }

    private void closeOpenTag() throws IOException {
        if (this.startStillOpen) {
            this.writer.write("\n>");
            this.startStillOpen = false;
        }
    }

    public void writeText(char[] text, int offset, int length) throws IOException {
        this.closeOpenTag();
        if (this.xml) {
            this.writer.write(XmlUtils.escape(text, offset, length, true));
        } else {
            this.helper.writeText(text, offset, length);
        }
    }

    public void startDocument() throws IOException {
    }

    public void endDocument() throws IOException {
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void startElement(String name, UIComponent currentComponent) throws IOException {
        this.component = currentComponent;
        this.stack.push(name);
        if (this.startStillOpen) {
            this.writer.write("\n>");
        }
        this.writer.write("<");
        this.writer.write(name);
        this.startStillOpen = true;
    }

    public void endElement(String name) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("end Element: " + name));
        }
        String top = "";
        try {
            top = this.stack.pop();
        }
        catch (EmptyStackException e) {
            LOG.error((Object)("Failed to close element \"" + name + "\"!"));
            throw e;
        }
        if (!top.equals(name)) {
            String trace = this.getCallingClassStackTraceElementString();
            LOG.error((Object)("Element end with name='" + name + "' doesn't " + "match with top element on the stack='" + top + "' " + trace.substring(trace.indexOf(40))));
        }
        if (EMPTY_TAG.contains(name)) {
            if (this.xml) {
                this.writer.write("\n/>");
            } else {
                this.writer.write("\n>");
            }
        } else {
            if (this.startStillOpen) {
                this.writer.write("\n>");
            }
            this.writer.write("</");
            this.writer.write(name);
            this.writer.write(">");
        }
        this.startStillOpen = false;
    }

    public void writeComment(Object obj) throws IOException {
        this.closeOpenTag();
        String comment = obj.toString();
        this.write("<!--");
        if (comment.indexOf("--") < 0) {
            this.write(comment);
        } else {
            String trace = this.getCallingClassStackTraceElementString();
            LOG.warn((Object)("Comment must not contain the sequence '--', comment = '" + comment + "' " + trace.substring(trace.indexOf(40))));
            this.write(StringUtils.replace((String)comment, (String)"--", (String)"++"));
        }
        this.write("-->");
    }

    public ResponseWriter cloneWithWriter(Writer originalWriter) {
        return new TobagoResponseWriterImpl(originalWriter, this.getContentType(), this.getCharacterEncoding());
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        String attribute = this.findValue(value, property);
        this.writeAttribute(name, attribute, true);
    }

    private String getCallingClassStackTraceElementString() {
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        int i = 1;
        while (stackTrace[i].getClassName().equals(((Object)((Object)this)).getClass().getName())) {
            ++i;
        }
        return stackTrace[i].toString();
    }

    public void writeURIAttribute(String s, Object obj, String s1) throws IOException {
        LOG.error((Object)"Not implemented yet!");
    }

    public void writeAttribute(String name, String value, boolean escape) throws IOException {
        if (!this.startStillOpen) {
            String trace = this.getCallingClassStackTraceElementString();
            String error = "Cannot write attribute when start-tag not open. name = '" + name + "' " + "value = '" + value + "' " + trace.substring(trace.indexOf(40));
            LOG.error((Object)error);
            throw new IllegalStateException(error);
        }
        if (value != null) {
            this.writer.write(32);
            this.writer.write(name);
            this.writer.write("=\"");
            if (this.xml) {
                this.writer.write(XmlUtils.escape(value));
            } else if (escape) {
                this.helper.writeAttributeValue(value);
            } else {
                this.writer.write(value);
            }
            this.writer.write(34);
        }
    }

    public void writeClassAttribute() throws IOException {
        Object clazz = this.component.getAttributes().get("styleClass");
        if (clazz != null) {
            this.writeAttribute("class", clazz.toString(), false);
        }
    }

    public void writeStyleAttribute() throws IOException {
        Object style = this.component.getAttributes().get("style");
        if (style != null) {
            this.writeAttribute("style", style.toString(), false);
        }
    }
}

