/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.LayoutTokens;
import org.apache.myfaces.tobago.component.UICell;
import org.apache.myfaces.tobago.component.UIForm;
import org.apache.myfaces.tobago.component.UIHiddenInput;
import org.apache.myfaces.tobago.renderkit.LayoutableRendererBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LayoutUtil {
    private static final Log LOG = LogFactory.getLog(LayoutUtil.class);
    private static Boolean fixLayoutTransparency;

    private LayoutUtil() {
    }

    public static int getInnerSpace(FacesContext facesContext, UIComponent component, boolean width) {
        String attribute = width ? "innerWidth" : "innerHeight";
        Integer innerSpace = (Integer)component.getAttributes().get(attribute);
        if (innerSpace == null) {
            int space = -1;
            Integer spaceInteger = width ? LayoutUtil.getLayoutWidth(component) : LayoutUtil.getLayoutHeight(component);
            if (spaceInteger != null) {
                space = spaceInteger;
            }
            if (space < 0 && component.getParent() != null) {
                space = LayoutUtil.getInnerSpace(facesContext, component.getParent(), width);
            }
            innerSpace = space != -1 ? Integer.valueOf(LayoutUtil.getInnerSpace(facesContext, component, space, width)) : Integer.valueOf(-1);
            component.getAttributes().put(attribute, innerSpace);
        }
        return innerSpace;
    }

    public static int getInnerSpace(FacesContext facesContext, UIComponent component, int outerSpace, boolean width) {
        int margin;
        block6: {
            margin = 0;
            if (component.getRendererType() != null) {
                try {
                    LayoutableRendererBase renderer = ComponentUtil.getRenderer(facesContext, component);
                    if (width) {
                        margin += renderer.getPaddingWidth(facesContext, component);
                        margin += renderer.getComponentExtraWidth(facesContext, component);
                        break block6;
                    }
                    margin += renderer.getHeaderHeight(facesContext, component);
                    margin += renderer.getPaddingHeight(facesContext, component);
                    margin += renderer.getComponentExtraHeight(facesContext, component);
                }
                catch (Exception e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"cannot find margin", (Throwable)e);
                    }
                    break block6;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("renderertype = null, component: " + component));
            }
        }
        return outerSpace - margin;
    }

    public static int getLabelWidth(UIComponent component) {
        String labelWidth;
        UIComponent label;
        if (component != null && (label = component.getFacet("label")) != null && (labelWidth = (String)label.getAttributes().get("width")) != null) {
            try {
                return Integer.parseInt(LayoutUtil.stripNonNumericChars(labelWidth));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)"Can't parse label width, using default value", (Throwable)e);
            }
        }
        return 0;
    }

    public static Integer getLayoutWidth(UIComponent component) {
        return LayoutUtil.getLayoutSpace(component, "width", "layoutWidth");
    }

    public static Integer getLayoutHeight(UIComponent component) {
        return LayoutUtil.getLayoutSpace(component, "height", "layoutHeight");
    }

    public static Integer getLayoutSpace(UIComponent component, String sizeAttribute, String layoutAttribute) {
        Object value = ComponentUtil.getAttribute(component, sizeAttribute);
        if (value != null) {
            if (value instanceof String) {
                return new Integer(LayoutUtil.stripNonNumericChars((String)value));
            }
            return (Integer)value;
        }
        if (!ComponentUtil.getBooleanAttribute(component, "inline")) {
            value = ComponentUtil.getAttribute(component, layoutAttribute);
            return (Integer)value;
        }
        return null;
    }

    public static List<UIComponent> addChildren(List<UIComponent> children, UIComponent panel) {
        for (Object o : panel.getChildren()) {
            UIComponent child = (UIComponent)o;
            if (LayoutUtil.isTransparentForLayout(child)) {
                LayoutUtil.addChildren(children, child);
                continue;
            }
            children.add(child);
        }
        return children;
    }

    public static boolean isTransparentForLayout(UIComponent component) {
        if (component instanceof UINamingContainer && component.getRendererType() == null) {
            return true;
        }
        if ("facelets".equals(component.getFamily())) {
            return !"com.sun.facelets.tag.UIDebug".equals(component.getClass().getName());
        }
        if (component instanceof UIForm) {
            return true;
        }
        return fixLayoutTransparency != false && (component instanceof UIHiddenInput || component instanceof UIParameter || component.getClass().getPackage().getName().equals("com.sun.facelets.compiler"));
    }

    public static UIComponent getLayoutParent(UIComponent component) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && LayoutUtil.isTransparentForLayout(parent); parent = parent.getParent()) {
        }
        return parent;
    }

    public static void maybeSetLayoutAttribute(UIComponent cell, String attribute, Integer value) {
        if ("Out".equals(cell.getRendererType())) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("set " + value + " to " + cell.getRendererType()));
        }
        cell.getAttributes().put(attribute, value);
        if ("layoutWidth".equals(attribute)) {
            cell.getAttributes().remove("innerWidth");
        } else if ("layoutHeight".equals(attribute)) {
            cell.getAttributes().remove("innerHeight");
        }
        if (cell instanceof UICell) {
            List<UIComponent> children = LayoutUtil.addChildren(new ArrayList<UIComponent>(), cell);
            for (UIComponent component : children) {
                LayoutUtil.maybeSetLayoutAttribute(component, attribute, value);
            }
        }
    }

    public static int calculateFixedHeightForChildren(FacesContext facesContext, UIComponent component) {
        int height = 0;
        for (Object o : component.getChildren()) {
            int h;
            UIComponent child = (UIComponent)o;
            LayoutableRendererBase renderer = ComponentUtil.getRenderer(facesContext, child);
            if (renderer == null && child instanceof UINamingContainer && child.getChildren().size() > 0) {
                renderer = ComponentUtil.getRenderer(facesContext, (UIComponent)child.getChildren().get(0));
            }
            if (renderer == null || (h = renderer.getFixedHeight(facesContext, child)) <= 0) continue;
            height += h;
        }
        return height;
    }

    public static Dimension getMinimumSize(FacesContext facesContext, UIComponent component) {
        LayoutableRendererBase renderer;
        Dimension dimension = (Dimension)component.getAttributes().get("minimunSize");
        if (dimension == null && (renderer = ComponentUtil.getRenderer(facesContext, component)) != null) {
            dimension = renderer.getMinimumSize(facesContext, component);
        }
        if (dimension == null) {
            dimension = new Dimension(-1, -1);
        }
        return dimension;
    }

    public static boolean checkTokens(String columns) {
        StringTokenizer st = new StringTokenizer(columns, ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (LayoutUtil.checkToken(token)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkToken(String columnToken) {
        return LayoutTokens.parseToken(columnToken) != null;
    }

    public static String stripNonNumericChars(String token) {
        if (token == null || token.length() == 0) {
            return token;
        }
        StringBuilder builder = new StringBuilder(token.length());
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (!Character.isDigit(c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public static boolean isNumberAndSuffix(String token, String suffix) {
        return token.endsWith(suffix) && NumberUtils.isDigits((String)LayoutUtil.removeSuffix(token, suffix));
    }

    public static String removeSuffix(String token, String suffix) {
        return token.substring(0, token.length() - suffix.length());
    }

    public static void setFixLayoutTransparency(boolean fixLayoutTransparency) {
        if (LayoutUtil.fixLayoutTransparency == null) {
            LayoutUtil.fixLayoutTransparency = fixLayoutTransparency;
        } else {
            LOG.error((Object)"LayoutUtil.setFixLayoutTransparency() can only called one time.");
        }
    }
}

