/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.HideLayoutToken;
import org.apache.myfaces.tobago.component.LayoutToken;
import org.apache.myfaces.tobago.component.LayoutTokens;
import org.apache.myfaces.tobago.component.PercentLayoutToken;
import org.apache.myfaces.tobago.component.PixelLayoutToken;
import org.apache.myfaces.tobago.component.RelativeLayoutToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutInfo {
    private static final Log LOG = LogFactory.getLog(LayoutInfo.class);
    private static final int FREE = -1;
    public static final int HIDE = -2;
    private int cellsLeft;
    private int spaceLeft;
    private int[] spaces;
    private LayoutTokens layoutTokens;
    private String clientIdForLogging;

    public LayoutInfo(int cellCount, int space, LayoutTokens layoutTokens, String clientIdForLogging) {
        this(cellCount, space, layoutTokens, clientIdForLogging, false);
    }

    public LayoutInfo(int cellCount, int space, LayoutTokens layoutTokens, String clientIdForLogging, boolean ignoreMismatch) {
        this.cellsLeft = cellCount;
        this.spaceLeft = space;
        this.layoutTokens = layoutTokens;
        this.clientIdForLogging = clientIdForLogging;
        if (layoutTokens.getSize() > cellCount) {
            if (!ignoreMismatch) {
                LOG.warn((Object)("More tokens (" + layoutTokens.getSize() + ") for layout than cells (" + cellCount + ") found! Ignoring" + " redundant tokens. Token string was: " + layoutTokens + " clientId='" + clientIdForLogging + "'"));
            }
            layoutTokens.shrinkSizeTo(cellCount);
        } else {
            if (!ignoreMismatch && LOG.isWarnEnabled() && cellCount - layoutTokens.getSize() != 0) {
                LOG.warn((Object)("More cells (" + cellCount + ") than tokens (" + layoutTokens.getSize() + ") for layout found! Setting missing tokens to '1*'." + " Token string was: " + layoutTokens + " clientId='" + clientIdForLogging + "'"));
            }
            layoutTokens.ensureSize(cellCount, new RelativeLayoutToken(1));
        }
        this.createAndInitSpaces(cellCount, -1);
    }

    private void createAndInitSpaces(int columns, int initValue) {
        this.spaces = new int[columns];
        for (int j = 0; j < this.spaces.length; ++j) {
            this.spaces[j] = initValue;
        }
    }

    public void update(int space, int index) {
        this.update(space, index, false);
    }

    public void update(int space, int index, boolean force) {
        if (space > this.spaceLeft) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("More space (" + space + ") needed than available (" + this.spaceLeft + ")!" + " clientId='" + this.clientIdForLogging + "'"));
            }
            if (!force) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Cutting to fit.  clientId='" + this.clientIdForLogging + "'"));
                }
                space = this.spaceLeft < 0 ? 0 : this.spaceLeft;
            }
        }
        this.spaceLeft -= space;
        --this.cellsLeft;
        if (index < this.spaces.length) {
            this.spaces[index] = space;
            if (this.spaceLeft < 1 && this.columnsLeft() && LOG.isWarnEnabled()) {
                LOG.warn((Object)("There are columns left but no more space! cellsLeft=" + this.cellsLeft + ", tokens=" + this.layoutTokens + " clientId='" + this.clientIdForLogging + "'"));
                LOG.warn((Object)("calculated spaces = " + LayoutInfo.tokensToString(this.spaces) + " clientId='" + this.clientIdForLogging + "'"));
            }
        } else {
            LOG.warn((Object)("More space to assign (" + space + "px) but no more columns!" + " More layout tokens than column tags?" + " clientId='" + this.clientIdForLogging + "'"));
        }
    }

    public boolean columnsLeft() {
        return this.cellsLeft > 0;
    }

    public void handleIllegalTokens() {
        for (int i = 0; i < this.spaces.length; ++i) {
            if (!this.isFree(i)) continue;
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Illegal layout token pattern \"" + this.layoutTokens.get(i) + "\" ignored, set to 0px !" + " clientId='" + this.clientIdForLogging + "'"));
            }
            this.spaces[i] = 0;
        }
    }

    public static String[] createLayoutTokens(String columnLayout, int count, String defaultToken) {
        String[] tokens;
        if (columnLayout != null) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(columnLayout, ";");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                if ("*".equals(token)) {
                    token = "1*";
                }
                list.add(token);
            }
            tokens = list.toArray(new String[list.size()]);
        } else {
            defaultToken = "*".equals(defaultToken) ? "1*" : defaultToken;
            tokens = new String[count];
            for (int i = 0; i < tokens.length; ++i) {
                tokens[i] = defaultToken;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("created Tokens : " + LayoutInfo.tokensToString(tokens)));
        }
        return tokens;
    }

    public static String listToTokenString(List list) {
        String[] tokens = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            tokens[i] = list.get(i).toString();
        }
        return LayoutInfo.tokensToString(tokens);
    }

    public static String tokensToString(int[] tokens) {
        String[] strings = new String[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            strings[i] = Integer.toString(tokens[i]);
        }
        return LayoutInfo.tokensToString(strings);
    }

    public static String tokensToString(String[] tokens) {
        StringBuilder sb = new StringBuilder();
        for (String token : tokens) {
            if (sb.length() != 0) {
                sb.append(";");
            }
            sb.append(token);
        }
        sb.insert(0, "\"");
        sb.append("\"");
        return sb.toString();
    }

    public boolean isFree(int column) {
        return this.spaces[column] == -1;
    }

    public int getSpaceForColumn(int column) {
        if (column >= this.spaces.length) {
            LOG.error((Object)("spaces length " + this.spaces.length + " column " + column));
            return 0;
        }
        return this.spaces[column];
    }

    public int getSpaceLeft() {
        return this.spaceLeft;
    }

    public LayoutTokens getLayoutTokens() {
        return this.layoutTokens;
    }

    public boolean hasLayoutTokens() {
        return !this.layoutTokens.isEmpty();
    }

    public List<Integer> getSpaceList() {
        ArrayList<Integer> list = new ArrayList<Integer>(this.spaces.length);
        for (int space : this.spaces) {
            list.add(space);
        }
        return list;
    }

    public void handleSpaceLeft() {
        if (this.spaceLeft > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("spread spaceLeft (" + this.spaceLeft + "px) to columns" + " clientId='" + this.clientIdForLogging + "'"));
                LOG.debug((Object)("spaces before spread :" + this.arrayAsString(this.spaces) + " clientId='" + this.clientIdForLogging + "'"));
            }
            for (int i = 0; i < this.layoutTokens.getSize(); ++i) {
                if (!(this.layoutTokens.get(i) instanceof RelativeLayoutToken)) continue;
                this.addSpace(this.spaceLeft, i);
                break;
            }
            boolean found = false;
            while (this.spaceLeft > 0) {
                for (int i = this.layoutTokens.getSize() - 1; i > -1; --i) {
                    if (this.spaceLeft <= 0 || !(this.layoutTokens.get(i) instanceof RelativeLayoutToken)) continue;
                    found = true;
                    this.addSpace(1, i);
                }
                if (found) continue;
            }
        }
        if (this.spaceLeft > 0 && LOG.isWarnEnabled()) {
            LOG.warn((Object)("Space left after spreading : " + this.spaceLeft + "px!" + " clientId='" + this.clientIdForLogging + "'"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("spaces after spread  :" + this.arrayAsString(this.spaces) + " clientId='" + this.clientIdForLogging + "'"));
        }
    }

    private String arrayAsString(int[] currentSpaces) {
        StringBuilder sb = new StringBuilder("[");
        for (int currentSpace : currentSpaces) {
            sb.append(currentSpace);
            sb.append(", ");
        }
        sb.replace(sb.lastIndexOf(", "), sb.length(), "]");
        return sb.toString();
    }

    private void addSpace(int space, int i) {
        if (this.spaces[i] > -2) {
            if (this.spaces[i] == -1) {
                this.spaces[i] = space;
            } else {
                int n = i;
                this.spaces[n] = this.spaces[n] + space;
            }
            this.spaceLeft -= space;
        }
    }

    private void parsePortions(int portions) {
        if (this.columnsLeft() && portions > 0) {
            int widthForPortions = this.getSpaceLeft();
            for (int i = 0; i < this.layoutTokens.getSize(); ++i) {
                LayoutToken token = this.layoutTokens.get(i);
                if (!this.isFree(i) || !(token instanceof RelativeLayoutToken)) continue;
                int portion = ((RelativeLayoutToken)token).getFactor();
                float w = (float)widthForPortions / (float)portions * (float)portion;
                if (w < 0.0f) {
                    this.update(0, i);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("set column " + i + " from " + token + " to with " + w + " == 0px" + " clientId='" + this.clientIdForLogging + "'"));
                    continue;
                }
                this.update(Math.round(w), i);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("set column " + i + " from " + token + " to with " + w + " == " + Math.round(w) + "px" + " clientId='" + this.clientIdForLogging + "'"));
            }
        }
    }

    public void parseColumnLayout(double space) {
        this.parseColumnLayout(space, 0);
    }

    public void parseColumnLayout(double space, int padding) {
        if (this.hasLayoutTokens()) {
            int portions = 0;
            for (int i = 0; i < this.layoutTokens.getSize(); ++i) {
                LayoutToken token = this.layoutTokens.get(i);
                if (token instanceof HideLayoutToken) {
                    this.update(0, i);
                    this.spaces[i] = -2;
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("set column " + i + " from " + this.layoutTokens.get(i) + " to hide " + " clientId='" + this.clientIdForLogging + "'"));
                    continue;
                }
                if (token instanceof PixelLayoutToken) {
                    int w = ((PixelLayoutToken)token).getPixel();
                    this.update(w, i, true);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("set column " + i + " from " + token + " to with " + w + " clientId='" + this.clientIdForLogging + "'"));
                    continue;
                }
                if (token instanceof RelativeLayoutToken) {
                    portions += ((RelativeLayoutToken)token).getFactor();
                    continue;
                }
                if (!(token instanceof PercentLayoutToken)) continue;
                int percent = ((PercentLayoutToken)token).getPercent();
                int w = (int)(space / 100.0 * (double)percent);
                this.update(w, i);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("set column " + i + " from " + token + " to with " + w + " clientId='" + this.clientIdForLogging + "'"));
            }
            this.parsePortions(portions);
            this.handleSpaceLeft();
        }
        if (this.columnsLeft() && LOG.isWarnEnabled()) {
            this.handleIllegalTokens();
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("cellLeft", this.cellsLeft).append("spaceLeft", this.spaceLeft).append("spaces", this.spaces).append("layoutTokens", (Object)this.layoutTokens).toString();
    }
}

