/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.taglib.component;

import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UICommand;

public class AttributeTag
extends TagSupport {
    private static final long serialVersionUID = 6231531736083277631L;
    private String name;
    private String value;

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doStartTag() throws JspException {
        ValueBinding valueBinding;
        UIComponentTag tag = UIComponentTag.getParentUIComponentTag((PageContext)this.pageContext);
        if (tag == null) {
            throw new JspException("Not nested in faces tag");
        }
        if (!tag.getCreated()) {
            return 0;
        }
        UIComponent component = tag.getComponentInstance();
        if (component == null) {
            throw new JspException("Component Instance is null");
        }
        String attributeName = this.name;
        if (UIComponentTag.isValueReference((String)this.name)) {
            valueBinding = ComponentUtil.createValueBinding(this.name);
            if (valueBinding == null) throw new JspException("Can not get ValueBinding for attribute name " + this.name);
            attributeName = (String)valueBinding.getValue(FacesContext.getCurrentInstance());
        }
        if (component instanceof EditableValueHolder && "validator".equals(attributeName)) {
            ComponentUtil.setValidator((EditableValueHolder)component, this.value);
            return 0;
        } else if (component instanceof ValueHolder && "converter".equals(attributeName)) {
            ComponentUtil.setConverter((ValueHolder)component, this.value);
            return 0;
        } else if ("styleClass".equals(attributeName)) {
            ComponentUtil.setStyleClasses(component, this.value);
            return 0;
        } else if ("renderedPartially".equals(attributeName) && component instanceof UICommand) {
            ComponentUtil.setRenderedPartially((UICommand)component, this.value);
            return 0;
        } else if (UIComponentTag.isValueReference((String)this.value)) {
            valueBinding = ComponentUtil.createValueBinding(this.value);
            if (valueBinding == null) throw new JspException("Can not get ValueBinding for attribute value " + this.value);
            component.setValueBinding(this.name, valueBinding);
            return 0;
        } else {
            component.getAttributes().put(attributeName, this.value);
        }
        return 0;
    }

    public void release() {
        super.release();
        this.name = null;
        this.value = null;
    }
}

