/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UIData;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.LayoutableRendererBase;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.RendererBaseWrapper;
import org.apache.myfaces.tobago.renderkit.html.HtmlStyleMap;
import org.apache.myfaces.tobago.renderkit.html.StyleClasses;
import org.apache.myfaces.tobago.util.LayoutUtil;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriterWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlRendererUtil {
    private static final Log LOG = LogFactory.getLog(HtmlRendererUtil.class);
    private static final String ERROR_FOCUS_KEY = HtmlRendererUtil.class.getName() + ".ErrorFocusId";

    private HtmlRendererUtil() {
    }

    private static boolean renderErrorFocusId(FacesContext facesContext, UIInput input) throws IOException {
        if (ComponentUtil.isError(input)) {
            if (!FacesContext.getCurrentInstance().getExternalContext().getRequestMap().containsKey(ERROR_FOCUS_KEY)) {
                FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(ERROR_FOCUS_KEY, Boolean.TRUE);
                TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter(facesContext);
                String id = input.getClientId(facesContext);
                writer.writeJavascript("Tobago.errorFocusId = '" + id + "';");
                return true;
            }
            return true;
        }
        return FacesContext.getCurrentInstance().getExternalContext().getRequestMap().containsKey(ERROR_FOCUS_KEY);
    }

    public static void renderFocusId(FacesContext facesContext, UIComponent component) throws IOException {
        if (component instanceof UIInput) {
            HtmlRendererUtil.renderFocusId(facesContext, (UIInput)component);
        }
    }

    public static void renderFocusId(FacesContext facesContext, UIInput component) throws IOException {
        if (HtmlRendererUtil.renderErrorFocusId(facesContext, component)) {
            return;
        }
        if (ComponentUtil.getBooleanAttribute((UIComponent)component, "focus")) {
            UIPage page = ComponentUtil.findPage(facesContext, (UIComponent)component);
            String id = component.getClientId(facesContext);
            if (!StringUtils.isBlank((String)page.getFocusId()) && !page.getFocusId().equals(id)) {
                LOG.warn((Object)("page focusId = \"" + page.getFocusId() + "\" ignoring new value \"" + id + "\""));
            } else {
                TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter(facesContext);
                writer.writeJavascript("Tobago.focusId = '" + id + "';");
            }
        }
    }

    public static void prepareRender(FacesContext facesContext, UIComponent component) {
        LayoutableRendererBase layoutRendererBase = ComponentUtil.getRenderer(facesContext, component);
        if (layoutRendererBase != null && !(layoutRendererBase instanceof RendererBaseWrapper)) {
            HtmlRendererUtil.createCssClass(facesContext, component);
            HtmlRendererUtil.layoutWidth(facesContext, component);
            HtmlRendererUtil.layoutHeight(facesContext, component);
        }
    }

    public static HtmlStyleMap prepareInnerStyle(UIComponent component) {
        HtmlStyleMap htmlStyleMap = new HtmlStyleMap();
        Integer innerSpaceInteger = (Integer)component.getAttributes().get("innerWidth");
        if (innerSpaceInteger != null && innerSpaceInteger != -1) {
            htmlStyleMap.put("width", (Object)innerSpaceInteger);
        }
        if ((innerSpaceInteger = (Integer)component.getAttributes().get("innerHeight")) != null && innerSpaceInteger != -1) {
            htmlStyleMap.put("height", (Object)innerSpaceInteger);
        }
        return htmlStyleMap;
    }

    public static void createCssClass(FacesContext facesContext, UIComponent component) {
        String rendererName = HtmlRendererUtil.getRendererName(facesContext, component);
        if (rendererName != null) {
            StyleClasses classes = StyleClasses.ensureStyleClasses(component);
            classes.updateClassAttributeAndMarkup(component, rendererName);
        }
    }

    public static String getRendererName(FacesContext facesContext, UIComponent component) {
        LayoutableRendererBase layoutableRendererBase;
        String rendererType = component.getRendererType();
        if (rendererType != null && (layoutableRendererBase = ComponentUtil.getRenderer(facesContext, component)) != null) {
            return layoutableRendererBase.getRendererName(rendererType);
        }
        return null;
    }

    public static void writeLabelWithAccessKey(TobagoResponseWriter writer, LabelWithAccessKey label) throws IOException {
        int pos = label.getPos();
        String text = label.getText();
        if (pos == -1) {
            writer.writeText(text);
        } else {
            writer.writeText(text.substring(0, pos));
            writer.startElement("u", null);
            writer.writeText(Character.toString(text.charAt(pos)));
            writer.endElement("u");
            writer.writeText(text.substring(pos + 1));
        }
    }

    public static void setDefaultTransition(FacesContext facesContext, boolean transition) throws IOException {
        HtmlRendererUtil.writeScriptLoader(facesContext, null, new String[]{"Tobago.transition = " + transition + ";"});
    }

    public static void addClickAcceleratorKey(FacesContext facesContext, String clientId, char key) throws IOException {
        HtmlRendererUtil.addClickAcceleratorKey(facesContext, clientId, key, null);
    }

    public static void addClickAcceleratorKey(FacesContext facesContext, String clientId, char key, String modifier) throws IOException {
        String str = HtmlRendererUtil.createOnclickAcceleratorKeyJsStatement(clientId, key, modifier);
        HtmlRendererUtil.writeScriptLoader(facesContext, null, new String[]{str});
    }

    public static void addAcceleratorKey(FacesContext facesContext, String func, char key) throws IOException {
        HtmlRendererUtil.addAcceleratorKey(facesContext, func, key, null);
    }

    public static void addAcceleratorKey(FacesContext facesContext, String func, char key, String modifier) throws IOException {
        String str = HtmlRendererUtil.createAcceleratorKeyJsStatement(func, key, modifier);
        HtmlRendererUtil.writeScriptLoader(facesContext, null, new String[]{str});
    }

    public static String createOnclickAcceleratorKeyJsStatement(String clientId, char key, String modifier) {
        String func = "Tobago.clickOnElement('" + clientId + "');";
        return HtmlRendererUtil.createAcceleratorKeyJsStatement(func, key, modifier);
    }

    public static String createAcceleratorKeyJsStatement(String func, char key, String modifier) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("new Tobago.AcceleratorKey(function() {");
        buffer.append(func);
        if (!func.endsWith(";")) {
            buffer.append(';');
        }
        buffer.append("}, \"");
        buffer.append(key);
        if (modifier != null) {
            buffer.append("\", \"");
            buffer.append(modifier);
        }
        buffer.append("\");");
        return buffer.toString();
    }

    public static String getLayoutSpaceStyle(UIComponent component) {
        StringBuilder sb = new StringBuilder();
        Integer space = LayoutUtil.getLayoutSpace(component, "layoutWidth", "layoutWidth");
        if (space != null) {
            sb.append(" width: ");
            sb.append(space);
            sb.append("px;");
        }
        if ((space = LayoutUtil.getLayoutSpace(component, "layoutHeight", "layoutHeight")) != null) {
            sb.append(" height: ");
            sb.append(space);
            sb.append("px;");
        }
        return sb.toString();
    }

    public static Integer getStyleAttributeIntValue(HtmlStyleMap style, String name) {
        if (style == null) {
            return null;
        }
        return style.getInt(name);
    }

    public static String getStyleAttributeValue(String style, String name) {
        if (style == null) {
            return null;
        }
        String value = null;
        StringTokenizer st = new StringTokenizer(style, ";");
        while (st.hasMoreTokens()) {
            String attribute = st.nextToken().trim();
            if (!attribute.startsWith(name)) continue;
            value = attribute.substring(attribute.indexOf(58) + 1).trim();
        }
        return value;
    }

    public static void replaceStyleAttribute(UIComponent component, String styleAttribute, String value) {
        HtmlStyleMap style = HtmlRendererUtil.ensureStyleAttributeMap(component);
        style.put(styleAttribute, (Object)value);
    }

    public static void replaceStyleAttribute(UIComponent component, String attribute, String styleAttribute, String value) {
        HtmlStyleMap style = HtmlRendererUtil.ensureStyleAttributeMap(component, attribute);
        style.put(styleAttribute, (Object)value);
    }

    public static void replaceStyleAttribute(UIComponent component, String styleAttribute, int value) {
        HtmlStyleMap style = HtmlRendererUtil.ensureStyleAttributeMap(component);
        style.put(styleAttribute, (Object)value);
    }

    public static void replaceStyleAttribute(UIComponent component, String attribute, String styleAttribute, int value) {
        HtmlStyleMap style = HtmlRendererUtil.ensureStyleAttributeMap(component, attribute);
        style.put(styleAttribute, (Object)value);
    }

    private static HtmlStyleMap ensureStyleAttributeMap(UIComponent component) {
        return HtmlRendererUtil.ensureStyleAttributeMap(component, "style");
    }

    private static HtmlStyleMap ensureStyleAttributeMap(UIComponent component, String attribute) {
        Map attributes = component.getAttributes();
        HtmlStyleMap style = (HtmlStyleMap)attributes.get(attribute);
        if (style == null) {
            style = new HtmlStyleMap();
            attributes.put(attribute, style);
        }
        return style;
    }

    public static String replaceStyleAttribute(String style, String name, String value) {
        style = HtmlRendererUtil.removeStyleAttribute(style != null ? style : "", name);
        return style + " " + name + ": " + value + ";";
    }

    public static String removeStyleAttribute(String style, String name) {
        if (style == null) {
            return null;
        }
        String pattern = name + "\\s*?:[^;]*?;";
        return style.replaceAll(pattern, "").trim();
    }

    public static void removeStyleAttribute(UIComponent component, String name) {
        HtmlRendererUtil.ensureStyleAttributeMap(component).remove(name);
    }

    @Deprecated
    public static void addCssClass(UIComponent component, String clazz) {
        StyleClasses.ensureStyleClasses(component).addFullQualifiedClass(clazz);
    }

    public static void layoutWidth(FacesContext facesContext, UIComponent component) {
        HtmlRendererUtil.layoutSpace(facesContext, component, true);
    }

    public static void layoutHeight(FacesContext facesContext, UIComponent component) {
        HtmlRendererUtil.layoutSpace(facesContext, component, false);
    }

    public static void layoutSpace(FacesContext facesContext, UIComponent component, boolean width) {
        UIComponent parent;
        String styleAttribute;
        String layoutAttribute;
        Integer layoutSpace;
        if (width) {
            layoutSpace = LayoutUtil.getLayoutWidth(component);
            layoutAttribute = "layoutWidth";
            styleAttribute = "width";
        } else {
            layoutSpace = LayoutUtil.getLayoutHeight(component);
            layoutAttribute = "layoutHeight";
            styleAttribute = "height";
        }
        int space = -1;
        if (layoutSpace != null) {
            space = layoutSpace;
        }
        if (space == -1 && !"Out".equals(component.getRendererType()) && (space = LayoutUtil.getInnerSpace(facesContext, parent = component.getParent(), width)) > 0 && !ComponentUtil.isFacetOf(component, parent)) {
            component.getAttributes().put(layoutAttribute, space);
            if (width) {
                component.getAttributes().remove("innerWidth");
            } else {
                component.getAttributes().remove("innerHeight");
            }
        }
        if (space > 0) {
            int layoutSpace2;
            UIComponent layout;
            LayoutableRendererBase renderer = ComponentUtil.getRenderer(facesContext, component);
            if (layoutSpace != null || !ComponentUtil.getBooleanAttribute(component, "inline")) {
                int styleSpace = space;
                if (renderer != null) {
                    styleSpace = width ? (styleSpace -= renderer.getComponentExtraWidth(facesContext, component)) : (styleSpace -= renderer.getComponentExtraHeight(facesContext, component));
                }
                HtmlRendererUtil.replaceStyleAttribute(component, styleAttribute, styleSpace);
            }
            if ((layout = component.getFacet("layout")) != null && (layoutSpace2 = LayoutUtil.getInnerSpace(facesContext, component, width)) > 0) {
                layout.getAttributes().put(layoutAttribute, layoutSpace2);
            }
        }
    }

    public static void createHeaderAndBodyStyles(FacesContext facesContext, UIComponent component) {
        HtmlRendererUtil.createHeaderAndBodyStyles(facesContext, component, true);
        HtmlRendererUtil.createHeaderAndBodyStyles(facesContext, component, false);
    }

    public static void createHeaderAndBodyStyles(FacesContext facesContext, UIComponent component, boolean width) {
        LayoutableRendererBase renderer = ComponentUtil.getRenderer(facesContext, component);
        HtmlStyleMap style = (HtmlStyleMap)component.getAttributes().get("style");
        Integer styleSpace = null;
        try {
            styleSpace = style.getInt(width ? "width" : "height");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (styleSpace != null) {
            int bodySpace = 0;
            int headerSpace = 0;
            if (!width) {
                if (renderer != null) {
                    headerSpace = renderer.getHeaderHeight(facesContext, component);
                }
                bodySpace = styleSpace - headerSpace;
            }
            HtmlStyleMap headerStyle = HtmlRendererUtil.ensureStyleAttributeMap(component, "style_header");
            HtmlStyleMap bodyStyle = HtmlRendererUtil.ensureStyleAttributeMap(component, "style_body");
            if (width) {
                headerStyle.put("width", (Object)styleSpace);
                bodyStyle.put("width", (Object)styleSpace);
            } else {
                headerStyle.put("height", (Object)headerSpace);
                bodyStyle.put("height", (Object)bodySpace);
            }
        }
    }

    @Deprecated
    public static void updateClassAttribute(String cssClass, String rendererName, UIComponent component) {
        throw new UnsupportedOperationException("Please use StyleClasses.ensureStyleClasses(component).updateClassAttribute(renderer, component)");
    }

    @Deprecated
    public static void addMarkupClass(UIComponent component, String rendererName, String subComponent, StringBuilder tobagoClass) {
        throw new UnsupportedOperationException("Please use StyleClasses.addMarkupClass()");
    }

    @Deprecated
    public static void addMarkupClass(UIComponent component, String rendererName, StyleClasses classes) {
        classes.addMarkupClass(component, rendererName);
    }

    public static void addImageSources(FacesContext facesContext, TobagoResponseWriter writer, String src, String id) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("new Tobago.Image('");
        buffer.append(id);
        buffer.append("','");
        buffer.append(ResourceManagerUtil.getImageWithPath(facesContext, src, false));
        buffer.append("','");
        buffer.append(ResourceManagerUtil.getImageWithPath(facesContext, HtmlRendererUtil.createSrc(src, "Disabled"), true));
        buffer.append("','");
        buffer.append(ResourceManagerUtil.getImageWithPath(facesContext, HtmlRendererUtil.createSrc(src, "Hover"), true));
        buffer.append("');");
        writer.writeJavascript(buffer.toString());
    }

    public static String createSrc(String src, String ext) {
        int dot = src.lastIndexOf(46);
        if (dot == -1) {
            LOG.warn((Object)("Image src without extension: '" + src + "'"));
            return src;
        }
        return src.substring(0, dot) + ext + src.substring(dot);
    }

    public static TobagoResponseWriter getTobagoResponseWriter(FacesContext facesContext) {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (writer instanceof TobagoResponseWriter) {
            return (TobagoResponseWriter)writer;
        }
        return new TobagoResponseWriterWrapper(writer);
    }

    @Deprecated
    public static void writeJavascript(ResponseWriter writer, String script) throws IOException {
        HtmlRendererUtil.startJavascript(writer);
        writer.write(script);
        HtmlRendererUtil.endJavascript(writer);
    }

    @Deprecated
    public static void startJavascript(ResponseWriter writer) throws IOException {
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("\n<!--\n");
    }

    @Deprecated
    public static void endJavascript(ResponseWriter writer) throws IOException {
        writer.write("\n// -->\n");
        writer.endElement("script");
    }

    public static void writeScriptLoader(FacesContext facesContext, String script) throws IOException {
        HtmlRendererUtil.writeScriptLoader(facesContext, new String[]{script}, null);
    }

    public static void writeScriptLoader(FacesContext facesContext, String[] scripts, String[] afterLoadCmds) throws IOException {
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter(facesContext);
        String allScripts = "[]";
        if (scripts != null) {
            allScripts = ResourceManagerUtil.getScriptsAsJSArray(facesContext, scripts);
        }
        StringBuilder script = new StringBuilder();
        script.append("new Tobago.ScriptLoader(\n    ");
        script.append(allScripts);
        if (afterLoadCmds != null && afterLoadCmds.length > 0) {
            script.append(", \n");
            boolean first = true;
            for (String afterLoadCmd : afterLoadCmds) {
                String[] splittedStrings;
                for (String splitted : splittedStrings = StringUtils.split((String)afterLoadCmd, (char)'\n')) {
                    String cmd = StringUtils.replace((String)splitted, (String)"\\", (String)"\\\\");
                    cmd = StringUtils.replace((String)cmd, (String)"\"", (String)"\\\"");
                    script.append(first ? "          " : "        + ");
                    script.append("\"");
                    script.append(cmd);
                    script.append("\"\n");
                    first = false;
                }
            }
        }
        script.append(");");
        writer.writeJavascript(script.toString());
    }

    public static void writeStyleLoader(FacesContext facesContext, String[] styles) throws IOException {
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter(facesContext);
        StringBuilder builder = new StringBuilder();
        builder.append("Tobago.ensureStyleFiles(\n    ");
        builder.append(ResourceManagerUtil.getStylesAsJSArray(facesContext, styles));
        builder.append(");");
        writer.writeJavascript(builder.toString());
    }

    public static String getTitleFromTipAndMessages(FacesContext facesContext, UIComponent component) {
        String messages = ComponentUtil.getFacesMessageAsString(facesContext, component);
        return HtmlRendererUtil.addTip(messages, component.getAttributes().get("tip"));
    }

    public static String addTip(String title, Object tip) {
        if (tip != null) {
            title = title != null && title.length() > 0 ? title + " :: " : "";
            title = title + tip;
        }
        return title;
    }

    public static void renderSelectItems(UIInput component, List<SelectItem> items, Object[] values, TobagoResponseWriter writer, FacesContext facesContext) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("value = '" + Arrays.toString(values) + "'"));
        }
        for (SelectItem item : items) {
            String image;
            if (item instanceof SelectItemGroup) {
                writer.startElement("optgroup", null);
                writer.writeAttribute("label", item.getLabel(), true);
                if (item.isDisabled()) {
                    writer.writeAttribute("disabled", true);
                }
                SelectItem[] selectItems = ((SelectItemGroup)item).getSelectItems();
                HtmlRendererUtil.renderSelectItems(component, Arrays.asList(selectItems), values, writer, facesContext);
                writer.endElement("optgroup");
                continue;
            }
            writer.startElement("option", null);
            Object itemValue = item.getValue();
            if (itemValue instanceof String && values != null && values.length > 0 && !(values[0] instanceof String)) {
                itemValue = ComponentUtil.getConvertedValue(facesContext, component, (String)itemValue);
            }
            String formattedValue = RenderUtil.getFormattedValue(facesContext, (UIComponent)component, itemValue);
            writer.writeAttribute("value", formattedValue, true);
            if (item instanceof org.apache.myfaces.tobago.model.SelectItem && (image = ((org.apache.myfaces.tobago.model.SelectItem)item).getImage()) != null) {
                String imagePath = ResourceManagerUtil.getImageWithPath(facesContext, image);
                writer.writeStyleAttribute("background-image: url('" + imagePath + "')");
            }
            if (item instanceof SupportsMarkup) {
                StyleClasses optionStyle = new StyleClasses();
                optionStyle.addMarkupClass((SupportsMarkup)item, HtmlRendererUtil.getRendererName(facesContext, (UIComponent)component), "option");
                writer.writeClassAttribute(optionStyle);
            }
            if (RenderUtil.contains(values, itemValue)) {
                writer.writeAttribute("selected", true);
            }
            if (item.isDisabled()) {
                writer.writeAttribute("disabled", true);
            }
            writer.writeText(item.getLabel());
            writer.endElement("option");
        }
    }

    public static String getComponentId(FacesContext context, UIComponent component, String componentId) {
        UIComponent partiallyComponent = ComponentUtil.findComponent(component, componentId);
        if (partiallyComponent != null) {
            int rowIndex;
            String clientId = partiallyComponent.getClientId(context);
            if (partiallyComponent instanceof UIData && (rowIndex = ((UIData)partiallyComponent).getRowIndex()) >= 0 && clientId.endsWith(Integer.toString(rowIndex))) {
                return clientId.substring(0, clientId.lastIndexOf(58));
            }
            return clientId;
        }
        LOG.error((Object)("No Component found for id " + componentId + " search base component " + component.getClientId(context)));
        return null;
    }

    public static String toStyleString(String key, Integer value) {
        StringBuilder buf = new StringBuilder();
        buf.append(key);
        buf.append(":");
        buf.append(value);
        buf.append("px; ");
        return buf.toString();
    }

    public static String toStyleString(String key, String value) {
        StringBuilder buf = new StringBuilder();
        buf.append(key);
        buf.append(":");
        buf.append(value);
        buf.append("; ");
        return buf.toString();
    }

    public static void renderTip(UIComponent component, TobagoResponseWriter writer) throws IOException {
        Object objTip = component.getAttributes().get("tip");
        if (objTip != null) {
            writer.writeAttribute("title", String.valueOf(objTip), true);
        }
    }

    public static void renderImageTip(UIComponent component, TobagoResponseWriter writer) throws IOException {
        Object objTip = component.getAttributes().get("tip");
        if (objTip != null) {
            writer.writeAttribute("alt", String.valueOf(objTip), true);
        } else {
            writer.writeAttribute("alt", "", false);
        }
    }

    public static String getJavascriptString(String str) {
        if (str != null) {
            return "\"" + str + "\"";
        }
        return null;
    }

    public static String getRenderedPartiallyJavascriptArray(FacesContext facesContext, UICommand command) {
        if (command == null) {
            return null;
        }
        String[] list = command.getRenderedPartially();
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[");
        for (int i = 0; i < list.length; ++i) {
            if (i != 0) {
                strBuilder.append(",");
            }
            strBuilder.append("\"");
            strBuilder.append(HtmlRendererUtil.getComponentId(facesContext, (UIComponent)command, list[i]));
            strBuilder.append("\"");
        }
        strBuilder.append("]");
        return strBuilder.toString();
    }

    public static String getJavascriptArray(String[] list) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[");
        for (int i = 0; i < list.length; ++i) {
            if (i != 0) {
                strBuilder.append(",");
            }
            strBuilder.append("\"");
            strBuilder.append(list[i]);
            strBuilder.append("\"");
        }
        strBuilder.append("]");
        return strBuilder.toString();
    }

    public static void removeStyleClasses(UIComponent cell) {
        Object obj = cell.getAttributes().get("styleClass");
        if (obj != null && obj instanceof StyleClasses && cell.getRendererType() != null) {
            StyleClasses styleClasses = (StyleClasses)obj;
            if (!styleClasses.isEmpty()) {
                String rendererName = cell.getRendererType().substring(0, 1).toLowerCase(Locale.ENGLISH) + cell.getRendererType().substring(1);
                styleClasses.removeTobagoClasses(rendererName);
            }
            if (styleClasses.isEmpty()) {
                cell.getAttributes().remove("styleClass");
            }
        }
    }
}

