/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.layout.Box;
import org.apache.myfaces.tobago.renderkit.LayoutableRendererBase;

public class PageRendererBase
extends LayoutableRendererBase {
    private static final Log LOG = LogFactory.getLog(PageRendererBase.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        if (component instanceof UIPage) {
            UIPage page = (UIPage)component;
            String name = page.getClientId(facesContext) + "::" + "form-action";
            String newActionId = (String)facesContext.getExternalContext().getRequestParameterMap().get(name);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("action = " + newActionId));
            }
            page.setActionId(newActionId);
            try {
                String actionPositionName = page.getClientId(facesContext) + "::" + "action-position";
                String actionPositionString = (String)facesContext.getExternalContext().getRequestParameterMap().get(actionPositionName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("actionPosition='" + actionPositionString + "'"));
                }
                if (StringUtils.isNotEmpty((String)actionPositionString)) {
                    Box actionPosition = new Box(actionPositionString);
                    page.setActionPosition(actionPosition);
                } else {
                    page.setActionPosition(null);
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Can't analyse parameter for action-position", (Throwable)e);
            }
        }
    }
}

