/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.portlet;

import java.io.UnsupportedEncodingException;
import javax.faces.context.FacesContext;
import javax.portlet.ActionRequest;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;

public final class PortletUtils {
    private static final boolean PORTLET_API_AVAILABLE = PortletUtils.portletApiAvailable();
    private static final String VIEW_ID = PortletUtils.class.getName() + ".VIEW_ID";

    private static boolean portletApiAvailable() {
        try {
            return PortletRequest.class != null;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    private PortletUtils() {
    }

    public static boolean isRenderResponse(FacesContext facesContext) {
        return PORTLET_API_AVAILABLE && facesContext.getExternalContext().getResponse() instanceof RenderResponse;
    }

    public static boolean isPortletRequest(FacesContext facesContext) {
        return PORTLET_API_AVAILABLE && facesContext.getExternalContext().getContext() instanceof PortletContext;
    }

    public static String getViewId(FacesContext facesContext) {
        PortletRequest request = (PortletRequest)facesContext.getExternalContext().getRequest();
        return request.getParameter(VIEW_ID);
    }

    public static String setViewIdForUrl(FacesContext facesContext, String viewId) {
        RenderResponse response = (RenderResponse)facesContext.getExternalContext().getResponse();
        PortletURL url = response.createActionURL();
        url.setParameter(VIEW_ID, viewId);
        return url.toString();
    }

    public static void ensureEncoding(FacesContext facesContext) throws UnsupportedEncodingException {
        ActionRequest request = (ActionRequest)facesContext.getExternalContext().getRequest();
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding("UTF-8");
        }
    }

    public static Object getAttributeFromSessionForApplication(Object session, String name) {
        if (PORTLET_API_AVAILABLE && session instanceof PortletSession) {
            return ((PortletSession)session).getAttribute(name, 1);
        }
        throw new IllegalArgumentException("Unknown session type: " + session.getClass().getName());
    }
}

