/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.lifecycle;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.lifecycle.PhaseExecutor;
import org.apache.myfaces.tobago.lifecycle.TobagoLifecycle;
import org.apache.myfaces.tobago.webapp.Secret;

class RestoreViewExecutor
implements PhaseExecutor {
    private static final Log LOG = LogFactory.getLog(RestoreViewExecutor.class);

    RestoreViewExecutor() {
    }

    public boolean execute(FacesContext facesContext) {
        Application application;
        ViewHandler viewHandler;
        ExternalContext externalContext = facesContext.getExternalContext();
        Map sessionMap = externalContext.getSessionMap();
        UIViewRoot viewRoot = (UIViewRoot)sessionMap.get(TobagoLifecycle.VIEW_ROOT_KEY);
        if (viewRoot != null) {
            facesContext.setViewRoot(viewRoot);
            sessionMap.remove(TobagoLifecycle.VIEW_ROOT_KEY);
            List messageHolders = (List)sessionMap.get(TobagoLifecycle.FACES_MESSAGES_KEY);
            if (messageHolders != null) {
                for (Object[] messageHolder : messageHolders) {
                    facesContext.addMessage((String)messageHolder[0], (FacesMessage)messageHolder[1]);
                }
            }
            sessionMap.remove(TobagoLifecycle.FACES_MESSAGES_KEY);
            facesContext.renderResponse();
            return true;
        }
        if (facesContext.getViewRoot() != null) {
            facesContext.getViewRoot().setLocale(facesContext.getExternalContext().getRequestLocale());
            ComponentUtil.resetPage(facesContext);
            RestoreViewExecutor.recursivelyHandleComponentReferencesAndSetValid(facesContext, (UIComponent)facesContext.getViewRoot());
            return false;
        }
        String viewId = RestoreViewExecutor.deriveViewId(facesContext);
        if (viewId == null) {
            if (externalContext.getRequestServletPath() == null) {
                return true;
            }
            if (!externalContext.getRequestServletPath().endsWith("/")) {
                try {
                    externalContext.redirect(externalContext.getRequestServletPath() + "/");
                    facesContext.responseComplete();
                    return true;
                }
                catch (IOException e) {
                    throw new FacesException("redirect failed", (Throwable)e);
                }
            }
        }
        if ((viewRoot = (viewHandler = (application = facesContext.getApplication()).getViewHandler()).restoreView(facesContext, viewId)) == null) {
            viewRoot = viewHandler.createView(facesContext, viewId);
            viewRoot.setViewId(viewId);
            facesContext.renderResponse();
        }
        facesContext.setViewRoot(viewRoot);
        ComponentUtil.resetPage(facesContext);
        if (!this.isPostBack(facesContext)) {
            facesContext.renderResponse();
        }
        if (!this.isSessionSecretValid(facesContext)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Secret is invalid!");
            }
            facesContext.renderResponse();
        }
        RestoreViewExecutor.recursivelyHandleComponentReferencesAndSetValid(facesContext, (UIComponent)viewRoot);
        facesContext.getExternalContext().getRequestMap().put(TobagoLifecycle.VIEW_ROOT_KEY, viewRoot);
        return false;
    }

    private boolean isPostBack(FacesContext facesContext) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        return requestParameterMap.containsKey("jsf_tree");
    }

    private boolean isSessionSecretValid(FacesContext facesContext) {
        if (TobagoConfig.getInstance(FacesContext.getCurrentInstance()).isCheckSessionSecret()) {
            return Secret.check(facesContext);
        }
        return true;
    }

    public PhaseId getPhase() {
        return PhaseId.RESTORE_VIEW;
    }

    private static String deriveViewId(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        String viewId = externalContext.getRequestPathInfo();
        if (viewId == null) {
            String suffix;
            viewId = externalContext.getRequestServletPath();
            if (viewId == null) {
                String msg = "RequestServletPath is null, cannot determine viewId of current page.";
                LOG.error((Object)msg);
                throw new FacesException(msg);
            }
            String defaultSuffix = externalContext.getInitParameter("javax.faces.DEFAULT_SUFFIX");
            String string = suffix = defaultSuffix != null ? defaultSuffix : ".jsp";
            if (suffix.charAt(0) != '.') {
                String msg = "Default suffix must start with a dot!";
                LOG.error((Object)msg);
                throw new FacesException(msg);
            }
            int dot = viewId.lastIndexOf(46);
            if (dot == -1) {
                LOG.error((Object)("Assumed extension mapping, but there is no extension in " + viewId));
                viewId = null;
            } else {
                viewId = viewId.substring(0, dot) + suffix;
            }
        }
        return viewId;
    }

    public static void recursivelyHandleComponentReferencesAndSetValid(FacesContext facesContext, UIComponent parent) {
        boolean forceHandle = false;
        Method handleBindingsMethod = RestoreViewExecutor.getBindingMethod(parent);
        if (handleBindingsMethod != null && !forceHandle) {
            try {
                handleBindingsMethod.invoke((Object)parent, new Object[0]);
            }
            catch (Throwable th) {
                LOG.error((Object)("Exception while invoking handleBindings on component with client-id:" + parent.getClientId(facesContext)), th);
            }
        } else {
            Iterator it = parent.getFacetsAndChildren();
            while (it.hasNext()) {
                UIComponent component = (UIComponent)it.next();
                ValueBinding binding = component.getValueBinding("binding");
                if (binding != null && !binding.isReadOnly(facesContext)) {
                    binding.setValue(facesContext, (Object)component);
                }
                if (component instanceof UIInput) {
                    ((UIInput)component).setValid(true);
                }
                RestoreViewExecutor.recursivelyHandleComponentReferencesAndSetValid(facesContext, component);
            }
        }
    }

    private static Method getBindingMethod(UIComponent parent) {
        Class<?>[] clazzes;
        for (Class<?> clazz : clazzes = parent.getClass().getInterfaces()) {
            if (clazz.getName().indexOf("BindingAware") == -1) continue;
            try {
                return parent.getClass().getMethod("handleBindings", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return null;
    }
}

