/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.lifecycle;

import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.ajax.api.AjaxUtils;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.component.UIViewRoot;
import org.apache.myfaces.tobago.lifecycle.PhaseExecutor;
import org.apache.myfaces.tobago.util.ApplyRequestValuesCallback;
import org.apache.myfaces.tobago.util.Callback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ApplyRequestValuesExecutor
implements PhaseExecutor {
    private static final Log LOG = LogFactory.getLog(ApplyRequestValuesExecutor.class);
    private Callback callback = new ApplyRequestValuesCallback();

    @Override
    public boolean execute(FacesContext facesContext) {
        Map<String, UIComponent> ajaxComponents = AjaxUtils.parseAndStoreComponents(facesContext);
        if (ajaxComponents != null) {
            UIPage page = ComponentUtil.findPage(facesContext);
            page.decode(facesContext);
            page.markSubmittedForm(facesContext);
            this.decodeActionComponent(facesContext, page, ajaxComponents);
            for (Map.Entry<String, UIComponent> entry : ajaxComponents.entrySet()) {
                UIComponent ajaxComponent = entry.getValue();
                ComponentUtil.invokeOnComponent(facesContext, entry.getKey(), ajaxComponent, this.callback);
            }
            UIViewRoot viewRoot = (UIViewRoot)facesContext.getViewRoot();
            viewRoot.broadcastEventsForPhase(facesContext, PhaseId.APPLY_REQUEST_VALUES);
        } else {
            facesContext.getViewRoot().processDecodes(facesContext);
        }
        return false;
    }

    private void decodeActionComponent(FacesContext facesContext, UIPage page, Map<String, UIComponent> ajaxComponents) {
        String actionId = page.getActionId();
        UIComponent actionComponent = null;
        if (actionId != null) {
            actionComponent = facesContext.getViewRoot().findComponent(actionId);
        }
        if (actionComponent == null) {
            return;
        }
        for (UIComponent ajaxComponent : ajaxComponents.values()) {
            for (UIComponent component = actionComponent; component != null; component = component.getParent()) {
                if (component != ajaxComponent) continue;
                return;
            }
        }
        ComponentUtil.invokeOnComponent(facesContext, actionId, actionComponent, this.callback);
    }

    @Override
    public PhaseId getPhase() {
        return PhaseId.APPLY_REQUEST_VALUES;
    }
}

