/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.ResourceManagerFactory;
import org.apache.myfaces.tobago.context.ResourceUtils;
import org.apache.myfaces.tobago.renderkit.html.CommandRendererHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceManagerUtil {
    private ResourceManagerUtil() {
    }

    public static String getProperty(FacesContext facesContext, String bundle, String key) {
        return ResourceManagerFactory.getResourceManager(facesContext).getProperty(facesContext.getViewRoot(), bundle, key);
    }

    public static String getPropertyNotNull(FacesContext facesContext, String bundle, String key) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        String result = ResourceManagerFactory.getResourceManager(facesContext).getProperty(viewRoot, bundle, key);
        if (result == null) {
            return "???" + key + "???";
        }
        return result;
    }

    public static String getImageWithPath(FacesContext facesContext, String name) {
        return facesContext.getExternalContext().getRequestContextPath() + ResourceManagerFactory.getResourceManager(facesContext).getImage(facesContext.getViewRoot(), name);
    }

    public static String getImageWithPath(FacesContext facesContext, String name, boolean ignoreMissing) {
        String image = ResourceManagerFactory.getResourceManager(facesContext).getImage(facesContext.getViewRoot(), name, ignoreMissing);
        if (image == null) {
            return null;
        }
        return facesContext.getExternalContext().getRequestContextPath() + image;
    }

    public static List<String> getStyles(FacesContext facesContext, String name) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        String contextPath = facesContext.getExternalContext().getRequestContextPath();
        String[] styles = ResourceManagerFactory.getResourceManager(facesContext).getStyles(viewRoot, name);
        return ResourceManagerUtil.addContextPath(styles, contextPath);
    }

    private static List<String> addContextPath(String[] strings, String contextPath) {
        ArrayList<String> withContext = new ArrayList<String>(strings.length);
        for (String string : strings) {
            withContext.add(contextPath + string);
        }
        return withContext;
    }

    public static List<String> getScripts(FacesContext facesContext, String name) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        String contextPath = facesContext.getExternalContext().getRequestContextPath();
        String[] scripts = ResourceManagerFactory.getResourceManager(facesContext).getScripts(viewRoot, name);
        return ResourceManagerUtil.addContextPath(scripts, contextPath);
    }

    public static String getScriptsAsJSArray(FacesContext facesContext, String[] names) {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String name : names) {
            fileNames.addAll(ResourceManagerUtil.getScripts(facesContext, name));
        }
        return ResourceManagerUtil.toJSArray(fileNames);
    }

    public static String getStylesAsJSArray(FacesContext facesContext, String[] names) {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String name : names) {
            fileNames.addAll(ResourceManagerUtil.getStyles(facesContext, name));
        }
        return ResourceManagerUtil.toJSArray(fileNames);
    }

    public static String toJSArray(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String name : list) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append('\'');
            sb.append(name);
            sb.append('\'');
        }
        return "[" + sb.toString() + "]";
    }

    public static String getDisabledImageWithPath(FacesContext facesContext, String image) {
        String filename = ResourceUtils.addPostfixToFilename(image, "Disabled");
        return ResourceManagerUtil.getImageWithPath(facesContext, filename, true);
    }

    public static String getImageWithPath(FacesContext facesContext, String image, CommandRendererHelper helper) {
        String imageWithPath = null;
        if (helper.isDisabled()) {
            imageWithPath = ResourceManagerUtil.getDisabledImageWithPath(facesContext, image);
        }
        if (imageWithPath == null) {
            imageWithPath = ResourceManagerUtil.getImageWithPath(facesContext, image);
        }
        return imageWithPath;
    }

    public static String getBlankPage(FacesContext facesContext) {
        return facesContext.getExternalContext().getRequestContextPath() + "/org/apache/myfaces/tobago/renderkit/html/standard/blank.html";
    }

    public static String getPageWithoutContextPath(FacesContext facesContext, String name) {
        return ResourceManagerFactory.getResourceManager(facesContext).getImage(facesContext.getViewRoot(), name);
    }

    public static boolean isAbsoluteResource(String value) {
        if (value == null) {
            return true;
        }
        String upper = value.toUpperCase(Locale.ENGLISH);
        return upper.startsWith("/") || upper.startsWith("HTTP:") || upper.startsWith("HTTPS:") || upper.startsWith("FTP:");
    }
}

