/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.UserAgent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientProperties
implements Serializable {
    private static final long serialVersionUID = -6719319982485268698L;
    private static final String CLIENT_PROPERTIES_IN_SESSION = ClientProperties.class.getName();
    private static final Log LOG = LogFactory.getLog(ClientProperties.class);
    private String contentType = "html";
    private Theme theme;
    private UserAgent userAgent = UserAgent.DEFAULT;
    private boolean debugMode;
    private String id;

    private ClientProperties(TobagoConfig tobagoConfig) {
        this.theme = tobagoConfig.getDefaultTheme();
        this.updateId();
    }

    private ClientProperties(FacesContext facesContext) {
        String acceptLanguage;
        ExternalContext externalContext = facesContext.getExternalContext();
        String accept = (String)externalContext.getRequestHeaderMap().get("Accept");
        if (accept != null && accept.indexOf("text/vnd.wap.wml") > -1) {
            this.contentType = "wml";
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("contentType='" + this.contentType + "' from header " + "Accept='" + accept + "'"));
        }
        String requestUserAgent = (String)externalContext.getRequestHeaderMap().get("User-Agent");
        this.userAgent = UserAgent.getInstance(requestUserAgent);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("userAgent='" + this.userAgent + "' from header " + "'User-Agent: " + requestUserAgent + "'"));
        }
        if ((acceptLanguage = (String)externalContext.getRequestHeaderMap().get("Accept-Language")) != null) {
            boolean bl = this.debugMode = acceptLanguage.indexOf("to-ba-go") > -1;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("debug-mode=" + this.debugMode));
        }
        String requestTheme = (String)externalContext.getRequestParameterMap().get("tobago.theme");
        TobagoConfig config = TobagoConfig.getInstance(facesContext);
        this.theme = config.getTheme(requestTheme);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("theme='" + this.theme.getName() + "' from requestParameter " + "tobago.theme='" + requestTheme + "'"));
        }
        this.updateId();
    }

    private void updateId() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getContentType());
        buffer.append('/');
        buffer.append(this.getTheme().getName());
        buffer.append('/');
        buffer.append(this.getUserAgent());
        this.id = buffer.toString();
        UIViewRoot viewRoot = FacesContext.getCurrentInstance().getViewRoot();
        if (viewRoot instanceof org.apache.myfaces.tobago.component.UIViewRoot) {
            ((org.apache.myfaces.tobago.component.UIViewRoot)viewRoot).updateRendererCachePrefix();
        }
    }

    public static ClientProperties getDefaultInstance(FacesContext facesContext) {
        return new ClientProperties(TobagoConfig.getInstance(facesContext));
    }

    public static ClientProperties getInstance(UIViewRoot viewRoot) {
        ClientProperties instance = (ClientProperties)viewRoot.getAttributes().get("clientProperties");
        if (instance == null) {
            LOG.error((Object)"No ClientProperties instance found creating new one");
            return ClientProperties.getInstance(FacesContext.getCurrentInstance());
        }
        return instance;
    }

    public static ClientProperties getInstance(FacesContext facesContext) {
        ExternalContext context = facesContext.getExternalContext();
        boolean hasSession = context.getSession(false) != null;
        ClientProperties client = null;
        if (hasSession) {
            client = (ClientProperties)context.getSessionMap().get(CLIENT_PROPERTIES_IN_SESSION);
        }
        if (client == null) {
            client = new ClientProperties(facesContext);
            if (hasSession) {
                context.getSessionMap().put(CLIENT_PROPERTIES_IN_SESSION, client);
            }
        }
        return client;
    }

    public static List<String> getLocaleList(Locale locale, boolean propertyPathMode) {
        int underscore;
        String string = locale.toString();
        String prefix = propertyPathMode ? "" : "_";
        ArrayList<String> locales = new ArrayList<String>(4);
        locales.add(prefix + string);
        while ((underscore = string.lastIndexOf(95)) > 0) {
            string = string.substring(0, underscore);
            locales.add(prefix + string);
        }
        locales.add(propertyPathMode ? "default" : "");
        return locales;
    }

    public String getId() {
        return this.id;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        this.updateId();
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
        this.updateId();
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(UserAgent userAgent) {
        this.userAgent = userAgent;
        this.updateId();
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }
}

