/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.UITreeOld;

@Deprecated
public class UITreeOldNode
extends UIInput {
    private static final Log LOG = LogFactory.getLog(UITreeOldNode.class);
    private static final String SUB_REFERENCE_KEY = "subReferenceKey";

    protected UITreeOldNode(UIComponent parent, int index) {
        if (parent instanceof UITreeOldNode) {
            String parentSubReference = ((UITreeOldNode)parent).getSubReference();
            if (parentSubReference == null) {
                this.getAttributes().put(SUB_REFERENCE_KEY, "childAt[" + index + "]");
            } else {
                this.getAttributes().put(SUB_REFERENCE_KEY, parentSubReference + ".childAt[" + index + "]");
            }
        }
        this.setRendererType("TreeOldNode");
        parent.getChildren().add(this);
        this.initId();
        this.initName();
        this.initDisabled();
        this.initTip();
    }

    public UITreeOldNode() {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public String getSubReference() {
        return (String)this.getAttributes().get(SUB_REFERENCE_KEY);
    }

    public DefaultMutableTreeNode getTreeNode() {
        return (DefaultMutableTreeNode)this.getValue();
    }

    public Object getValue() {
        TreeNode value = null;
        UITreeOld root = this.findTreeRoot();
        String subReference = this.getSubReference();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("root         = '" + (Object)((Object)root) + "'"));
            LOG.debug((Object)("subReference = '" + subReference + "'"));
        }
        TreeNode rootNode = (TreeNode)root.getValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("rootNode = '" + rootNode + "'"));
        }
        if (rootNode != null) {
            try {
                value = subReference == null ? rootNode : (TreeNode)PropertyUtils.getProperty((Object)rootNode, (String)subReference);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("treeNode     = '" + value + "'"));
                }
            }
            catch (Throwable e) {
                LOG.error((Object)("subReference = '" + subReference + "'"), e);
            }
        }
        return value;
    }

    protected void createTreeNodes() {
        TreeNode node = (TreeNode)this.getValue();
        if (node != null) {
            int childCount = node.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UITreeOldNode component = new UITreeOldNode((UIComponent)this, i);
                component.createTreeNodes();
            }
        }
    }

    private void initName() {
        TreeNode treeNode = (TreeNode)this.getValue();
        if (treeNode != null) {
            Object name = this.getReference(treeNode, "nameReference");
            if (name == null) {
                name = ((Object)((Object)this)).toString();
            }
            this.getAttributes().put("name", name.toString());
        }
    }

    private void initTip() {
        Object tip;
        TreeNode treeNode = (TreeNode)this.getValue();
        if (treeNode != null && (tip = this.getReference(treeNode, "tipReference")) != null) {
            this.getAttributes().put("tip", tip.toString());
        }
    }

    private void initDisabled() {
        TreeNode treeNode = (TreeNode)this.getValue();
        if (treeNode != null) {
            Object disabled = this.getReference(treeNode, "disabledReference");
            if (!(disabled instanceof Boolean)) {
                disabled = disabled instanceof String ? Boolean.valueOf((String)disabled) : Boolean.valueOf(false);
            }
            this.getAttributes().put("disabled", disabled);
        }
    }

    private void initId() {
        TreeNode treeNode = (TreeNode)this.getValue();
        if (treeNode != null) {
            Object id = this.getReference(treeNode, "idReference");
            if (!(id instanceof String)) {
                id = "node" + Integer.toString(System.identityHashCode(treeNode));
            }
            this.setId((String)id);
        }
    }

    private Object getReference(TreeNode treeNode, String key) {
        Object value = null;
        String reference = null;
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            UITreeOld root = this.findTreeRoot();
            ValueBinding binding = root.getValueBinding(key);
            if (binding == null) {
                reference = (String)root.getAttributes().get(key);
                if (reference == null) {
                    return null;
                }
                String ref = "#{tobagoTreeNode." + reference + "}";
                binding = facesContext.getApplication().createValueBinding(ref);
            } else {
                reference = binding.getExpressionString();
            }
            Map requestMap = facesContext.getExternalContext().getRequestMap();
            requestMap.put("tobagoTreeNode", treeNode);
            value = binding.getValue(facesContext);
            requestMap.remove("tobagoTreeNode");
        }
        catch (Exception e) {
            LOG.warn((Object)("Can't find " + key + " over ref='" + reference + "' treeNode='" + treeNode + "! " + treeNode.getClass().getName()), (Throwable)e);
        }
        return value;
    }

    public UITreeOld findTreeRoot() {
        UIComponent ancestor;
        for (ancestor = this.getParent(); ancestor != null && ancestor instanceof UITreeOldNode; ancestor = ancestor.getParent()) {
        }
        if (ancestor instanceof UITreeOld) {
            return (UITreeOld)ancestor;
        }
        return null;
    }

    public void updateModel(FacesContext facesContext) {
    }
}

