/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.tobago.ajax.api.AjaxComponent;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.component.UIPanelBase;

public class UIPopup
extends UIPanelBase
implements NamingContainer,
AjaxComponent {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.Popup";
    private String width;
    private String height;
    private String left;
    private String top;
    private boolean activated;
    private Boolean modal;

    public void setActivated(boolean activated) {
        this.activated = activated;
        this.addToPage();
    }

    public void processDecodes(FacesContext facesContext) {
        if (this.isSubmitted()) {
            Iterator it = this.getFacetsAndChildren();
            while (it.hasNext()) {
                UIComponent childOrFacet = (UIComponent)it.next();
                childOrFacet.processDecodes(facesContext);
            }
            try {
                this.decode(facesContext);
            }
            catch (RuntimeException e) {
                facesContext.renderResponse();
                throw e;
            }
            if (facesContext.getRenderResponse()) {
                this.setActivated(true);
            }
            this.addToPage();
        }
    }

    public boolean isRendered() {
        ValueBinding valueBinding = this.getValueBinding("rendered");
        if (valueBinding != null) {
            return (Boolean)valueBinding.getValue(this.getFacesContext());
        }
        return this.isActivated() || this.isRedisplay();
    }

    private boolean isSubmitted() {
        String action = ComponentUtil.findPage(this.getFacesContext(), (UIComponent)this).getActionId();
        return action != null && action.startsWith(this.getClientId(this.getFacesContext()) + ':');
    }

    private boolean isRedisplay() {
        UIComponent command;
        UIPage page;
        String action;
        if (this.isSubmitted() && (action = (page = ComponentUtil.findPage(this.getFacesContext(), (UIComponent)this)).getActionId()) != null && (command = page.findComponent(':' + action)) != null && command instanceof UICommand) {
            return command.getAttributes().get("popupClose") == null;
        }
        return false;
    }

    private boolean isActivated() {
        return this.activated;
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        super.encodeBegin(facesContext);
    }

    public void processValidators(FacesContext context) {
        if (this.isSubmitted()) {
            Iterator it = this.getFacetsAndChildren();
            while (it.hasNext()) {
                UIComponent childOrFacet = (UIComponent)it.next();
                childOrFacet.processValidators(context);
            }
            if (context.getRenderResponse()) {
                this.setActivated(true);
            }
        }
    }

    public void processUpdates(FacesContext context) {
        if (this.isSubmitted()) {
            Iterator it = this.getFacetsAndChildren();
            while (it.hasNext()) {
                UIComponent childOrFacet = (UIComponent)it.next();
                childOrFacet.processUpdates(context);
            }
        }
    }

    public void setParent(UIComponent uiComponent) {
        super.setParent(uiComponent);
        this.addToPage();
    }

    public Object saveState(FacesContext context) {
        Object[] saveState = new Object[]{super.saveState(context), this.width, this.height, this.left, this.top, this.activated, this.modal};
        return saveState;
    }

    public void restoreState(FacesContext context, Object savedState) {
        Object[] values = (Object[])savedState;
        super.restoreState(context, values[0]);
        this.width = (String)values[1];
        this.height = (String)values[2];
        this.left = (String)values[3];
        this.top = (String)values[4];
        this.activated = (Boolean)values[5];
        this.modal = (Boolean)values[6];
    }

    public String getWidth() {
        if (this.width != null) {
            return this.width;
        }
        ValueBinding vb = this.getValueBinding("width");
        if (vb != null) {
            Object value = vb.getValue(this.getFacesContext());
            return value != null ? value.toString() : null;
        }
        return null;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        if (this.height != null) {
            return this.height;
        }
        ValueBinding vb = this.getValueBinding("height");
        if (vb != null) {
            Object value = vb.getValue(this.getFacesContext());
            return value != null ? value.toString() : null;
        }
        return null;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getLeft() {
        if (this.left != null) {
            return this.left;
        }
        ValueBinding vb = this.getValueBinding("left");
        if (vb != null) {
            Object value = vb.getValue(this.getFacesContext());
            return value != null ? value.toString() : null;
        }
        return null;
    }

    public void setLeft(String left) {
        this.left = left;
    }

    public String getTop() {
        if (this.top != null) {
            return this.top;
        }
        ValueBinding vb = this.getValueBinding("top");
        if (vb != null) {
            Object value = vb.getValue(this.getFacesContext());
            return value != null ? value.toString() : null;
        }
        return null;
    }

    public void setTop(String top) {
        this.top = top;
    }

    public boolean isModal() {
        if (this.modal != null) {
            return this.modal;
        }
        ValueBinding vb = this.getValueBinding("modal");
        if (vb != null) {
            return Boolean.TRUE.equals(vb.getValue(this.getFacesContext()));
        }
        return true;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
    }

    private void addToPage() {
        UIPage page = ComponentUtil.findPage(this.getFacesContext(), (UIComponent)this);
        if (page != null) {
            page.getPopups().add(this);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        this.activated = false;
    }

    public void encodeAjax(FacesContext facesContext) throws IOException {
        super.encodeAjax(facesContext);
        this.activated = false;
    }
}

