/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.ajax.api.AjaxComponent;
import org.apache.myfaces.tobago.ajax.api.AjaxUtils;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.UILayout;

public class UIInput
extends javax.faces.component.UIInput
implements AjaxComponent,
SupportsMarkup {
    private static final Log LOG = LogFactory.getLog(UIInput.class);
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.Input";
    private Boolean readonly;
    private Boolean disabled;
    private Boolean password;
    private String[] markup;
    private MethodBinding suggestMethod;
    private Integer tabIndex;

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.suggestMethod = (MethodBinding)UIInput.restoreAttachedState((FacesContext)context, (Object)values[1]);
        this.readonly = (Boolean)values[2];
        this.password = (Boolean)values[3];
        this.markup = (String[])values[4];
        this.disabled = (Boolean)values[5];
        this.tabIndex = (Integer)values[6];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), UIInput.saveAttachedState((FacesContext)context, (Object)this.suggestMethod), this.readonly, this.password, this.markup, this.disabled, this.tabIndex};
        return values;
    }

    public String[] getMarkup() {
        if (this.markup != null) {
            return this.markup;
        }
        return ComponentUtil.getMarkupBinding(this.getFacesContext(), this);
    }

    public void setMarkup(String[] markup) {
        this.markup = markup;
    }

    public boolean isReadonly() {
        if (this.readonly != null) {
            return this.readonly;
        }
        ValueBinding vb = this.getValueBinding("readonly");
        if (vb != null) {
            return Boolean.TRUE.equals(vb.getValue(this.getFacesContext()));
        }
        return false;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isDisabled() {
        if (this.disabled != null) {
            return this.disabled;
        }
        ValueBinding vb = this.getValueBinding("disabled");
        if (vb != null) {
            return Boolean.TRUE.equals(vb.getValue(this.getFacesContext()));
        }
        return false;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isPassword() {
        if (this.password != null) {
            return this.password;
        }
        ValueBinding vb = this.getValueBinding("password");
        if (vb != null) {
            return Boolean.TRUE.equals(vb.getValue(this.getFacesContext()));
        }
        return false;
    }

    public void setPassword(boolean password) {
        this.password = password;
    }

    public MethodBinding getSuggestMethod() {
        return this.suggestMethod;
    }

    public void setSuggestMethod(MethodBinding suggestMethod) {
        this.suggestMethod = suggestMethod;
    }

    public Integer getTabIndex() {
        Number number;
        if (this.tabIndex != null) {
            return this.tabIndex;
        }
        ValueBinding vb = this.getValueBinding("tabIndex");
        if (vb != null && (number = (Number)vb.getValue(this.getFacesContext())) != null) {
            return number.intValue();
        }
        return null;
    }

    public void setTabIndex(Integer tabIndex) {
        this.tabIndex = tabIndex;
    }

    public void updateModel(FacesContext facesContext) {
        if (ComponentUtil.mayUpdateModel((UIComponent)this)) {
            super.updateModel(facesContext);
        }
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        UILayout.getLayout((UIComponent)this).layoutBegin(facesContext, (UIComponent)this);
        super.encodeBegin(facesContext);
    }

    public void encodeAjax(FacesContext facesContext) throws IOException {
        AjaxUtils.encodeAjaxComponent(facesContext, (UIComponent)this);
    }

    public void processAjax(FacesContext facesContext) throws IOException {
        String ajaxId = (String)facesContext.getExternalContext().getRequestParameterMap().get("affectedAjaxComponent");
        if (ajaxId.equals(this.getClientId(facesContext))) {
            this.encodeAjax(facesContext);
        } else {
            AjaxUtils.processAjaxOnChildren(facesContext, (UIComponent)this);
        }
    }
}

