/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.OnComponentCreated;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UIDateInput;
import org.apache.myfaces.tobago.component.UIForm;
import org.apache.myfaces.tobago.component.UIHiddenInput;
import org.apache.myfaces.tobago.component.UILinkCommand;
import org.apache.myfaces.tobago.component.UIPopup;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.html.StyleClasses;

public class UIDatePicker
extends UILinkCommand
implements OnComponentCreated {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.DatePicker";
    public static final String OPEN_POPUP = "openPopup";
    public static final String CLOSE_POPUP = "closePopup";
    private String forComponent;

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.forComponent};
        return values;
    }

    public void restoreState(FacesContext context, Object savedState) {
        Object[] values = (Object[])savedState;
        super.restoreState(context, values[0]);
        this.forComponent = (String)values[1];
    }

    private UIComponent getUIDateInput(UIComponent parent) {
        for (Object object : parent.getChildren()) {
            UIComponent child = (UIComponent)object;
            if (!(child instanceof UIDateInput)) continue;
            return child;
        }
        return null;
    }

    public String getFor() {
        if ("@auto".equals(this.forComponent)) {
            UIComponent component = this.getUIDateInput(this.getParent());
            if (component == null && this.getParent() instanceof UIForm) {
                component = this.getUIDateInput(this.getParent().getParent());
            }
            if (component != null) {
                return component.getId();
            }
        }
        return this.forComponent;
    }

    public UIComponent getForComponent() {
        if ("@auto".equals(this.forComponent)) {
            UIComponent component = this.getUIDateInput(this.getParent());
            if (component == null && this.getParent() instanceof UIForm) {
                component = this.getUIDateInput(this.getParent().getParent());
            }
            return component;
        }
        return this.findComponent(this.forComponent);
    }

    public void setFor(String forComponent) {
        this.forComponent = forComponent;
    }

    public void broadcast(FacesEvent facesEvent) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIPopup popup = (UIPopup)this.getFacets().get("pickerPopup");
        String clientId = this.getForComponent().getClientId(facesContext);
        UIComponent box = popup.findComponent("box");
        UIComponent calendar = box.findComponent("calendar");
        calendar.getAttributes().put("CalendarDateInputId", clientId);
        UIComponent time = box.findComponent("time");
        if (time != null) {
            time.getAttributes().put("CalendarDateInputId", clientId);
        }
        super.broadcast(facesEvent);
    }

    public void onComponentCreated() {
        this.preparePicker(this);
    }

    public void preparePicker(UIDatePicker link) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (this.forComponent == null) {
            link.setFor("@auto");
        }
        link.setImmediate(true);
        String linkId = link.getId();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        UIHiddenInput hidden = (UIHiddenInput)ComponentUtil.createComponent(facesContext, "org.apache.myfaces.tobago.HiddenInput", "Hidden", linkId != null ? linkId + "hidden" : viewRoot.createUniqueId());
        link.getChildren().add(hidden);
        UIPopup popup = (UIPopup)ComponentUtil.createComponent(facesContext, "org.apache.myfaces.tobago.Popup", "Popup", linkId != null ? linkId + "popup" : viewRoot.createUniqueId());
        link.getFacets().put("pickerPopup", popup);
        popup.setRendered(false);
        Map attributes = popup.getAttributes();
        attributes.put("popupReset", Boolean.TRUE);
        UIComponent box = ComponentUtil.createComponent(facesContext, "org.apache.myfaces.tobago.Box", "Box");
        popup.getChildren().add(box);
        box.setId("box");
        box.getAttributes().put("label", ResourceManagerUtil.getPropertyNotNull(facesContext, "tobago", "datePickerTitle"));
        UIComponent layout = ComponentUtil.createComponent(facesContext, "org.apache.myfaces.tobago.GridLayout", "GridLayout", "layout");
        box.getFacets().put("layout", layout);
        layout.getAttributes().put("rows", "*;fixed;fixed");
        UIComponent calendar = ComponentUtil.createComponent(facesContext, "javax.faces.Output", "Calendar", "calendar");
        box.getChildren().add(calendar);
        UIComponent timePanel = ComponentUtil.createComponent(facesContext, "org.apache.myfaces.tobago.Panel", "Panel", "timePanel");
        box.getChildren().add(timePanel);
        layout = ComponentUtil.createComponent(facesContext, "org.apache.myfaces.tobago.GridLayout", "GridLayout", "timePanelLayout");
        timePanel.getFacets().put("layout", layout);
        layout.getAttributes().put("columns", "1*;fixed;1*");
        UIComponent cell = ComponentUtil.createComponent(facesContext, "org.apache.myfaces.tobago.Panel", "Panel", "cell1");
        timePanel.getChildren().add(cell);
        UIComponent time = ComponentUtil.createComponent(facesContext, "org.apache.myfaces.tobago.TimeInput", "Time", "time");
        timePanel.getChildren().add(time);
        cell = ComponentUtil.createComponent(facesContext, "org.apache.myfaces.tobago.Panel", "Panel", "cell2");
        timePanel.getChildren().add(cell);
        UIComponent buttonPanel = ComponentUtil.createComponent(facesContext, "org.apache.myfaces.tobago.Panel", "Panel", "buttonPanel");
        layout = ComponentUtil.createComponent(facesContext, "org.apache.myfaces.tobago.GridLayout", "GridLayout", "buttonPanelLayout");
        buttonPanel.getFacets().put("layout", layout);
        layout.getAttributes().put("columns", "*;*");
        layout.getAttributes().put("rows", "fixed");
        box.getChildren().add(buttonPanel);
        UICommand okButton = (UICommand)ComponentUtil.createComponent(facesContext, "org.apache.myfaces.tobago.ButtonCommand", "Button", "okclosePopup");
        buttonPanel.getChildren().add(okButton);
        attributes = okButton.getAttributes();
        attributes.put("label", ResourceManagerUtil.getPropertyNotNull(facesContext, "tobago", "datePickerOk"));
        UICommand cancelButton = (UICommand)ComponentUtil.createComponent(facesContext, "org.apache.myfaces.tobago.ButtonCommand", "Button", CLOSE_POPUP);
        buttonPanel.getChildren().add(cancelButton);
        attributes = cancelButton.getAttributes();
        attributes.put("label", ResourceManagerUtil.getPropertyNotNull(facesContext, "tobago", "datePickerCancel"));
        UIGraphic image = (UIGraphic)ComponentUtil.createComponent(facesContext, "javax.faces.Graphic", "Image", linkId != null ? linkId + "image" : viewRoot.createUniqueId());
        image.setRendered(true);
        image.setValue((Object)"image/date.gif");
        image.getAttributes().put("alt", "");
        StyleClasses.ensureStyleClasses((UIComponent)image).addFullQualifiedClass("tobago-input-picker");
        link.getChildren().add(image);
    }
}

