/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.ajax.api.AjaxComponent;
import org.apache.myfaces.tobago.ajax.api.AjaxUtils;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.FixedLayoutToken;
import org.apache.myfaces.tobago.component.LayoutToken;
import org.apache.myfaces.tobago.component.LayoutTokens;
import org.apache.myfaces.tobago.component.Pager;
import org.apache.myfaces.tobago.component.RelativeLayoutToken;
import org.apache.myfaces.tobago.component.Sorter;
import org.apache.myfaces.tobago.component.UIColumn;
import org.apache.myfaces.tobago.component.UIColumnEvent;
import org.apache.myfaces.tobago.component.UIColumnSelector;
import org.apache.myfaces.tobago.component.UILayout;
import org.apache.myfaces.tobago.component.UIReload;
import org.apache.myfaces.tobago.event.PageActionEvent;
import org.apache.myfaces.tobago.event.SheetStateChangeEvent;
import org.apache.myfaces.tobago.event.SheetStateChangeListener;
import org.apache.myfaces.tobago.event.SheetStateChangeSource;
import org.apache.myfaces.tobago.event.SortActionEvent;
import org.apache.myfaces.tobago.event.SortActionSource;
import org.apache.myfaces.tobago.model.SheetState;
import org.apache.myfaces.tobago.renderkit.LayoutableRendererBase;
import org.apache.myfaces.tobago.renderkit.SheetRendererWorkaround;
import org.apache.myfaces.tobago.util.LayoutInfo;
import org.apache.myfaces.tobago.util.LayoutUtil;
import org.apache.myfaces.tobago.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIData
extends javax.faces.component.UIData
implements SheetStateChangeSource,
SortActionSource,
AjaxComponent {
    private static final Log LOG = LogFactory.getLog(UIData.class);
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.Data";
    public static final String FACET_SORTER = "sorter";
    public static final String SORTER_ID = "sorter";
    public static final String ATTR_SCROLL_POSITION = "attrScrollPosition";
    public static final String NONE = "none";
    public static final String SINGLE = "single";
    public static final String SINGLE_OR_NONE = "singleOrNone";
    public static final String MULTI = "multi";
    public static final int DEFAULT_DIRECT_LINK_COUNT = 9;
    public static final int DEFAULT_ROW_COUNT = 100;
    private static final String DEFAULT_SELECTABLE = "multi";
    private MethodBinding stateChangeListener;
    private List<Integer> widthList;
    private MethodBinding sortActionListener;
    private SheetState sheetState;
    private Boolean showHeader;
    private String showRowRange;
    private String showPageRange;
    private String showDirectLinks;
    private String columns;
    private Integer directLinkCount;
    private Integer rows;
    private String selectable;
    private transient LayoutTokens columnLayout;

    public void resetColumnWidths() {
        SheetState state = this.getSheetState(FacesContext.getCurrentInstance());
        if (state != null) {
            state.setColumnWidths(null);
        }
        this.getAttributes().remove("widthListString");
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        UILayout.prepareDimension(facesContext, (UIComponent)this);
        SheetState state = this.getSheetState(facesContext);
        if (state.getFirst() > -1 && state.getFirst() < this.getRowCount()) {
            ValueBinding valueBinding = this.getValueBinding("first");
            if (valueBinding != null) {
                valueBinding.setValue(facesContext, (Object)state.getFirst());
            } else {
                this.setFirst(state.getFirst());
            }
        }
        super.encodeBegin(facesContext);
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        this.setupState(facesContext);
        this.prepareDimensions(facesContext);
        super.encodeEnd(facesContext);
    }

    public void processDecodes(FacesContext context) {
        UIReload reload;
        String ajaxId = (String)context.getExternalContext().getRequestParameterMap().get("affectedAjaxComponent");
        if (ajaxId != null && ajaxId.equals(this.getClientId(context)) && this.getFacet("reload") != null && this.getFacet("reload") instanceof UIReload && this.getFacet("reload").isRendered() && ((UIReload)this.getFacet("reload")).isImmediate() && ajaxId.equals(ComponentUtil.findPage(context, (UIComponent)this).getActionId()) && !(reload = (UIReload)this.getFacet("reload")).getUpdate()) {
            if (context.getExternalContext().getResponse() instanceof HttpServletResponse) {
                ((HttpServletResponse)context.getExternalContext().getResponse()).setStatus(304);
            }
            context.responseComplete();
            return;
        }
        super.processDecodes(context);
    }

    public String getShowRowRange() {
        if (this.showRowRange != null) {
            return this.showRowRange;
        }
        ValueBinding vb = this.getValueBinding("showRowRange");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return NONE;
    }

    public void setShowRowRange(String showRowRange) {
        this.showRowRange = showRowRange;
    }

    public String getShowPageRange() {
        if (this.showPageRange != null) {
            return this.showPageRange;
        }
        ValueBinding vb = this.getValueBinding("showPageRange");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return NONE;
    }

    public void setShowPageRange(String showPageRange) {
        this.showPageRange = showPageRange;
    }

    public String getColumns() {
        if (this.columns != null) {
            return this.columns;
        }
        ValueBinding vb = this.getValueBinding("columns");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return null;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public String getShowDirectLinks() {
        if (this.showDirectLinks != null) {
            return this.showDirectLinks;
        }
        ValueBinding vb = this.getValueBinding("showDirectLinks");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return NONE;
    }

    public void setShowDirectLinks(String showDirectLinks) {
        this.showDirectLinks = showDirectLinks;
    }

    public String getSelectable() {
        if (this.selectable != null) {
            return this.selectable;
        }
        ValueBinding vb = this.getValueBinding("selectable");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return "multi";
    }

    public void setSelectable(String selectable) {
        this.selectable = selectable;
    }

    public Integer getDirectLinkCount() {
        if (this.directLinkCount != null) {
            return this.directLinkCount;
        }
        ValueBinding vb = this.getValueBinding("directLinkCount");
        if (vb != null) {
            return (Integer)vb.getValue(this.getFacesContext());
        }
        return 9;
    }

    public void setDirectLinkCount(Integer directLinkCount) {
        this.directLinkCount = directLinkCount;
    }

    private void setupState(FacesContext facesContext) {
        SheetState state = this.getSheetState(facesContext);
        this.ensureColumnWidthList(facesContext, state);
    }

    public void setState(SheetState state) {
        this.sheetState = state;
    }

    public SheetState getSheetState(FacesContext facesContext) {
        if (this.sheetState != null) {
            return this.sheetState;
        }
        ValueBinding stateBinding = this.getValueBinding("state");
        if (stateBinding != null) {
            SheetState state = (SheetState)stateBinding.getValue(facesContext);
            if (state == null) {
                state = new SheetState();
                stateBinding.setValue(facesContext, (Object)state);
            }
            return state;
        }
        this.sheetState = new SheetState();
        return this.sheetState;
    }

    public LayoutTokens getColumnLayout() {
        String columns;
        if (this.columnLayout == null && (columns = this.getColumns()) != null) {
            this.columnLayout = LayoutTokens.parse(columns);
        }
        return this.columnLayout;
    }

    private void ensureColumnWidthList(FacesContext facesContext, SheetState state) {
        List<Integer> currentWidthList = null;
        List<javax.faces.component.UIColumn> rendererdColumns = this.getRenderedColumns();
        Map attributes = this.getAttributes();
        String widthListString = null;
        if (state != null) {
            widthListString = state.getColumnWidths();
        }
        if (widthListString == null) {
            widthListString = (String)attributes.get("widthListString");
        }
        if (widthListString != null) {
            currentWidthList = StringUtils.parseIntegerList(widthListString);
        }
        if (currentWidthList != null && currentWidthList.size() != rendererdColumns.size()) {
            currentWidthList = null;
        }
        if (currentWidthList == null) {
            LayoutTokens tokens = this.getColumnLayout();
            List<javax.faces.component.UIColumn> allColumns = this.getAllColumns();
            LayoutTokens newTokens = new LayoutTokens();
            if (allColumns.size() > 0) {
                for (int i = 0; i < allColumns.size(); ++i) {
                    javax.faces.component.UIColumn column = allColumns.get(i);
                    if (!column.isRendered()) continue;
                    if (tokens == null) {
                        if (column instanceof UIColumn) {
                            newTokens.addToken(LayoutTokens.parseToken(((UIColumn)column).getWidth()));
                            continue;
                        }
                        newTokens.addToken(RelativeLayoutToken.DEFAULT_INSTANCE);
                        continue;
                    }
                    if (i < tokens.getSize()) {
                        newTokens.addToken(tokens.get(i));
                        continue;
                    }
                    newTokens.addToken(RelativeLayoutToken.DEFAULT_INSTANCE);
                }
            }
            int space = LayoutUtil.getInnerSpace(facesContext, (UIComponent)this, true);
            SheetRendererWorkaround renderer = (SheetRendererWorkaround)((Object)ComponentUtil.getRenderer(facesContext, (UIComponent)this));
            space -= renderer.getContentBorder(facesContext, this);
            if (renderer.needVerticalScrollbar(facesContext, this)) {
                space -= renderer.getScrollbarWidth(facesContext, (UIComponent)this);
            }
            LayoutInfo layoutInfo = new LayoutInfo(newTokens.getSize(), space, newTokens, this.getClientId(facesContext), false);
            this.parseFixedWidth(facesContext, layoutInfo, rendererdColumns);
            layoutInfo.parseColumnLayout(space);
            currentWidthList = layoutInfo.getSpaceList();
        }
        if (currentWidthList != null) {
            if (rendererdColumns.size() != currentWidthList.size()) {
                LOG.warn((Object)("widthList.size() = " + currentWidthList.size() + " != columns.size() = " + rendererdColumns.size() + "  widthList : " + LayoutInfo.listToTokenString(currentWidthList)));
            } else {
                this.widthList = currentWidthList;
            }
        }
    }

    private void parseFixedWidth(FacesContext facesContext, LayoutInfo layoutInfo, List<javax.faces.component.UIColumn> rendereredColumns) {
        LayoutTokens tokens = layoutInfo.getLayoutTokens();
        for (int i = 0; i < tokens.getSize(); ++i) {
            LayoutToken token = tokens.get(i);
            if (!(token instanceof FixedLayoutToken)) continue;
            int width = 0;
            if (!rendereredColumns.isEmpty()) {
                if (i < rendereredColumns.size()) {
                    javax.faces.component.UIColumn column = rendereredColumns.get(i);
                    if (column instanceof UIColumnSelector) {
                        LayoutableRendererBase renderer = ComponentUtil.getRenderer(facesContext, (UIComponent)column);
                        if (renderer == null) {
                            LOG.warn((Object)("can't find renderer for " + column.getClass().getName()));
                            renderer = ComponentUtil.getRenderer(facesContext, "javax.faces.Panel", "Out");
                        }
                        width = renderer.getFixedWidth(facesContext, (UIComponent)column);
                    } else {
                        for (UIComponent component : column.getChildren()) {
                            LayoutableRendererBase renderer = ComponentUtil.getRenderer(facesContext, component);
                            width += renderer.getFixedWidth(facesContext, component);
                        }
                    }
                    layoutInfo.update(width, i);
                } else {
                    layoutInfo.update(0, i);
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)"More LayoutTokens found than rows! skipping!");
                    }
                }
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("set column " + i + " from fixed to with " + width));
        }
    }

    private void prepareDimensions(FacesContext facesContext) {
        List<Integer> columnWidths = this.getWidthList();
        int i = 0;
        for (javax.faces.component.UIColumn column : this.getRenderedColumns()) {
            if (i < columnWidths.size()) {
                Integer width = columnWidths.get(i);
                if (!(column instanceof UIColumnSelector)) {
                    if (column.getChildCount() == 1) {
                        UIComponent child = (UIComponent)column.getChildren().get(0);
                        int cellPaddingWidth = ((LayoutableRendererBase)this.getRenderer(facesContext)).getConfiguredValue(facesContext, (UIComponent)this, "cellPaddingWidth");
                        child.getAttributes().put("layoutWidth", width - cellPaddingWidth);
                        child.getAttributes().remove("innerWidth");
                    } else {
                        LOG.warn((Object)("More or less than 1 child in column! Can't set width for column " + i + " to " + width));
                    }
                }
            } else {
                LOG.warn((Object)("More columns than columnSizes! Can't set width for column " + i));
            }
            ++i;
        }
    }

    public int getLast() {
        int last = this.getFirst() + this.getRows();
        return last < this.getRowCount() ? last : this.getRowCount();
    }

    public int getPage() {
        int first = this.getFirst() + 1;
        int rows = this.getRows();
        if (rows == 0) {
            return 0;
        }
        if (first % rows > 0) {
            return first / rows + 1;
        }
        return first / rows;
    }

    public int getPages() {
        int rows = this.getRows();
        if (rows == 0) {
            return 0;
        }
        return this.getRowCount() / rows + (this.getRowCount() % rows == 0 ? 0 : 1);
    }

    public List<UIComponent> getRenderedChildrenOf(javax.faces.component.UIColumn column) {
        ArrayList<UIComponent> children = new ArrayList<UIComponent>();
        for (Object o : column.getChildren()) {
            UIComponent kid = (UIComponent)o;
            if (!kid.isRendered()) continue;
            children.add(kid);
        }
        return children;
    }

    public boolean isAtBeginning() {
        return this.getFirst() == 0;
    }

    public boolean hasRowCount() {
        return this.getRowCount() != -1;
    }

    public boolean isAtEnd() {
        if (!this.hasRowCount()) {
            this.setRowIndex(this.getFirst() + this.getRows() + 1);
            return !this.isRowAvailable();
        }
        return this.getFirst() >= this.getLastPageIndex();
    }

    public int getLastPageIndex() {
        int rowCount;
        int rows = this.getRows();
        if (rows == 0) {
            return 0;
        }
        int tail = (rowCount = this.getRowCount()) % rows;
        return rowCount - (tail != 0 ? tail : rows);
    }

    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        this.updateSheetState(context);
    }

    private void updateSheetState(FacesContext facesContext) {
        SheetState state = this.getSheetState(facesContext);
        if (state != null) {
            Map attributes = this.getAttributes();
            List<Integer> list = (List<Integer>)attributes.get("selectedListString");
            state.setSelectedRows(list != null ? list : Collections.emptyList());
            state.setColumnWidths((String)attributes.get("widthListString"));
            state.setScrollPosition((Integer[])attributes.get(ATTR_SCROLL_POSITION));
            attributes.remove("selectedListString");
            attributes.remove(ATTR_SCROLL_POSITION);
        }
    }

    public Object saveState(FacesContext context) {
        Object[] saveState = new Object[]{super.saveState(context), this.sheetState, UIData.saveAttachedState((FacesContext)context, (Object)this.sortActionListener), UIData.saveAttachedState((FacesContext)context, (Object)this.stateChangeListener), this.showHeader, this.showRowRange, this.showPageRange, this.showDirectLinks, this.directLinkCount, this.selectable, this.columns, this.rows};
        return saveState;
    }

    public void restoreState(FacesContext context, Object savedState) {
        Object[] values = (Object[])savedState;
        super.restoreState(context, values[0]);
        this.sheetState = (SheetState)values[1];
        this.sortActionListener = (MethodBinding)UIData.restoreAttachedState((FacesContext)context, (Object)values[2]);
        this.stateChangeListener = (MethodBinding)UIData.restoreAttachedState((FacesContext)context, (Object)values[3]);
        this.showHeader = (Boolean)values[4];
        this.showRowRange = (String)values[5];
        this.showPageRange = (String)values[6];
        this.showDirectLinks = (String)values[7];
        this.directLinkCount = (Integer)values[8];
        this.selectable = (String)values[9];
        this.columns = (String)values[10];
        this.rows = (Integer)values[11];
    }

    public List<javax.faces.component.UIColumn> getAllColumns() {
        ArrayList<javax.faces.component.UIColumn> columns = new ArrayList<javax.faces.component.UIColumn>();
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof javax.faces.component.UIColumn) || kid instanceof UIColumnEvent) continue;
            columns.add((javax.faces.component.UIColumn)kid);
        }
        return columns;
    }

    public List<javax.faces.component.UIColumn> getRenderedColumns() {
        ArrayList<javax.faces.component.UIColumn> columns = new ArrayList<javax.faces.component.UIColumn>();
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof javax.faces.component.UIColumn) || !kid.isRendered() || kid instanceof UIColumnEvent) continue;
            columns.add((javax.faces.component.UIColumn)kid);
        }
        return columns;
    }

    @Override
    public MethodBinding getSortActionListener() {
        if (this.sortActionListener != null) {
            return this.sortActionListener;
        }
        return new Sorter();
    }

    @Override
    public void setSortActionListener(MethodBinding sortActionListener) {
        this.sortActionListener = sortActionListener;
    }

    public void queueEvent(FacesEvent facesEvent) {
        UIComponent parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("component is not a descendant of a UIViewRoot");
        }
        if (facesEvent.getComponent() == this && (facesEvent instanceof SheetStateChangeEvent || facesEvent instanceof PageActionEvent)) {
            facesEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("queueEvent = \"" + facesEvent + "\""));
            }
            parent.queueEvent(facesEvent);
        } else {
            UIComponent source = facesEvent.getComponent();
            UIComponent sourceParent = source.getParent();
            if (sourceParent.getParent() == this && source.getId() != null && source.getId().endsWith("sorter")) {
                facesEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
                parent.queueEvent((FacesEvent)new SortActionEvent(this, (javax.faces.component.UIColumn)sourceParent));
            } else {
                super.queueEvent(facesEvent);
            }
        }
    }

    public void broadcast(FacesEvent facesEvent) throws AbortProcessingException {
        super.broadcast(facesEvent);
        if (facesEvent instanceof SheetStateChangeEvent) {
            this.invokeMethodBinding(this.getStateChangeListener(), facesEvent);
        } else if (facesEvent instanceof PageActionEvent) {
            this.invokeMethodBinding(new Pager(), facesEvent);
            this.invokeMethodBinding(this.getStateChangeListener(), new SheetStateChangeEvent((UIComponent)this));
        } else if (facesEvent instanceof SortActionEvent) {
            this.getSheetState(this.getFacesContext()).updateSortState((SortActionEvent)facesEvent);
            this.invokeMethodBinding(this.getSortActionListener(), facesEvent);
        }
    }

    private void invokeMethodBinding(MethodBinding methodBinding, FacesEvent event) {
        if (methodBinding != null && event != null) {
            try {
                Object[] objects = new Object[]{event};
                methodBinding.invoke(this.getFacesContext(), objects);
            }
            catch (EvaluationException e) {
                Throwable cause = e.getCause();
                if (cause instanceof AbortProcessingException) {
                    throw (AbortProcessingException)cause;
                }
                throw e;
            }
        }
    }

    @Override
    public void addStateChangeListener(SheetStateChangeListener listener) {
        this.addFacesListener(listener);
    }

    @Override
    public SheetStateChangeListener[] getStateChangeListeners() {
        return (SheetStateChangeListener[])this.getFacesListeners(SheetStateChangeListener.class);
    }

    @Override
    public void removeStateChangeListener(SheetStateChangeListener listener) {
        this.removeFacesListener(listener);
    }

    @Override
    public MethodBinding getStateChangeListener() {
        return this.stateChangeListener;
    }

    @Override
    public void setStateChangeListener(MethodBinding stateChangeListener) {
        this.stateChangeListener = stateChangeListener;
    }

    public List<Integer> getWidthList() {
        return this.widthList;
    }

    public int getRows() {
        if (this.rows != null) {
            return this.rows;
        }
        ValueBinding vb = this.getValueBinding("rows");
        if (vb != null) {
            return (Integer)vb.getValue(this.getFacesContext());
        }
        return 100;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public boolean isShowHeader() {
        if (this.showHeader != null) {
            return this.showHeader;
        }
        ValueBinding vb = this.getValueBinding("showHeader");
        if (vb != null) {
            return !Boolean.FALSE.equals(vb.getValue(this.getFacesContext()));
        }
        return true;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    @Override
    public void encodeAjax(FacesContext facesContext) throws IOException {
        this.setupState(facesContext);
        this.prepareDimensions(facesContext);
        ValueBinding binding = this.getValueBinding("value");
        if (binding != null) {
            this.setValue(null);
        } else {
            this.setValue(this.getValue());
        }
        AjaxUtils.encodeAjaxComponent(facesContext, (UIComponent)this);
    }

    @Override
    public void processAjax(FacesContext facesContext) throws IOException {
        String ajaxId = (String)facesContext.getExternalContext().getRequestParameterMap().get("affectedAjaxComponent");
        if (ajaxId.equals(this.getClientId(facesContext))) {
            AjaxUtils.processActiveAjaxComponent(facesContext, (UIComponent)this);
        } else {
            AjaxUtils.processAjaxOnChildren(facesContext, (UIComponent)this);
        }
    }

    public Integer[] getScrollPosition() {
        Integer[] scrollPosition = (Integer[])this.getAttributes().get(ATTR_SCROLL_POSITION);
        if (scrollPosition == null) {
            scrollPosition = this.getSheetState(FacesContext.getCurrentInstance()).getScrollPosition();
        }
        return scrollPosition;
    }

    public UIComponent findComponent(String searchId) {
        return super.findComponent(this.stripRowIndex(searchId));
    }

    String stripRowIndex(String searchId) {
        if (searchId.length() > 0 && Character.isDigit(searchId.charAt(0))) {
            for (int i = 1; i < searchId.length(); ++i) {
                char c = searchId.charAt(i);
                if (c == ':') {
                    searchId = searchId.substring(i + 1);
                    break;
                }
                if (!Character.isDigit(c)) break;
            }
        }
        return searchId;
    }
}

