/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.UILayout;

public class UICommand
extends javax.faces.component.UICommand {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.Command";
    private static final Log LOG = LogFactory.getLog(UICommand.class);
    private static final String[] RENDERED_PARTIALLY_DEFAULT = new String[0];
    private Boolean defaultCommand;
    private Boolean disabled;
    private String[] renderedPartially;
    private String target;
    private Boolean transition;

    public boolean isDefaultCommand() {
        if (this.defaultCommand != null) {
            return this.defaultCommand;
        }
        ValueBinding vb = this.getValueBinding("defaultCommand");
        if (vb != null) {
            return Boolean.TRUE.equals(vb.getValue(this.getFacesContext()));
        }
        return false;
    }

    public void setDefaultCommand(boolean defaultCommand) {
        this.defaultCommand = defaultCommand;
    }

    public String[] getRenderedPartially() {
        Object value;
        if (this.renderedPartially != null) {
            return this.renderedPartially;
        }
        ValueBinding vb = this.getValueBinding("renderedPartially");
        if (vb != null && (value = vb.getValue(this.getFacesContext())) != null) {
            if (value instanceof String[]) {
                return (String[])value;
            }
            if (value instanceof String) {
                return StringUtils.split((String)((String)value), (String)",");
            }
            LOG.error((Object)("Ignoring RenderedPartially value binding. Unknown instance " + value.getClass().getName()));
        }
        return RENDERED_PARTIALLY_DEFAULT;
    }

    public void setRenderedPartially(String renderedPartially) {
        if (renderedPartially != null) {
            String[] components = StringUtils.split((String)renderedPartially, (String)",");
            this.setRenderedPartially(components);
        }
    }

    public void setRenderedPartially(String[] renderedPartially) {
        this.renderedPartially = renderedPartially;
    }

    public boolean isDisabled() {
        if (this.disabled != null) {
            return this.disabled;
        }
        ValueBinding vb = this.getValueBinding("disabled");
        if (vb != null) {
            return Boolean.TRUE.equals(vb.getValue(this.getFacesContext()));
        }
        return false;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isTransition() {
        if (this.transition != null) {
            return this.transition;
        }
        ValueBinding vb = this.getValueBinding("transition");
        if (vb != null) {
            return Boolean.TRUE.equals(vb.getValue(this.getFacesContext()));
        }
        return true;
    }

    public void setTransition(boolean transition) {
        this.transition = transition;
    }

    public String getTarget() {
        if (this.target != null) {
            return this.target;
        }
        ValueBinding vb = this.getValueBinding("target");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return null;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Object saveState(FacesContext context) {
        Object[] saveState = new Object[]{super.saveState(context), this.defaultCommand, this.disabled, this.renderedPartially, this.target, this.transition};
        return saveState;
    }

    public void restoreState(FacesContext context, Object savedState) {
        Object[] values = (Object[])savedState;
        super.restoreState(context, values[0]);
        this.defaultCommand = (Boolean)values[1];
        this.disabled = (Boolean)values[2];
        this.renderedPartially = (String[])values[3];
        this.target = (String)values[4];
        this.transition = (Boolean)values[5];
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processDecodes(context);
        }
    }

    public void encodeChildren(FacesContext facesContext) throws IOException {
        if (this.isRendered()) {
            UILayout.getLayout((UIComponent)this).encodeChildrenOfComponent(facesContext, (UIComponent)this);
        }
    }

    public void queueEvent(FacesEvent facesEvent) {
        super.queueEvent(facesEvent);
        if (this == facesEvent.getSource()) {
            if (this.isImmediate()) {
                facesEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                facesEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
    }
}

