/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.FixedLayoutToken;
import org.apache.myfaces.tobago.component.LayoutToken;
import org.apache.myfaces.tobago.component.MinimumLayoutToken;
import org.apache.myfaces.tobago.component.PercentLayoutToken;
import org.apache.myfaces.tobago.component.PixelLayoutToken;
import org.apache.myfaces.tobago.component.RelativeLayoutToken;
import org.apache.myfaces.tobago.util.LayoutUtil;

public class LayoutTokens {
    private static final Log LOG = LogFactory.getLog(LayoutTokens.class);
    private List<LayoutToken> tokens = new ArrayList<LayoutToken>();

    public int getSize() {
        return this.tokens.size();
    }

    public void set(int index, LayoutToken token) {
        this.tokens.set(index, token);
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public LayoutToken get(int index) {
        return this.tokens.get(index);
    }

    public void shrinkSizeTo(int size) {
        for (int i = this.getSize() - 1; i >= size; --i) {
            this.tokens.remove(i);
        }
    }

    public void ensureSize(int size, LayoutToken token) {
        for (int index = this.getSize(); index < size; ++index) {
            this.addToken(token);
        }
    }

    public void addToken(LayoutToken token) {
        this.tokens.add(token);
    }

    public static LayoutTokens parse(String[] tokens) {
        LayoutTokens layoutTokens = new LayoutTokens();
        for (String token : tokens) {
            LayoutTokens.parseToken(token, layoutTokens);
        }
        return layoutTokens;
    }

    public static LayoutTokens parse(String tokens) {
        return LayoutTokens.parse(tokens, null);
    }

    public static LayoutTokens parse(String tokens, LayoutToken defaultToken) {
        LayoutTokens layoutTokens = new LayoutTokens();
        if (tokens == null) {
            layoutTokens.addToken(defaultToken);
            return layoutTokens;
        }
        StringTokenizer tokenizer = new StringTokenizer(tokens, ";");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            LayoutTokens.parseToken(token, layoutTokens);
        }
        return layoutTokens;
    }

    private static void parseToken(String token, LayoutTokens layoutTokens) {
        LayoutToken layoutToken = LayoutTokens.parseToken(token);
        if (layoutToken != null) {
            layoutTokens.addToken(layoutToken);
        }
    }

    public static LayoutToken parseToken(String token) {
        try {
            if ("*".equals(token)) {
                return RelativeLayoutToken.DEFAULT_INSTANCE;
            }
            if (token.equals("fixed")) {
                return FixedLayoutToken.INSTANCE;
            }
            if (token.equals("minimum")) {
                return new MinimumLayoutToken();
            }
            if (LayoutTokens.isPixelToken(token)) {
                return new PixelLayoutToken(Integer.parseInt(LayoutUtil.removeSuffix(token, "px")));
            }
            if (LayoutTokens.isPercentToken(token)) {
                return new PercentLayoutToken(Integer.parseInt(LayoutUtil.removeSuffix(token, "%")));
            }
            if (LayoutTokens.isRelativeToken(token)) {
                return new RelativeLayoutToken(Integer.parseInt(LayoutUtil.removeSuffix(token, "*")));
            }
            LOG.error((Object)("Ignoring unknown layout token '" + token + "'"));
        }
        catch (NumberFormatException e) {
            LOG.error((Object)("Error parsing layout token '" + token + "'"), (Throwable)e);
        }
        return null;
    }

    static boolean isPixelToken(String token) {
        return LayoutUtil.isNumberAndSuffix(token, "px");
    }

    static boolean isPercentToken(String token) {
        return LayoutUtil.isNumberAndSuffix(token, "%");
    }

    static boolean isRelativeToken(String token) {
        return LayoutUtil.isNumberAndSuffix(token, "*");
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (LayoutToken token : this.tokens) {
            str.append(token);
            str.append(";");
        }
        return str.toString();
    }
}

