/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.FacesEvent;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.ajax.api.AjaxRenderer;
import org.apache.myfaces.tobago.ajax.api.AjaxUtils;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.component.UIPanelBase;
import org.apache.myfaces.tobago.component.UITab;
import org.apache.myfaces.tobago.component.UITabGroup;
import org.apache.myfaces.tobago.component.UIToolBar;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.event.TabChangeEvent;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.LayoutableRendererBase;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlStyleMap;
import org.apache.myfaces.tobago.renderkit.html.StyleClasses;
import org.apache.myfaces.tobago.util.AccessKeyMap;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TabGroupRenderer
extends LayoutableRendererBase
implements AjaxRenderer {
    private static final Log LOG;
    private static final String[] SCRIPTS;
    public static final String ACTIVE_INDEX_POSTFIX = "__activeIndex";
    static /* synthetic */ Class class$org$apache$myfaces$tobago$renderkit$html$scarborough$standard$tag$TabGroupRenderer;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$component$UITabGroup;

    public void decode(FacesContext facesContext, UIComponent component) {
        if (ComponentUtil.isOutputOnly((UIComponent)component)) {
            return;
        }
        int oldIndex = ((UITabGroup)component).getRenderedIndex();
        String clientId = component.getClientId(facesContext);
        Map parameters = facesContext.getExternalContext().getRequestParameterMap();
        String newValue = (String)parameters.get(clientId + ACTIVE_INDEX_POSTFIX);
        try {
            int activeIndex = Integer.parseInt(newValue);
            if (activeIndex != oldIndex) {
                TabChangeEvent event = new TabChangeEvent(component, _Integer.valueOf((int)oldIndex), _Integer.valueOf((int)activeIndex));
                component.queueEvent((FacesEvent)event);
            }
        }
        catch (NumberFormatException e) {
            LOG.error((Object)("Can't parse activeIndex: '" + newValue + "'"));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UITabGroup component = (UITabGroup)uiComponent;
        HtmlRendererUtil.createHeaderAndBodyStyles((FacesContext)facesContext, (UIComponent)component);
        this.layoutTabs(facesContext, component);
        int activeIndex = this.ensureRenderedActiveIndex(facesContext, component);
        String clientId = component.getClientId(facesContext);
        String hiddenId = clientId + ACTIVE_INDEX_POSTFIX;
        String switchType = component.getSwitchType();
        UIPage page = ComponentUtil.findPage((FacesContext)facesContext, (UIComponent)component);
        page.getScriptFiles().addAll(Arrays.asList(SCRIPTS));
        if (TobagoConfig.getInstance((FacesContext)facesContext).isAjaxEnabled()) {
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, (String[])SCRIPTS, (String[])new String[0]);
        }
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", false);
        writer.writeAttribute("value", Integer.toString(activeIndex), false);
        writer.writeNameAttribute(hiddenId);
        writer.writeIdAttribute(hiddenId);
        writer.endElement("input");
        String image1x1 = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/1x1.gif");
        TabList tabList = this.getTabList(facesContext, component);
        int virtualTab = 0;
        int currentWidth = 0;
        int navigationBarWidth = 0;
        if (ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"showNavigationBar")) {
            navigationBarWidth = this.getConfiguredValue(facesContext, (UIComponent)component, "navigationBarWidth");
        }
        Iterator i$ = component.getChildren().iterator();
        while (i$.hasNext()) {
            UIComponent tab = (UIComponent)i$.next();
            if (!(tab instanceof UIPanelBase)) continue;
            if (tab.isRendered()) {
                currentWidth += tabList.getWidthList().get(virtualTab).intValue();
                if ("client".equals(switchType) || virtualTab == activeIndex) {
                    if (virtualTab != activeIndex) {
                        HtmlRendererUtil.replaceStyleAttribute((UIComponent)component, (String)"display", (String)"none");
                    } else {
                        HtmlRendererUtil.removeStyleAttribute((UIComponent)component, (String)"display");
                    }
                    writer.startElement("div", null);
                    writer.writeComment((Object)"empty div fix problem with mozilla and fieldset");
                    writer.endElement("div");
                    writer.startElement("div", null);
                    writer.writeIdAttribute(clientId);
                    StyleClasses classes = (StyleClasses)component.getAttributes().get("styleClass");
                    writer.writeClassAttribute(classes);
                    this.renderTabGroupView(facesContext, writer, component, virtualTab, (HtmlStyleMap)component.getAttributes().get("style"), switchType, image1x1, navigationBarWidth, currentWidth, tabList);
                    writer.endElement("div");
                    if (TobagoConfig.getInstance((FacesContext)facesContext).isAjaxEnabled() && "reloadTab".equals(switchType)) {
                        String[] cmds = new String[]{"new Tobago.TabGroup(", "    '" + clientId + "', ", "    '" + activeIndex + "', ", "    '" + component.getChildCount() + "');"};
                        HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, (String[])new String[0], (String[])cmds);
                    }
                }
            }
            ++virtualTab;
        }
    }

    private Integer getCurrentWidth(TabList tabs, int tabIndex) {
        int currentWidth = 0;
        for (int i = 0; i <= tabIndex; ++i) {
            currentWidth += tabs.getWidthList().get(i).intValue();
        }
        return _Integer.valueOf((int)currentWidth);
    }

    private TabList getTabList(FacesContext facesContext, UITabGroup component) {
        TabList tabs = new TabList();
        int index = 0;
        int tabLabelExtraWidth = this.getConfiguredValue(facesContext, (UIComponent)component, "tabLabelExtraWidth");
        boolean first = true;
        Iterator i$ = component.getChildren().iterator();
        while (i$.hasNext()) {
            UIComponent child = (UIComponent)i$.next();
            if (!(child instanceof UITab)) continue;
            UITab tab = (UITab)child;
            if (tab.isRendered()) {
                LabelWithAccessKey label = new LabelWithAccessKey((UIComponent)tab);
                if (label.getText() != null) {
                    tabs.getWidthList().add(_Integer.valueOf((int)(RenderUtil.calculateStringWidth2((FacesContext)facesContext, (UIComponent)component, (String)label.getText()) + tabLabelExtraWidth)));
                } else {
                    tabs.getWidthList().add(_Integer.valueOf((int)(RenderUtil.calculateStringWidth2((FacesContext)facesContext, (UIComponent)component, (String)Integer.toString(index + 1)) + tabLabelExtraWidth)));
                }
                if (first) {
                    tabs.firstIndex = index;
                    first = false;
                }
                tabs.lastIndex = index;
            } else {
                tabs.getWidthList().add(_Integer.valueOf((int)0));
            }
            ++index;
        }
        return tabs;
    }

    private int ensureRenderedActiveIndex(FacesContext context, UITabGroup tabGroup) {
        ValueBinding vb;
        int activeIndex = tabGroup.getSelectedIndex();
        int index = -1;
        int closestRenderedTabIndex = -1;
        Iterator i$ = tabGroup.getChildren().iterator();
        while (i$.hasNext()) {
            UIComponent tab = (UIComponent)i$.next();
            ++index;
            if (!(tab instanceof UIPanelBase)) continue;
            if (index == activeIndex) {
                if (tab.isRendered()) {
                    return index;
                }
                if (closestRenderedTabIndex > -1) break;
            }
            if (!tab.isRendered()) continue;
            closestRenderedTabIndex = index;
            if (index <= activeIndex) continue;
            break;
        }
        if (closestRenderedTabIndex == -1) {
            closestRenderedTabIndex = 0;
        }
        if ((vb = tabGroup.getValueBinding("selectedIndex")) != null) {
            vb.setValue(context, (Object)_Integer.valueOf((int)closestRenderedTabIndex));
        } else {
            tabGroup.setSelectedIndex(closestRenderedTabIndex);
        }
        return closestRenderedTabIndex;
    }

    private void renderTabGroupView(FacesContext facesContext, TobagoResponseWriter writer, UITabGroup component, int virtualTab, HtmlStyleMap oStyle, String switchType, String image1x1, int toolbarWidth, int currentWidth, TabList tabList) throws IOException {
        writer.startElement("table", null);
        writer.writeAttribute("border", 0);
        writer.writeAttribute("cellpadding", 0);
        writer.writeAttribute("cellspacing", 0);
        writer.writeAttribute("summary", "", false);
        String clientId = component.getClientId(facesContext);
        writer.writeIdAttribute(clientId + "__" + virtualTab);
        writer.writeStyleAttribute(oStyle);
        writer.startElement("tr", null);
        writer.writeAttribute("valign", "bottom", false);
        writer.startElement("td", null);
        HtmlStyleMap headerStyle = (HtmlStyleMap)component.getAttributes().get("style_header");
        headerStyle.put("position", (Object)"relative");
        headerStyle.put("width", (Object)headerStyle.getInt((Object)"width"));
        int width = headerStyle.getInt((Object)"width");
        writer.writeStyleAttribute(headerStyle);
        writer.startElement("div", null);
        writer.writeStyleAttribute(headerStyle);
        writer.startElement("div", null);
        HtmlStyleMap map = new HtmlStyleMap();
        if (currentWidth > width) {
            map.put("width", (Object)_Integer.valueOf((int)currentWidth));
            map.put("left", (Object)_Integer.valueOf((int)(width - toolbarWidth - currentWidth)));
        } else {
            map.put("width", (Object)_Integer.valueOf((int)(width - toolbarWidth)));
        }
        map.put("overflow", (Object)"hidden");
        map.put("position", (Object)"absolute");
        writer.writeStyleAttribute(map);
        writer.startElement("table", (UIComponent)component);
        writer.writeAttribute("border", 0);
        writer.writeAttribute("cellpadding", 0);
        writer.writeAttribute("cellspacing", 0);
        writer.writeAttribute("summary", "", false);
        headerStyle = (HtmlStyleMap)component.getAttributes().get("style_header");
        writer.writeStyleAttribute(headerStyle);
        writer.startElement("colgroup", null);
        Iterator<Integer> i$ = tabList.getWidthList().iterator();
        while (i$.hasNext()) {
            Integer colWidth = i$.next();
            if (colWidth <= 0) continue;
            writer.startElement("col", null);
            writer.writeAttribute("width", colWidth.intValue());
            writer.endElement("col");
        }
        writer.endElement("colgroup");
        writer.startElement("tr", null);
        writer.writeAttribute("valign", "bottom", false);
        UIToolBar toolBar = null;
        if (toolbarWidth > 0) {
            toolBar = this.createToolBar(facesContext, component, virtualTab, switchType, tabList, clientId);
        }
        UITab activeTab = null;
        int index = 0;
        Iterator i$2 = component.getChildren().iterator();
        while (i$2.hasNext()) {
            UITab tab;
            UIComponent child = (UIComponent)i$2.next();
            if (child instanceof UITab && (tab = (UITab)child).isRendered()) {
                String onclick = TobagoConfig.getInstance((FacesContext)facesContext).isAjaxEnabled() && "reloadTab".equals(switchType) ? null : "tobago_switchTab('" + switchType + "','" + clientId + "'," + index + ',' + component.getChildCount() + ')';
                LabelWithAccessKey label = new LabelWithAccessKey((UIComponent)tab);
                StyleClasses outerClass = new StyleClasses();
                StyleClasses innerClass = new StyleClasses();
                if (virtualTab == index) {
                    outerClass.addClass("tab", "selected-outer");
                    innerClass.addClass("tab", "selected-inner");
                    activeTab = tab;
                } else {
                    outerClass.addClass("tab", "unselected-outer");
                    innerClass.addClass("tab", "unselected-inner");
                }
                outerClass.addMarkupClass((SupportsMarkup)tab, "tab", "outer");
                innerClass.addMarkupClass((SupportsMarkup)tab, "tab", "outer");
                writer.startElement("td", (UIComponent)tab);
                map = new HtmlStyleMap();
                map.put("width", (Object)tabList.getWidthList().get(index));
                writer.writeStyleAttribute(map);
                writer.writeIdAttribute(tab.getClientId(facesContext));
                HtmlRendererUtil.renderTip((UIComponent)tab, (TobagoResponseWriter)writer);
                writer.startElement("div", null);
                writer.writeStyleAttribute(map);
                writer.startElement("div", null);
                writer.writeClassAttribute(outerClass);
                writer.startElement("div", null);
                writer.writeClassAttribute(innerClass);
                writer.startElement("span", null);
                String tabId = clientId + "__" + virtualTab + "__" + index;
                writer.writeIdAttribute(tabId);
                if (tab.isDisabled()) {
                    writer.writeClassAttribute("tobago-tab-disabled");
                } else {
                    writer.writeClassAttribute("tobago-tab-link");
                    if (onclick != null) {
                        writer.writeAttribute("onclick", onclick, true);
                    }
                }
                if (label.getText() != null) {
                    HtmlRendererUtil.writeLabelWithAccessKey((TobagoResponseWriter)writer, (LabelWithAccessKey)label);
                } else {
                    writer.writeText(Integer.toString(index + 1));
                }
                writer.endElement("span");
                if (label.getAccessKey() != null) {
                    if (LOG.isWarnEnabled() && !AccessKeyMap.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey())) {
                        LOG.warn((Object)("dublicated accessKey : " + label.getAccessKey()));
                    }
                    HtmlRendererUtil.addClickAcceleratorKey((FacesContext)facesContext, (String)tabId, (char)label.getAccessKey().charValue());
                }
                writer.endElement("div");
                writer.endElement("div");
                writer.endElement("div");
                writer.endElement("td");
            }
            ++index;
        }
        writer.startElement("td", null);
        if (currentWidth > width) {
            writer.writeAttribute("width", toolbarWidth);
        } else {
            writer.writeAttribute("width", Integer.toString(width - currentWidth) + "px", false);
        }
        writer.startElement("div", null);
        writer.writeClassAttribute("tobago-tab-fulfill");
        writer.startElement("img", null);
        writer.writeAttribute("src", image1x1, false);
        writer.writeAttribute("alt", "", false);
        writer.endElement("img");
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
        if (toolBar != null) {
            this.renderToolbar(facesContext, writer, (UIPanel)toolBar, width - toolbarWidth, toolbarWidth);
        }
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        this.encodeContent(writer, facesContext, activeTab);
        writer.endElement("table");
    }

    private UIToolBar createToolBar(FacesContext facesContext, UITabGroup component, int virtualTab, String switchType, TabList tabList, String clientId) {
        Application application = facesContext.getApplication();
        UICommand scrollLeft = (UICommand)application.createComponent("org.apache.myfaces.tobago.Command");
        scrollLeft.setId(component.getId() + "__" + virtualTab + "__" + "previous");
        scrollLeft.setRendererType(null);
        scrollLeft.getAttributes().put("image", "image/tabPrev.gif");
        if (tabList.isFirst(virtualTab)) {
            scrollLeft.setDisabled(true);
        }
        if (!TobagoConfig.getInstance((FacesContext)facesContext).isAjaxEnabled() || !"reloadTab".equals(switchType)) {
            scrollLeft.getAttributes().put("onclick", "tobago_previousTab('" + switchType + "','" + clientId + "'," + component.getChildCount() + ')');
        } else {
            scrollLeft.getAttributes().put("onclick", "javascript:false");
        }
        UICommand scrollRight = (UICommand)application.createComponent("org.apache.myfaces.tobago.Command");
        scrollRight.setId(component.getId() + "__" + virtualTab + "__" + "next");
        scrollRight.setRendererType(null);
        scrollRight.getAttributes().put("image", "image/tabNext.gif");
        if (tabList.isLast(virtualTab)) {
            scrollRight.setDisabled(true);
        }
        if (!TobagoConfig.getInstance((FacesContext)facesContext).isAjaxEnabled() || !"reloadTab".equals(switchType)) {
            scrollRight.getAttributes().put("onclick", "tobago_nextTab('" + switchType + "','" + clientId + "'," + component.getChildCount() + ')');
        } else {
            scrollRight.getAttributes().put("onclick", "javascript:false");
        }
        UIToolBar toolBar = (UIToolBar)application.createComponent("org.apache.myfaces.tobago.ToolBar");
        toolBar.setId(component.getId() + "__toolBar");
        toolBar.setRendererType("TabNavigationBar");
        toolBar.setTransient(true);
        toolBar.getChildren().add(scrollLeft);
        toolBar.getChildren().add(scrollRight);
        component.getFacets().put("toolBar", toolBar);
        return toolBar;
    }

    private void renderToolbar(FacesContext facesContext, TobagoResponseWriter writer, UIPanel toolbar, int width, int navigationBarWidth) throws IOException {
        writer.startElement("div", null);
        HtmlStyleMap map = new HtmlStyleMap();
        map.put("width", (Object)_Integer.valueOf((int)navigationBarWidth));
        map.put("left", (Object)_Integer.valueOf((int)width));
        writer.writeStyleAttribute(map);
        writer.writeClassAttribute("tobago-tabNavigationBar");
        RenderUtil.encode((FacesContext)facesContext, (UIComponent)toolbar);
        writer.endElement("div");
    }

    protected void encodeContent(TobagoResponseWriter writer, FacesContext facesContext, UITab activeTab) throws IOException {
        HtmlStyleMap bodyStyle = (HtmlStyleMap)activeTab.getParent().getAttributes().get("style_body");
        writer.startElement("tr", null);
        writer.startElement("td", null);
        StyleClasses classes = new StyleClasses();
        classes.addClass("tab", "content");
        classes.addMarkupClass((SupportsMarkup)activeTab, "tab", "content");
        writer.writeClassAttribute(classes);
        writer.writeStyleAttribute(bodyStyle);
        writer.flush();
        RenderUtil.encodeChildren((FacesContext)facesContext, (UIComponent)activeTab);
        writer.endElement("td");
        writer.endElement("tr");
    }

    public void encodeAjax(FacesContext context, UIComponent component) throws IOException {
        Class<?> clazz = class$org$apache$myfaces$tobago$component$UITabGroup;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$component$UITabGroup = new UITabGroup[0].getClass().getComponentType();
        }
        AjaxUtils.checkParamValidity((FacesContext)context, (UIComponent)component, (Class)clazz);
        TabList tabList = this.getTabList(context, (UITabGroup)component);
        int index = this.ensureRenderedActiveIndex(context, (UITabGroup)component);
        int currentWidth = this.getCurrentWidth(tabList, index);
        int navigationBarWidth = 0;
        if (ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"showNavigationBar")) {
            navigationBarWidth = this.getConfiguredValue(context, component, "navigationBarWidth");
        }
        this.renderTabGroupView(context, HtmlRendererUtil.getTobagoResponseWriter((FacesContext)context), (UITabGroup)component, index, (HtmlStyleMap)component.getAttributes().get("style"), "reloadTab", ResourceManagerUtil.getImageWithPath((FacesContext)context, (String)"image/1x1.gif"), navigationBarWidth, currentWidth, tabList);
    }

    public int getFixedHeight(FacesContext facesContext, UIComponent uiComponent) {
        int fixedHeight;
        UITabGroup component = (UITabGroup)uiComponent;
        int height = ComponentUtil.getIntAttribute((UIComponent)component, (String)"height", (int)-1);
        if (height != -1) {
            fixedHeight = height;
        } else {
            fixedHeight = 0;
            Iterator i$ = component.getChildren().iterator();
            while (i$.hasNext()) {
                UIComponent tab = (UIComponent)i$.next();
                if (!(tab instanceof UIPanelBase) || !tab.isRendered()) continue;
                LayoutableRendererBase renderer = ComponentUtil.getRenderer((FacesContext)facesContext, (UIComponent)tab);
                fixedHeight = Math.max(fixedHeight, renderer.getFixedHeight(facesContext, tab));
            }
            fixedHeight += this.getConfiguredValue(facesContext, (UIComponent)component, "headerHeight");
            fixedHeight += this.getConfiguredValue(facesContext, (UIComponent)component, "paddingHeight");
        }
        return fixedHeight;
    }

    private void layoutTabs(FacesContext facesContext, UITabGroup component) {
        Object layoutWidth = component.getAttributes().get("layoutWidth");
        Object layoutHeight = component.getAttributes().get("layoutHeight");
        Iterator i$ = component.getChildren().iterator();
        while (i$.hasNext()) {
            UIComponent tab = (UIComponent)i$.next();
            if (!(tab instanceof UIPanelBase) || !tab.isRendered()) continue;
            if (layoutWidth != null) {
                HtmlRendererUtil.layoutSpace((FacesContext)facesContext, (UIComponent)tab, (boolean)true);
            }
            if (layoutHeight == null) continue;
            HtmlRendererUtil.layoutSpace((FacesContext)facesContext, (UIComponent)tab, (boolean)false);
        }
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$renderkit$html$scarborough$standard$tag$TabGroupRenderer;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$renderkit$html$scarborough$standard$tag$TabGroupRenderer = new TabGroupRenderer[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
        SCRIPTS = new String[]{"script/tab.js", "script/tabgroup.js", "script/tobago-menu.js"};
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TabList {
        private List<Integer> widthList = new ArrayList<Integer>();
        private int firstIndex;
        private int lastIndex;

        private TabList() {
        }

        public List<Integer> getWidthList() {
            return this.widthList;
        }

        public boolean isFirst(int index) {
            return this.firstIndex == index;
        }

        public boolean isLast(int index) {
            return this.lastIndex == index;
        }
    }
}

