/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.UIColumn;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.ajax.api.AjaxRenderer;
import org.apache.myfaces.tobago.ajax.api.AjaxUtils;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIColumnEvent;
import org.apache.myfaces.tobago.component.UIColumnSelector;
import org.apache.myfaces.tobago.component.UIData;
import org.apache.myfaces.tobago.component.UIMenu;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.component.UIReload;
import org.apache.myfaces.tobago.component.UISelectOne;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.context.ResourceManagerFactory;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.event.PageAction;
import org.apache.myfaces.tobago.model.SheetState;
import org.apache.myfaces.tobago.renderkit.LayoutableRendererBase;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.SheetRendererWorkaround;
import org.apache.myfaces.tobago.renderkit.html.CommandRendererHelper;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlStyleMap;
import org.apache.myfaces.tobago.renderkit.html.StyleClasses;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetRenderer
extends LayoutableRendererBase
implements SheetRendererWorkaround,
AjaxRenderer {
    private static final Log LOG;
    public static final String WIDTHS_POSTFIX = "::widths";
    public static final String SCROLL_POSTFIX = "::scrollPosition";
    public static final String SELECTED_POSTFIX = "::selected";
    private static final Integer HEIGHT_0;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$component$UIData;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$renderkit$html$scarborough$standard$tag$SheetRenderer;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$component$UISelectOne;

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.storeFooterHeight(facesContext, uiComponent);
        UIData data = (UIData)uiComponent;
        HtmlRendererUtil.createHeaderAndBodyStyles((FacesContext)facesContext, (UIComponent)data);
        String sheetId = data.getClientId(facesContext);
        HtmlStyleMap sheetStyle = (HtmlStyleMap)data.getAttributes().get("style");
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startElement("div", null);
        writer.writeIdAttribute(new StringBuffer().append(sheetId).append("_outer_div").toString());
        writer.writeClassAttribute("tobago-sheet-outer-div");
        writer.writeStyleAttribute(sheetStyle);
        org.apache.myfaces.tobago.component.UICommand clickAction = null;
        org.apache.myfaces.tobago.component.UICommand dblClickAction = null;
        int columnSelectorIndex = -1;
        int i = 0;
        for (UIComponent child : data.getChildren()) {
            if (child instanceof UIColumnEvent) {
                UIComponent selectionChild;
                UIColumnEvent columnEvent = (UIColumnEvent)child;
                if (columnEvent.isRendered() && (selectionChild = (UIComponent)child.getChildren().get(0)) != null && selectionChild instanceof org.apache.myfaces.tobago.component.UICommand && selectionChild.isRendered()) {
                    org.apache.myfaces.tobago.component.UICommand action = (org.apache.myfaces.tobago.component.UICommand)selectionChild;
                    if ("click".equals(columnEvent.getEvent())) {
                        clickAction = action;
                    }
                    if ("dblclick".equals(columnEvent.getEvent())) {
                        dblClickAction = action;
                    }
                }
            } else if (child instanceof UIColumnSelector) {
                columnSelectorIndex = i;
            }
            ++i;
        }
        this.renderSheet(facesContext, data, clickAction != null || dblClickAction != null);
        writer.endElement("div");
        boolean ajaxEnabled = TobagoConfig.getInstance((FacesContext)facesContext).isAjaxEnabled();
        String[] styles = new String[]{"style/tobago-sheet.css"};
        String[] scripts = new String[]{"script/tobago-sheet.js"};
        Integer frequency = null;
        UIComponent facetReload = data.getFacet("reload");
        if (facetReload != null && facetReload instanceof UIReload && facetReload.isRendered()) {
            UIReload update = (UIReload)facetReload;
            frequency = _Integer.valueOf((int)update.getFrequency());
        }
        String[] cmds = new String[]{new StringBuffer().append("new Tobago.Sheet(\"").append(sheetId).append("\", ").append(ajaxEnabled).append(", undefined, undefined, \"").append(data.getSelectable()).append("\", ").append(columnSelectorIndex).append(", ").append(frequency).append(",  ").append(clickAction != null ? HtmlRendererUtil.getJavascriptString((String)clickAction.getId()) : null).append(",  ").append(HtmlRendererUtil.getRenderedPartiallyJavascriptArray((FacesContext)facesContext, (org.apache.myfaces.tobago.component.UICommand)clickAction)).append(",  ").append(dblClickAction != null ? HtmlRendererUtil.getJavascriptString((String)dblClickAction.getId()) : null).append(",  ").append(HtmlRendererUtil.getRenderedPartiallyJavascriptArray((FacesContext)facesContext, (org.apache.myfaces.tobago.component.UICommand)dblClickAction)).append(");").toString()};
        UIPage page = ComponentUtil.findPage((FacesContext)facesContext, (UIComponent)data);
        page.getStyleFiles().add(styles[0]);
        page.getScriptFiles().add(scripts[0]);
        if (!ajaxEnabled) {
            page.getOnloadScripts().add(cmds[0]);
        } else {
            HtmlRendererUtil.writeStyleLoader((FacesContext)facesContext, (String[])styles);
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, (String[])scripts, (String[])cmds);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void renderSheet(FacesContext facesContext, UIData data, boolean hasClickAction) throws IOException {
        writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        resourceManager = ResourceManagerFactory.getResourceManager((FacesContext)facesContext);
        viewRoot = facesContext.getViewRoot();
        contextPath = facesContext.getExternalContext().getRequestContextPath();
        sheetId = data.getClientId(facesContext);
        image1x1 = new StringBuffer().append(contextPath).append(resourceManager.getImage(viewRoot, "image/1x1.gif")).toString();
        selectorDisabled = new StringBuffer().append(contextPath).append(resourceManager.getImage(viewRoot, "image/sheetUncheckedDisabled.gif")).toString();
        unchecked = new StringBuffer().append(contextPath).append(resourceManager.getImage(viewRoot, "image/sheetUnchecked.gif")).toString();
        attributes = data.getAttributes();
        sheetStyle = (HtmlStyleMap)attributes.get("style");
        sheetHeight = HtmlRendererUtil.getStyleAttributeIntValue((HtmlStyleMap)sheetStyle, (String)"height");
        if (sheetHeight == null) {
            SheetRenderer.LOG.error((Object)"no height in parent container, setting to 100");
            sheetHeight = _Integer.valueOf((int)100);
        }
        footerHeight = (Integer)attributes.get("footerHeight");
        selectable = data.getSelectable();
        state = data.getSheetState(facesContext);
        columnWidths = data.getWidthList();
        selectedRows = org.apache.myfaces.tobago.util.StringUtils.toString(this.getSelectedRows(data, state));
        renderedColumnList = data.getRenderedColumns();
        writer.startElement("input", null);
        writer.writeIdAttribute(new StringBuffer().append(sheetId).append("::widths").toString());
        writer.writeNameAttribute(new StringBuffer().append(sheetId).append("::widths").toString());
        writer.writeAttribute("type", "hidden", false);
        writer.writeAttribute("value", org.apache.myfaces.tobago.util.StringUtils.toString((List)columnWidths), false);
        writer.endElement("input");
        writer.startElement("input", null);
        writer.writeIdAttribute(new StringBuffer().append(sheetId).append("::scrollPosition").toString());
        writer.writeNameAttribute(new StringBuffer().append(sheetId).append("::scrollPosition").toString());
        writer.writeAttribute("type", "hidden", false);
        scrollPosition = data.getScrollPosition();
        if (scrollPosition != null) {
            scroll = new StringBuffer().append(scrollPosition[0]).append(";").append(scrollPosition[1]).toString();
            writer.writeAttribute("value", scroll, false);
        } else {
            writer.writeAttribute("value", "", false);
        }
        writer.endElement("input");
        if (!"none".equals(selectable)) {
            writer.startElement("input", null);
            writer.writeIdAttribute(new StringBuffer().append(sheetId).append("::selected").toString());
            writer.writeNameAttribute(new StringBuffer().append(sheetId).append("::selected").toString());
            writer.writeAttribute("type", "hidden", false);
            writer.writeAttribute("value", selectedRows, true);
            writer.endElement("input");
        }
        if (!(showHeader = data.isShowHeader()) || !ClientProperties.getInstance((FacesContext)facesContext).getUserAgent().isMsie6()) ** GOTO lbl-1000
        v0 = SheetRenderer.class$org$apache$myfaces$tobago$component$UISelectOne;
        if (v0 == null) {
            v0 = SheetRenderer.class$org$apache$myfaces$tobago$component$UISelectOne = new UISelectOne[0].getClass().getComponentType();
        }
        if (ComponentUtil.findDescendant((UIComponent)data, (Class)v0) != null) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = ie6SelectOneFix = false;
        }
        if (showHeader) {
            writer.startElement("div", null);
            writer.writeIdAttribute(new StringBuffer().append(sheetId).append("_header_div").toString());
            writer.writeClassAttribute("tobago-sheet-header-div");
            headerStyle = (HtmlStyleMap)attributes.get("style_header");
            zIndex = this.getZIndex(facesContext);
            if (headerStyle != null) {
                headerStyle.put("z-index", (Object)_Integer.valueOf((int)(zIndex + 1)));
                if (ie6SelectOneFix) {
                    headerStyle.put("position", (Object)"relative");
                }
                writer.writeStyleAttribute(headerStyle);
            }
            columnCount = 0;
            sortMarkerWidth = this.getAscendingMarkerWidth(facesContext, (UIComponent)data);
            imageAscending = new StringBuffer().append(contextPath).append(resourceManager.getImage(viewRoot, "image/ascending.gif")).toString();
            imageDescending = new StringBuffer().append(contextPath).append(resourceManager.getImage(viewRoot, "image/descending.gif")).toString();
            img = resourceManager.getImage(viewRoot, "image/unsorted.gif", true);
            imageUnsorted = image1x1;
            if (img != null) {
                imageUnsorted = new StringBuffer().append(contextPath).append(img).toString();
            }
            for (UIColumn column : renderedColumnList) {
                this.renderColumnHeader(facesContext, writer, data, columnCount, column, imageAscending, imageDescending, imageUnsorted, image1x1, sortMarkerWidth);
                ++columnCount;
            }
            writer.startElement("div", null);
            writer.writeIdAttribute(new StringBuffer().append(sheetId).append("_header_box_filler").toString());
            writer.writeClassAttribute("tobago-sheet-header-box tobago-sheet-header-filler");
            writer.writeAttribute("style", "width: 0px", false);
            writer.startElement("div", null);
            writer.writeClassAttribute("tobago-sheet-header");
            writer.flush();
            writer.write("&nbsp;");
            writer.endElement("div");
            writer.endElement("div");
            writer.endElement("div");
        }
        bodyStyle = (HtmlStyleMap)attributes.get("style_body");
        bodyHeight = sheetHeight - footerHeight;
        HtmlRendererUtil.replaceStyleAttribute((UIComponent)data, (String)"style_body", (String)"height", (int)bodyHeight);
        writer.startElement("div", null);
        writer.writeIdAttribute(new StringBuffer().append(sheetId).append("_data_div").toString());
        writer.writeClassAttribute("tobago-sheet-body-div ");
        if (ie6SelectOneFix) {
            headerHeight = this.getConfiguredValue(facesContext, (UIComponent)data, "headerHeight");
            bodyStyle.put("height", (Object)_Integer.valueOf((int)(bodyHeight - headerHeight)));
            bodyStyle.put("position", (Object)"relative");
        }
        if (!showHeader || ie6SelectOneFix) {
            bodyStyle.put("padding-top", (Object)"0");
        }
        writer.writeAttribute("style", bodyStyle.toString(), false);
        if (ie6SelectOneFix) {
            bodyStyle.remove((Object)"position");
        }
        if (!showHeader || ie6SelectOneFix) {
            bodyStyle.remove((Object)"padding-top");
        }
        bodyStyle.remove((Object)"height");
        space = HtmlRendererUtil.getStyleAttributeIntValue((HtmlStyleMap)bodyStyle, (String)"width");
        sheetBodyStyle = (HtmlStyleMap)bodyStyle.clone();
        if (space != null) {
            space = _Integer.valueOf((int)(space - this.getContentBorder(facesContext, data)));
            if (this.needVerticalScrollbar(facesContext, data)) {
                space = _Integer.valueOf((int)(space - this.getScrollbarWidth(facesContext, (UIComponent)data)));
            }
            sheetBodyStyle.put("width", (Object)space);
        }
        writer.startElement("table", null);
        writer.writeAttribute("cellspacing", 0);
        writer.writeAttribute("cellpadding", 0);
        writer.writeAttribute("summary", "", false);
        writer.writeClassAttribute("tobago-sheet-body-table");
        writer.writeStyleAttribute(sheetBodyStyle);
        if (columnWidths != null) {
            writer.startElement("colgroup", null);
            for (Integer columnWidth : columnWidths) {
                writer.startElement("col", null);
                writer.writeAttribute("width", columnWidth.intValue());
                writer.endElement("col");
            }
            writer.endElement("colgroup");
        }
        if (SheetRenderer.LOG.isDebugEnabled()) {
            SheetRenderer.LOG.debug((Object)new StringBuffer().append("first = ").append(data.getFirst()).append("   rows = ").append(data.getRows()).toString());
        }
        var = data.getVar();
        odd = false;
        visibleIndex = -1;
        last = data.getFirst() + data.getRows();
        for (rowIndex = data.getFirst(); rowIndex < last; ++rowIndex) {
            data.setRowIndex(rowIndex);
            if (!data.isRowAvailable()) break;
            ++visibleIndex;
            odd = odd == false;
            v2 = rowClass = odd != false ? "tobago-sheet-content-odd " : "tobago-sheet-content-even ";
            if (SheetRenderer.LOG.isDebugEnabled()) {
                SheetRenderer.LOG.debug((Object)new StringBuffer().append("var       ").append(var).toString());
                SheetRenderer.LOG.debug((Object)new StringBuffer().append("list      ").append(data.getValue()).toString());
            }
            writer.startElement("tr", null);
            writer.writeClassAttribute(rowClass);
            writer.writeIdAttribute(new StringBuffer().append(sheetId).append("_data_tr_").append(rowIndex).toString());
            writer.flush();
            columnIndex = -1;
            for (UIColumn column : renderedColumnList) {
                tdClass = new StyleClasses();
                tdClass.addClass("sheet", "cell-td");
                tdClass.addMarkupClass((UIComponent)column, "column");
                if (++columnIndex == 0) {
                    tdClass.addClass("sheet", "cell-first-column");
                }
                if (hasClickAction) {
                    tdClass.addClass("sheet", "cell-clickable");
                }
                cellClass = StyleClasses.ensureStyleClasses((UIComponent)column);
                tdClass.addClasses(cellClass);
                writer.startElement("td", (UIComponent)column);
                writer.writeClassAttribute(tdClass.toString());
                align = (String)column.getAttributes().get("align");
                if (align != null) {
                    writer.writeStyleAttribute(HtmlRendererUtil.toStyleString((String)"text-align", (String)align));
                }
                writer.startElement("div", null);
                writer.writeIdAttribute(new StringBuffer().append(sheetId).append("_data_row_").append(visibleIndex).append("_column").append(columnIndex).toString());
                writer.writeClassAttribute("tobago-sheet-cell-outer");
                writer.writeStyleAttribute(HtmlRendererUtil.toStyleString((String)"width", (Integer)((Integer)columnWidths.get(columnIndex))));
                writer.startElement("div", null);
                writer.writeClassAttribute("tobago-sheet-cell-inner");
                writer.flush();
                if (column instanceof UIColumnSelector) {
                    disabled = ComponentUtil.getBooleanAttribute((UIComponent)column, (String)"disabled");
                    writer.startElement("input", null);
                    writer.writeAttribute("type", "checkbox", false);
                    writer.writeAttribute("disabled", disabled);
                    writer.writeIdAttribute(new StringBuffer().append(sheetId).append("_data_row_selector_").append(rowIndex).toString());
                    writer.writeClassAttribute("tobago-selectBooleanCheckbox-default");
                    writer.endElement("input");
                } else {
                    childs = data.getRenderedChildrenOf(column);
                    for (UIComponent grandkid : childs) {
                        grandkid.getAttributes().put("layoutHeight", SheetRenderer.HEIGHT_0);
                        RenderUtil.encode((FacesContext)facesContext, (UIComponent)grandkid);
                    }
                    if (childs.size() > 1 && SheetRenderer.LOG.isInfoEnabled()) {
                        SheetRenderer.LOG.info((Object)"Column should not contain more than one child. Please surround the components with a tc:panel.");
                    }
                }
                writer.endElement("div");
                writer.endElement("div");
                writer.endElement("td");
            }
            writer.startElement("td", null);
            writer.writeClassAttribute("tobago-sheet-cell-td tobago-sheet-cell-filler");
            writer.startElement("div", null);
            writer.writeIdAttribute(new StringBuffer().append(sheetId).append("_data_row_").append(visibleIndex).append("_column_filler").toString());
            writer.writeClassAttribute("tobago-sheet-cell-outer");
            writer.writeStyleAttribute("width: 0px;");
            writer.flush();
            writer.write("&nbsp;");
            writer.endElement("div");
            writer.endElement("td");
            writer.endElement("tr");
        }
        data.setRowIndex(-1);
        if (visibleIndex == -1 && showHeader) {
            writer.startElement("tr", null);
            writer.flush();
            columnIndex = -1;
            for (UIColumn column : renderedColumnList) {
                writer.startElement("td", null);
                writer.startElement("div", null);
                writer.writeStyleAttribute(HtmlRendererUtil.toStyleString((String)"width", (Integer)((Integer)columnWidths.get(++columnIndex))));
                writer.endElement("div");
                writer.endElement("td");
            }
            writer.startElement("td", null);
            writer.startElement("div", null);
            writer.writeClassAttribute("tobago-sheet-cell-outer");
            writer.writeStyleAttribute("width: 0px;");
            writer.flush();
            writer.write("&nbsp;");
            writer.endElement("div");
            writer.endElement("td");
            writer.endElement("tr");
        }
        writer.endElement("table");
        writer.endElement("div");
        this.renderFooter(facesContext, data, writer, sheetId, sheetHeight, footerHeight, bodyStyle);
        if (showHeader) {
            this.resetZIndex(facesContext);
        }
    }

    private Integer getZIndex(FacesContext facesContext) {
        Integer zIndex = (Integer)facesContext.getExternalContext().getRequestMap().get("zIndex");
        zIndex = zIndex == null ? _Integer.valueOf((int)1) : _Integer.valueOf((int)(zIndex + 4));
        facesContext.getExternalContext().getRequestMap().put("zIndex", zIndex);
        return zIndex;
    }

    private void resetZIndex(FacesContext facesContext) {
        Integer zIndex = (Integer)facesContext.getExternalContext().getRequestMap().get("zIndex");
        if (zIndex != null) {
            zIndex = zIndex == 1 ? null : _Integer.valueOf((int)(zIndex - 4));
            facesContext.getExternalContext().getRequestMap().put("zIndex", zIndex);
        }
    }

    protected void renderFooter(FacesContext facesContext, UIData data, TobagoResponseWriter writer, String sheetId, Integer sheetHeight, int footerHeight, HtmlStyleMap bodyStyle) throws IOException {
        String showRowRange = this.getPagingAttribute(data, "showRowRange");
        String showPageRange = this.getPagingAttribute(data, "showPageRange");
        String showDirectLinks = this.getPagingAttribute(data, "showDirectLinks");
        if (this.isValidPagingValue(showRowRange) || this.isValidPagingValue(showPageRange) || this.isValidPagingValue(showDirectLinks)) {
            String className;
            String pagerCommandId;
            String pagingOnClick;
            org.apache.myfaces.tobago.component.UICommand pagerCommand;
            Application application = facesContext.getApplication();
            HtmlStyleMap footerStyle = (HtmlStyleMap)bodyStyle.clone();
            footerStyle.put("height", (Object)_Integer.valueOf((int)footerHeight));
            footerStyle.put("top", (Object)_Integer.valueOf((int)(sheetHeight - footerHeight)));
            writer.startElement("div", (UIComponent)data);
            writer.writeClassAttribute("tobago-sheet-footer");
            writer.writeStyleAttribute(footerStyle);
            if (this.isValidPagingValue(showRowRange)) {
                pagerCommand = (org.apache.myfaces.tobago.component.UICommand)data.getFacet("pagerRow");
                if (pagerCommand == null) {
                    pagerCommand = this.createPagingCommand(application, PageAction.TO_ROW, false);
                    data.getFacets().put("pagerRow", pagerCommand);
                }
                pagingOnClick = new CommandRendererHelper(facesContext, (UICommand)pagerCommand).getOnclickDoubleQuoted();
                pagerCommandId = pagerCommand.getClientId(facesContext);
                className = new StringBuffer().append("tobago-sheet-paging-rows-span tobago-sheet-paging-span-").append(showRowRange).toString();
                writer.startElement("span", null);
                writer.writeAttribute("onclick", new StringBuffer().append("tobagoSheetEditPagingRow(this, '").append(pagerCommandId).append("', '").append(pagingOnClick).append("')").toString(), true);
                writer.writeClassAttribute(className);
                writer.writeAttribute("title", ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetPagingInfoRowPagingTip"), true);
                writer.writeText("");
                writer.write(this.createSheetPagingInfo(data, facesContext, pagerCommandId, true));
                writer.endElement("span");
            }
            if (this.isValidPagingValue(showDirectLinks)) {
                String className2 = new StringBuffer().append("tobago-sheet-paging-links-span tobago-sheet-paging-span-").append(showDirectLinks).toString();
                writer.startElement("span", null);
                writer.writeClassAttribute(className2);
                writer.writeIdAttribute(new StringBuffer().append(sheetId).append("::").append("pagingLinks").toString());
                this.writeDirectPagingLinks(writer, facesContext, application, data);
                writer.endElement("span");
            }
            if (this.isValidPagingValue(showPageRange)) {
                pagerCommand = (org.apache.myfaces.tobago.component.UICommand)data.getFacet("pagerPage");
                if (pagerCommand == null) {
                    pagerCommand = this.createPagingCommand(application, PageAction.TO_PAGE, false);
                    data.getFacets().put("pagerPage", pagerCommand);
                }
                pagingOnClick = new CommandRendererHelper(facesContext, (UICommand)pagerCommand).getOnclickDoubleQuoted();
                pagerCommandId = pagerCommand.getClientId(facesContext);
                className = new StringBuffer().append("tobago-sheet-paging-pages-span tobago-sheet-paging-span-").append(showPageRange).toString();
                writer.startElement("span", null);
                writer.writeClassAttribute(className);
                writer.writeIdAttribute(new StringBuffer().append(sheetId).append("::").append("pagingPages").toString());
                writer.writeText("");
                boolean atBeginning = data.isAtBeginning();
                this.link(facesContext, application, atBeginning, PageAction.FIRST, data);
                this.link(facesContext, application, atBeginning, PageAction.PREV, data);
                writer.startElement("span", null);
                writer.writeClassAttribute("tobago-sheet-paging-pages-text");
                writer.writeAttribute("onclick", new StringBuffer().append("tobagoSheetEditPagingRow(this, '").append(pagerCommandId).append("', '").append(pagingOnClick).append("')").toString(), true);
                writer.writeAttribute("title", ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetPagingInfoPagePagingTip"), true);
                writer.writeText("");
                writer.write(this.createSheetPagingInfo(data, facesContext, pagerCommandId, false));
                writer.endElement("span");
                boolean atEnd = data.isAtEnd();
                this.link(facesContext, application, atEnd, PageAction.NEXT, data);
                this.link(facesContext, application, atEnd || !data.hasRowCount(), PageAction.LAST, data);
                writer.endElement("span");
            }
            writer.endElement("div");
        }
    }

    private String createSheetPagingInfo(UIData data, FacesContext facesContext, String pagerCommandId, boolean row) {
        String sheetPagingInfo;
        if (data.getRowCount() > 0) {
            int last;
            int first;
            Locale locale = facesContext.getViewRoot().getLocale();
            if (row) {
                first = data.getFirst() + 1;
                last = data.getLast();
            } else {
                first = data.getPage();
                last = data.getPages();
            }
            String key = first != last ? ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)new StringBuffer().append("sheetPagingInfo").append(row ? "Rows" : "Pages").toString()) : ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)new StringBuffer().append("sheetPagingInfoSingle").append(row ? "Row" : "Page").toString());
            MessageFormat detail = new MessageFormat(key, locale);
            Object[] args = new Object[]{_Integer.valueOf((int)first), _Integer.valueOf((int)last), _Integer.valueOf((int)data.getRowCount()), new StringBuffer().append(pagerCommandId).append("::").append("text").toString()};
            sheetPagingInfo = detail.format(args);
        } else {
            sheetPagingInfo = ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)new StringBuffer().append("sheetPagingInfoEmpty").append(row ? "Row" : "Page").toString());
        }
        return sheetPagingInfo;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        Integer[] scrollPosition;
        String value;
        String widths;
        super.decode(facesContext, component);
        String key = new StringBuffer().append(component.getClientId(facesContext)).append(WIDTHS_POSTFIX).toString();
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(key) && (widths = (String)requestParameterMap.get(key)).trim().length() > 0) {
            component.getAttributes().put("widthListString", widths);
        }
        if (requestParameterMap.containsKey(key = new StringBuffer().append(component.getClientId(facesContext)).append(SELECTED_POSTFIX).toString())) {
            List selectedRows;
            String selected = (String)requestParameterMap.get(key);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)new StringBuffer().append("selected = ").append(selected).toString());
            }
            try {
                selectedRows = org.apache.myfaces.tobago.util.StringUtils.parseIntegerList((String)selected);
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)selected, (Throwable)e);
                selectedRows = Collections.EMPTY_LIST;
            }
            component.getAttributes().put("selectedListString", selectedRows);
        }
        if ((value = (String)requestParameterMap.get(key = new StringBuffer().append(component.getClientId(facesContext)).append(SCROLL_POSTFIX).toString())) != null && (scrollPosition = SheetState.parseScrollPosition((String)value)) != null) {
            component.getAttributes().put("attrScrollPosition", scrollPosition);
        }
    }

    public boolean needVerticalScrollbar(FacesContext facesContext, UIData data) {
        HtmlStyleMap style;
        Integer height;
        Object forceScrollbar = data.getAttributes().get("forceVerticalScrollbar");
        if (forceScrollbar != null) {
            if ("true".equals(forceScrollbar)) {
                return true;
            }
            if ("false".equals(forceScrollbar)) {
                return false;
            }
            if (!"auto".equals(forceScrollbar)) {
                LOG.warn((Object)new StringBuffer().append("Illegal value for attribute 'forceVerticalScrollbar' : \"").append(forceScrollbar).append("\"").toString());
            }
        }
        if ((height = HtmlRendererUtil.getStyleAttributeIntValue((HtmlStyleMap)(style = (HtmlStyleMap)data.getAttributes().get("style")), (String)"height")) != null) {
            int first = data.getFirst();
            int rows = Math.min(data.getRowCount(), first + data.getRows()) - first;
            int heightNeeded = this.getHeaderHeight(facesContext, (UIComponent)data) + this.getFooterHeight(facesContext, (UIComponent)data) + rows * this.getConfiguredValue(facesContext, (UIComponent)data, "rowHeight") + this.getRowPadding(facesContext, (UIComponent)data);
            return heightNeeded > height;
        }
        return false;
    }

    private int getRowPadding(FacesContext facesContext, UIComponent component) {
        return this.getConfiguredValue(facesContext, component, "rowPadding");
    }

    public int getScrollbarWidth(FacesContext facesContext, UIComponent component) {
        return this.getConfiguredValue(facesContext, component, "scrollbarWidth");
    }

    protected void storeFooterHeight(FacesContext facesContext, UIComponent component) {
        component.getAttributes().put("footerHeight", _Integer.valueOf((int)this.getFooterHeight(facesContext, component)));
    }

    protected int getFooterHeight(FacesContext facesContext, UIComponent component) {
        int footerHeight = this.isValidPagingAttribute((UIData)component, "showRowRange") || this.isValidPagingAttribute((UIData)component, "showPageRange") || this.isValidPagingAttribute((UIData)component, "showDirectLinks") ? this.getConfiguredValue(facesContext, component, "footerHeight") : 0;
        return footerHeight;
    }

    private boolean isValidPagingAttribute(UIData component, String name) {
        return this.isValidPagingValue(this.getPagingAttribute(component, name));
    }

    private String getPagingAttribute(UIData component, String name) {
        String value = ComponentUtil.getStringAttribute((UIComponent)component, (String)name);
        if (this.isValidPagingValue(value)) {
            return value;
        }
        if (!"none".equals(value)) {
            LOG.warn((Object)new StringBuffer().append("illegal value in sheet' paging attribute : \"").append(value).append("\"").toString());
        }
        return "none";
    }

    private boolean isValidPagingValue(String value) {
        return "left".equals(value) || "center".equals(value) || "right".equals(value);
    }

    protected int getAscendingMarkerWidth(FacesContext facesContext, UIComponent component) {
        return this.getConfiguredValue(facesContext, component, "ascendingMarkerWidth");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected List<Integer> getSelectedRows(UIData data, SheetState state) {
        List selected = (List)data.getAttributes().get("selectedListString");
        if (selected == null && state != null) {
            selected = state.getSelectedRows();
        }
        if (selected == null) {
            selected = Collections.EMPTY_LIST;
        }
        return selected;
    }

    private void link(FacesContext facesContext, Application application, boolean disabled, PageAction command, UIData data) throws IOException {
        org.apache.myfaces.tobago.component.UICommand link = this.createPagingCommand(application, command, disabled);
        data.getFacets().put(command.getToken(), link);
        String tip = ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)new StringBuffer().append("sheet").append(command.getToken()).toString());
        String image = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)new StringBuffer().append("image/sheet").append(command.getToken()).append(disabled ? "Disabled" : "").append(".gif").toString());
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startElement("img", null);
        writer.writeIdAttribute(new StringBuffer().append(data.getClientId(facesContext)).append("::").append("pagingPages").append("::").append(command.getToken()).toString());
        writer.writeClassAttribute(new StringBuffer().append("tobago-sheet-footer-pager-button").append(disabled ? " tobago-sheet-footer-pager-button-disabled" : "").toString());
        writer.writeAttribute("src", image, false);
        writer.writeAttribute("title", tip, true);
        writer.writeAttribute("alt", "", false);
        if (!disabled) {
            CommandRendererHelper helper = new CommandRendererHelper(facesContext, (UICommand)link);
            String onClick = helper.getOnclick();
            writer.writeAttribute("onclick", onClick, true);
        }
        writer.endElement("img");
    }

    protected void renderColumnHeader(FacesContext facesContext, TobagoResponseWriter writer, UIData component, int columnIndex, UIColumn column, String imageAscending, String imageDescending, String imageUnsorted, String image1x1, int sortMarkerWidth) throws IOException {
        this.renderColumnHeader(facesContext, writer, component, columnIndex, column, imageAscending, imageDescending, imageUnsorted, image1x1, sortMarkerWidth, ComponentUtil.getBooleanAttribute((UIComponent)column, (String)"resizable"));
    }

    protected void renderColumnHeader(FacesContext facesContext, TobagoResponseWriter writer, UIData component, int columnIndex, UIColumn column, String imageAscending, String imageDescending, String imageUnsorted, String image1x1, int sortMarkerWidth, boolean headerResizer) throws IOException {
        String resizerClass;
        String sheetId = component.getClientId(facesContext);
        Application application = facesContext.getApplication();
        List columnWidths = component.getWidthList();
        String divWidth = new StringBuffer().append("width: ").append(columnWidths.get(columnIndex)).append("px;").toString();
        writer.startElement("div", null);
        writer.writeIdAttribute(new StringBuffer().append(sheetId).append("_header_box_").append(columnIndex).toString());
        writer.writeClassAttribute("tobago-sheet-header-box");
        writer.writeAttribute("style", divWidth, false);
        String tip = (String)column.getAttributes().get("tip");
        if (tip == null) {
            tip = "";
        }
        String sorterImage = null;
        String sorterClass = "";
        String sortTitle = null;
        boolean sortable = ComponentUtil.getBooleanAttribute((UIComponent)column, (String)"sortable");
        if (sortable && !(column instanceof UIColumnSelector)) {
            org.apache.myfaces.tobago.component.UICommand sortCommand = (org.apache.myfaces.tobago.component.UICommand)column.getFacet("sorter");
            if (sortCommand == null) {
                String columnId = column.getClientId(facesContext);
                String sorterId = new StringBuffer().append(columnId.substring(columnId.lastIndexOf(":") + 1)).append("_").append("sorter").toString();
                sortCommand = (org.apache.myfaces.tobago.component.UICommand)application.createComponent("org.apache.myfaces.tobago.Command");
                sortCommand.setRendererType("Link");
                sortCommand.setId(sorterId);
                column.getFacets().put("sorter", sortCommand);
            }
            String onclick = new StringBuffer().append("Tobago.submitAction2(this, '").append(sortCommand.getClientId(facesContext)).append("', null, null)").toString();
            writer.writeAttribute("onclick", onclick, false);
            if (StringUtils.isNotEmpty((String)tip)) {
                tip = new StringBuffer().append(tip).append(" - ").toString();
            }
            tip = new StringBuffer().append(tip).append(ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetTipSorting")).toString();
            SheetState sheetState = component.getSheetState(facesContext);
            if (column.getId().equals(sheetState.getSortedColumnId())) {
                if (sheetState.isAscending()) {
                    sorterImage = imageAscending;
                    sortTitle = ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetAscending");
                } else {
                    sorterImage = imageDescending;
                    sortTitle = ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetDescending");
                }
            }
            sorterClass = " tobago-sheet-header-sortable";
        }
        writer.writeAttribute("title", tip, true);
        String align = (String)column.getAttributes().get("align");
        writer.startElement("div", null);
        writer.writeIdAttribute(new StringBuffer().append(sheetId).append("_header_outer_").append(columnIndex).toString());
        writer.writeClassAttribute(new StringBuffer().append("tobago-sheet-header").append(sorterClass).toString());
        if (align != null) {
            writer.writeStyleAttribute(new StringBuffer().append("text-align: ").append(align).append(";").toString());
        }
        if (column instanceof UIColumnSelector) {
            resizerClass = "tobago-sheet-header-resize";
            this.renderColumnSelectorHeader(facesContext, writer, component, column);
        } else {
            resizerClass = "tobago-sheet-header-resize tobago-sheet-header-resize-cursor";
            this.renderColumnHeaderLabel(facesContext, writer, column, sortMarkerWidth, align, image1x1);
        }
        writer.endElement("div");
        if (headerResizer) {
            writer.startElement("div", null);
            writer.writeIdAttribute(new StringBuffer().append(sheetId).append("_header_resizer_").append(columnIndex).toString());
            writer.writeClassAttribute(resizerClass);
            writer.flush();
            writer.write("&nbsp;");
            writer.endElement("div");
        }
        if (sortable && !(column instanceof UIColumnSelector)) {
            if (sorterImage == null && imageUnsorted != null) {
                sorterImage = imageUnsorted;
            }
            writer.startElement("div", null);
            writer.writeClassAttribute("tobago-sheet-header-sort-div");
            if (sortTitle != null) {
                writer.writeAttribute("title", sortTitle, true);
            }
            if (sorterImage != null) {
                writer.startElement("img", null);
                writer.writeAttribute("src", sorterImage, false);
                writer.writeAttribute("alt", "", false);
                if (sortTitle != null) {
                    writer.writeAttribute("title", sortTitle, true);
                }
                writer.endElement("img");
            }
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    protected void renderColumnSelectorHeader(FacesContext facesContext, TobagoResponseWriter writer, UIData component, UIColumn column) throws IOException {
        UIPanel menu = (UIPanel)column.getFacet("menupopup");
        if (menu == null) {
            Application application = facesContext.getApplication();
            menu = (UIPanel)application.createComponent("org.apache.myfaces.tobago.Menu");
            menu.setId("selectorMenu");
            column.getFacets().put("menupopup", menu);
            menu.setRendererType("MenuBar");
            menu.getAttributes().put("menuPopup", Boolean.TRUE);
            menu.getAttributes().put("menuPopupType", "SheetSelector");
            menu.getAttributes().put("image", "image/sheetSelectorMenu.gif");
            String sheetId = column.getParent().getClientId(facesContext);
            String action = new StringBuffer().append("Tobago.Sheets.selectAll('").append(sheetId).append("')").toString();
            String label = ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetMenuSelect");
            org.apache.myfaces.tobago.component.UICommand menuItem = this.createMenuItem(application, label, action);
            menuItem.setId("menuSelectAll");
            menu.getChildren().add(menuItem);
            action = new StringBuffer().append("Tobago.Sheets.unSelectAll('").append(sheetId).append("')").toString();
            label = ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetMenuUnselect");
            menuItem = this.createMenuItem(application, label, action);
            menuItem.setId("menuUnselectAll");
            menu.getChildren().add(menuItem);
            action = new StringBuffer().append("Tobago.Sheets.toggleAllSelections('").append(sheetId).append("')").toString();
            label = ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetMenuToggleselect");
            menuItem = this.createMenuItem(application, label, action);
            menuItem.setId("menuToggleSelections");
            menu.getChildren().add(menuItem);
        }
        menu.setRendered("multi".equals(component.getSelectable()));
        writer.startElement("div", null);
        writer.writeIdAttribute(column.getClientId(facesContext));
        writer.writeClassAttribute("tobago-sheet-selector-menu");
        writer.endElement("div");
        RenderUtil.encode((FacesContext)facesContext, (UIComponent)menu);
    }

    private org.apache.myfaces.tobago.component.UICommand createMenuItem(Application application, String label, String action) {
        org.apache.myfaces.tobago.component.UICommand menuItem = (org.apache.myfaces.tobago.component.UICommand)application.createComponent("org.apache.myfaces.tobago.MenuCommand");
        menuItem.setRendererType("MenuCommand");
        menuItem.getAttributes().put("onclick", action);
        menuItem.getAttributes().put("label", label);
        return menuItem;
    }

    private void renderColumnHeaderLabel(FacesContext facesContext, TobagoResponseWriter writer, UIColumn column, int sortMarkerWidth, String align, String image1x1) throws IOException {
        String label = (String)column.getAttributes().get("label");
        if (label != null) {
            writer.writeText((Object)label, null);
            if (ComponentUtil.getBooleanAttribute((UIComponent)column, (String)"sortable") && "right".equals(align)) {
                writer.startElement("img", null);
                writer.writeAttribute("src", image1x1, false);
                writer.writeAttribute("alt", "", false);
                writer.writeAttribute("width", sortMarkerWidth);
                writer.writeAttribute("height", 1);
                writer.endElement("img");
            }
        } else {
            writer.startElement("img", null);
            writer.writeAttribute("src", image1x1, false);
            writer.writeAttribute("alt", "", false);
            writer.endElement("img");
        }
        if (column.getFacet("menupopup") != null) {
            this.renderFilter(facesContext, writer, (UIComponent)column);
        }
    }

    private void renderFilter(FacesContext facesContext, TobagoResponseWriter writer, UIComponent column) throws IOException {
        UIComponent facet = column.getFacet("menupopup");
        if (facet instanceof UIMenu) {
            if (facet.getAttributes().get("menuPopup") != Boolean.TRUE) {
                facet.setRendererType("MenuBar");
                facet.getAttributes().put("menuPopup", Boolean.TRUE);
                facet.getAttributes().put("menuPopupType", "SheetSelector");
            }
            if (StringUtils.isBlank((String)((String)facet.getAttributes().get("image")))) {
                facet.getAttributes().put("image", "image/sheetSelectorMenu.gif");
            }
            writer.startElement("span", null);
            writer.writeIdAttribute(column.getClientId(facesContext));
            writer.writeClassAttribute("tobago-sheet-selector-menu");
            writer.endElement("span");
            RenderUtil.encode((FacesContext)facesContext, (UIComponent)facet);
        } else {
            LOG.warn((Object)new StringBuffer().append("Unknown filter component: ").append(facet).toString());
        }
    }

    private void writeDirectPagingLinks(TobagoResponseWriter writer, FacesContext facesContext, Application application, UIData data) throws IOException {
        int skip;
        org.apache.myfaces.tobago.component.UICommand pagerCommand = (org.apache.myfaces.tobago.component.UICommand)data.getFacet("pagerPage");
        if (pagerCommand == null) {
            pagerCommand = this.createPagingCommand(application, PageAction.TO_PAGE, false);
            data.getFacets().put("pagerPage", pagerCommand);
        }
        String pagerCommandId = pagerCommand.getClientId(facesContext);
        String onclick = new CommandRendererHelper(facesContext, (UICommand)pagerCommand).getOnclickDoubleQuoted();
        String hrefPostfix = new StringBuffer().append("', '").append(onclick).append("');").toString();
        int linkCount = ComponentUtil.getIntAttribute((UIComponent)data, (String)"directLinkCount");
        ArrayList<Integer> prevs = new ArrayList<Integer>(--linkCount);
        int page = data.getPage();
        for (int i = 0; i < linkCount && page > 1; ++i) {
            if (--page <= 0) continue;
            prevs.add(0, _Integer.valueOf((int)page));
        }
        ArrayList<Integer> nexts = new ArrayList<Integer>(linkCount);
        page = data.getPage();
        for (int i = 0; i < linkCount && page < data.getPages(); ++i) {
            if (++page <= 1) continue;
            nexts.add(_Integer.valueOf((int)page));
        }
        if (prevs.size() > linkCount / 2 && nexts.size() > linkCount - linkCount / 2) {
            while (prevs.size() > linkCount / 2) {
                prevs.remove(0);
            }
            while (nexts.size() > linkCount - linkCount / 2) {
                nexts.remove(nexts.size() - 1);
            }
        } else if (prevs.size() <= linkCount / 2) {
            while (prevs.size() + nexts.size() > linkCount) {
                nexts.remove(nexts.size() - 1);
            }
        } else {
            while (prevs.size() + nexts.size() > linkCount) {
                prevs.remove(0);
            }
        }
        int n = skip = prevs.size() > 0 ? (Integer)prevs.get(0) : 1;
        if (skip > 1) {
            skip -= linkCount - linkCount / 2;
            String name = "...";
            if (--skip < 1) {
                skip = 1;
                if ((Integer)prevs.get(0) == 2) {
                    name = "1";
                }
            }
            this.writeLinkElement(writer, name, Integer.toString(skip), pagerCommandId, hrefPostfix, true);
        }
        for (Integer prev : prevs) {
            String name = prev.toString();
            this.writeLinkElement(writer, name, name, pagerCommandId, hrefPostfix, true);
        }
        String name = Integer.toString(data.getPage());
        this.writeLinkElement(writer, name, name, pagerCommandId, hrefPostfix, false);
        for (Integer next : nexts) {
            name = next.toString();
            this.writeLinkElement(writer, name, name, pagerCommandId, hrefPostfix, true);
        }
        int n2 = skip = nexts.size() > 0 ? ((Integer)nexts.get(nexts.size() - 1)).intValue() : data.getPages();
        if (skip < data.getPages()) {
            skip += linkCount / 2;
            name = "...";
            if (++skip > data.getPages()) {
                skip = data.getPages();
                if ((Integer)nexts.get(nexts.size() - 1) == skip - 1) {
                    name = Integer.toString(skip);
                }
            }
            this.writeLinkElement(writer, name, Integer.toString(skip), pagerCommandId, hrefPostfix, true);
        }
    }

    private org.apache.myfaces.tobago.component.UICommand createPagingCommand(Application application, PageAction command, boolean disabled) {
        org.apache.myfaces.tobago.component.UICommand link = (org.apache.myfaces.tobago.component.UICommand)application.createComponent("org.apache.myfaces.tobago.Command");
        link.setRendererType("SheetPageCommand");
        link.setRendered(true);
        link.setId(command.getToken());
        link.getAttributes().put("inline", Boolean.TRUE);
        link.getAttributes().put("disabled", disabled);
        return link;
    }

    private void writeLinkElement(TobagoResponseWriter writer, String str, String skip, String id, String hrefPostfix, boolean makeLink) throws IOException {
        String type = makeLink ? "a" : "span";
        writer.startElement(type, null);
        writer.writeClassAttribute("tobago-sheet-paging-links-link");
        if (makeLink) {
            writer.writeIdAttribute(new StringBuffer().append(id).append("::").append("link_").append(skip).toString());
            writer.writeAttribute("href", (Object)new StringBuffer().append("javascript: tobagoSheetSetPagerPage('").append(id).append("', '").append(skip).append(hrefPostfix).toString(), null);
        }
        writer.flush();
        writer.write(str);
        writer.endElement(type);
    }

    public int getContentBorder(FacesContext facesContext, UIData data) {
        return this.getConfiguredValue(facesContext, (UIComponent)data, "contentBorder");
    }

    public void encodeAjax(FacesContext facesContext, UIComponent component) throws IOException {
        Class<?> clazz = class$org$apache$myfaces$tobago$component$UIData;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$component$UIData = new UIData[0].getClass().getComponentType();
        }
        AjaxUtils.checkParamValidity((FacesContext)facesContext, (UIComponent)component, (Class)clazz);
        boolean update = true;
        String ajaxId = (String)facesContext.getExternalContext().getRequestParameterMap().get("affectedAjaxComponent");
        if (ajaxId.equals(component.getClientId(facesContext)) && component.getFacet("reload") != null && component.getFacet("reload") instanceof UIReload && component.getFacet("reload").isRendered() && ajaxId.equals(ComponentUtil.findPage((FacesContext)facesContext, (UIComponent)component).getActionId()) && !((UIReload)component.getFacet("reload")).isImmediate()) {
            UIReload reload = (UIReload)component.getFacet("reload");
            update = reload.getUpdate();
        }
        if (update) {
            org.apache.myfaces.tobago.component.UICommand clickAction = null;
            org.apache.myfaces.tobago.component.UICommand dblClickAction = null;
            for (UIComponent child : component.getChildren()) {
                UIComponent selectionChild;
                UIColumnEvent columnEvent;
                if (!(child instanceof UIColumnEvent) || !(columnEvent = (UIColumnEvent)child).isRendered() || (selectionChild = (UIComponent)child.getChildren().get(0)) == null || !(selectionChild instanceof org.apache.myfaces.tobago.component.UICommand) || !selectionChild.isRendered()) continue;
                org.apache.myfaces.tobago.component.UICommand action = (org.apache.myfaces.tobago.component.UICommand)selectionChild;
                if ("click".equals(columnEvent.getEvent())) {
                    clickAction = action;
                }
                if (!"dblclick".equals(columnEvent.getEvent())) continue;
                dblClickAction = action;
            }
            this.renderSheet(facesContext, (UIData)component, clickAction != null || dblClickAction != null);
        } else {
            facesContext.getResponseWriter().write("<status code=\"304\"/>");
        }
    }

    public int getFixedHeight(FacesContext facesContext, UIComponent component) {
        if (component == null) {
            return 0;
        }
        UIData data = (UIData)component;
        int headerHeight = this.getHeaderHeight(facesContext, component);
        int footerHeight = this.getFooterHeight(facesContext, component);
        int rowHeight = this.getConfiguredValue(facesContext, component, "rowHeight");
        int rows = data.getRows();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)new StringBuffer().append(headerHeight).append(" ").append(footerHeight).append(" ").append(rowHeight).append(" ").append(rows).toString());
        }
        return headerHeight + rows * rowHeight + footerHeight + 2;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$renderkit$html$scarborough$standard$tag$SheetRenderer;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$renderkit$html$scarborough$standard$tag$SheetRenderer = new SheetRenderer[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
        HEIGHT_0 = _Integer.valueOf((int)0);
    }
}

