/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UIProgress;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.LayoutableRendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.StyleClasses;
import org.apache.myfaces.tobago.util.LayoutUtil;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class ProgressRenderer
extends LayoutableRendererBase {
    private static final Log LOG;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$renderkit$html$scarborough$standard$tag$ProgressRenderer;

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UIProgress component = (UIProgress)uiComponent;
        BoundedRangeModel model = (BoundedRangeModel)component.getValue();
        if (model == null) {
            LOG.warn((Object)"'null' value found! Using dummy Model instead!");
            model = new DefaultBoundedRangeModel(40, 1, 0, 100);
        }
        String image = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/1x1.gif");
        String value1 = Integer.toString(model.getValue());
        String value2 = Integer.toString(model.getMaximum() - model.getValue());
        int diff = model.getMaximum() - model.getMinimum();
        Object title = component.getAttributes().get("tip");
        if (title == null && diff > 0) {
            title = Integer.toString(100 * model.getValue() / diff) + " %";
        }
        Integer width = LayoutUtil.getLayoutWidth((UIComponent)component);
        String width1 = value1;
        String width2 = value2;
        if (width != null) {
            int value = diff > 0 ? (width - 1) * model.getValue() / diff : width;
            width1 = Integer.toString(value);
            width2 = Integer.toString(width - 2 - value);
        }
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startElement("span", (UIComponent)component);
        writer.writeClassAttribute();
        if (title != null) {
            writer.writeAttribute("title", String.valueOf(title), true);
        }
        writer.startElement("img", null);
        StyleClasses color1Classes = new StyleClasses();
        color1Classes.addClass("progress", "color1");
        color1Classes.addMarkupClass((SupportsMarkup)component, "progress", "color1");
        writer.writeClassAttribute(color1Classes);
        writer.writeAttribute("src", image, false);
        if (title != null) {
            writer.writeAttribute("alt", String.valueOf(title), true);
        }
        writer.writeAttribute("style", "width:" + width1 + "px", false);
        writer.writeAttribute("border", 0);
        writer.endElement("img");
        writer.startElement("img", null);
        StyleClasses color2Classes = new StyleClasses();
        color2Classes.addClass("progress", "color2");
        color2Classes.addMarkupClass((SupportsMarkup)component, "progress", "color2");
        writer.writeClassAttribute(color2Classes);
        writer.writeAttribute("src", image, false);
        if (title != null) {
            writer.writeAttribute("alt", String.valueOf(title), true);
        }
        writer.writeAttribute("style", "width:" + width2 + "px", false);
        writer.writeAttribute("border", 0);
        writer.endElement("img");
        writer.endElement("span");
        UIComponent facet = component.getFacet("complete");
        if (model.getValue() == model.getMaximum() && facet != null && facet instanceof UICommand) {
            UICommand command = (UICommand)facet;
            writer.writeJavascript("Tobago.submitAction2(this, '" + command.getClientId(facesContext) + "', null, null);");
        }
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$renderkit$html$scarborough$standard$tag$ProgressRenderer;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$renderkit$html$scarborough$standard$tag$ProgressRenderer = new ProgressRenderer[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }
}

