/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import net.sf.retrotranslator.runtime.java.lang._String;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIForm;
import org.apache.myfaces.tobago.component.UILayout;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.component.UIPopup;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.model.PageState;
import org.apache.myfaces.tobago.renderkit.PageRendererBase;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.util.AccessKeyMap;
import org.apache.myfaces.tobago.util.FastStringWriter;
import org.apache.myfaces.tobago.util.MimeTypeUtils;
import org.apache.myfaces.tobago.util.ResponseUtils;
import org.apache.myfaces.tobago.webapp.Secret;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageRenderer
extends PageRendererBase {
    private static final Log LOG;
    private static final String LOOSE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">";
    private static final String STRICT = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">";
    private static final String FRAMESET = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">";
    private static final String CLIENT_DEBUG_SEVERITY = "clientDebugSeverity";
    private static final String LAST_FOCUS_ID = "lastFocusId";
    static /* synthetic */ Class class$org$apache$myfaces$tobago$renderkit$html$scarborough$standard$tag$PageRenderer;

    public void decode(FacesContext facesContext, UIComponent component) {
        String lastFocusId;
        super.decode(facesContext, component);
        String clientId = component.getClientId(facesContext);
        ExternalContext externalContext = facesContext.getExternalContext();
        String severity = (String)externalContext.getRequestParameterMap().get(new StringBuffer().append(clientId).append("::").append("clientSeverity").toString());
        if (severity != null) {
            externalContext.getRequestMap().put(CLIENT_DEBUG_SEVERITY, severity);
        }
        if ((lastFocusId = (String)externalContext.getRequestParameterMap().get(new StringBuffer().append(clientId).append("::").append(LAST_FOCUS_ID).toString())) != null) {
            component.getAttributes().put(LAST_FOCUS_ID, lastFocusId);
        }
        this.updatePageState(facesContext, component);
    }

    public void updatePageState(FacesContext facesContext, UIComponent component) {
        if (component instanceof UIPage) {
            PageState state = ((UIPage)component).getPageState(facesContext);
            String value = null;
            try {
                String name = new StringBuffer().append(component.getClientId(facesContext)).append("::").append("form-clientDimension").toString();
                value = (String)facesContext.getExternalContext().getRequestParameterMap().get(name);
                if (value != null) {
                    StringTokenizer tokenizer = new StringTokenizer(value, ";");
                    int width = Integer.parseInt(tokenizer.nextToken());
                    int height = Integer.parseInt(tokenizer.nextToken());
                    if (state != null) {
                        state.setClientWidth(width);
                        state.setClientHeight(height);
                    }
                    facesContext.getExternalContext().getRequestMap().put("tobago-page-clientDimension-width", _Integer.valueOf((int)width));
                    facesContext.getExternalContext().getRequestMap().put("tobago-page-clientDimension-height", _Integer.valueOf((int)height));
                }
            }
            catch (Exception e) {
                LOG.error((Object)new StringBuffer().append("Error in decoding state: value='").append(value).append("'").toString(), (Throwable)e);
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        String lastFocusId;
        UIComponent command;
        Set styleBlocks;
        UIPage page = (UIPage)component;
        HtmlRendererUtil.prepareRender((FacesContext)facesContext, (UIComponent)page);
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        FastStringWriter content = new FastStringWriter(10240);
        ResponseWriter contentWriter = writer.cloneWithWriter((Writer)content);
        facesContext.setResponseWriter(contentWriter);
        UIComponent menubar = page.getFacet("menuBar");
        if (menubar != null) {
            menubar.getAttributes().put("pageMenu", Boolean.TRUE);
            page.getOnloadScripts().add(new StringBuffer().append("Tobago.setElementWidth('").append(menubar.getClientId(facesContext)).append("', Tobago.getBrowserInnerWidth())").toString());
            RenderUtil.encode((FacesContext)facesContext, (UIComponent)menubar);
        }
        UILayout.getLayout((UIComponent)component).encodeChildrenOfComponent(facesContext, component);
        FastStringWriter popups = new FastStringWriter();
        contentWriter = writer.cloneWithWriter((Writer)popups);
        facesContext.setResponseWriter(contentWriter);
        UIPopup[] popupArray = page.getPopups().toArray(new UIPopup[page.getPopups().size()]);
        for (int i = 0; i < popupArray.length; ++i) {
            UIPopup popup = popupArray[i];
            RenderUtil.encode((FacesContext)facesContext, (UIComponent)popup);
        }
        facesContext.setResponseWriter((ResponseWriter)writer);
        ResponseUtils.ensureNoCacheHeader((ExternalContext)facesContext.getExternalContext());
        if (LOG.isDebugEnabled()) {
            Iterator i$ = page.getAttributes().entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = i$.next();
                LOG.debug((Object)new StringBuffer().append("*** '").append(entry.getKey()).append("' -> '").append(entry.getValue()).append("'").toString());
            }
        }
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        String viewId = facesContext.getViewRoot().getViewId();
        String formAction = viewHandler.getActionURL(facesContext, viewId);
        formAction = facesContext.getExternalContext().encodeActionURL(formAction);
        String contentType = writer.getContentTypeWithCharSet();
        ResponseUtils.ensureContentTypeHeader((FacesContext)facesContext, (String)contentType);
        String title = (String)page.getAttributes().get("label");
        String doctype = this.generateDoctype(page);
        if (doctype != null) {
            writer.write(doctype);
            writer.write("\n");
        }
        writer.startElement("html", null);
        writer.startElement("head", null);
        boolean debugMode = ClientProperties.getInstance((UIViewRoot)facesContext.getViewRoot()).isDebugMode();
        writer.writeJavascript("var TbgHeadStart = new Date();");
        writer.startElement("meta", null);
        writer.writeAttribute("http-equiv", "Content-Type", false);
        writer.writeAttribute("content", contentType, false);
        writer.endElement("meta");
        writer.startElement("title", null);
        writer.writeText(title != null ? title : "");
        writer.endElement("title");
        for (String styleFile : page.getStyleFiles()) {
            List styles = ResourceManagerUtil.getStyles((FacesContext)facesContext, (String)styleFile);
            for (String styleString : styles) {
                if (styleString.length() <= 0) continue;
                writer.startElement("link", null);
                writer.writeAttribute("rel", "stylesheet", false);
                writer.writeAttribute("href", styleString, false);
                writer.writeAttribute("type", "text/css", false);
                writer.endElement("link");
            }
        }
        String icon = page.getApplicationIcon();
        if (icon != null) {
            if (!ResourceManagerUtil.isAbsoluteResource((String)icon)) {
                icon = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)icon);
            }
            writer.startElement("link", null);
            if (icon.endsWith(".ico")) {
                writer.writeAttribute("rel", "shortcut icon", false);
                writer.writeAttribute("href", icon, false);
            } else {
                writer.writeAttribute("rel", "icon", false);
                writer.writeAttribute("type", MimeTypeUtils.getMimeTypeForFile((String)icon), false);
                writer.writeAttribute("href", icon, false);
            }
            writer.endElement("link");
        }
        if ((styleBlocks = page.getStyleBlocks()).size() > 0) {
            writer.startElement("style", null);
            for (String cssBlock : styleBlocks) {
                writer.write(cssBlock);
            }
            writer.endElement("style");
        }
        List scriptFiles = page.getScriptFiles();
        this.addScripts(writer, facesContext, "script/prototype.js");
        this.addScripts(writer, facesContext, "script/tobago.js");
        this.addScripts(writer, facesContext, "script/theme-config.js");
        scriptFiles.remove("script/prototype.js");
        scriptFiles.remove("script/tobago.js");
        scriptFiles.remove("script/theme-config.js");
        int clientLogSeverity = 2;
        boolean hideClientLogging = true;
        if (debugMode) {
            String severity = (String)facesContext.getExternalContext().getRequestMap().get(CLIENT_DEBUG_SEVERITY);
            LOG.info((Object)new StringBuffer().append("get clientDebugSeverity = ").append(severity).toString());
            if (severity != null) {
                try {
                    int index = severity.indexOf(59);
                    if (index == -1) {
                        index = severity.length();
                    }
                    clientLogSeverity = Integer.parseInt(severity.substring(0, index));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                hideClientLogging = !_String.contains((String)severity, (CharSequence)"show");
            }
            scriptFiles.add("script/effects.js");
            scriptFiles.add("script/dragdrop.js");
            scriptFiles.add("script/logging.js");
        }
        for (String scriptFile : scriptFiles) {
            this.addScripts(writer, facesContext, scriptFile);
        }
        String focusId = page.getFocusId();
        if (focusId != null) {
            writer.writeJavascript(new StringBuffer().append("Tobago.focusId = '").append(focusId).append("';").toString());
        }
        if (component.getFacets().containsKey("action") && (command = component.getFacet("action")) != null && command.isRendered()) {
            int duration = ComponentUtil.getIntAttribute((UIComponent)command, (String)"delay", (int)100);
            boolean transition = ComponentUtil.getBooleanAttribute((UIComponent)command, (String)"transition");
            String target = ComponentUtil.getStringAttribute((UIComponent)command, (String)"target");
            String action = target != null ? new StringBuffer().append("Tobago.submitAction2(this, '").append(command.getClientId(facesContext)).append("', ").append(transition).append(", '").append(target).append("')").toString() : new StringBuffer().append("Tobago.submitAction2(this, '").append(command.getClientId(facesContext)).append("', ").append(transition).append(", null)").toString();
            page.getOnloadScripts().add(new StringBuffer().append("setTimeout(\"").append(action).append("\", ").append(duration).append(");\n").toString());
        }
        if (component.getFacets().containsKey("resizeAction")) {
            UIComponent facet = component.getFacet("resizeAction");
            UIComponent command2 = null;
            if (facet instanceof UICommand) {
                command2 = facet;
            } else if (facet instanceof UIForm && facet.getChildCount() == 1) {
                command2 = (UIComponent)facet.getChildren().get(0);
            }
            if (command2 != null && command2.isRendered()) {
                writer.writeJavascript(new StringBuffer().append("Tobago.resizeActionId = '").append(command2.getClientId(facesContext)).append("';").toString());
            }
        }
        StringBuffer script = new StringBuffer(128);
        this.writeEventFunction(script, page.getOnloadScripts(), "load", false);
        this.writeEventFunction(script, page.getOnunloadScripts(), "unload", false);
        this.writeEventFunction(script, page.getOnexitScripts(), "exit", false);
        this.writeEventFunction(script, page.getOnsubmitScripts(), "submit", true);
        int debugCounter = 0;
        for (String scriptBlock : page.getScriptBlocks()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)new StringBuffer().append("write scriptblock ").append(++debugCounter).append(" :\n").append(scriptBlock).toString());
            }
            script.append(scriptBlock);
            script.append('\n');
        }
        writer.writeJavascript(script.toString());
        String clientId = page.getClientId(facesContext);
        String defaultActionId = page.getDefaultActionId() != null ? page.getDefaultActionId() : "";
        writer.endElement("head");
        writer.startElement("body", (UIComponent)page);
        writer.writeAttribute("onload", new StringBuffer().append("Tobago.init('").append(clientId).append("');").toString(), false);
        writer.writeAttribute("scroll", "auto", false);
        writer.writeClassAttribute();
        writer.writeIdAttribute(clientId);
        StringBuffer images = new StringBuffer(256);
        images.append("Tobago.pngFixBlankImage = '");
        images.append(ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/blank.gif"));
        images.append("';\n");
        images.append("Tobago.OVERLAY_BACKGROUND = '");
        images.append(ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/tobago-overlay-background.png"));
        images.append("';\n");
        images.append("Tobago.OVERLAY_WAIT = '");
        images.append(ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/tobago-overlay-wait.gif"));
        images.append("';\n");
        writer.writeJavascript(images.toString());
        if (debugMode) {
            String[] jsFiles = new String[]{"script/effects.js", "script/dragdrop.js", "script/logging.js"};
            String[] jsCommand = new String[]{new StringBuffer().append("new LOG.LogArea({hide: ").append(hideClientLogging).append("});").toString()};
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, (String[])jsFiles, (String[])jsCommand);
        }
        writer.writeJavascript("TbgTimer.startBody = new Date();");
        writer.startElement("form", (UIComponent)page);
        writer.writeNameAttribute(new StringBuffer().append(clientId).append("::").append("form").toString());
        writer.writeAttribute("action", formAction, true);
        writer.writeIdAttribute(page.getFormId(facesContext));
        writer.writeAttribute("method", this.getMethod(page), false);
        String enctype = (String)facesContext.getExternalContext().getRequestMap().get(UIPage.ENCTYPE_KEY);
        if (enctype != null) {
            writer.writeAttribute("enctype", enctype, false);
        } else {
            writer.writeAttributeFromComponent("enctype", "enctype");
        }
        writer.writeAttribute("accept-charset", "utf-8", false);
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(new StringBuffer().append(clientId).append("::").append("form-action").toString());
        writer.writeIdAttribute(new StringBuffer().append(clientId).append("::").append("form-action").toString());
        writer.writeAttribute("value", defaultActionId, true);
        writer.endElement("input");
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(new StringBuffer().append(clientId).append("::").append("context-path").toString());
        writer.writeIdAttribute(new StringBuffer().append(clientId).append("::").append("context-path").toString());
        writer.writeAttribute("value", facesContext.getExternalContext().getRequestContextPath(), true);
        writer.endElement("input");
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(new StringBuffer().append(clientId).append("::").append("action-position").toString());
        writer.writeIdAttribute(new StringBuffer().append(clientId).append("::").append("action-position").toString());
        writer.endElement("input");
        if (TobagoConfig.getInstance((FacesContext)FacesContext.getCurrentInstance()).isCheckSessionSecret()) {
            Secret.encode((FacesContext)facesContext, (TobagoResponseWriter)writer);
        }
        if (debugMode) {
            writer.startElement("input", null);
            writer.writeAttribute("value", clientLogSeverity);
            writer.writeAttribute("id", new StringBuffer().append(clientId).append("::").append("clientSeverity").toString(), false);
            writer.writeAttribute("name", new StringBuffer().append(clientId).append("::").append("clientSeverity").toString(), false);
            writer.writeAttribute("type", "hidden", false);
            writer.endElement("input");
        }
        if (component.getFacet("backButtonDetector") != null) {
            UIComponent hidden = component.getFacet("backButtonDetector");
            RenderUtil.encode((FacesContext)facesContext, (UIComponent)hidden);
        }
        if ((lastFocusId = (String)component.getAttributes().get(LAST_FOCUS_ID)) != null) {
            writer.writeJavascript(new StringBuffer().append("Tobago.lastFocusId = '").append(lastFocusId).append("';").toString());
            component.getAttributes().remove(LAST_FOCUS_ID);
        }
        writer.write(content.toString());
        writer.write(popups.toString());
        writer.startElement("span", null);
        writer.writeIdAttribute(new StringBuffer().append(clientId).append("::").append("jsf-state-container").toString());
        writer.flush();
        FastStringWriter buffer = new FastStringWriter(40);
        TobagoResponseWriter originalWriter = (TobagoResponseWriter)facesContext.getResponseWriter();
        writer = (TobagoResponseWriter)writer.cloneWithWriter((Writer)buffer);
        facesContext.setResponseWriter((ResponseWriter)writer);
        viewHandler.writeState(facesContext);
        String stateContent = buffer.toString();
        writer = originalWriter;
        facesContext.setResponseWriter((ResponseWriter)writer);
        if (StringUtils.isBlank((String)stateContent)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Writing state will not happen! So we write the hidden field manually.");
            }
            writer.startElement("input", null);
            writer.writeAttribute("type", "hidden", false);
            writer.writeAttribute("name", "jsf_tree", false);
            writer.writeAttribute("id", "jsf_tree", false);
            writer.writeAttribute("value", "workaround", false);
            writer.endElement("input");
        } else {
            writer.write(stateContent);
        }
        writer.endElement("span");
        if (ClientProperties.getInstance((UIViewRoot)facesContext.getViewRoot()).getUserAgent().isMsie()) {
            writer.startElement("input", null);
            writer.writeAttribute("type", "text", false);
            writer.writeAttribute("name", "tobago.dummy", false);
            writer.writeAttribute("tabindex", "-1", false);
            writer.writeAttribute("style", "visibility:hidden;display:none;", false);
            writer.endElement("input");
        }
        writer.endElement("form");
        if (debugMode) {
            ArrayList<String> logMessages = new ArrayList<String>();
            Iterator ids = facesContext.getClientIdsWithMessages();
            while (ids.hasNext()) {
                String id = (String)ids.next();
                Iterator messages = facesContext.getMessages(id);
                while (messages.hasNext()) {
                    FacesMessage message = (FacesMessage)messages.next();
                    logMessages.add(this.errorMessageForDebugging(id, message));
                }
            }
            if (!logMessages.isEmpty()) {
                logMessages.add(0, "LOG.show();");
            }
            logMessages.add(new StringBuffer().append("LOG.info(\"FacesContext = ").append(facesContext).append("\");").toString());
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, null, (String[])logMessages.toArray(new String[logMessages.size()]));
        }
        writer.writeJavascript("TbgTimer.endBody = new Date();");
        writer.writeJavascript(new StringBuffer().append("setTimeout(\"Tobago.init('").append(clientId).append("')\", 1000)").toString());
        writer.startElement("noscript", null);
        writer.startElement("div", null);
        writer.writeClassAttribute("tobago-page-noscript");
        writer.writeText(ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"pageNoscript"));
        writer.endElement("div");
        writer.endElement("noscript");
        writer.endElement("body");
        writer.endElement("html");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)new StringBuffer().append("unused AccessKeys    : ").append(AccessKeyMap.getUnusedKeys((FacesContext)facesContext)).toString());
            LOG.debug((Object)new StringBuffer().append("dublicated AccessKeys: ").append(AccessKeyMap.getDublicatedKeys((FacesContext)facesContext)).toString());
        }
    }

    private void writeEventFunction(StringBuffer script, Set<String> eventFunctions, String event, boolean returnBoolean) throws IOException {
        if (!eventFunctions.isEmpty()) {
            script.append("Tobago.applicationOn");
            script.append(event);
            script.append(" = function(on").append(event).append("Args) {\n");
            if (returnBoolean) {
                script.append("  var result;\n");
            }
            for (String function : eventFunctions) {
                if (returnBoolean) {
                    script.append("  result = ");
                } else {
                    script.append("  ");
                }
                script.append(function);
                if (!function.trim().endsWith(";")) {
                    script.append(";\n");
                } else {
                    script.append("\n");
                }
                if (!returnBoolean) continue;
                script.append("  if (typeof result == \"boolean\" && ! result) {\n");
                script.append("    return false;\n");
                script.append("  }\n");
            }
            script.append("\n  return true;\n}\n");
        }
    }

    private void addScripts(TobagoResponseWriter writer, FacesContext facesContext, String script) throws IOException {
        List<String> scripts;
        if (ResourceManagerUtil.isAbsoluteResource((String)script)) {
            scripts = new ArrayList();
            scripts.add(script);
        } else {
            scripts = ResourceManagerUtil.getScripts((FacesContext)facesContext, (String)script);
        }
        for (String scriptString : scripts) {
            if (scriptString.length() <= 0) continue;
            writer.startElement("script", null);
            writer.writeAttribute("src", scriptString, true);
            writer.writeAttribute("type", "text/javascript", false);
            writer.endElement("script");
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    private void errorMessageForDebugging(String id, FacesMessage message, ResponseWriter writer) throws IOException {
        writer.startElement("div", null);
        writer.writeAttribute("style", (Object)"color: red", null);
        writer.write("[");
        writer.write(id != null ? id : "null");
        writer.write("]");
        writer.write("[");
        writer.write(message.getSummary() == null ? "null" : message.getSummary());
        writer.write("/");
        writer.write(message.getDetail() == null ? "null" : message.getDetail());
        writer.write("]");
        writer.endElement("div");
        writer.startElement("br", null);
        writer.endElement("br");
    }

    private String errorMessageForDebugging(String id, FacesMessage message) {
        StringBuffer sb = new StringBuffer("LOG.info(\"FacesMessage: [");
        sb.append(id != null ? id : "null");
        sb.append("][");
        sb.append(message.getSummary() == null ? "null" : this.escape(message.getSummary()));
        sb.append("/");
        sb.append(message.getDetail() == null ? "null" : this.escape(message.getDetail()));
        sb.append("]\");");
        return sb.toString();
    }

    private String escape(String s) {
        return StringUtils.replace((String)StringUtils.replace((String)s, (String)"\\", (String)"\\\\"), (String)"\"", (String)"\\\"");
    }

    private String getMethod(UIPage page) {
        String method = (String)page.getAttributes().get("method");
        return method == null ? "post" : method;
    }

    protected String generateDoctype(UIPage page) {
        String doctype = (String)page.getAttributes().get("doctype");
        String type = null;
        if (doctype == null || "loose".equals(doctype)) {
            type = LOOSE;
        } else if ("strict".equals(doctype)) {
            type = STRICT;
        } else if ("frameset".equals(doctype)) {
            type = FRAMESET;
        } else {
            LOG.warn((Object)new StringBuffer().append("Unsupported DOCTYPE keyword :'").append(doctype).append("'").toString());
        }
        return type;
    }

    public boolean getRendersChildren() {
        return true;
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$renderkit$html$scarborough$standard$tag$PageRenderer;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$renderkit$html$scarborough$standard$tag$PageRenderer = new PageRenderer[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }
}

