/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UICell;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UIMessages;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.component.UIPopup;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.MessageRendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.StyleClasses;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class MessagesRenderer
extends MessageRendererBase {
    private static final Log LOG;
    public static final String CLOSE_POPUP = "closePopup";
    static /* synthetic */ Class class$org$apache$myfaces$tobago$renderkit$html$scarborough$standard$tag$MessagesRenderer;

    public int getFixedHeight(FacesContext facesContext, UIComponent component) {
        UIMessages messages = (UIMessages)component;
        int count = messages.getMessageListCount(facesContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("component = '" + component + "'"));
            LOG.debug((Object)("here are " + count + " messages"));
        }
        return count > 0 ? count * this.getConfiguredValue(facesContext, component, "messageHeight") : this.getConfiguredValue(facesContext, component, "fixedHeight");
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UIMessages messages = (UIMessages)component;
        if (messages.isConfirmation()) {
            this.createPopup(facesContext, messages);
            return;
        }
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("facesContext is " + facesContext.getClass().getName()));
        }
        if (facesContext.getMessages().hasNext()) {
            writer.startElement("span", (UIComponent)messages);
            writer.writeClassAttribute("tobago-validation-message");
            writer.writeStyleAttribute();
            Iterator i$ = messages.createMessageList(facesContext).iterator();
            while (i$.hasNext()) {
                UIMessages.Item item = (UIMessages.Item)i$.next();
                this.encodeMessage(writer, messages, item.getFacesMessage(), item.getClientId());
            }
            writer.endElement("span");
        }
    }

    private void createPopup(FacesContext facesContext, UIMessages messages) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"POPUP");
        }
        String id = messages.getId() != null ? messages.getId() + "popup" : facesContext.getViewRoot().createUniqueId();
        UIPopup popup = (UIPopup)ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Popup", (String)"Popup", (String)id);
        UIPage page = ComponentUtil.findPage((FacesContext)facesContext, (UIComponent)messages);
        popup.setWidth(page.getWidth() - 200 + "px");
        popup.setHeight(page.getHeight() - 200 + "px");
        popup.setLeft("100px");
        popup.setTop("100px");
        popup.setRendered(true);
        popup.setActivated(true);
        page.getPopups().add(popup);
        Map okButtonAttributes = popup.getAttributes();
        okButtonAttributes.put("popupReset", Boolean.TRUE);
        UIComponent box = ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Box", (String)"Box");
        popup.getChildren().add(box);
        box.setId("box");
        box.getAttributes().put("label", ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"tobago.message.confirmation.title"));
        UIComponent layout = ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.GridLayout", (String)"GridLayout", (String)"layout");
        box.getFacets().put("layout", layout);
        layout.getAttributes().put("rows", "*;fixed");
        layout.getAttributes().put("margin", "10");
        UICell scrollPanel = (UICell)ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Cell", (String)"Cell", (String)"messagePanel");
        box.getChildren().add(scrollPanel);
        messages.getParent().getChildren().remove(messages);
        messages.setConfirmation(false);
        scrollPanel.setScrollbars("auto");
        scrollPanel.getChildren().add(messages);
        UIComponent buttonPanel = ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Panel", (String)"Panel", (String)"buttonPanel");
        layout = ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.GridLayout", (String)"GridLayout", (String)"buttonPanelLayout");
        buttonPanel.getFacets().put("layout", layout);
        layout.getAttributes().put("columns", "*;100px");
        layout.getAttributes().put("rows", "fixed");
        box.getChildren().add(buttonPanel);
        UICell space = (UICell)ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Cell", (String)"Cell", (String)"space");
        buttonPanel.getChildren().add(space);
        UICommand okButton = (UICommand)ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.ButtonCommand", (String)"Button", (String)CLOSE_POPUP);
        buttonPanel.getChildren().add(okButton);
        okButtonAttributes = okButton.getAttributes();
        okButtonAttributes.put("label", ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"tobago.message.confirmation.okay"));
        okButtonAttributes.put("popupClose", "immediate");
    }

    private void encodeMessage(TobagoResponseWriter writer, UIMessages messages, FacesMessage message, String clientId) throws IOException {
        String summary = message.getSummary();
        String detail = message.getDetail();
        writer.startElement("label", null);
        if (clientId != null) {
            writer.writeAttribute("for", clientId, false);
        }
        writer.writeAttribute("title", detail, true);
        StyleClasses classes = new StyleClasses();
        classes.addMarkupClass("messages", message.getSeverity().toString().toLowerCase());
        writer.writeClassAttribute(classes);
        boolean writeEmptyText = true;
        if (summary != null && messages.isShowSummary()) {
            writer.writeText(summary);
            writeEmptyText = false;
            if (detail != null && messages.isShowDetail()) {
                writer.writeText(" ");
            }
        }
        if (detail != null && messages.isShowDetail()) {
            writeEmptyText = false;
            writer.writeText(detail);
        }
        if (writeEmptyText) {
            writer.writeText("");
        }
        writer.endElement("label");
        writer.startElement("br", null);
        writer.endElement("br");
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$renderkit$html$scarborough$standard$tag$MessagesRenderer;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$renderkit$html$scarborough$standard$tag$MessagesRenderer = new MessagesRenderer[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }
}

