/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIPanel;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIMenu;
import org.apache.myfaces.tobago.component.UIMenuCommand;
import org.apache.myfaces.tobago.component.UIMenuSeparator;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.component.UISelectBooleanCommand;
import org.apache.myfaces.tobago.component.UISelectOneCommand;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.LayoutableRendererBase;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.html.CommandRendererHelper;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.StyleClasses;
import org.apache.myfaces.tobago.util.AccessKeyMap;
import org.apache.myfaces.tobago.util.FastStringWriter;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuBarRenderer
extends LayoutableRendererBase {
    private static final Log LOG;
    public static final String SEARCH_ID_POSTFIX = "::popup";
    static /* synthetic */ Class class$org$apache$myfaces$tobago$renderkit$html$scarborough$standard$tag$MenuBarRenderer;

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        String clientId;
        if (ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"menuPopup")) {
            clientId = component.getParent().getClientId(facesContext);
        } else {
            clientId = component.getClientId(facesContext);
            TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
            writer.startElement("div", component);
            writer.writeIdAttribute(clientId);
            StyleClasses styleClasses = StyleClasses.ensureStyleClasses((UIComponent)component);
            if (ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"pageMenu")) {
                styleClasses.addClass("menuBar", "page-facet");
            } else {
                writer.writeStyleAttribute();
            }
            writer.writeClassAttribute(styleClasses);
            writer.endElement("div");
        }
        ArrayList<String> accKeyFunctions = new ArrayList<String>();
        StringBuffer scriptBuffer = new StringBuffer();
        String setupFunction = this.createSetupFunction(facesContext, component, clientId, accKeyFunctions, scriptBuffer);
        this.addScriptsAndStyles(facesContext, component, clientId, setupFunction, scriptBuffer.toString());
        if (!accKeyFunctions.isEmpty()) {
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, null, (String[])accKeyFunctions.toArray(new String[accKeyFunctions.size()]));
        }
    }

    private void renderTopLevelItems(FacesContext facesContext, TobagoResponseWriter writer, List<String> accKeyFunctions, UIComponent component) throws IOException {
        String bac = "green;";
        for (Object o : component.getChildren()) {
            if (!(o instanceof UIMenu)) continue;
            writer.startElement("span", null);
            writer.writeAttribute("style", new StringBuffer().append("position: relative; background: ").append(bac).append(";").toString(), false);
            this.writeMenuEntry(facesContext, writer, accKeyFunctions, (UIPanel)((UIMenu)o));
            writer.endElement("span");
            bac = "lime";
        }
    }

    protected void addScriptsAndStyles(FacesContext facesContext, UIComponent component, String clientId, String setupFunction, String scriptBlock) throws IOException {
        UIPage page = ComponentUtil.findPage((FacesContext)facesContext, (UIComponent)component);
        page.getScriptFiles().add("script/tobago-menu.js");
        page.getStyleFiles().add("style/tobago-menu.css");
        String function = new StringBuffer().append(setupFunction).append("('").append(clientId).append("', '").append(page.getClientId(facesContext)).append("');").toString();
        if (TobagoConfig.getInstance((FacesContext)facesContext).isAjaxEnabled()) {
            HtmlRendererUtil.writeStyleLoader((FacesContext)facesContext, (String[])new String[]{"style/tobago-menu.css"});
            StringTokenizer st = new StringTokenizer(scriptBlock, "\n");
            ArrayList<String> lines = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                lines.add(st.nextToken());
            }
            lines.add(function);
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, (String[])new String[]{"script/tobago-menu.js"}, (String[])lines.toArray(new String[lines.size()]));
        } else {
            page.getScriptBlocks().add(scriptBlock);
            page.getOnloadScripts().add(function);
        }
    }

    protected String createSetupFunction(FacesContext facesContext, UIComponent component, String clientId, List<String> accKeyFunctions, StringBuffer sb) throws IOException {
        String setupFunction = new StringBuffer().append("setupMenu").append(StringUtils.replaceChars((String)clientId, (String)":.-", (String)"___")).toString();
        sb.append("function ");
        sb.append(setupFunction);
        sb.append("(id, pageId) {\n");
        sb.append("  var menuStart = new Date();\n");
        sb.append("  var searchId = id + '::popup';\n");
        sb.append("  var menubar = document.getElementById(searchId);\n");
        sb.append("  if (! menubar) {\n");
        sb.append("    searchId  = id;\n");
        sb.append("    menubar = document.getElementById(searchId);\n");
        sb.append("  }\n");
        sb.append("  if (menubar) {\n");
        sb.append("    var menu = createMenuRoot(searchId);\n");
        sb.append("    menubar.menu = menu;\n");
        sb.append("    menu.setSubitemArrowImage(\"");
        sb.append(ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/MenuArrow.gif"));
        sb.append("\");\n");
        if (ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"menuPopup")) {
            this.addMenu(sb, "menu", facesContext, accKeyFunctions, (UIPanel)component, 0);
            sb.append("    initMenuPopUp(searchId, pageId, \"");
            sb.append(component.getAttributes().get("menuPopupType"));
            sb.append("\");\n");
        } else {
            this.addMenuEntrys(sb, "menu", facesContext, accKeyFunctions, component, true);
            sb.append("    initMenuBar(searchId, pageId);\n");
        }
        sb.append("  }\n");
        sb.append("  else {\n");
        sb.append("    LOG.debug('kein Element mit id: ' + searchId + ' gefunden!');\n");
        sb.append("  }\n");
        sb.append("  LOG.debug('Menu Total Time : ' + (new Date().getTime() - menuStart.getTime()));\n");
        sb.append("}\n");
        return setupFunction;
    }

    private int addMenu(StringBuffer sb, String var, FacesContext facesContext, List<String> accKeyFunctions, UIPanel menu, int i) throws IOException {
        if (!menu.isRendered()) {
            return i;
        }
        String name = new StringBuffer().append(var).append("_").append(i++).toString();
        sb.append("    var ").append(name).append(" = ").append(this.createMenuEntry(facesContext, accKeyFunctions, menu)).append(";\n");
        sb.append("    ").append(var).append(".addMenuItem(").append(name).append(");\n");
        this.addMenuEntrys(sb, name, facesContext, accKeyFunctions, (UIComponent)menu, false);
        return i;
    }

    private String createMenuEntry(FacesContext facesContext, List<String> accKeyFunctions, UIPanel uiPanel) throws IOException {
        ResponseWriter savedWriter = facesContext.getResponseWriter();
        FastStringWriter stringWriter = new FastStringWriter();
        ResponseWriter newWriter = savedWriter.cloneWithWriter((Writer)stringWriter);
        facesContext.setResponseWriter(newWriter);
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        this.writeMenuEntry(facesContext, writer, accKeyFunctions, uiPanel);
        facesContext.setResponseWriter(savedWriter);
        return new StringBuffer().append("new Tobago.Menu.Item('").append(this.prepareForScript(stringWriter.toString())).append("', null)").toString();
    }

    private void writeMenuEntry(FacesContext facesContext, TobagoResponseWriter writer, List<String> accKeyFunctions, UIPanel uiPanel) throws IOException {
        boolean disabled = ComponentUtil.getBooleanAttribute((UIComponent)uiPanel, (String)"disabled");
        boolean topMenu = uiPanel.getParent().getRendererType() != null || ComponentUtil.getBooleanAttribute((UIComponent)uiPanel, (String)"menuPopup");
        boolean pageMenu = uiPanel.getParent().getRendererType() != null && ComponentUtil.getBooleanAttribute((UIComponent)uiPanel.getParent(), (String)"pageMenu");
        String spanClass = new StringBuffer().append("tobago-menuBar-item-span tobago-menuBar-item-span-").append(disabled ? "disabled" : "enabled").append(topMenu ? " tobago-menuBar-item-span-top" : "").append(pageMenu ? " tobago-menuBar-item-page-top" : "").toString();
        LabelWithAccessKey label = new LabelWithAccessKey((UIComponent)uiPanel);
        String image = (String)uiPanel.getAttributes().get("image");
        this.addImage(writer, facesContext, image, disabled);
        writer.startElement("a", null);
        writer.writeClassAttribute(spanClass);
        writer.writeAttribute("href", "#", false);
        writer.writeAttribute("onfocus", "tobagoMenuFocus(event)", false);
        writer.writeAttribute("onblur", "tobagoMenuBlur(event)", false);
        writer.writeAttribute("onkeydown", "tobagoMenuKeyDown(event)", false);
        writer.writeAttribute("onkeypress", "tobagoMenuKeyPress(event)", false);
        writer.writeIdAttribute(uiPanel.getClientId(facesContext));
        if (label.getText() != null) {
            if (label.getAccessKey() != null) {
                if (LOG.isInfoEnabled() && !AccessKeyMap.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey())) {
                    LOG.info((Object)new StringBuffer().append("dublicated accessKey : ").append(label.getAccessKey()).toString());
                }
                if (!disabled) {
                    this.addAcceleratorKey(facesContext, accKeyFunctions, (UIComponent)uiPanel, label.getAccessKey());
                }
            }
            HtmlRendererUtil.writeLabelWithAccessKey((TobagoResponseWriter)writer, (LabelWithAccessKey)label);
        }
        writer.endElement("a");
    }

    private void addAcceleratorKey(FacesContext facesContext, List<String> accKeyFunctions, UIComponent component, Character accessKey) {
        String clientId = component.getClientId(facesContext);
        String jsStatement = HtmlRendererUtil.createOnclickAcceleratorKeyJsStatement((String)clientId, (char)accessKey.charValue(), null);
        accKeyFunctions.add(jsStatement);
    }

    private void addImage(TobagoResponseWriter writer, FacesContext facesContext, String image, boolean disabled) throws IOException {
        if (image != null) {
            String disabledImage = null;
            if (disabled) {
                disabledImage = ResourceManagerUtil.getDisabledImageWithPath((FacesContext)facesContext, (String)image);
            }
            image = disabledImage != null ? disabledImage : ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)image);
        } else {
            image = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/blank.gif");
        }
        writer.startElement("img", null);
        writer.writeClassAttribute("tobago-menu-item-image");
        writer.writeAttribute("src", image, false);
        writer.endElement("img");
    }

    private int addMenuEntrys(StringBuffer sb, String var, FacesContext facesContext, List<String> accKeyFunctions, UIComponent component, boolean warn) throws IOException {
        return this.addMenuEntrys(sb, var, facesContext, accKeyFunctions, component, warn, 0);
    }

    private int addMenuEntrys(StringBuffer sb, String var, FacesContext facesContext, List<String> accKeyFunctions, UIComponent component, boolean warn, int index) throws IOException {
        for (Object o : component.getChildren()) {
            UIComponent entry = (UIComponent)o;
            if (!entry.isRendered()) continue;
            if (entry instanceof UICommand) {
                this.addMenuEntry(sb, var, facesContext, accKeyFunctions, (UICommand)entry);
                continue;
            }
            if (entry instanceof UIMenuSeparator) {
                this.addMenuSeparator(sb, var);
                continue;
            }
            if (entry instanceof UIMenu) {
                index = this.addMenu(sb, var, facesContext, accKeyFunctions, (UIPanel)entry, index);
                continue;
            }
            if (entry instanceof UIForm) {
                index = this.addMenuEntrys(sb, var, facesContext, accKeyFunctions, entry, warn, index);
                continue;
            }
            if (!warn) continue;
            LOG.error((Object)new StringBuffer().append("Illegal UIComponent class in menuBar: ").append(entry.getClass().getName()).toString());
        }
        return index;
    }

    private void addMenuEntry(StringBuffer sb, String var, FacesContext facesContext, List<String> accKeyFunctions, UICommand command) throws IOException {
        CommandRendererHelper helper = new CommandRendererHelper(facesContext, command);
        String onclick = helper.getOnclick();
        if (command instanceof UIMenuCommand) {
            if (command.getFacet("items") != null) {
                UIComponent facet = command.getFacet("items");
                if (facet instanceof UISelectOne) {
                    this.addSelectOne(sb, var, facesContext, accKeyFunctions, command, onclick);
                } else if (facet instanceof UISelectBoolean) {
                    this.addSelectBoolean(sb, var, facesContext, accKeyFunctions, command, onclick);
                }
            } else {
                this.addCommand(sb, var, facesContext, accKeyFunctions, command, onclick);
            }
        } else if (command instanceof UISelectBooleanCommand) {
            this.addSelectBoolean(sb, var, facesContext, accKeyFunctions, command, onclick);
        } else if (command instanceof UISelectOneCommand) {
            this.addSelectOne(sb, var, facesContext, accKeyFunctions, command, onclick);
        }
    }

    private void addCommand(StringBuffer sb, String var, FacesContext facesContext, List<String> accKeyFunctions, UICommand command, String onClick) throws IOException {
        String image = (String)command.getAttributes().get("image");
        this.addMenuItem(sb, var, facesContext, accKeyFunctions, command, image, onClick);
    }

    private void addSelectBoolean(StringBuffer sb, String var, FacesContext facesContext, List<String> accKeyFunctions, UICommand command, String onClick) throws IOException {
        UIComponent checkbox = command.getFacet("items");
        if (checkbox == null) {
            checkbox = ComponentUtil.createUISelectBooleanFacet((FacesContext)facesContext, (UICommand)command);
            checkbox.setId(facesContext.getViewRoot().createUniqueId());
        }
        boolean checked = ComponentUtil.getBooleanAttribute((UIComponent)checkbox, (String)"value");
        String clientId = checkbox.getClientId(facesContext);
        onClick = RenderUtil.addMenuCheckToggle((String)clientId, (String)onClick);
        if (checked) {
            sb.append("    menuCheckToggle('").append(clientId).append("');\n");
        }
        String image = checked ? "image/MenuCheckmark.gif" : null;
        this.addMenuItem(sb, var, facesContext, accKeyFunctions, command, image, onClick);
    }

    private void addMenuItem(StringBuffer sb, String var, FacesContext facesContext, List<String> accKeyFunctions, UICommand command, String image, String onclick) throws IOException {
        LabelWithAccessKey label = new LabelWithAccessKey((UIComponent)command);
        this.addMenuItem(sb, var, facesContext, accKeyFunctions, command, label, image, onclick);
    }

    private void addSelectOne(StringBuffer sb, String var, FacesContext facesContext, List<String> accKeyFunctions, UICommand command, String onclick) throws IOException {
        List items;
        LabelWithAccessKey label = new LabelWithAccessKey((UIComponent)command);
        UISelectOne radio = (UISelectOne)command.getFacet("items");
        if (radio == null) {
            items = ComponentUtil.getSelectItems((UIComponent)command);
            radio = ComponentUtil.createUIMenuSelectOneFacet((FacesContext)facesContext, (UICommand)command);
            radio.setId(facesContext.getViewRoot().createUniqueId());
        } else {
            items = ComponentUtil.getSelectItems((UIComponent)radio);
        }
        Object value = radio.getValue();
        boolean markFirst = !ComponentUtil.hasSelectedValue((List)items, (Object)value);
        String radioId = radio.getClientId(facesContext);
        String onClickPrefix = new StringBuffer().append("menuSetRadioValue('").append(radioId).append("', '").toString();
        String onClickPostfix = onclick != null ? new StringBuffer().append("') ; ").append(onclick).toString() : "";
        for (SelectItem item : items) {
            String image;
            String labelText = item.getLabel();
            label.reset();
            if (labelText != null) {
                if (labelText.indexOf(95) > -1) {
                    label.setup(labelText);
                } else {
                    label.setText(labelText);
                }
            } else {
                LOG.warn((Object)new StringBuffer().append("Menu item has label=null. UICommand.getClientId()=").append(command.getClientId(facesContext)).toString());
            }
            String formattedValue = RenderUtil.getFormattedValue((FacesContext)facesContext, (UIComponent)radio, (Object)item.getValue());
            onclick = new StringBuffer().append(onClickPrefix).append(formattedValue).append(onClickPostfix).toString();
            if (ObjectUtils.equals((Object)item.getValue(), (Object)value) || markFirst) {
                image = "image/MenuRadioChecked.gif";
                markFirst = false;
                sb.append("    ").append(onClickPrefix).append(formattedValue).append("');");
            } else {
                image = "image/MenuRadioUnchecked.gif";
            }
            this.addMenuItem(sb, var, facesContext, accKeyFunctions, command, label, image, onclick);
        }
    }

    private void addMenuItem(StringBuffer sb, String var, FacesContext facesContext, List<String> accKeyFunctions, UICommand command, LabelWithAccessKey label, String image, String onClick) throws IOException {
        if (!command.isRendered()) {
            return;
        }
        boolean disabled = ComponentUtil.getBooleanAttribute((UIComponent)command, (String)"disabled");
        String spanClass = new StringBuffer().append("tobago-menuBar-item-span tobago-menuBar-item-span-").append(disabled ? "disabled" : "enabled").toString();
        ResponseWriter savedWriter = facesContext.getResponseWriter();
        FastStringWriter stringWriter = new FastStringWriter();
        ResponseWriter newWriter = savedWriter.cloneWithWriter((Writer)stringWriter);
        facesContext.setResponseWriter(newWriter);
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        this.addImage(writer, facesContext, image, disabled);
        writer.startElement("a", null);
        writer.writeClassAttribute(spanClass);
        writer.writeIdAttribute(command.getClientId(facesContext));
        if (label.getAccessKey() != null) {
            if (LOG.isInfoEnabled() && !AccessKeyMap.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey())) {
                LOG.info((Object)new StringBuffer().append("duplicate accessKey : ").append(label.getAccessKey()).append(" in ").append(label.getText()).toString());
            }
            if (!disabled) {
                this.addAcceleratorKey(facesContext, accKeyFunctions, (UIComponent)command, label.getAccessKey());
            }
        }
        writer.writeAttribute("href", "#", false);
        writer.writeAttribute("onfocus", "tobagoMenuFocus(event)", false);
        writer.writeAttribute("onblur", "tobagoMenuBlur(event)", false);
        writer.writeAttribute("onkeydown", "tobagoMenuKeyDown(event)", false);
        writer.writeAttribute("onkeypress", "tobagoMenuKeyPress(event)", false);
        if (label.getText() != null) {
            HtmlRendererUtil.writeLabelWithAccessKey((TobagoResponseWriter)writer, (LabelWithAccessKey)label);
        }
        writer.endElement("a");
        facesContext.setResponseWriter(savedWriter);
        String html = stringWriter.toString();
        sb.append("    ");
        sb.append(var);
        sb.append(".addMenuItem(new Tobago.Menu.Item('");
        sb.append(this.prepareForScript(html));
        sb.append("', ");
        if (!disabled) {
            sb.append("\"");
            sb.append(onClick);
            sb.append("\"");
        } else {
            sb.append("null");
        }
        sb.append(", ");
        sb.append(disabled ? "true" : "false");
        sb.append("));\n");
    }

    private void addMenuSeparator(StringBuffer sb, String var) {
        String html = "<div style=\"text-align: center;\"><hr class=\"tobago-menuBar-separator\"></div>";
        sb.append("    ");
        sb.append(var);
        sb.append(".addMenuItem(new Tobago.Menu.Item('");
        sb.append(this.prepareForScript(html));
        sb.append("', ");
        sb.append("null");
        sb.append(", ");
        sb.append("true");
        sb.append(", ");
        sb.append("true");
        sb.append("));\n");
    }

    private String prepareForScript(String s) {
        return StringUtils.replace((String)s.replace('\n', ' '), (String)"'", (String)"\\'");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$renderkit$html$scarborough$standard$tag$MenuBarRenderer;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$renderkit$html$scarborough$standard$tag$MenuBarRenderer = new MenuBarRenderer[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }
}

