/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.speyside.standard.tag;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.ajax.api.AjaxRenderer;
import org.apache.myfaces.tobago.ajax.api.AjaxUtils;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.renderkit.BoxRendererBase;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlStyleMap;
import org.apache.myfaces.tobago.renderkit.html.StyleClasses;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class BoxRenderer
extends BoxRendererBase
implements AjaxRenderer {
    private static final Log LOG = LogFactory.getLog(BoxRenderer.class);

    public int getFixedHeight(FacesContext facesContext, UIComponent component) {
        return super.getFixedHeight(facesContext, component);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        Integer styleHeight;
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        HtmlStyleMap style = (HtmlStyleMap)component.getAttributes().get("style");
        if (style != null && (styleHeight = style.getInt((Object)"height")) != null) {
            style.put("height", (Object)(styleHeight - 1));
        }
        String clientId = component.getClientId(facesContext);
        writer.startElement("div", component);
        writer.writeClassAttribute();
        writer.writeIdAttribute(clientId);
        if (style != null) {
            writer.writeStyleAttribute(style);
        }
        writer.writeJavascript("Tobago.addAjaxComponent(\"" + clientId + "\")");
        this.encodeBeginInner(facesContext, writer, component);
    }

    private void encodeBeginInner(FacesContext facesContext, TobagoResponseWriter writer, UIComponent component) throws IOException {
        HtmlStyleMap innerStyle = HtmlRendererUtil.prepareInnerStyle((UIComponent)component);
        this.renderBoxHeader(facesContext, writer, component);
        writer.startElement("div", component);
        StyleClasses contentClasses = new StyleClasses();
        contentClasses.addClass("box", "content");
        if (component instanceof SupportsMarkup) {
            contentClasses.addMarkupClass((SupportsMarkup)component, "box", "content");
        }
        writer.writeClassAttribute(contentClasses);
        writer.startElement("div", component);
        StyleClasses contentInnerClasses = new StyleClasses();
        contentInnerClasses.addClass("box", "content-inner");
        if (component instanceof SupportsMarkup) {
            contentInnerClasses.addMarkupClass((SupportsMarkup)component, "box", "content-inner");
        }
        writer.writeClassAttribute(contentInnerClasses);
        writer.writeStyleAttribute(innerStyle);
    }

    protected void renderBoxHeader(FacesContext facesContext, TobagoResponseWriter writer, UIComponent component) throws IOException {
        writer.startElement("div", component);
        StyleClasses headerClasses = new StyleClasses();
        headerClasses.addClass("box", "header");
        if (component instanceof SupportsMarkup) {
            headerClasses.addMarkupClass((SupportsMarkup)component, "box", "header");
        }
        writer.writeClassAttribute(headerClasses);
        UIComponent label = component.getFacet("label");
        writer.startElement("span", null);
        writer.writeClassAttribute("tobago-box-header-label");
        String labelString = (String)component.getAttributes().get("label");
        if (label != null) {
            RenderUtil.encode((FacesContext)facesContext, (UIComponent)label);
        } else if (labelString != null) {
            writer.writeText(labelString);
        }
        writer.endElement("span");
        UIPanel toolbar = (UIPanel)component.getFacet("toolBar");
        if (toolbar != null) {
            this.renderToolbar(facesContext, writer, toolbar);
        }
        writer.endElement("div");
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        this.encodeEndInner(writer);
        writer.endElement("div");
    }

    private void encodeEndInner(TobagoResponseWriter writer) throws IOException {
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void renderToolbar(FacesContext facesContext, TobagoResponseWriter writer, UIPanel toolbar) throws IOException {
        Map attributes = toolbar.getAttributes();
        String className = "tobago-box-header-toolbar-div";
        if ("off".equals(attributes.get("labelPosition"))) {
            className = className + " tobago-box-header-toolbar-label_off";
        }
        writer.startElement("div", null);
        writer.writeClassAttribute(className);
        toolbar.setRendererType("BoxToolBar");
        RenderUtil.encode((FacesContext)facesContext, (UIComponent)toolbar);
        writer.endElement("div");
    }

    public void encodeAjax(FacesContext facesContext, UIComponent component) throws IOException {
        AjaxUtils.checkParamValidity((FacesContext)facesContext, (UIComponent)component, UIPanel.class);
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        this.encodeBeginInner(facesContext, writer, component);
        component.encodeChildren(facesContext);
        this.encodeEndInner(writer);
        facesContext.responseComplete();
    }
}

