/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.viewController.jsf;

import java.util.Set;
import java.util.TreeSet;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.orchestra.viewController.ViewControllerManager;
import org.apache.myfaces.orchestra.viewController.ViewControllerManagerFactory;

public class ViewControllerPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = -3975277433747722402L;
    private final Log log = LogFactory.getLog(ViewControllerPhaseListener.class);

    public void beforePhase(PhaseEvent event) {
        if (PhaseId.RESTORE_VIEW.equals(event.getPhaseId()) || PhaseId.RENDER_RESPONSE.equals(event.getPhaseId())) {
            this.assertConversationState(event.getFacesContext());
            if (event.getFacesContext().getResponseComplete()) {
                return;
            }
        }
        this.executeInitView(event.getFacesContext());
        if (PhaseId.RENDER_RESPONSE.equals(event.getPhaseId())) {
            this.preRenderResponse(event.getFacesContext());
        }
        if (PhaseId.INVOKE_APPLICATION.equals(event.getPhaseId())) {
            this.preInvokeApplication(event.getFacesContext());
        }
    }

    public void afterPhase(PhaseEvent event) {
        if (PhaseId.RESTORE_VIEW.equals(event.getPhaseId())) {
            this.assertConversationState(event.getFacesContext());
            if (event.getFacesContext().getResponseComplete()) {
                return;
            }
        }
        this.executeInitView(event.getFacesContext());
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    protected String getViewId(FacesContext facesContext) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot == null) {
            return null;
        }
        return viewRoot.getViewId();
    }

    protected void assertConversationState(FacesContext facesContext) {
        ViewControllerManager manager = ViewControllerManagerFactory.getInstance();
        if (manager == null) {
            return;
        }
        String viewId = this.getViewId(facesContext);
        if (viewId == null) {
            return;
        }
        manager.assertConversationState(viewId);
    }

    protected void preRenderResponse(FacesContext facesContext) {
        ViewControllerManager manager = ViewControllerManagerFactory.getInstance();
        if (manager == null) {
            return;
        }
        String viewId = this.getViewId(facesContext);
        if (viewId == null) {
            return;
        }
        manager.executePreRenderView(viewId);
    }

    protected void executeInitView(FacesContext facesContext) {
        this.postRestoreView(facesContext);
    }

    protected void postRestoreView(FacesContext facesContext) {
        ViewControllerManager manager = ViewControllerManagerFactory.getInstance();
        if (manager == null) {
            return;
        }
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot == null) {
            return;
        }
        String viewId = viewRoot.getViewId();
        if (viewId == null) {
            return;
        }
        String viewKey = String.valueOf(System.identityHashCode(viewRoot));
        ViewControllerPhaseListenerState state = this.getState(facesContext);
        if (state.initedViews.contains(viewKey)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Skipping already-initialized viewcontroller bean " + viewKey + " for view " + viewId));
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing viewcontroller bean " + viewKey + " for view " + viewId));
        }
        state.initedViews.add(viewKey);
        manager.executeInitView(viewId);
    }

    protected ViewControllerPhaseListenerState getState(FacesContext facesContext) {
        ViewControllerPhaseListenerState state = (ViewControllerPhaseListenerState)facesContext.getExternalContext().getRequestMap().get(ViewControllerPhaseListenerState.class.getName());
        if (state == null) {
            state = new ViewControllerPhaseListenerState();
            facesContext.getExternalContext().getRequestMap().put(ViewControllerPhaseListenerState.class.getName(), state);
        }
        return state;
    }

    protected void preInvokeApplication(FacesContext facesContext) {
        ViewControllerManager manager = ViewControllerManagerFactory.getInstance();
        if (manager == null) {
            return;
        }
        String viewId = this.getViewId(facesContext);
        if (viewId == null) {
            return;
        }
        manager.executePreProcess(viewId);
    }

    public static class ViewControllerPhaseListenerState {
        private Set initedViews = new TreeSet();

        protected ViewControllerPhaseListenerState() {
        }
    }
}

