/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.beanval.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.myfaces.extensions.validator.beanval.BeanValidationModuleKey;
import org.apache.myfaces.extensions.validator.beanval.ExtValBeanValidationContext;
import org.apache.myfaces.extensions.validator.beanval.storage.ModelValidationEntry;
import org.apache.myfaces.extensions.validator.beanval.util.BeanValidationUtils;
import org.apache.myfaces.extensions.validator.beanval.validation.ModelValidationResult;
import org.apache.myfaces.extensions.validator.core.el.ELHelper;
import org.apache.myfaces.extensions.validator.core.property.DefaultPropertyInformation;
import org.apache.myfaces.extensions.validator.core.property.PropertyDetails;
import org.apache.myfaces.extensions.validator.core.property.PropertyInformation;
import org.apache.myfaces.extensions.validator.core.validation.message.FacesMessageHolder;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ToDo(value=Priority.MEDIUM, description="refactor implementation details")
@UsageInformation(value={UsageCategory.INTERNAL})
public class ModelValidationPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = -3482233893186708878L;
    protected final Logger logger = Logger.getLogger(this.getClass().getName());

    public void afterPhase(PhaseEvent phaseEvent) {
        this.logger.finest("jsr303 start model validation");
        HashMap<Object, List<Class>> processedValidationTargets = new HashMap<Object, List<Class>>();
        HashMap<String, ModelValidationResult> results = new HashMap<String, ModelValidationResult>();
        for (ModelValidationEntry modelValidationEntry : this.getModelValidationEntriesToValidate()) {
            this.processModelValidation(modelValidationEntry, processedValidationTargets, results);
        }
        this.processModelValidationResults(results);
        this.executeGlobalAfterValidationInterceptorsFor(results);
        this.logger.finest("jsr303 validation finished");
    }

    private List<ModelValidationEntry> getModelValidationEntriesToValidate() {
        return ExtValBeanValidationContext.getCurrentInstance().getModelValidationEntriesToValidate();
    }

    private void processModelValidation(ModelValidationEntry modelValidationEntry, Map<Object, List<Class>> processedValidationTargets, Map<String, ModelValidationResult> results) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELHelper elHelper = ExtValUtils.getELHelper();
        for (Object validationTarget : modelValidationEntry.getValidationTargets()) {
            Class[] groupsToValidate;
            PropertyInformation propertyInformation = this.createPropertyInformation(modelValidationEntry, validationTarget, elHelper);
            if (!this.executeGlobalBeforeValidationInterceptors(facesContext, modelValidationEntry.getComponent(), validationTarget, propertyInformation) || !this.shouldContinueValidation(modelValidationEntry, groupsToValidate = modelValidationEntry.isDisplayMessageInline() ? modelValidationEntry.getGroups() : this.filterGroupsToValidate(modelValidationEntry, validationTarget, processedValidationTargets))) continue;
            this.addProcessedTarget(validationTarget, groupsToValidate, processedValidationTargets);
            Set<ConstraintViolation<Object>> violations = this.validateTarget(validationTarget, groupsToValidate);
            if (violations == null || violations.isEmpty()) continue;
            this.processViolations(facesContext, modelValidationEntry, validationTarget, violations, results);
        }
    }

    private Class[] filterGroupsToValidate(ModelValidationEntry modelValidationEntry, Object validationTarget, Map<Object, List<Class>> processedValidationTargets) {
        if (!processedValidationTargets.containsKey(validationTarget)) {
            return modelValidationEntry.getGroups();
        }
        ArrayList<Class> result = new ArrayList<Class>();
        List<Class> validatedGroups = processedValidationTargets.get(validationTarget);
        for (Class group : modelValidationEntry.getGroups()) {
            if (validatedGroups.contains(group)) continue;
            result.add(group);
        }
        return result.toArray(new Class[result.size()]);
    }

    private boolean shouldContinueValidation(ModelValidationEntry modelValidationEntry, Class[] groupsToValidate) {
        return groupsToValidate != null && groupsToValidate.length != 0 || modelValidationEntry.isDisplayMessageInline();
    }

    private void addProcessedTarget(Object validationTarget, Class[] groups, Map<Object, List<Class>> processedValidationTargets) {
        if (!processedValidationTargets.containsKey(validationTarget)) {
            processedValidationTargets.put(validationTarget, new ArrayList());
        }
        List<Class> validatedGroups = processedValidationTargets.get(validationTarget);
        for (Class group : groups) {
            if (validatedGroups.contains(group)) continue;
            validatedGroups.add(group);
        }
    }

    private PropertyInformation createPropertyInformation(ModelValidationEntry modelValidationEntry, Object validationTarget, ELHelper elHelper) {
        DefaultPropertyInformation propertyInformation = new DefaultPropertyInformation();
        PropertyDetails propertyDetails = modelValidationEntry.getComponent() != null ? elHelper.getPropertyDetailsOfValueBinding(modelValidationEntry.getComponent()) : new PropertyDetails(null, validationTarget, null);
        propertyInformation.setInformation("property_details", (Object)propertyDetails);
        return propertyInformation;
    }

    private boolean executeGlobalBeforeValidationInterceptors(FacesContext facesContext, UIComponent uiComponent, Object validationTarget, PropertyInformation propertyInformation) {
        return ExtValUtils.executeGlobalBeforeValidationInterceptors((FacesContext)facesContext, (UIComponent)uiComponent, (Object)validationTarget, (String)PropertyInformation.class.getName(), (Object)propertyInformation, BeanValidationModuleKey.class);
    }

    private void executeGlobalAfterValidationInterceptors(FacesContext facesContext, UIComponent uiComponent, Object validationTarget, PropertyInformation propertyInformation) {
        ExtValUtils.executeGlobalAfterValidationInterceptors((FacesContext)facesContext, (UIComponent)uiComponent, (Object)validationTarget, (String)PropertyInformation.class.getName(), (Object)propertyInformation, BeanValidationModuleKey.class);
    }

    private Set<ConstraintViolation<Object>> validateTarget(Object validationTarget, Class[] groups) {
        if (groups == null || groups.length == 0) {
            return null;
        }
        ValidatorFactory validatorFactory = ExtValBeanValidationContext.getCurrentInstance().getValidatorFactory();
        return validatorFactory.usingContext().messageInterpolator(ExtValBeanValidationContext.getCurrentInstance().getMessageInterpolator()).constraintValidatorFactory(validatorFactory.getConstraintValidatorFactory()).traversableResolver(validatorFactory.getTraversableResolver()).getValidator().validate(validationTarget, groups);
    }

    private void processViolations(FacesContext facesContext, ModelValidationEntry modelValidationEntry, Object validationTarget, Set<ConstraintViolation<Object>> violations, Map<String, ModelValidationResult> results) {
        Iterator<ConstraintViolation<Object>> violationsIterator = violations.iterator();
        while (violationsIterator.hasNext()) {
            this.tryToCreateModelValidationResult(facesContext, modelValidationEntry, results);
            ModelValidationResult result = this.resolveModelValidationResult(facesContext, modelValidationEntry, results);
            ConstraintViolation<Object> constraintViolation = violationsIterator.next();
            this.addViolationMessage(modelValidationEntry, validationTarget, constraintViolation, result);
        }
    }

    private void tryToCreateModelValidationResult(FacesContext facesContext, ModelValidationEntry modelValidationEntry, Map<String, ModelValidationResult> results) {
        if (!this.isModelValidationResultAvailableFor(facesContext, modelValidationEntry, results)) {
            ModelValidationResult result = new ModelValidationResult();
            results.put(modelValidationEntry.getComponent().getClientId(facesContext), result);
        }
    }

    private ModelValidationResult resolveModelValidationResult(FacesContext facesContext, ModelValidationEntry modelValidationEntry, Map<String, ModelValidationResult> results) {
        return results.get(modelValidationEntry.getComponent().getClientId(facesContext));
    }

    private boolean isModelValidationResultAvailableFor(FacesContext facesContext, ModelValidationEntry modelValidationEntry, Map<String, ModelValidationResult> results) {
        return results.containsKey(modelValidationEntry.getComponent().getClientId(facesContext));
    }

    private void addViolationMessage(ModelValidationEntry modelValidationEntry, Object validationTarget, ConstraintViolation<Object> constraintViolation, ModelValidationResult result) {
        if (modelValidationEntry.isDisplayMessageInline()) {
            result.addFacesMessageHolder(this.createFacesMessageHolderForConstraintViolation(constraintViolation, modelValidationEntry, validationTarget, true));
        } else {
            result.addFacesMessageHolder(this.createFacesMessageHolderForConstraintViolation(constraintViolation, modelValidationEntry, validationTarget, false));
        }
    }

    private FacesMessageHolder createFacesMessageHolderForConstraintViolation(final ConstraintViolation violation, ModelValidationEntry modelValidationEntry, Object validationTarget, boolean displayAtComponent) {
        final String newViolationMessage = this.tryToChangeViolationMessage(modelValidationEntry, validationTarget, violation);
        ConstraintViolation newConstraintViolation = new ConstraintViolation(){
            private ConstraintViolation wrapped;
            {
                this.wrapped = violation;
            }

            public String getMessage() {
                return newViolationMessage;
            }

            public String getMessageTemplate() {
                return this.wrapped.getMessageTemplate();
            }

            public Object getRootBean() {
                return this.wrapped.getRootBean();
            }

            public Class getRootBeanClass() {
                return this.wrapped.getRootBeanClass();
            }

            public Object getLeafBean() {
                return this.wrapped.getLeafBean();
            }

            public Path getPropertyPath() {
                return this.wrapped.getPropertyPath();
            }

            public Object getInvalidValue() {
                return this.wrapped.getInvalidValue();
            }

            public ConstraintDescriptor getConstraintDescriptor() {
                return this.wrapped.getConstraintDescriptor();
            }
        };
        UIComponent uiComponent = null;
        String clientId = null;
        if (displayAtComponent) {
            uiComponent = modelValidationEntry.getComponent();
            clientId = uiComponent.getClientId(FacesContext.getCurrentInstance());
        }
        FacesMessageHolder result = new FacesMessageHolder(BeanValidationUtils.createFacesMessageForConstraintViolation(uiComponent, validationTarget, (ConstraintViolation<Object>)newConstraintViolation));
        result.setClientId(clientId);
        return result;
    }

    private String tryToChangeViolationMessage(ModelValidationEntry modelValidationEntry, Object validationTarget, ConstraintViolation violation) {
        if (!this.isDefaultMessage(modelValidationEntry)) {
            return this.interpolateValidationErrorMessage(modelValidationEntry.getCustomMessage(), validationTarget, violation);
        }
        return violation.getMessage();
    }

    private boolean isDefaultMessage(ModelValidationEntry modelValidationEntry) {
        return "".equals(modelValidationEntry.getCustomMessage());
    }

    private String interpolateValidationErrorMessage(String extValInlineMessage, final Object validationTarget, final ConstraintViolation violation) {
        return ExtValBeanValidationContext.getCurrentInstance().getMessageInterpolator().interpolate(extValInlineMessage, new MessageInterpolator.Context(){

            public ConstraintDescriptor<?> getConstraintDescriptor() {
                return violation.getConstraintDescriptor();
            }

            public Object getValidatedValue() {
                return validationTarget;
            }
        });
    }

    @ToDo(value=Priority.MEDIUM)
    private void processModelValidationResults(Map<String, ModelValidationResult> results) {
        for (ModelValidationResult result : results.values()) {
            BeanValidationUtils.processViolationMessages(result.getFacesMessageHolderList());
        }
    }

    private void executeGlobalAfterValidationInterceptorsFor(Map<String, ModelValidationResult> results) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        for (ModelValidationResult result : results.values()) {
            for (FacesMessageHolder facesMessageHolder : result.getFacesMessageHolderList()) {
                UIComponent component = null;
                if (facesMessageHolder.getClientId() != null && !facesMessageHolder.getClientId().equals("*")) {
                    component = facesContext.getViewRoot().findComponent(facesMessageHolder.getClientId());
                }
                this.executeGlobalAfterValidationInterceptors(facesContext, component, null, null);
            }
        }
    }

    public void beforePhase(PhaseEvent phaseEvent) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.UPDATE_MODEL_VALUES;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof ModelValidationPhaseListener;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

