/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.el;

import java.io.Externalizable;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.extensions.validator.core.el.ELHelper;
import org.apache.myfaces.extensions.validator.core.el.FaceletsTaglibExpressionHelper;
import org.apache.myfaces.extensions.validator.core.el.ValueBindingExpression;
import org.apache.myfaces.extensions.validator.core.property.PropertyDetails;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;
import org.apache.myfaces.extensions.validator.util.ReflectionUtils;

@UsageInformation(value={UsageCategory.INTERNAL})
public class DefaultELHelper
implements ELHelper {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());

    public DefaultELHelper() {
        this.logger.fine(this.getClass().getName() + " instantiated");
    }

    public Class getTypeOfExpression(FacesContext facesContext, ValueBindingExpression valueBindingExpression) {
        Object bean = this.getValueOfExpression(facesContext, valueBindingExpression);
        return bean != null ? ProxyUtils.getUnproxiedClass(bean.getClass()) : null;
    }

    public Object getBean(String beanName) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getApplication().getVariableResolver().resolveVariable(facesContext, beanName);
    }

    public Object getValueOfExpression(FacesContext facesContext, ValueBindingExpression valueBindingExpression) {
        return valueBindingExpression != null ? facesContext.getApplication().createValueBinding(valueBindingExpression.getExpressionString()).getValue(facesContext) : null;
    }

    public boolean isELTermValid(FacesContext facesContext, String valueBindingExpression) {
        return facesContext.getApplication().createValueBinding(valueBindingExpression) != null;
    }

    private ValueBindingExpression getValueBindingExpression(UIComponent uiComponent, boolean allowBlankCharacters) {
        FacesContext facesContext;
        String valueBindingExpression = DefaultELHelper.getOriginalValueBindingExpression(uiComponent);
        if (valueBindingExpression == null) {
            this.logger.finest(uiComponent.getClass() + " has no value binding - component id: " + uiComponent.getId());
            return null;
        }
        if (!allowBlankCharacters) {
            valueBindingExpression = valueBindingExpression.replace(" ", "");
        }
        if (this.getTypeOfExpression(facesContext = FacesContext.getCurrentInstance(), new ValueBindingExpression(valueBindingExpression).getBaseExpression()) == null) {
            ValueBindingExpression result = FaceletsTaglibExpressionHelper.tryToCreateValueBindingForFaceletsBinding(uiComponent);
            if (result == null) {
                this.logger.warning("couldn't resolve expression: " + valueBindingExpression);
                return null;
            }
            Class entityClass = this.getTypeOfExpression(facesContext, result.getBaseExpression());
            if (entityClass == null) {
                this.logger.warning("couldn't resolve expression: " + result.getExpressionString());
                return null;
            }
            return result;
        }
        return new ValueBindingExpression(valueBindingExpression);
    }

    public PropertyDetails getPropertyDetailsOfValueBinding(UIComponent uiComponent) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ValueBindingExpression valueBindingExpression = this.getValueBindingExpression(uiComponent, false);
        if (valueBindingExpression == null) {
            return null;
        }
        ValueBindingExpression currentValueBindingExpression = new ValueBindingExpression(valueBindingExpression.getExpressionString());
        String path = null;
        while (currentValueBindingExpression.getBaseExpression() != null) {
            path = path == null ? this.getPropertyName(currentValueBindingExpression) : this.getPropertyName(currentValueBindingExpression) + "." + path;
            currentValueBindingExpression = currentValueBindingExpression.getBaseExpression();
        }
        path = currentValueBindingExpression.getProperty() + "." + path;
        Object baseObject = this.getValueOfExpression(facesContext, valueBindingExpression.getBaseExpression());
        return new PropertyDetails(path, baseObject, this.getPropertyName(valueBindingExpression));
    }

    private String getPropertyName(ValueBindingExpression valueBindingExpression) {
        String propertyName = valueBindingExpression.getProperty();
        if (propertyName.contains(".")) {
            propertyName = this.extractPropertyNameOfPropertyPath(propertyName);
        }
        return propertyName;
    }

    @ToDo(value=Priority.MEDIUM, description="support for more dynamic bindings - details see inline")
    private String extractPropertyNameOfPropertyPath(String propertyChain) {
        String[] properties = propertyChain.split("\\.");
        Object currentPropertyValue = this.getBean(properties[0]);
        for (int i = 1; i < properties.length; ++i) {
            String currentPropertyName = properties[i];
            Class currentClassOfPropertyValue = ProxyUtils.getUnproxiedClass(currentPropertyValue.getClass());
            Method currentMethod = ReflectionUtils.tryToGetMethod(currentClassOfPropertyValue, "get" + currentPropertyName.substring(0, 1).toUpperCase() + currentPropertyName.substring(1));
            if (currentMethod == null && currentPropertyValue instanceof Map) {
                ((Map)currentPropertyValue).get(currentPropertyName);
                continue;
            }
            currentPropertyValue = ReflectionUtils.tryToInvokeMethod(currentPropertyValue, currentMethod);
        }
        if (currentPropertyValue instanceof String) {
            return (String)currentPropertyValue;
        }
        this.logger.severe("unexpected value within map syntax: " + propertyChain + " last property name: " + currentPropertyValue);
        return null;
    }

    static String getOriginalValueBindingExpression(UIComponent uiComponent) {
        ValueBinding valueExpression = uiComponent.getValueBinding("value");
        return valueExpression != null ? valueExpression.getExpressionString() : null;
    }

    public boolean isELTermWellFormed(Object o) {
        if (o instanceof ValueBinding || o instanceof Externalizable) {
            return false;
        }
        String s = o.toString();
        return (s.contains("#") || s.contains("$")) && s.contains("{") && s.contains("}");
    }

    public Object getBindingOfComponent(UIComponent uiComponent, String name) {
        return uiComponent.getValueBinding(name);
    }
}

