/*
 * Decompiled with CFR 0.152.
 */
package jakarta.enterprise.util;

import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class TypeLiteral<T>
implements Serializable {
    private static final long serialVersionUID = 6993258591899719600L;
    private Type definedType = this.getDefinedType(this.getClass());

    protected TypeLiteral() {
    }

    public final Type getType() {
        return this.definedType;
    }

    public final Class<T> getRawType() {
        Class rawType;
        if (this.definedType instanceof Class) {
            rawType = (Class)this.definedType;
        } else if (this.definedType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)this.definedType;
            rawType = (Class)pt.getRawType();
        } else if (this.definedType instanceof GenericArrayType) {
            rawType = Object[].class;
        } else {
            throw new RuntimeException("Illegal type for the Type Literal Class");
        }
        return rawType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Type getDefinedType(Class<?> clazz) {
        if (clazz == null) {
            throw new RuntimeException("Class parameter can not be null!");
        }
        Type superClazz = clazz.getGenericSuperclass();
        if (superClazz.equals(Object.class)) {
            throw new RuntimeException("Super class must be parametrized type!");
        }
        if (!(superClazz instanceof ParameterizedType)) return this.getDefinedType((Class)superClazz);
        ParameterizedType pt = (ParameterizedType)superClazz;
        Type[] actualArgs = pt.getActualTypeArguments();
        if (actualArgs.length != 1) throw new RuntimeException("More than one parametric type!");
        return actualArgs[0];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.definedType == null ? 0 : this.definedType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeLiteral other = (TypeLiteral)obj;
        return !(this.definedType == null ? other.definedType != null : !this.definedType.equals(other.definedType));
    }
}

