/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.apache.myfaces.util.AbstractThreadSafeAttributeMap;

public final class SessionMap
extends AbstractThreadSafeAttributeMap<Object> {
    private final HttpServletRequest _httpRequest;

    SessionMap(HttpServletRequest httpRequest) {
        this._httpRequest = httpRequest;
    }

    @Override
    protected Object getAttribute(String key) {
        HttpSession httpSession = this._getSession();
        return httpSession == null ? null : httpSession.getAttribute(key);
    }

    @Override
    protected void setAttribute(String key, Object value) {
        this._httpRequest.getSession(true).setAttribute(key, value);
    }

    @Override
    protected void removeAttribute(String key) {
        HttpSession httpSession = this._getSession();
        if (httpSession != null) {
            httpSession.removeAttribute(key);
        }
    }

    @Override
    protected Enumeration<String> getAttributeNames() {
        HttpSession httpSession = this._getSession();
        return httpSession == null ? Collections.emptyEnumeration() : httpSession.getAttributeNames();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        throw new UnsupportedOperationException();
    }

    private HttpSession _getSession() {
        return this._httpRequest.getSession(false);
    }
}

