/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.roster.persistence;

import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.modules.ServerRuntimeContextService;
import org.apache.vysper.xmpp.modules.roster.MutableRoster;
import org.apache.vysper.xmpp.modules.roster.Roster;
import org.apache.vysper.xmpp.modules.roster.RosterException;
import org.apache.vysper.xmpp.modules.roster.RosterItem;
import org.apache.vysper.xmpp.modules.roster.persistence.RosterManager;

public abstract class AbstractRosterManager
implements RosterManager,
ServerRuntimeContextService {
    protected abstract Roster retrieveRosterInternal(Entity var1);

    protected abstract Roster addNewRosterInternal(Entity var1);

    public Roster retrieve(Entity jid) {
        jid = jid.getBareJID();
        return this.retrieveRosterInternal(jid);
    }

    public void addContact(Entity jid, RosterItem rosterItem) throws RosterException {
        if (jid == null) {
            throw new RosterException("jid not provided");
        }
        MutableRoster mutableRoster = (MutableRoster)this.retrieve(jid);
        if (mutableRoster == null) {
            mutableRoster = (MutableRoster)this.addNewRosterInternal(jid);
        }
        mutableRoster.addItem(rosterItem);
    }

    public RosterItem getContact(Entity jidUser, Entity jidContact) throws RosterException {
        if (jidUser == null) {
            throw new RosterException("jid not provided");
        }
        Roster roster = this.retrieve(jidUser);
        if (roster == null) {
            throw new RosterException("roster not available for jid = " + jidUser.getFullQualifiedName());
        }
        return roster.getEntry(jidContact);
    }

    public void removeContact(Entity jidUser, Entity jidContact) throws RosterException {
        if (jidUser == null) {
            throw new RosterException("jid not provided");
        }
        Roster roster = this.retrieve(jidUser);
        if (roster == null) {
            throw new RosterException("roster not available for jid = " + jidUser.getFullQualifiedName());
        }
    }

    public String getServiceName() {
        return "rosterManager";
    }
}

