/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0160_offline_storage;

import org.apache.vysper.xmpp.modules.extension.xep0160_offline_storage.OfflineStorageProvider;
import org.apache.vysper.xmpp.stanza.MessageStanza;
import org.apache.vysper.xmpp.stanza.MessageStanzaType;
import org.apache.vysper.xmpp.stanza.PresenceStanza;
import org.apache.vysper.xmpp.stanza.PresenceStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOfflineStorageProvider
implements OfflineStorageProvider {
    final Logger logger = LoggerFactory.getLogger(AbstractOfflineStorageProvider.class);

    public void receive(Stanza stanza) {
        boolean store = false;
        this.logger.debug("Received Stanza for offline storage:" + ((Object)((Object)stanza)).getClass().getSimpleName());
        if (stanza instanceof MessageStanza) {
            MessageStanza messageStanza = (MessageStanza)stanza;
            MessageStanzaType type = messageStanza.getMessageType();
            switch (type) {
                case NORMAL: 
                case CHAT: {
                    store = true;
                    break;
                }
                case GROUPCHAT: 
                case ERROR: 
                case HEADLINE: {
                    store = false;
                    break;
                }
                default: {
                    throw new RuntimeException("unknown mesage type " + (Object)((Object)type));
                }
            }
        } else if (stanza instanceof PresenceStanza) {
            PresenceStanza presenceStanza = (PresenceStanza)stanza;
            PresenceStanzaType type = presenceStanza.getPresenceType();
            switch (type) {
                case SUBSCRIBE: 
                case SUBSCRIBED: 
                case UNSUBSCRIBE: 
                case UNSUBSCRIBED: {
                    store = true;
                    break;
                }
                case ERROR: 
                case PROBE: 
                case UNAVAILABLE: {
                    store = false;
                    break;
                }
                default: {
                    throw new RuntimeException("unknown presence type " + (Object)((Object)type));
                }
            }
        }
        if (!store) {
            this.logger.debug("Stanza is not intended for offline storage");
            return;
        }
        this.logger.debug("Stanza will be stored offline");
        this.storeStanza(stanza);
    }

    protected abstract void storeStanza(Stanza var1);
}

