/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.spring;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.vysper.xmpp.modules.Module;
import org.apache.vysper.xmpp.server.Endpoint;
import org.apache.vysper.xmpp.server.XMPPServer;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringCompatibleXMPPServer
extends XMPPServer {
    protected final List<Module> listOfModules = new ArrayList<Module>();
    protected File certificateFile = null;
    protected String certificatePassword = null;

    public SpringCompatibleXMPPServer(String domain) {
        super(domain);
    }

    public void setCertificateFile(Resource certificateFile) throws IOException {
        this.certificateFile = certificateFile.getFile();
    }

    public void setCertificatePassword(String certificatePassword) {
        this.certificatePassword = certificatePassword;
    }

    public void setEndpoints(Collection<Endpoint> endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addEndpoint(endpoint);
        }
    }

    public void setModules(Collection<Module> modules) {
        this.listOfModules.addAll(modules);
    }

    public void init() throws Exception {
        this.setTLSCertificateInfo(this.certificateFile, this.certificatePassword);
        this.start();
        if (this.listOfModules != null) {
            for (Module module : this.listOfModules) {
                this.addModule(module);
            }
        }
    }

    public void destroy() {
        this.stop();
    }
}

