/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.security.user.AuthorizableImpl;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GroupImpl
extends AuthorizableImpl
implements org.apache.jackrabbit.api.security.user.Group {
    private static final Logger log = LoggerFactory.getLogger((Class)GroupImpl.class);
    private Principal principal = null;

    private GroupImpl(NodeImpl node, UserManagerImpl userManager) throws RepositoryException {
        super(node, userManager);
    }

    static org.apache.jackrabbit.api.security.user.Group create(NodeImpl node, UserManagerImpl userManager) throws RepositoryException {
        if (node == null || !node.isNodeType(NT_REP_GROUP)) {
            throw new IllegalArgumentException();
        }
        if (!Text.isDescendant((String)"/rep:security/rep:authorizables/rep:groups", (String)node.getPath())) {
            throw new IllegalArgumentException("Group has to be within the Group Path");
        }
        return new GroupImpl(node, userManager);
    }

    public String getID() throws RepositoryException {
        return this.getNode().getName();
    }

    public boolean isGroup() {
        return true;
    }

    public Principal getPrincipal() throws RepositoryException {
        if (this.principal == null) {
            this.principal = new NodeBasedGroup(this.getPrincipalName());
        }
        return this.principal;
    }

    public Iterator getDeclaredMembers() throws RepositoryException {
        return this.getMembers(false).iterator();
    }

    public Iterator getMembers() throws RepositoryException {
        return this.getMembers(true).iterator();
    }

    public boolean isMember(Authorizable authorizable) throws RepositoryException {
        if (authorizable == null || !(authorizable instanceof AuthorizableImpl)) {
            return false;
        }
        String thisID = this.getID();
        AuthorizableImpl impl = (AuthorizableImpl)authorizable;
        Iterator it = impl.memberOf();
        while (it.hasNext()) {
            if (!thisID.equals(((GroupImpl)it.next()).getID())) continue;
            return true;
        }
        return false;
    }

    public boolean addMember(Authorizable authorizable) throws RepositoryException {
        if (authorizable == null || !(authorizable instanceof AuthorizableImpl) || this.isMember(authorizable)) {
            return false;
        }
        if (this.isCyclicMembership(authorizable)) {
            log.warn("Attempt to create circular group membership.");
            return false;
        }
        AuthorizableImpl authImpl = (AuthorizableImpl)authorizable;
        NodeImpl memberNode = authImpl.getNode();
        if (memberNode.isSame(this.getNode())) {
            String msg = "Attempt to add a Group as member of itself (" + this.getID() + ").";
            log.warn(msg);
            return false;
        }
        return authImpl.addToGroup(this);
    }

    public boolean removeMember(Authorizable authorizable) throws RepositoryException {
        if (!this.isMember(authorizable) || !(authorizable instanceof AuthorizableImpl)) {
            return false;
        }
        return ((AuthorizableImpl)authorizable).removeFromGroup(this);
    }

    private Collection getMembers(boolean includeIndirect) throws RepositoryException {
        PropertyIterator itr = this.getNode().getReferences();
        HashSet<Object> members = new HashSet<Object>((int)itr.getSize());
        while (itr.hasNext()) {
            NodeImpl n = (NodeImpl)itr.nextProperty().getParent();
            if (n.isNodeType(NT_REP_GROUP)) {
                org.apache.jackrabbit.api.security.user.Group group = this.userManager.createGroup(n);
                if (!members.add(group) || !includeIndirect) continue;
                members.addAll(((GroupImpl)group).getMembers(true));
                continue;
            }
            if (!n.isNodeType(NT_REP_USER)) continue;
            User user = this.userManager.createUser(n);
            members.add(user);
        }
        return members;
    }

    private boolean isCyclicMembership(Authorizable newMember) throws RepositoryException {
        boolean cyclic = false;
        if (newMember.isGroup()) {
            org.apache.jackrabbit.api.security.user.Group gr = (org.apache.jackrabbit.api.security.user.Group)newMember;
            cyclic = gr.isMember((Authorizable)this);
        }
        return cyclic;
    }

    private class NodeBasedGroup
    extends AuthorizableImpl.NodeBasedPrincipal
    implements Group {
        private Set members;

        private NodeBasedGroup(String name) {
            super(GroupImpl.this, name);
        }

        public boolean addMember(Principal user) {
            return false;
        }

        public boolean isMember(Principal member) {
            Collection members = this.getMembers();
            if (members.contains(member)) {
                return true;
            }
            Iterator it = members.iterator();
            while (it.hasNext()) {
                Principal p = (Principal)it.next();
                if (!(p instanceof Group) || !((Group)p).isMember(member)) continue;
                return true;
            }
            return false;
        }

        public boolean removeMember(Principal user) {
            return false;
        }

        public Enumeration members() {
            return Collections.enumeration(this.getMembers());
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            this.getMembers();
            stream.defaultWriteObject();
        }

        private Collection getMembers() {
            if (this.members == null) {
                this.members = new HashSet();
                try {
                    Iterator it = GroupImpl.this.getMembers();
                    while (it.hasNext()) {
                        Authorizable authrz = (Authorizable)it.next();
                        this.members.add(authrz.getPrincipal());
                    }
                }
                catch (RepositoryException e) {
                    log.error("Unable to retrieve Group members.");
                }
            }
            return this.members;
        }
    }

    private class MemberIterator
    implements Iterator {
        private final Iterator ids;
        private Authorizable next;

        private MemberIterator(Iterator ids) {
            this.ids = ids;
            this.next = this.seekNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Authorizable n = this.next;
            this.next = this.seekNext();
            return n;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Authorizable seekNext() {
            org.apache.jackrabbit.api.security.user.Group auth = null;
            while (auth == null && this.ids.hasNext()) {
                String uuid = (String)this.ids.next();
                try {
                    NodeImpl mem = (NodeImpl)GroupImpl.this.getSession().getNodeByUUID(uuid);
                    if (mem.isNodeType(UserConstants.NT_REP_GROUP)) {
                        auth = GroupImpl.this.userManager.createGroup(mem);
                        continue;
                    }
                    auth = GroupImpl.this.userManager.createUser(mem);
                }
                catch (RepositoryException e) {
                    log.warn("Internal error while building next member.", (Object)e.getMessage());
                }
            }
            return auth;
        }
    }
}

