/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.core.im.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.vysper.xml.fragment.Attribute;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.delivery.failure.DeliveryException;
import org.apache.vysper.xmpp.delivery.failure.IgnoreFailureStrategy;
import org.apache.vysper.xmpp.modules.core.base.handler.XMPPCoreStanzaHandler;
import org.apache.vysper.xmpp.modules.core.im.handler.AbstractPresenceSpecializedHandler;
import org.apache.vysper.xmpp.modules.extension.xep0160_offline_storage.OfflineStorageProvider;
import org.apache.vysper.xmpp.modules.roster.RosterException;
import org.apache.vysper.xmpp.modules.roster.RosterItem;
import org.apache.vysper.xmpp.modules.roster.RosterUtils;
import org.apache.vysper.xmpp.modules.roster.SubscriptionType;
import org.apache.vysper.xmpp.modules.roster.persistence.RosterManager;
import org.apache.vysper.xmpp.protocol.commandstanza.EndOfSessionCommandStanza;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.stanza.PresenceStanza;
import org.apache.vysper.xmpp.stanza.PresenceStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.StanzaErrorCondition;
import org.apache.vysper.xmpp.stanza.StanzaErrorType;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanzaVerifier;
import org.apache.vysper.xmpp.state.resourcebinding.ResourceRegistry;
import org.apache.vysper.xmpp.state.resourcebinding.ResourceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresenceAvailabilityHandler
extends AbstractPresenceSpecializedHandler {
    protected static final String DIRECTED_PRESENCE_MAP = "DIRECTED_PRESENCE_MAP_";
    final Logger logger = LoggerFactory.getLogger(PresenceAvailabilityHandler.class);

    @Override
    Stanza executeCorePresence(ServerRuntimeContext serverRuntimeContext, boolean isOutboundStanza, SessionContext sessionContext, PresenceStanza presenceStanza, RosterManager rosterManager) {
        if (PresenceStanzaType.isSubscriptionType(presenceStanza.getPresenceType())) {
            throw new RuntimeException("case not handled in availability handler" + presenceStanza.getPresenceType().value());
        }
        Entity initiatingEntity = sessionContext == null ? null : sessionContext.getInitiatingEntity();
        XMPPCoreStanzaVerifier verifier = presenceStanza.getCoreVerifier();
        ResourceRegistry registry = serverRuntimeContext.getResourceRegistry();
        if (!serverRuntimeContext.getServerFeatures().isRelayingPresence() || sessionContext != null && sessionContext.getAttribute("stanza.presence.no_receive") != null) {
            return null;
        }
        PresenceStanzaType type = presenceStanza.getPresenceType();
        boolean available = PresenceStanzaType.isAvailable(type);
        if (isOutboundStanza) {
            Entity user = XMPPCoreStanzaHandler.extractUniqueSenderJID(presenceStanza, sessionContext);
            if (user == null) {
                return ServerErrorResponses.getStanzaError(StanzaErrorCondition.UNKNOWN_SENDER, presenceStanza, StanzaErrorType.MODIFY, "sender info insufficient: no from", null, null);
            }
            if (available) {
                return this.handleOutboundAvailable(presenceStanza, serverRuntimeContext, sessionContext, rosterManager, user, registry);
            }
            if (type == PresenceStanzaType.UNAVAILABLE) {
                return this.handleOutboundUnavailable(presenceStanza, serverRuntimeContext, sessionContext, rosterManager, user, registry);
            }
            if (type == PresenceStanzaType.PROBE) {
                return this.handleOutboundPresenceProbe(presenceStanza, serverRuntimeContext, sessionContext, registry);
            }
            if (type == PresenceStanzaType.ERROR) {
                throw new RuntimeException("not implemented yet");
            }
            throw new RuntimeException("unhandled outbound presence case " + type.value());
        }
        if (available) {
            return this.handleInboundAvailable(presenceStanza, serverRuntimeContext, sessionContext, registry);
        }
        if (type == PresenceStanzaType.UNAVAILABLE) {
            return this.handleInboundUnavailable(presenceStanza, serverRuntimeContext, sessionContext, registry);
        }
        if (type == PresenceStanzaType.PROBE) {
            return this.handleInboundPresenceProbe(presenceStanza, serverRuntimeContext, sessionContext, registry, rosterManager);
        }
        if (type == PresenceStanzaType.ERROR) {
            throw new RuntimeException("not implemented yet");
        }
        throw new RuntimeException("unhandled inbound presence case " + type.value());
    }

    private Stanza handleOutboundUnavailable(PresenceStanza presenceStanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext, RosterManager rosterManager, Entity user, ResourceRegistry registry) {
        boolean hasTo = presenceStanza.getCoreVerifier().attributePresent("to");
        if (hasTo) {
            return this.handleOutboundDirectedPresence(presenceStanza, serverRuntimeContext, sessionContext, rosterManager, user, registry, true);
        }
        if (!user.isResourceSet()) {
            throw new RuntimeException("resource id not available");
        }
        boolean stateChanged = registry.setResourceState(user.getResource(), ResourceState.UNAVAILABLE);
        if (!stateChanged) {
            return null;
        }
        sessionContext.getServerRuntimeContext().getPresenceCache().remove(user);
        SessionContext.SessionTerminationCause terminationCause = null;
        if (presenceStanza instanceof EndOfSessionCommandStanza) {
            EndOfSessionCommandStanza commandStanza = (EndOfSessionCommandStanza)presenceStanza;
            terminationCause = commandStanza.getSessionTerminationCause();
        }
        ArrayList<Entity> contacts = new ArrayList<Entity>();
        Map<SubscriptionType, List<RosterItem>> itemMap = RosterUtils.getRosterItemsByState(rosterManager, user);
        List<RosterItem> item_FROM = itemMap.get((Object)SubscriptionType.FROM);
        List<RosterItem> item_TO = itemMap.get((Object)SubscriptionType.TO);
        List<RosterItem> item_BOTH = itemMap.get((Object)SubscriptionType.BOTH);
        ArrayList<RosterItem> rosterContacts_FROM = new ArrayList<RosterItem>();
        rosterContacts_FROM.addAll(item_FROM);
        rosterContacts_FROM.addAll(item_BOTH);
        for (RosterItem rosterContact : rosterContacts_FROM) {
            contacts.add(rosterContact.getJid());
        }
        Set<Entity> entitySet = this.getDirectedPresenceMap(sessionContext, user);
        if (entitySet != null) {
            contacts.addAll(entitySet);
            entitySet.clear();
        }
        List<String> resources = registry.getAvailableResources(user);
        if (!SessionContext.SessionTerminationCause.isClientReceivingStanzas(terminationCause)) {
            resources.remove(user.getResource());
        }
        for (String resource : resources) {
            EntityImpl otherResource = new EntityImpl(user, resource);
            contacts.add(otherResource);
        }
        this.relayTo(user, contacts, presenceStanza, sessionContext);
        return null;
    }

    private Stanza handleOutboundPresenceProbe(PresenceStanza presenceStanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext, ResourceRegistry registry) {
        throw new IllegalStateException("clients might not send presence probes");
    }

    private PresenceStanza handleOutboundAvailable(PresenceStanza presenceStanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext, RosterManager rosterManager, Entity user, ResourceRegistry registry) {
        boolean hasTo = presenceStanza.getCoreVerifier().attributePresent("to");
        if (hasTo) {
            return this.handleOutboundDirectedPresence(presenceStanza, serverRuntimeContext, sessionContext, rosterManager, user, registry, false);
        }
        if (!user.isResourceSet()) {
            throw new RuntimeException("resource id not available");
        }
        String resourceId = user.getResource();
        ResourceState resourceState = registry.getResourceState(resourceId);
        boolean isPresenceUpdate = resourceState != null && ResourceState.isAvailable(resourceState);
        this.updateLatestPresence(sessionContext, user, presenceStanza);
        if (!isPresenceUpdate) {
            ResourceState currentState = registry.getResourceState(resourceId);
            registry.setResourceState(resourceId, ResourceState.makeAvailable(currentState));
        }
        registry.setResourcePriority(resourceId, presenceStanza.getPrioritySafe());
        OfflineStorageProvider offlineProvider = (OfflineStorageProvider)serverRuntimeContext.getStorageProvider(OfflineStorageProvider.class);
        if (offlineProvider == null) {
            this.logger.warn("No Offline Storage Provider configured");
        } else {
            Collection<Stanza> offlineStanzas = offlineProvider.getStanzasForBareJID(user.getBareJID().getFullQualifiedName());
            for (Stanza stanza : offlineStanzas) {
                this.logger.debug("Sending out delayed offline stanza");
                this.relayStanza(user, stanza, sessionContext);
            }
        }
        ArrayList<Entity> contacts = new ArrayList<Entity>();
        Map<SubscriptionType, List<RosterItem>> itemMap = RosterUtils.getRosterItemsByState(rosterManager, user);
        List<RosterItem> item_FROM = itemMap.get((Object)SubscriptionType.FROM);
        List<RosterItem> item_TO = itemMap.get((Object)SubscriptionType.TO);
        List<RosterItem> item_BOTH = itemMap.get((Object)SubscriptionType.BOTH);
        ArrayList<RosterItem> rosterContacts_FROM = new ArrayList<RosterItem>();
        rosterContacts_FROM.addAll(item_FROM);
        rosterContacts_FROM.addAll(item_BOTH);
        for (RosterItem rosterContact : rosterContacts_FROM) {
            contacts.add(rosterContact.getJid());
        }
        List<String> resources = registry.getAvailableResources(user);
        for (String resource : resources) {
            EntityImpl otherResource = new EntityImpl(user, resource);
            contacts.add(otherResource);
        }
        this.relayTo(user, contacts, presenceStanza, sessionContext);
        if (!isPresenceUpdate) {
            ArrayList<RosterItem> rosterContacts_TO = new ArrayList<RosterItem>();
            rosterContacts_TO.addAll(item_TO);
            rosterContacts_TO.addAll(item_BOTH);
            for (RosterItem rosterItem : rosterContacts_TO) {
                Entity contact_TO = rosterItem.getJid();
                PresenceStanza probeStanza = this.buildPresenceStanza(user, contact_TO, PresenceStanzaType.PROBE, null);
                this.relayStanza(contact_TO, probeStanza, sessionContext);
            }
        }
        return null;
    }

    private PresenceStanza handleOutboundDirectedPresence(PresenceStanza presenceStanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext, RosterManager rosterManager, Entity user, ResourceRegistry registry, boolean unvailable) {
        boolean IsTOAvailable;
        boolean isFromContact;
        Entity to = presenceStanza.getTo();
        Entity from = presenceStanza.getFrom();
        Stanza redirectDirectedStanza = presenceStanza;
        if (from == null || !from.isResourceSet()) {
            from = new EntityImpl(sessionContext.getInitiatingEntity(), registry.getUniqueResourceForSession(sessionContext));
            redirectDirectedStanza = StanzaBuilder.createForwardStanza(presenceStanza, from, null);
        }
        Set<Entity> dpMap = this.getDirectedPresenceMap(sessionContext, from);
        try {
            isFromContact = rosterManager.retrieve(from.getBareJID()).getEntry(to.getBareJID()).hasFrom();
        }
        catch (Exception e) {
            isFromContact = false;
        }
        boolean bl = IsTOAvailable = !ResourceState.isAvailable(registry.getResourceState(from.getResource()));
        if (unvailable) {
            dpMap.remove(to);
        } else if (!isFromContact || !IsTOAvailable) {
            dpMap.add(to);
        }
        try {
            serverRuntimeContext.getStanzaRelay().relay(to, redirectDirectedStanza, new IgnoreFailureStrategy());
        }
        catch (DeliveryException e) {
            this.logger.warn("relaying directed presence failed. from = " + from + ", to = " + to);
        }
        return null;
    }

    private Set<Entity> getDirectedPresenceMap(SessionContext sessionContext, Entity from) {
        String mapKey = DIRECTED_PRESENCE_MAP + from.getResource();
        HashSet directedPresenceMap = (HashSet)sessionContext.getAttribute(mapKey);
        if (directedPresenceMap == null) {
            directedPresenceMap = new HashSet();
            sessionContext.putAttribute(mapKey, directedPresenceMap);
        }
        return directedPresenceMap;
    }

    private PresenceStanza handleInboundUnavailable(PresenceStanza presenceStanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext, ResourceRegistry registry) {
        String unavailableContact = "UNKNOWN";
        if (presenceStanza != null && presenceStanza.getFrom() != null) {
            unavailableContact = presenceStanza.getFrom().getFullQualifiedName();
        }
        this.logger.info("{} has become unavailable", (Object)unavailableContact);
        return presenceStanza;
    }

    private XMPPCoreStanza handleInboundPresenceProbe(PresenceStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext, ResourceRegistry registry, RosterManager rosterManager) {
        RosterItem contactItem;
        Entity contact = stanza.getFrom();
        Entity user = stanza.getTo();
        try {
            contactItem = rosterManager.getContact(user, contact.getBareJID());
        }
        catch (RosterException e) {
            contactItem = null;
        }
        if (contactItem == null || !contactItem.hasFrom()) {
            this.relayStanza(contact, this.buildPresenceStanza(user, contact, PresenceStanzaType.UNSUBSCRIBED, null), sessionContext);
            return null;
        }
        if (contact.getResource() == null) {
            this.relayStanza(contact, this.buildPresenceStanza(user, contact, PresenceStanzaType.UNSUBSCRIBED, null), sessionContext);
            return null;
        }
        PresenceStanza latestPresenceStanza = this.retrieveLatestPresence(sessionContext, user);
        if (latestPresenceStanza == null) {
            this.relayStanza(contact, this.buildPresenceStanza(user, contact, PresenceStanzaType.UNAVAILABLE, null), sessionContext);
            return null;
        }
        this.relayStanza(contact, this.buildPresenceStanza(user, contact, null, latestPresenceStanza.getInnerElements()), sessionContext);
        return null;
    }

    private void updateLatestPresence(SessionContext sessionContext, Entity user, PresenceStanza stanza) {
        sessionContext.getServerRuntimeContext().getPresenceCache().put(user, stanza);
    }

    private PresenceStanza retrieveLatestPresence(SessionContext sessionContext, Entity user) {
        return sessionContext.getServerRuntimeContext().getPresenceCache().getForBareJID(user.getBareJID());
    }

    private PresenceStanza handleInboundAvailable(PresenceStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext, ResourceRegistry registry) {
        sessionContext.getResponseWriter().write(stanza);
        this.logger.info("{} has become available", (Object)stanza.getFrom().getFullQualifiedName());
        return null;
    }

    private void relayTo(Entity from, List<Entity> tos, PresenceStanza original, SessionContext sessionContext) {
        ArrayList<Attribute> toFromReplacements = new ArrayList<Attribute>(2);
        toFromReplacements.add(new Attribute("from", from.getFullQualifiedName()));
        for (Entity to : tos) {
            toFromReplacements.add(new Attribute("to", to.getFullQualifiedName()));
            Stanza outgoingStanza = (Stanza)StanzaBuilder.createClone(original, true, toFromReplacements).build();
            this.relayStanza(to, outgoingStanza, sessionContext);
            toFromReplacements.remove(toFromReplacements.size() - 1);
        }
    }
}

