/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.core;

import java.nio.charset.Charset;
import java.time.Duration;
import org.apache.sshd.common.Property;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.auth.WelcomeBannerPhase;

public final class CoreModuleProperties {
    public static final Property<String> PROXY_AUTH_CHANNEL_TYPE = Property.string((String)"ssh-agent-factory-proxy-auth-channel-type", (String)"auth-agent-req@openssh.com");
    public static final Property<Boolean> PREFER_UNIX_AGENT = Property.bool((String)"ssh-prefer-unix-agent", (boolean)OsUtils.isUNIX());
    public static final Property<Duration> CHANNEL_OPEN_TIMEOUT = Property.duration((String)"ssh-agent-server-channel-open-timeout", (Duration)Duration.ofSeconds(30L));
    public static final Property<String> PROXY_CHANNEL_TYPE = Property.string((String)"ssh-agent-server-channel-proxy-type", (String)"auth-agent@openssh.com");
    public static final Property<Duration> AUTH_SOCKET_TIMEOUT = Property.duration((String)"ssh-agent-server-proxy-auth-socket-timeout", (Duration)Duration.ofHours(1L));
    public static final int DEFAULT_FORWARDER_BUF_SIZE = 1024;
    public static final int MIN_FORWARDER_BUF_SIZE = 127;
    public static final int MAX_FORWARDER_BUF_SIZE = Short.MAX_VALUE;
    public static final Property<Integer> FORWARDER_BUFFER_SIZE = Property.integer((String)"channel-agent-fwd-buf-size", (int)1024);
    public static final Property<String> PREFERRED_AUTHS = Property.string((String)"preferred-auths");
    public static final Property<Integer> PASSWORD_PROMPTS = Property.integer((String)"password-prompts", (int)3);
    public static final Property<String> CLIENT_IDENTIFICATION = Property.string((String)"client-identification");
    public static final Property<Boolean> SEND_IMMEDIATE_IDENTIFICATION = Property.bool((String)"send-immediate-identification", (boolean)true);
    public static final Property<Boolean> SEND_IMMEDIATE_KEXINIT = Property.bool((String)"send-immediate-kex-init", (boolean)true);
    public static final Property<Boolean> ALLOW_DHG1_KEX_FALLBACK = Property.bool((String)"allow-dhg1-kex-fallback", (boolean)false);
    public static final Property<Duration> KEX_PROPOSAL_SETUP_TIMEOUT = Property.durationSec((String)"kex-proposal-setup-timeout", (Duration)Duration.ofSeconds(42L), (Duration)Duration.ofSeconds(5L));
    public static final Property<Duration> HEARTBEAT_INTERVAL = Property.duration((String)"heartbeat-interval", (Duration)Duration.ZERO);
    public static final Property<String> HEARTBEAT_REQUEST = Property.string((String)"heartbeat-request", (String)"keepalive@sshd.apache.org");
    public static final Property<Duration> HEARTBEAT_REPLY_WAIT = Property.durationSec((String)"heartbeat-reply-wait", (Duration)Duration.ofMinutes(5L));
    public static final Property<Boolean> IGNORE_INVALID_IDENTITIES = Property.bool((String)"ignore-invalid-identities", (boolean)true);
    public static final Property<Boolean> ABORT_ON_INVALID_CERTIFICATE = Property.bool((String)"abort-on-invalid-certificate", (boolean)false);
    public static final Property<String> INTERACTIVE_LANGUAGE_TAG = Property.string((String)"kb-client-interactive-language-tag", (String)"");
    public static final Property<String> INTERACTIVE_SUBMETHODS = Property.string((String)"kb-client-interactive-sub-methods", (String)"");
    public static final Property<Boolean> REQUEST_EXEC_REPLY = Property.bool((String)"channel-exec-want-reply", (boolean)false);
    public static final Property<Integer> INPUT_STREAM_PUMP_CHUNK_SIZE = Property.integer((String)"stdin-pump-chunk-size", (int)1024);
    public static final Property<Boolean> REQUEST_SHELL_REPLY = Property.bool((String)"channel-shell-want-reply", (boolean)false);
    public static final Property<Boolean> REQUEST_SUBSYSTEM_REPLY = Property.bool((String)"channel-subsystem-want-reply", (boolean)true);
    public static final Property<Boolean> ASYNC_SERVER_STDOUT_CHUNK_BELOW_WINDOW_SIZE = Property.bool((String)"server-async-stdout-chunk-below-window-size", (boolean)false);
    public static final Property<Boolean> ASYNC_SERVER_STDERR_CHUNK_BELOW_WINDOW_SIZE = Property.bool((String)"server-async-stderr-chunk-below-window-size", (boolean)false);
    public static final Property<Integer> PROP_DHGEX_CLIENT_MIN_KEY = Property.integer((String)"dhgex-client-min");
    public static final Property<Integer> PROP_DHGEX_CLIENT_MAX_KEY = Property.integer((String)"dhgex-client-max");
    public static final Property<Integer> PROP_DHGEX_CLIENT_PRF_KEY = Property.integer((String)"dhgex-client-prf");
    public static final long DEFAULT_WINDOW_SIZE = 0x200000L;
    public static final Property<Long> WINDOW_SIZE = Property.long_((String)"window-size", (long)0x200000L);
    public static final Property<Duration> WINDOW_TIMEOUT = Property.duration((String)"window-timeout", (Duration)Duration.ZERO);
    public static final Property<Integer> BUFFERED_IO_OUTPUT_MAX_PENDING_WRITE_SIZE = Property.integer((String)"buffered-io-output-max-pending-write-size", (int)262144);
    public static final Property<Duration> BUFFERED_IO_OUTPUT_MAX_PENDING_WRITE_WAIT = Property.duration((String)"buffered-io-output-max-pending-write-wait", (Duration)Duration.ofSeconds(30L));
    public static final long DEFAULT_MAX_PACKET_SIZE = 32768L;
    public static final Property<Long> MAX_PACKET_SIZE = Property.long_((String)"packet-size", (long)32768L);
    public static final long DEFAULT_LIMIT_PACKET_SIZE = 0x1FFFFFFFL;
    public static final Property<Long> LIMIT_PACKET_SIZE = Property.long_((String)"max-packet-size", (long)0x1FFFFFFFL);
    public static final Property<Integer> NIO_WORKERS = Property.validating((Property)Property.integer((String)"nio-workers", (int)(Runtime.getRuntime().availableProcessors() + 1)), w -> ValidateUtils.checkTrue((w > 0 ? 1 : 0) != 0, (String)"Number of NIO workers must be positive: %d", (Object)w));
    public static final Property<Duration> AUTH_TIMEOUT = Property.duration((String)"auth-timeout", (Duration)Duration.ofMinutes(2L));
    public static final Property<Duration> IDLE_TIMEOUT = Property.duration((String)"idle-timeout", (Duration)Duration.ofMinutes(10L));
    public static final Property<Duration> NIO2_READ_TIMEOUT = Property.duration((String)"nio2-read-timeout", (Duration)Duration.ZERO);
    public static final Property<Duration> NIO2_MIN_WRITE_TIMEOUT = Property.duration((String)"nio2-min-write-timeout", (Duration)Duration.ofSeconds(30L));
    public static final Property<Duration> DISCONNECT_TIMEOUT = Property.duration((String)"disconnect-timeout", (Duration)Duration.ofSeconds(10L));
    public static final Property<Duration> CHANNEL_CLOSE_TIMEOUT = Property.duration((String)"channel-close-timeout", (Duration)Duration.ofSeconds(5L));
    public static final Property<Duration> STOP_WAIT_TIME = Property.duration((String)"stop-wait-time", (Duration)Duration.ofMinutes(1L));
    public static final Property<Integer> SOCKET_BACKLOG = Property.integer((String)"socket-backlog", (int)0);
    public static final Property<Boolean> SOCKET_KEEPALIVE = Property.bool((String)"socket-keepalive", (boolean)false);
    public static final Property<Integer> SOCKET_SNDBUF = Property.integer((String)"socket-sndbuf");
    public static final Property<Integer> SOCKET_RCVBUF = Property.integer((String)"socket-rcvbuf");
    public static final Property<Boolean> SOCKET_REUSEADDR = Property.bool((String)"socket-reuseaddr", (boolean)true);
    public static final Property<Integer> SOCKET_LINGER = Property.integer((String)"socket-linger", (int)-1);
    public static final Property<Boolean> TCP_NODELAY = Property.bool((String)"tcp-nodelay", (boolean)false);
    public static final Property<Integer> NIO2_READ_BUFFER_SIZE = Property.integer((String)"nio2-read-buf-size", (int)32768);
    public static final Property<Integer> MAX_IDENTIFICATION_SIZE = Property.integer((String)"max-identification-size", (int)16384);
    public static final Property<Long> REKEY_BYTES_LIMIT = Property.long_((String)"rekey-bytes-limit", (long)0x40000000L);
    public static final Property<Duration> REKEY_TIME_LIMIT = Property.duration((String)"rekey-time-limit", (Duration)Duration.ofHours(1L));
    public static final Property<Long> REKEY_PACKETS_LIMIT = Property.long_((String)"rekey-packets-limit", (long)0x80000000L);
    public static final Property<Long> REKEY_BLOCKS_LIMIT = Property.long_((String)"rekey-blocks-limit", (long)0L);
    public static final Property<Long> IGNORE_MESSAGE_FREQUENCY = Property.long_((String)"ignore-message-frequency", (long)1024L);
    public static final Property<Integer> IGNORE_MESSAGE_VARIANCE = Property.integer((String)"ignore-message-variance", (int)32);
    public static final Property<Integer> IGNORE_MESSAGE_SIZE = Property.integer((String)"ignore-message-size", (int)16);
    public static final String AGENT_FORWARDING_TYPE = "agent-fw-auth-type";
    public static final String AGENT_FORWARDING_TYPE_IETF = "auth-agent-req";
    public static final String AGENT_FORWARDING_TYPE_OPENSSH = "auth-agent-req@openssh.com";
    public static final Property<Duration> WAIT_FOR_SPACE_TIMEOUT = Property.duration((String)"channel-output-wait-for-space-timeout", (Duration)Duration.ofSeconds(30L));
    public static final Property<Duration> FORWARD_REQUEST_TIMEOUT = Property.duration((String)"tcpip-forward-request-timeout", (Duration)Duration.ofSeconds(15L));
    public static final Property<Integer> MAX_CONCURRENT_CHANNELS = Property.integer((String)"max-sshd-channels", (int)Integer.MAX_VALUE);
    public static final Property<Boolean> SEND_REPLY_FOR_CHANNEL_DATA = Property.bool((String)"send-unknown-channel-data-reply", (boolean)false);
    public static final Property<Integer> MAX_AUTH_REQUESTS = Property.integer((String)"max-auth-requests", (int)20);
    public static final Property<Object> WELCOME_BANNER = Property.object((String)"welcome-banner");
    public static final String AUTO_WELCOME_BANNER_VALUE = "#auto-welcome-banner";
    public static final Property<String> WELCOME_BANNER_LANGUAGE = Property.string((String)"welcome-banner-language", (String)"en");
    public static final Property<WelcomeBannerPhase> WELCOME_BANNER_PHASE = Property.enum_((String)"welcome-banner-phase", WelcomeBannerPhase.class, (Enum)WelcomeBannerPhase.IMMEDIATE);
    public static final Property<Charset> WELCOME_BANNER_CHARSET = Property.charset((String)"welcome-banner-charset", (Charset)Charset.defaultCharset());
    public static final Property<String> AUTH_METHODS = Property.string((String)"auth-methods");
    public static final Property<Integer> MAX_CONCURRENT_SESSIONS = Property.integer((String)"max-concurrent-sessions");
    public static final Property<String> SERVER_EXTRA_IDENTIFICATION_LINES = Property.string((String)"server-extra-identification-lines");
    public static final char SERVER_EXTRA_IDENT_LINES_SEPARATOR = '|';
    public static final Property<String> SERVER_IDENTIFICATION = Property.string((String)"server-identification");
    public static final Property<Duration> COMMAND_EXIT_TIMEOUT = Property.duration((String)"command-exit-timeout", (Duration)Duration.ofMillis(5L));
    public static final Property<String> MODULI_URL = Property.string((String)"moduli-url");
    public static final Property<String> KB_SERVER_INTERACTIVE_NAME = Property.string((String)"kb-server-interactive-name", (String)"Password authentication");
    public static final Property<String> KB_SERVER_INTERACTIVE_INSTRUCTION = Property.string((String)"kb-server-interactive-instruction", (String)"");
    public static final Property<String> KB_SERVER_INTERACTIVE_LANG = Property.string((String)"kb-server-interactive-language", (String)"en-US");
    public static final Property<String> KB_SERVER_INTERACTIVE_PROMPT = Property.string((String)"kb-server-interactive-prompt", (String)"Password: ");
    public static final Property<Boolean> KB_SERVER_INTERACTIVE_ECHO_PROMPT = Property.bool((String)"kb-server-interactive-echo-prompt", (boolean)false);
    public static final Property<Integer> MAX_EXTDATA_BUFSIZE = Property.integer((String)"channel-session-max-extdata-bufsize", (int)0);
    public static final Property<Integer> PROP_DHGEX_SERVER_MIN_KEY = Property.integer((String)"dhgex-server-min");
    public static final Property<Integer> PROP_DHGEX_SERVER_MAX_KEY = Property.integer((String)"dhgex-server-max");
    public static final Property<Duration> PUMP_SLEEP_TIME = Property.duration((String)"inverted-shell-wrapper-pump-sleep", (Duration)Duration.ofMillis(1L));
    public static final Property<Integer> BUFFER_SIZE = Property.integer((String)"inverted-shell-wrapper-buffer-size", (int)8192);
    public static final Property<Duration> X11_OPEN_TIMEOUT = Property.duration((String)"x11-fwd-open-timeout", (Duration)Duration.ofSeconds(30L));
    public static final Property<Integer> X11_DISPLAY_OFFSET = Property.integer((String)"x11-fwd-display-offset", (int)10);
    public static final Property<Integer> X11_MAX_DISPLAYS = Property.integer((String)"x11-fwd-max-display", (int)1000);
    public static final Property<Integer> X11_BASE_PORT = Property.integer((String)"x11-fwd-base-port", (int)6000);
    public static final Property<String> X11_BIND_HOST = Property.string((String)"x11-fwd-bind-host", (String)"127.0.0.1");

    private CoreModuleProperties() {
        throw new UnsupportedOperationException("No instance");
    }
}

