/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli.server;

import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sshd.cli.CliLogger;
import org.apache.sshd.cli.CliSupport;
import org.apache.sshd.cli.server.helper.ScpCommandTransferEventListener;
import org.apache.sshd.cli.server.helper.ServerPortForwardingEventListener;
import org.apache.sshd.cli.server.helper.SftpServerSubSystemEventListener;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.forward.PortForwardingEventListener;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.keyprovider.MappedKeyPairProvider;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ReflectionUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.scp.common.ScpTransferEventListener;
import org.apache.sshd.scp.server.ScpCommandFactory;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.config.SshServerConfigFileReader;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.apache.sshd.server.keyprovider.AbstractGeneratorHostKeyProvider;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.shell.InteractiveProcessShellFactory;
import org.apache.sshd.server.shell.ProcessShellCommandFactory;
import org.apache.sshd.server.shell.ShellFactory;
import org.apache.sshd.server.subsystem.SubsystemFactory;
import org.apache.sshd.sftp.server.SftpEventListener;
import org.apache.sshd.sftp.server.SftpSubsystemFactory;
import org.slf4j.Logger;

public abstract class SshServerCliSupport
extends CliSupport {
    public static final String SHELL_FACTORY_OPTION = "ShellFactory";
    public static final ShellFactory DEFAULT_SHELL_FACTORY = InteractiveProcessShellFactory.INSTANCE;

    protected SshServerCliSupport() {
    }

    public static KeyPairProvider resolveServerKeys(PrintStream stderr, String hostKeyType, int hostKeySize, Collection<String> keyFiles) throws Exception {
        if (GenericUtils.isEmpty(keyFiles)) {
            List keys;
            KeyPair kp;
            PublicKey pubKey;
            String keyAlgorithm;
            AbstractGeneratorHostKeyProvider hostKeyProvider;
            Path hostKeyFile;
            if (SecurityUtils.isBouncyCastleRegistered()) {
                hostKeyFile = Paths.get("key.pem", new String[0]);
                hostKeyProvider = SecurityUtils.createGeneratorHostKeyProvider((Path)hostKeyFile);
            } else {
                hostKeyFile = Paths.get("key.ser", new String[0]);
                hostKeyProvider = new SimpleGeneratorHostKeyProvider(hostKeyFile);
            }
            hostKeyProvider.setAlgorithm(hostKeyType);
            if (hostKeySize != 0) {
                hostKeyProvider.setKeySize(hostKeySize);
            }
            if ("ECDSA".equalsIgnoreCase(keyAlgorithm = (pubKey = (kp = (KeyPair)(keys = (List)ValidateUtils.checkNotNullAndNotEmpty((Collection)hostKeyProvider.loadKeys(null), (String)"Failed to load keys from %s", (Object[])new Object[]{hostKeyFile})).get(0)).getPublic()).getAlgorithm())) {
                keyAlgorithm = "EC";
            } else if ("ED25519".equals(keyAlgorithm)) {
                keyAlgorithm = "EdDSA";
            }
            if (!Objects.equals(keyAlgorithm, hostKeyType)) {
                Files.deleteIfExists(hostKeyFile);
                hostKeyProvider.clearLoadedKeys();
            }
            return hostKeyProvider;
        }
        ArrayList<KeyPair> pairs = new ArrayList<KeyPair>(keyFiles.size());
        for (String keyFilePath : keyFiles) {
            Iterable ids;
            Path path = Paths.get(keyFilePath, new String[0]);
            PathResource location = new PathResource(path);
            try (InputStream inputStream = location.openInputStream();){
                ids = SecurityUtils.loadKeyPairIdentities(null, (NamedResource)location, (InputStream)inputStream, null);
            }
            catch (Exception e) {
                stderr.append("ERROR: Failed (").append(e.getClass().getSimpleName()).append(')').append(" to load host key file=").append(keyFilePath).append(": ").println(e.getMessage());
                stderr.flush();
                throw e;
            }
            if (ids == null) {
                stderr.append("WARNING: No keys loaded from ").println(keyFilePath);
                continue;
            }
            for (KeyPair kp : ids) {
                if (kp == null) {
                    stderr.append("WARNING: empty key found in ").println(keyFilePath);
                    continue;
                }
                pairs.add(kp);
            }
        }
        return new MappedKeyPairProvider(ValidateUtils.checkNotNullAndNotEmpty(pairs, (String)"No key pairs loaded for provided key files", (Object[])new Object[0]));
    }

    public static ForwardingFilter setupServerForwarding(SshServer server, Level level, PrintStream stdout, PrintStream stderr, PropertyResolver options) {
        ForwardingFilter forwardFilter = SshServerConfigFileReader.resolveServerForwarding((PropertyResolver)options);
        server.setForwardingFilter(forwardFilter);
        if (CliLogger.isEnabledVerbosityLogging(level)) {
            Logger logger = CliLogger.resolveLogger(SshServerCliSupport.class, level, stdout, stderr);
            server.addPortForwardingEventListener((PortForwardingEventListener)new ServerPortForwardingEventListener(logger));
        }
        return forwardFilter;
    }

    public static Object setupServerBanner(ServerFactoryManager server, PropertyResolver options) {
        Object banner = SshServerConfigFileReader.resolveBanner((PropertyResolver)options);
        CoreModuleProperties.WELCOME_BANNER.set((PropertyResolver)server, banner);
        return banner;
    }

    public static List<SubsystemFactory> resolveServerSubsystems(ServerFactoryManager server, Level level, PrintStream stdout, PrintStream stderr, PropertyResolver options) throws Exception {
        String nameList;
        ClassLoader cl = ThreadUtils.resolveDefaultClassLoader(SubsystemFactory.class);
        String classList = System.getProperty(SubsystemFactory.class.getName());
        if (GenericUtils.isNotEmpty((CharSequence)classList)) {
            String[] classes = GenericUtils.split((String)classList, (char)',');
            ArrayList<SubsystemFactory> subsystems = new ArrayList<SubsystemFactory>(classes.length);
            for (String fqcn : classes) {
                try {
                    Class<?> clazz = cl.loadClass(fqcn);
                    SubsystemFactory factory = (SubsystemFactory)ReflectionUtils.newInstance(clazz, SubsystemFactory.class);
                    factory = SshServerCliSupport.registerSubsystemFactoryListeners(server, level, stdout, stderr, options, factory);
                    subsystems.add(factory);
                }
                catch (Exception e) {
                    stderr.append("ERROR: Failed (").append(e.getClass().getSimpleName()).append(')').append(" to instantiate subsystem=").append(fqcn).append(": ").println(e.getMessage());
                    stderr.flush();
                    throw e;
                }
            }
            return subsystems;
        }
        String string = nameList = options == null ? null : options.getString("Subsystem");
        if (PropertyResolverUtils.isNoneValue((String)nameList)) {
            return Collections.emptyList();
        }
        if ("sftp".equalsIgnoreCase(nameList)) {
            SftpSubsystemFactory factory = SshServerCliSupport.registerSubsystemFactoryListeners(server, level, stdout, stderr, options, new SftpSubsystemFactory());
            PrintStream logStream = CliLogger.resolvePrintStream(level, stdout, stderr);
            CliLogger.log(logStream, level, "Using built-in SFTP subsystem");
            return Collections.singletonList(factory);
        }
        boolean havePreferences = GenericUtils.isNotEmpty((CharSequence)nameList);
        Set preferredNames = !havePreferences ? Collections.emptySet() : (Collection)Stream.of(GenericUtils.split((String)nameList, (char)',')).collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER)));
        ServiceLoader<SubsystemFactory> loader = ServiceLoader.load(SubsystemFactory.class, cl);
        ArrayList<SubsystemFactory> subsystems = new ArrayList<SubsystemFactory>();
        for (SubsystemFactory factory : loader) {
            String name = factory.getName();
            if (havePreferences && !preferredNames.contains(name)) continue;
            factory = SshServerCliSupport.registerSubsystemFactoryListeners(server, level, stdout, stderr, options, factory);
            subsystems.add(factory);
        }
        return subsystems;
    }

    public static <F extends SubsystemFactory> F registerSubsystemFactoryListeners(ServerFactoryManager server, Level level, PrintStream stdout, PrintStream stderr, PropertyResolver options, F factory) throws Exception {
        if (factory instanceof SftpSubsystemFactory) {
            if (CliLogger.isEnabledVerbosityLogging(level)) {
                Logger logger = CliLogger.resolveLogger(SftpEventListener.class, level, stdout, stderr);
                SftpServerSubSystemEventListener listener = new SftpServerSubSystemEventListener(logger);
                ((SftpSubsystemFactory)factory).addSftpEventListener((SftpEventListener)listener);
            }
            SshServerConfigFileReader.setupSftpSubsystem((ServerFactoryManager)server, (PropertyResolver)options);
        }
        return factory;
    }

    public static ShellFactory resolveShellFactory(Level level, PrintStream stdout, PrintStream stderr, PropertyResolver options) throws Exception {
        String factory;
        String string = factory = options == null ? null : options.getString(SHELL_FACTORY_OPTION);
        if (GenericUtils.isEmpty((CharSequence)factory)) {
            return DEFAULT_SHELL_FACTORY;
        }
        if (PropertyResolverUtils.isNoneValue((String)factory)) {
            return null;
        }
        if ("scp".equalsIgnoreCase(factory)) {
            return SshServerCliSupport.createScpCommandFactory(level, stdout, stderr, null);
        }
        if ("+scp".equalsIgnoreCase(factory)) {
            return SshServerCliSupport.createScpCommandFactory(level, stdout, stderr, DEFAULT_SHELL_FACTORY);
        }
        boolean useScp = false;
        if (factory.startsWith("scp+")) {
            factory = factory.substring("scp".length() + 1);
            ValidateUtils.checkNotNullAndNotEmpty((String)factory, (String)"No extra custom shell factory class specified");
            useScp = true;
        }
        ClassLoader cl = ThreadUtils.resolveDefaultClassLoader(ShellFactory.class);
        try {
            Class<?> clazz = cl.loadClass(factory);
            ShellFactory shellFactory = (ShellFactory)ReflectionUtils.newInstance(clazz, ShellFactory.class);
            return useScp ? SshServerCliSupport.createScpCommandFactory(level, stdout, stderr, shellFactory) : shellFactory;
        }
        catch (Exception e) {
            stderr.append("ERROR: Failed (").append(e.getClass().getSimpleName()).append(')').append(" to instantiate shell factory=").append(factory).append(": ").println(e.getMessage());
            stderr.flush();
            throw e;
        }
    }

    public static ScpCommandFactory createScpCommandFactory(Level level, PrintStream stdout, PrintStream stderr, ShellFactory delegateShellFactory) {
        ScpCommandFactory.Builder scp = new ScpCommandFactory.Builder().withDelegate((CommandFactory)ProcessShellCommandFactory.INSTANCE).withDelegateShellFactory(delegateShellFactory);
        if (CliLogger.isEnabledVerbosityLogging(level)) {
            Logger logger = CliLogger.resolveLogger(ScpTransferEventListener.class, level, stdout, stderr);
            scp.addEventListener((ScpTransferEventListener)new ScpCommandTransferEventListener(logger));
        }
        return scp.build();
    }
}

