/*
 * Decompiled with CFR 0.152.
 */
package org.c02e.jpgpj;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPDataValidationException;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPMarker;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.c02e.jpgpj.DecryptionException;
import org.c02e.jpgpj.DecryptionResult;
import org.c02e.jpgpj.FileMetadata;
import org.c02e.jpgpj.JcaContextHelper;
import org.c02e.jpgpj.Key;
import org.c02e.jpgpj.PassphraseException;
import org.c02e.jpgpj.Ring;
import org.c02e.jpgpj.Subkey;
import org.c02e.jpgpj.VerificationException;
import org.c02e.jpgpj.util.FileDetection;
import org.c02e.jpgpj.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Decryptor
implements Cloneable {
    public static final int DEFAULT_MAX_FILE_BUFFER_SIZE = 0x100000;
    public static final boolean DEFAULT_VERIFICATION_REQUIRED = true;
    public static final int DEFAULT_COPY_FILE_BUFFER_SIZE = 16384;
    public static final boolean DEFAULT_LOGGING_ENABLED = false;
    protected boolean verificationRequired = true;
    protected char[] symmetricPassphraseChars;
    @Deprecated
    protected String symmetricPassphrase;
    protected int maxFileBufferSize = 0x100000;
    protected int copyFileBufferSize = 16384;
    protected boolean loggingEnabled = false;
    protected Ring ring;
    protected final Logger log = LoggerFactory.getLogger((String)Decryptor.class.getName());

    public Decryptor() {
        this(new Ring());
    }

    public Decryptor(Ring ring) {
        this.setSymmetricPassphraseChars(null);
        this.setRing(ring);
    }

    public Decryptor(Key ... keys) {
        this(new Ring(keys));
    }

    public boolean isVerificationRequired() {
        return this.verificationRequired;
    }

    public void setVerificationRequired(boolean x) {
        this.verificationRequired = x;
    }

    public Decryptor withVerificationRequired(boolean x) {
        this.setVerificationRequired(x);
        return this;
    }

    public char[] getSymmetricPassphraseChars() {
        return this.symmetricPassphraseChars;
    }

    public void setSymmetricPassphraseChars(char[] x) {
        if (x == null) {
            x = new char[]{};
        }
        if (!Arrays.equals(x, this.symmetricPassphraseChars)) {
            this.symmetricPassphraseChars = x;
            this.symmetricPassphrase = null;
        }
    }

    public Decryptor withSymmetricPassphraseChars(char[] x) {
        this.setSymmetricPassphraseChars(x);
        return this;
    }

    public String getSymmetricPassphrase() {
        if (this.symmetricPassphrase == null) {
            this.symmetricPassphrase = new String(this.symmetricPassphraseChars);
        }
        return this.symmetricPassphrase;
    }

    public void setSymmetricPassphrase(String x) {
        this.setSymmetricPassphraseChars(x != null ? x.toCharArray() : null);
        this.symmetricPassphrase = x;
    }

    public Decryptor withSymmetricPassphrase(String x) {
        this.setSymmetricPassphrase(x);
        return this;
    }

    public int getMaxFileBufferSize() {
        return this.maxFileBufferSize;
    }

    public void setMaxFileBufferSize(int maxFileBufferSize) {
        this.maxFileBufferSize = maxFileBufferSize;
    }

    public Decryptor withMaxFileBufferSize(int maxFileBufferSize) {
        this.setMaxFileBufferSize(maxFileBufferSize);
        return this;
    }

    public int getCopyFileBufferSize() {
        return this.copyFileBufferSize;
    }

    public void setCopyFileBufferSize(int copyFileBufferSize) {
        this.copyFileBufferSize = copyFileBufferSize;
    }

    public Decryptor withCopyFileBufferSize(int copyFileBufferSize) {
        this.setCopyFileBufferSize(copyFileBufferSize);
        return this;
    }

    public Ring getRing() {
        return this.ring;
    }

    public void setRing(Ring x) {
        this.ring = x != null ? x : new Ring();
    }

    public Decryptor withRing(Ring x) {
        this.setRing(x);
        return this;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(boolean enabled) {
        this.loggingEnabled = enabled;
    }

    public Decryptor withLoggingEnabled(boolean enabled) {
        this.setLoggingEnabled(enabled);
        return this;
    }

    public void clearSecrets() {
        this.ring.clearSecrets();
        Arrays.fill(this.symmetricPassphraseChars, '\u0000');
        this.symmetricPassphraseChars = new char[0];
        this.symmetricPassphrase = null;
    }

    public FileMetadata decrypt(File ciphertext, File plaintext) throws IOException, PGPException {
        return this.decrypt(ciphertext.toPath(), plaintext.toPath());
    }

    /*
     * Exception decompiling
     */
    public FileMetadata decrypt(Path ciphertext, Path plaintext) throws IOException, PGPException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public InputStream wrapSourceInputStream(InputStream sourceStream, long inputSize) throws IOException {
        int bestFileBufferSize = Util.bestFileBufferSize(inputSize, this.getMaxFileBufferSize());
        return new BufferedInputStream(sourceStream, bestFileBufferSize);
    }

    public OutputStream wrapTargetOutputStream(OutputStream targetStream, long inputSize) throws IOException {
        int bestFileBufferSize = Util.bestFileBufferSize(inputSize, this.getMaxFileBufferSize());
        return new BufferedOutputStream(targetStream, bestFileBufferSize);
    }

    public FileMetadata decrypt(InputStream ciphertext, OutputStream plaintext) throws IOException, PGPException {
        DecryptionResult result = this.decryptWithFullDetails(ciphertext, plaintext);
        return result.getFileMetadata();
    }

    public DecryptionResult decryptWithFullDetails(InputStream ciphertext, OutputStream plaintext) throws IOException, PGPException {
        FileMetadata metadata;
        InputStream unarmoredStream = this.unarmor(ciphertext);
        List<FileMetadata> meta = this.unpack(this.parse(unarmoredStream), plaintext);
        if (meta.size() > 1) {
            throw new PGPException("content contained more than one file");
        }
        FileMetadata fileMetadata = metadata = meta.size() < 1 ? new FileMetadata() : meta.get(0);
        if (unarmoredStream instanceof ArmoredInputStream) {
            ArmoredInputStream ais = (ArmoredInputStream)unarmoredStream;
            String[] headers = ais.getArmorHeaders();
            return new DecryptionResult(metadata, true, headers == null || headers.length == 0 ? Collections.emptyList() : Arrays.asList(headers));
        }
        return new DecryptionResult(metadata, false, Collections.emptyList());
    }

    protected List<FileMetadata> unpack(Iterator<?> packets, OutputStream plaintext) throws IOException, PGPException {
        ArrayList<FileMetadata> meta = new ArrayList<FileMetadata>();
        List<Verifier> verifiers = new ArrayList<Verifier>();
        boolean logUnpacking = this.isLoggingEnabled();
        while (packets.hasNext()) {
            PGPOnePassSignatureList list;
            Object packet = packets.next();
            if (logUnpacking) {
                this.log.trace("unpack {}", packet.getClass());
            }
            if (packet instanceof PGPMarker) continue;
            if (packet instanceof PGPOnePassSignatureList) {
                list = (PGPOnePassSignatureList)packet;
                verifiers = this.buildVerifiers(list.iterator());
                continue;
            }
            if (packet instanceof PGPSignatureList) {
                list = (PGPSignatureList)packet;
                if (Util.isEmpty(verifiers)) {
                    verifiers = this.buildVerifiers(list.iterator());
                    continue;
                }
                this.matchSignatures(list.iterator(), verifiers);
                continue;
            }
            if (packet instanceof PGPEncryptedDataList) {
                list = (PGPEncryptedDataList)packet;
                meta.addAll(this.unpack(this.parse(this.decrypt(list.iterator())), plaintext));
                continue;
            }
            if (packet instanceof PGPCompressedData) {
                InputStream i = ((PGPCompressedData)packet).getDataStream();
                meta.addAll(this.unpack(this.parse(i), plaintext));
                continue;
            }
            if (packet instanceof PGPLiteralData) {
                PGPLiteralData data = (PGPLiteralData)packet;
                FileMetadata file = new FileMetadata(data);
                InputStream i = data.getDataStream();
                file.setLength(this.copy(i, plaintext, verifiers));
                meta.add(file);
                continue;
            }
            throw new PGPException("unexpected packet: " + packet.getClass());
        }
        if (logUnpacking) {
            this.log.trace("unpacked all");
        }
        this.verify(verifiers, meta);
        return meta;
    }

    protected List<Verifier> buildVerifiers(Iterator<?> signatures) throws PGPException {
        ArrayList<Verifier> verifiers = new ArrayList<Verifier>();
        while (signatures.hasNext()) {
            Verifier verifier = null;
            Object signature = signatures.next();
            if (signature instanceof PGPSignature) {
                verifier = new Verifier((PGPSignature)signature);
            } else if (signature instanceof PGPOnePassSignature) {
                verifier = new Verifier((PGPOnePassSignature)signature);
            }
            if (verifier == null || !verifier.isKeyAvailable()) continue;
            verifiers.add(verifier);
        }
        return verifiers;
    }

    protected void matchSignatures(Iterator<PGPSignature> signatures, List<Verifier> verifiers) {
        while (signatures.hasNext()) {
            PGPSignature signature = signatures.next();
            for (Verifier verifier : verifiers) {
                verifier.match(signature);
            }
        }
    }

    protected InputStream decrypt(Iterator<?> data) throws IOException, PGPException {
        PGPPBEEncryptedData pbe = null;
        Ring decryptRing = this.getRing();
        boolean logDecryption = this.isLoggingEnabled();
        while (data.hasNext()) {
            Object o = data.next();
            if (o instanceof PGPPublicKeyEncryptedData) {
                PGPPublicKeyEncryptedData pke = (PGPPublicKeyEncryptedData)o;
                Long id = pke.getKeyID();
                List<Key> keys = decryptRing.findAll(id);
                for (Key key : keys) {
                    Subkey subkey = key.findById(id);
                    if (this.isUsableForDecryption(subkey)) {
                        return this.decrypt(pke, subkey);
                    }
                    if (!logDecryption) continue;
                    this.log.info("not using decryption key {}", (Object)subkey);
                }
                if (!Util.isEmpty(keys) || !logDecryption) continue;
                this.log.info("not found decryption key {}", (Object)Util.formatKeyId(id));
                continue;
            }
            if (!(o instanceof PGPPBEEncryptedData) || pbe != null) continue;
            pbe = (PGPPBEEncryptedData)o;
        }
        return this.decrypt(pbe);
    }

    protected InputStream decrypt(PGPPublicKeyEncryptedData data, Subkey subkey) throws IOException, PGPException {
        if (data == null || subkey == null) {
            throw new DecryptionException("no suitable decryption key found");
        }
        if (this.isLoggingEnabled()) {
            this.log.info("using decryption key {}", (Object)subkey);
        }
        return data.getDataStream(this.buildPublicKeyDecryptor(subkey));
    }

    protected InputStream decrypt(PGPPBEEncryptedData data) throws IOException, PGPException {
        char[] passphraseChars = this.getSymmetricPassphraseChars();
        if (data == null || Util.isEmpty(passphraseChars)) {
            throw new DecryptionException("no suitable decryption key found");
        }
        try {
            return data.getDataStream(this.buildSymmetricKeyDecryptor(passphraseChars));
        }
        catch (PGPDataValidationException e) {
            throw new PassphraseException("incorrect passphrase for symmetric key", (Exception)((Object)e));
        }
    }

    protected long copy(InputStream i, OutputStream o, List<Verifier> verifiers) throws IOException, PGPException {
        long total = 0L;
        byte[] buf = this.getCopyBuffer();
        int len = i.read(buf);
        boolean verifyResult = this.isVerificationRequired();
        if (verifyResult && Util.isEmpty(verifiers)) {
            throw new VerificationException("content not signed with a required key");
        }
        while (len != -1) {
            total += (long)len;
            if (verifyResult) {
                for (Verifier verifier : verifiers) {
                    if (verifier.sig != null) {
                        verifier.sig.update(buf, 0, len);
                        continue;
                    }
                    verifier.sig1.update(buf, 0, len);
                }
            }
            o.write(buf, 0, len);
            len = i.read(buf);
        }
        return total;
    }

    protected void verify(List<Verifier> verifiers, List<FileMetadata> meta) throws PGPException {
        if (!this.isVerificationRequired()) {
            return;
        }
        for (Verifier verifier : verifiers) {
            if (!verifier.verify()) {
                throw new VerificationException("bad signature for key " + verifier.key);
            }
            if (this.isLoggingEnabled()) {
                this.log.debug("good signature for key {}", (Object)verifier.key);
            }
            Key key = verifier.getSignedBy();
            for (FileMetadata file : meta) {
                Ring verified = file.getVerified();
                List<Key> keys = verified.getKeys();
                keys.add(key);
            }
        }
    }

    protected InputStream unarmor(InputStream stream) throws IOException, PGPException {
        FileDetection.DetectionResult result = FileDetection.detectContainer(stream, this.getMaxFileBufferSize());
        switch (result.type) {
            case ASCII_ARMOR: {
                return new ArmoredInputStream(result.stream);
            }
            case PGP: {
                return result.stream;
            }
        }
        throw new PGPException("not a pgp message");
    }

    protected Iterator<?> parse(InputStream stream) {
        return new PGPObjectFactory(stream, (KeyFingerPrintCalculator)JcaContextHelper.getJcaKeyFingerprintCalculator()).iterator();
    }

    protected PGPContentVerifierBuilderProvider getVerifierProvider() {
        return JcaContextHelper.getPGPContentVerifierBuilderProvider();
    }

    protected boolean isUsableForDecryption(Subkey subkey) {
        return subkey != null && subkey.isForDecryption() && (subkey.isUnlocked() || !Util.isEmpty(subkey.passphraseChars));
    }

    protected PublicKeyDataDecryptorFactory buildPublicKeyDecryptor(Subkey subkey) throws PGPException {
        PGPPrivateKey privateKey = subkey.getPrivateKey();
        if (privateKey == null) {
            throw new PGPException("no private key for " + subkey);
        }
        return JcaContextHelper.getJcePublicKeyDataDecryptorFactoryBuilder().build(privateKey);
    }

    protected PBEDataDecryptorFactory buildSymmetricKeyDecryptor(char[] passphraseChars) throws PGPException {
        return JcaContextHelper.getJcePBEDataDecryptorFactoryBuilder().build(passphraseChars);
    }

    public byte[] getCopyBuffer() {
        return new byte[this.getCopyFileBufferSize()];
    }

    public Decryptor clone() {
        try {
            Decryptor other = (Decryptor)this.getClass().cast(super.clone());
            char[] thisChars = this.getSymmetricPassphraseChars();
            other.symmetricPassphraseChars = thisChars == null ? null : (char[])thisChars.clone();
            Ring thisRing = this.getRing();
            Ring clonedRing = thisRing == null ? null : thisRing.clone();
            other.setRing(clonedRing);
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException("Unexpected clone failure for " + this);
        }
    }

    protected class Verifier {
        public Key key;
        public PGPSignature sig;
        public PGPOnePassSignature sig1;

        public Verifier() {
        }

        public Verifier(PGPSignature s) throws PGPException {
            this.setSig(s);
        }

        public Verifier(PGPOnePassSignature s) throws PGPException {
            this.setSig1(s);
        }

        public boolean isKeyAvailable() {
            return this.key != null;
        }

        public void setSig(PGPSignature s) throws PGPException {
            this.sig = s;
            if (this.sig1 != null) {
                return;
            }
            Subkey subkey = this.findVerificationSubkey(s.getKeyID());
            if (subkey != null) {
                s.init(Decryptor.this.getVerifierProvider(), subkey.getPublicKey());
            }
        }

        public void setSig1(PGPOnePassSignature s) throws PGPException {
            this.sig1 = s;
            Subkey subkey = this.findVerificationSubkey(s.getKeyID());
            if (subkey != null) {
                s.init(Decryptor.this.getVerifierProvider(), subkey.getPublicKey());
            }
        }

        public boolean match(PGPSignature s) {
            if (this.sig1 != null && this.sig1.getKeyID() == s.getKeyID()) {
                this.sig = s;
                return true;
            }
            return false;
        }

        public boolean verify() throws PGPException {
            if (this.key == null || this.sig == null) {
                return false;
            }
            return this.sig1 != null ? this.sig1.verify(this.sig) : this.sig.verify();
        }

        public Key getSignedBy() throws PGPException {
            if (this.key == null || this.sig == null) {
                return null;
            }
            String uid = null;
            PGPSignatureSubpacketVector subpackets = this.sig.getHashedSubPackets();
            if (subpackets != null) {
                uid = subpackets.getSignerUserID();
            }
            Key by = this.key.toPublicKey();
            by.setSigningUid(uid != null ? uid : "");
            return by;
        }

        protected Subkey findVerificationSubkey(Long id) {
            Ring decryptorRing = Decryptor.this.getRing();
            List<Key> keys = decryptorRing.findAll(id);
            boolean logVerification = Decryptor.this.isLoggingEnabled();
            for (Key key : keys) {
                Subkey subkey = key.findById(id);
                if (subkey != null && subkey.isForVerification()) {
                    if (logVerification) {
                        Decryptor.this.log.info("using verification key {} for ID={}", (Object)subkey, (Object)Util.formatKeyId(id));
                    }
                    this.key = key;
                    return subkey;
                }
                if (!logVerification) continue;
                Decryptor.this.log.info("not using verification key {} for ID={}", (Object)subkey, (Object)Util.formatKeyId(id));
            }
            if (Util.isEmpty(keys) && logVerification) {
                Decryptor.this.log.info("not found verification key {}", (Object)Util.formatKeyId(id));
            }
            return null;
        }
    }
}

