/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.util.Arrays;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.integration.channel.interceptor.GlobalChannelInterceptorWrapper;
import org.springframework.integration.config.GlobalChannelInterceptor;
import org.springframework.integration.config.IntegrationConfigurationInitializer;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.util.CollectionUtils;

public class GlobalChannelInterceptorInitializer
implements IntegrationConfigurationInitializer {
    private ConfigurableListableBeanFactory beanFactory;
    private BeanExpressionContext beanExpressionContext;

    @Override
    public void initialize(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        this.beanExpressionContext = new BeanExpressionContext((ConfigurableBeanFactory)beanFactory, null);
        for (String beanName : registry.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(beanName);
            if (!(beanDefinition instanceof AnnotatedBeanDefinition)) continue;
            AnnotationMetadata metadata = ((AnnotatedBeanDefinition)beanDefinition).getMetadata();
            Map annotationAttributes = metadata.getAnnotationAttributes(GlobalChannelInterceptor.class.getName());
            if (CollectionUtils.isEmpty((Map)annotationAttributes) && beanDefinition.getSource() instanceof MethodMetadata) {
                MethodMetadata beanMethod = (MethodMetadata)beanDefinition.getSource();
                annotationAttributes = beanMethod.getAnnotationAttributes(GlobalChannelInterceptor.class.getName());
            }
            if (CollectionUtils.isEmpty((Map)annotationAttributes)) continue;
            Map attributes = annotationAttributes;
            RootBeanDefinition channelInterceptorWrapper = new RootBeanDefinition(GlobalChannelInterceptorWrapper.class, () -> this.createGlobalChannelInterceptorWrapper(beanName, attributes));
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)channelInterceptorWrapper, (BeanDefinitionRegistry)registry);
        }
    }

    private GlobalChannelInterceptorWrapper createGlobalChannelInterceptorWrapper(String interceptorBeanName, Map<String, Object> annotationAttributes) {
        ChannelInterceptor interceptor = (ChannelInterceptor)this.beanFactory.getBean(interceptorBeanName, ChannelInterceptor.class);
        GlobalChannelInterceptorWrapper interceptorWrapper = new GlobalChannelInterceptorWrapper(interceptor);
        String[] patterns = (String[])Arrays.stream((String[])annotationAttributes.get("patterns")).map(this::resolveEmbeddedValue).toArray(String[]::new);
        interceptorWrapper.setPatterns(patterns);
        interceptorWrapper.setOrder((Integer)annotationAttributes.get("order"));
        return interceptorWrapper;
    }

    private String resolveEmbeddedValue(String value) {
        String valueToReturn = this.beanFactory.resolveEmbeddedValue(value);
        if (valueToReturn == null || !valueToReturn.startsWith("#{") || !value.endsWith("}")) {
            return valueToReturn;
        }
        BeanExpressionResolver beanExpressionResolver = this.beanFactory.getBeanExpressionResolver();
        if (beanExpressionResolver != null) {
            Object result = beanExpressionResolver.evaluate(valueToReturn, this.beanExpressionContext);
            return result != null ? result.toString() : null;
        }
        return null;
    }
}

