/*
 * Decompiled with CFR 0.152.
 */
package org.c02e.jpgpj;

import java.io.File;
import java.util.Date;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.c02e.jpgpj.Ring;

public class FileMetadata {
    public static final String DEFAULT_NAME = "";
    public static final Format DEFAULT_FORMAT = Format.BINARY;
    protected String name;
    protected Format format;
    protected long length;
    protected long lastModified;
    protected Ring verified = new Ring();

    public FileMetadata() {
        this(DEFAULT_NAME);
    }

    public FileMetadata(PGPLiteralData data) {
        this(data.getFileName(), Format.byCode((char)data.getFormat()));
        Date modificationTime = data.getModificationTime();
        if (modificationTime != null) {
            this.setLastModified(modificationTime.getTime());
        }
    }

    public FileMetadata(File file) {
        this(DEFAULT_NAME, DEFAULT_FORMAT);
        this.setFile(file);
    }

    public FileMetadata(String name) {
        this(name, DEFAULT_FORMAT);
    }

    public FileMetadata(String name, Format format) {
        this(name, format, 0L, 0L);
    }

    public FileMetadata(String name, Format format, long length, long lastModified) {
        this.setName(name);
        this.setFormat(format);
        this.setLength(length);
        this.setLastModified(lastModified);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String x) {
        this.name = x != null ? x : DEFAULT_NAME;
    }

    public FileMetadata withName(String x) {
        this.setName(x);
        return this;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long x) {
        this.length = x;
    }

    public FileMetadata withLength(long x) {
        this.setLength(x);
        return this;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long x) {
        this.lastModified = x;
    }

    public FileMetadata withLastModified(long x) {
        this.setLastModified(x);
        return this;
    }

    public Date getLastModifiedDate() {
        return new Date(this.getLastModified());
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format x) {
        this.format = x != null ? x : Format.BINARY;
    }

    public FileMetadata withFormat(Format x) {
        this.setFormat(x);
        return this;
    }

    public Ring getVerified() {
        return this.verified;
    }

    public void setFile(File file) {
        if (file == null) {
            return;
        }
        this.setName(file.getName());
        this.setLength(file.length());
        this.setLastModified(file.lastModified());
    }

    public FileMetadata withFile(File file) {
        this.setFile(file);
        return this;
    }

    public int getSignatureType() {
        return this.format == Format.TEXT || this.format == Format.UTF8 ? 1 : 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + ", length=" + this.getLength() + ", format=" + (Object)((Object)this.getFormat()) + ", lastModified=" + this.getLastModifiedDate() + "]";
    }

    public static enum Format {
        BINARY('b'),
        TEXT('t'),
        UTF8('u');

        protected char code;

        private Format(char code) {
            this.code = code;
        }

        public char getCode() {
            return this.code;
        }

        public static Format byCode(char code) {
            switch (code) {
                case 'b': {
                    return BINARY;
                }
                case 't': {
                    return TEXT;
                }
                case 'u': {
                    return UTF8;
                }
            }
            return null;
        }
    }
}

