/*
 * Decompiled with CFR 0.152.
 */
package org.c02e.jpgpj;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.util.Strings;
import org.c02e.jpgpj.CompressionAlgorithm;
import org.c02e.jpgpj.EncryptedAsciiArmorHeadersCallback;
import org.c02e.jpgpj.EncryptedAsciiArmorHeadersManipulator;
import org.c02e.jpgpj.EncryptionAlgorithm;
import org.c02e.jpgpj.FileMetadata;
import org.c02e.jpgpj.HashingAlgorithm;
import org.c02e.jpgpj.Key;
import org.c02e.jpgpj.Ring;
import org.c02e.jpgpj.Subkey;
import org.c02e.jpgpj.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Encryptor {
    public static final int MAX_ENCRYPT_COPY_BUFFER_SIZE = 65536;
    public static final boolean DEFAULT_ASCII_ARMORED = false;
    public static final boolean DEFAULT_REMOVE_DEFAULT_ARMORED_VERSION_HEADER = false;
    public static final int DEFAULT_COMPRESSION_LEVEL = 6;
    public static final CompressionAlgorithm DEFAULT_COMPRESSION_ALGORITHM = CompressionAlgorithm.ZLIB;
    public static final EncryptionAlgorithm DEFAULT_ENCRYPTION_ALGORITHM = EncryptionAlgorithm.AES128;
    public static final HashingAlgorithm DEFAULT_SIGNING_ALGORITHM = HashingAlgorithm.SHA256;
    public static final HashingAlgorithm DEFAULT_KEY_DERIVATION_ALGORITHM = HashingAlgorithm.SHA512;
    public static final int DEFAULT_KEY_DERIVATION_ALGORITHM_WORK_FACTOR = 255;
    public static final int DEFAULT_MAX_FILE_BUFFER_SIZE = 0x100000;
    protected boolean asciiArmored = false;
    protected boolean removeDefaultArmoredVersionHeader = false;
    protected final Map<String, String> armoredHeaders = new HashMap<String, String>();
    protected EncryptedAsciiArmorHeadersCallback armorHeadersCallback;
    protected int compressionLevel = 6;
    protected CompressionAlgorithm compressionAlgorithm = DEFAULT_COMPRESSION_ALGORITHM;
    protected EncryptionAlgorithm encryptionAlgorithm = DEFAULT_ENCRYPTION_ALGORITHM;
    protected HashingAlgorithm signingAlgorithm = DEFAULT_SIGNING_ALGORITHM;
    protected char[] symmetricPassphraseChars;
    @Deprecated
    protected String symmetricPassphrase;
    protected HashingAlgorithm keyDerivationAlgorithm = DEFAULT_KEY_DERIVATION_ALGORITHM;
    protected int keyDerivationWorkFactor = 255;
    protected int maxFileBufferSize = 0x100000;
    protected Ring ring;
    protected final Logger log = LoggerFactory.getLogger((String)Encryptor.class.getName());

    public Encryptor() {
        this(new Ring());
    }

    public Encryptor(Ring ring) {
        this.setSymmetricPassphraseChars(null);
        this.setRing(ring);
    }

    public Encryptor(Key ... keys) {
        this(new Ring(keys));
    }

    public boolean isAsciiArmored() {
        return this.asciiArmored;
    }

    public void setAsciiArmored(boolean x) {
        this.asciiArmored = x;
    }

    public Encryptor withAsciiArmored(boolean x) {
        this.setAsciiArmored(x);
        return this;
    }

    public EncryptedAsciiArmorHeadersCallback getArmorHeadersCallback() {
        return this.armorHeadersCallback;
    }

    public void setArmorHeadersCallback(EncryptedAsciiArmorHeadersCallback x) {
        this.armorHeadersCallback = x;
    }

    public Encryptor withArmorHeadersCallback(EncryptedAsciiArmorHeadersCallback x) {
        this.setArmorHeadersCallback(x);
        return this;
    }

    public boolean isRemoveDefaultArmoredVersionHeader() {
        return this.removeDefaultArmoredVersionHeader;
    }

    public void setRemoveDefaultArmoredVersionHeader(boolean x) {
        this.removeDefaultArmoredVersionHeader = x;
    }

    public Encryptor withRemoveDefaultArmoredVersionHeader(boolean x) {
        this.setRemoveDefaultArmoredVersionHeader(x);
        return this;
    }

    public String getArmoredHeader(String name) {
        Objects.requireNonNull(name, "No header name provided");
        return this.armoredHeaders.get(name);
    }

    public Map<String, String> getArmoredHeaders() {
        if (this.armoredHeaders.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.armoredHeaders);
    }

    public void setArmoredHeaders(Map<String, String> headers) {
        this.armoredHeaders.clear();
        this.addArmoredHeaders(headers);
    }

    public Encryptor withArmoredHeaders(Map<String, String> headers) {
        this.setArmoredHeaders(headers);
        return this;
    }

    public void addArmoredHeaders(Map<String, String> headers) {
        if (headers != null) {
            this.armoredHeaders.putAll(headers);
        }
    }

    public String updateArmoredHeader(String name, String value) {
        if (value == null) {
            return this.removeArmoredHeader(name);
        }
        Objects.requireNonNull(name, "No header name provided");
        return this.armoredHeaders.put(name, value);
    }

    public Encryptor withArmoredHeader(String name, String value) {
        this.updateArmoredHeader(name, value);
        return this;
    }

    public String removeArmoredHeader(String name) {
        Objects.requireNonNull(name, "No header name provided");
        return this.armoredHeaders.remove(name);
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int x) {
        this.compressionLevel = x;
    }

    public Encryptor withCompressionLevel(int x) {
        this.setCompressionLevel(x);
        return this;
    }

    public CompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public void setCompressionAlgorithm(CompressionAlgorithm x) {
        this.compressionAlgorithm = x != null ? x : CompressionAlgorithm.Uncompressed;
    }

    public Encryptor withCompressionAlgorithm(CompressionAlgorithm x) {
        this.setCompressionAlgorithm(x);
        return this;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithm x) {
        this.encryptionAlgorithm = x != null ? x : EncryptionAlgorithm.Unencrypted;
    }

    public Encryptor withEncryptionAlgorithm(EncryptionAlgorithm x) {
        this.setEncryptionAlgorithm(x);
        return this;
    }

    public HashingAlgorithm getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public void setSigningAlgorithm(HashingAlgorithm x) {
        this.signingAlgorithm = x != null ? x : HashingAlgorithm.Unsigned;
    }

    public Encryptor withSigningAlgorithm(HashingAlgorithm x) {
        this.setSigningAlgorithm(x);
        return this;
    }

    public char[] getSymmetricPassphraseChars() {
        return this.symmetricPassphraseChars;
    }

    public void setSymmetricPassphraseChars(char[] x) {
        if (x == null) {
            x = new char[]{};
        }
        if (!Arrays.equals(x, this.symmetricPassphraseChars)) {
            this.symmetricPassphraseChars = x;
            this.symmetricPassphrase = null;
        }
    }

    public Encryptor withSymmetricPassphraseChars(char[] x) {
        this.setSymmetricPassphraseChars(x);
        return this;
    }

    public String getSymmetricPassphrase() {
        if (this.symmetricPassphrase == null) {
            this.symmetricPassphrase = new String(this.symmetricPassphraseChars);
        }
        return this.symmetricPassphrase;
    }

    public void setSymmetricPassphrase(String x) {
        this.setSymmetricPassphraseChars(x != null ? x.toCharArray() : null);
        this.symmetricPassphrase = x;
    }

    public Encryptor withSymmetricPassphrase(String x) {
        this.setSymmetricPassphrase(x);
        return this;
    }

    public HashingAlgorithm getKeyDeriviationAlgorithm() {
        return this.keyDerivationAlgorithm;
    }

    public void setKeyDeriviationAlgorithm(HashingAlgorithm x) {
        this.keyDerivationAlgorithm = x != null ? x : HashingAlgorithm.Unsigned;
    }

    public Encryptor withDeriviationAlgorithm(HashingAlgorithm x) {
        this.setKeyDeriviationAlgorithm(x);
        return this;
    }

    public int getKeyDeriviationWorkFactor() {
        return this.keyDerivationWorkFactor;
    }

    public void setKeyDeriviationWorkFactor(int x) {
        this.keyDerivationWorkFactor = x;
    }

    public Encryptor withKeyDeriviationWorkFactor(int x) {
        this.setKeyDeriviationWorkFactor(x);
        return this;
    }

    public int getMaxFileBufferSize() {
        return this.maxFileBufferSize;
    }

    public void setMaxFileBufferSize(int maxFileBufferSize) {
        this.maxFileBufferSize = maxFileBufferSize;
    }

    public Encryptor withMaxFileBufferSize(int maxFileBufferSize) {
        this.setMaxFileBufferSize(maxFileBufferSize);
        return this;
    }

    public Ring getRing() {
        return this.ring;
    }

    public void setRing(Ring x) {
        this.ring = x != null ? x : new Ring();
    }

    public Encryptor withRing(Ring x) {
        this.setRing(x);
        return this;
    }

    public void clearSecrets() {
        this.ring.clearSecrets();
        Arrays.fill(this.symmetricPassphraseChars, '\u0000');
        this.symmetricPassphraseChars = new char[0];
        this.symmetricPassphrase = null;
    }

    public void encrypt(File plaintext, File ciphertext) throws IOException, PGPException {
        if (plaintext.equals(ciphertext)) {
            throw new IOException("cannot encrypt " + plaintext + " over itself");
        }
        if (ciphertext.delete()) {
            this.log.debug("encrypt({}) deleted {}", (Object)plaintext, (Object)ciphertext);
        }
        InputStream input = null;
        OutputStream output = null;
        try {
            int bestFileBufferSize = Util.bestFileBufferSize(plaintext.length(), this.maxFileBufferSize);
            input = new BufferedInputStream(new FileInputStream(plaintext), bestFileBufferSize);
            output = new BufferedOutputStream(new FileOutputStream(ciphertext), this.estimateOutFileSize(plaintext.length()));
            this.encrypt(input, output, new FileMetadata(plaintext));
        }
        catch (Exception e) {
            if (output != null) {
                try {
                    output.close();
                    ciphertext.delete();
                }
                catch (Exception ee) {
                    this.log.error("failed to delete bad output file " + plaintext, (Throwable)ee);
                }
            }
            throw e;
        }
        finally {
            try {
                output.close();
            }
            catch (Exception exception) {}
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
    }

    public void encrypt(InputStream plaintext, OutputStream ciphertext) throws IOException, PGPException {
        this.encrypt(plaintext, ciphertext, null);
    }

    public void encrypt(InputStream plaintext, OutputStream ciphertext, FileMetadata meta) throws IOException, PGPException {
        if (meta == null) {
            meta = new FileMetadata();
        }
        try (OutputStream targetStream = this.prepareCiphertextOutputStream(ciphertext, meta, false);){
            this.copy(plaintext, targetStream, null, meta);
        }
    }

    public OutputStream prepareCiphertextOutputStream(FileMetadata plainMeta, File ciphertext) throws IOException, PGPException {
        if (ciphertext.delete()) {
            this.log.debug("prepareCiphertextOutputStream - deleted {}", (Object)ciphertext);
        }
        try (FileOutputStream fileStream = null;){
            fileStream = new FileOutputStream(ciphertext);
            OutputStream wrapper = this.prepareCiphertextOutputStream(fileStream, plainMeta, true);
            fileStream = null;
            OutputStream outputStream = wrapper;
            return outputStream;
        }
    }

    public OutputStream prepareCiphertextOutputStream(OutputStream ciphertext, FileMetadata meta, boolean closeOriginal) throws IOException, PGPException {
        if (meta == null) {
            meta = new FileMetadata();
        }
        ArrayList<OutputStream> stack = new ArrayList<OutputStream>(6);
        stack.add(ciphertext);
        ciphertext = this.pipeline(this.armor(ciphertext, meta), stack);
        ciphertext = this.pipeline(this.encrypt(ciphertext, meta), stack);
        ciphertext = this.pipeline(this.compress(ciphertext, meta), stack);
        SigningOutputStream signingstream = this.sign(ciphertext, meta);
        ciphertext = this.pipeline(signingstream, stack);
        ciphertext = this.pipeline(this.packet(ciphertext, meta), stack);
        return new EncryptorWrapperStream(ciphertext, signingstream, stack, closeOriginal);
    }

    protected OutputStream pipeline(OutputStream out, List<OutputStream> stack) {
        if (out == null) {
            return stack.get(stack.size() - 1);
        }
        stack.add(out);
        return out;
    }

    protected OutputStream armor(OutputStream out, FileMetadata meta) {
        if (!this.isAsciiArmored()) {
            return null;
        }
        ArmoredOutputStream aos = new ArmoredOutputStream(out);
        if (this.isRemoveDefaultArmoredVersionHeader()) {
            aos.setHeader("Version", null);
        }
        this.armoredHeaders.forEach((name, value) -> aos.setHeader(name, value));
        EncryptedAsciiArmorHeadersCallback callback = this.getArmorHeadersCallback();
        if (callback != null) {
            EncryptedAsciiArmorHeadersManipulator manipulator = EncryptedAsciiArmorHeadersManipulator.wrap(aos);
            callback.prepareAsciiArmoredHeaders(this, meta, manipulator);
        }
        return aos;
    }

    protected OutputStream encrypt(OutputStream out, FileMetadata meta) throws IOException, PGPException {
        EncryptionAlgorithm encAlgo = this.getEncryptionAlgorithm();
        this.log.trace("using encryption algorithm {}", (Object)encAlgo);
        if (encAlgo == EncryptionAlgorithm.Unencrypted) {
            return null;
        }
        Ring encRing = this.getRing();
        List<Key> keys = encRing.getEncryptionKeys();
        char[] passChars = this.getSymmetricPassphraseChars();
        if (Util.isEmpty(keys) && Util.isEmpty(passChars)) {
            throw new PGPException("no suitable encryption key found");
        }
        PGPEncryptedDataGenerator generator = this.buildEncryptor();
        for (Key key : keys) {
            generator.addMethod((PGPKeyEncryptionMethodGenerator)this.buildPublicKeyEncryptor(key));
        }
        if (!Util.isEmpty(passChars)) {
            generator.addMethod((PGPKeyEncryptionMethodGenerator)this.buildSymmetricKeyEncryptor());
        }
        return generator.open(out, this.getEncryptionBuffer(meta));
    }

    protected OutputStream compress(OutputStream out, FileMetadata meta) throws IOException, PGPException {
        CompressionAlgorithm compAlgo = this.getCompressionAlgorithm();
        int compLevel = this.getCompressionLevel();
        this.log.trace("using compression algorithm {} - {}", (Object)compAlgo, (Object)compLevel);
        if (compAlgo == CompressionAlgorithm.Uncompressed || compLevel < 1 || compLevel > 9) {
            return null;
        }
        byte[] buf = this.getCompressionBuffer(meta);
        return new PGPCompressedDataGenerator(compAlgo.ordinal(), compLevel).open(out, buf);
    }

    protected OutputStream packet(OutputStream out, FileMetadata meta) throws IOException, PGPException {
        FileMetadata.Format fmt = meta.getFormat();
        char format = fmt.getCode();
        String name = meta.getName();
        Date date = meta.getLastModifiedDate();
        byte[] buf = this.getLiteralBuffer(meta);
        return new PGPLiteralDataGenerator().open(out, format, name, date, buf);
    }

    protected SigningOutputStream sign(OutputStream out, FileMetadata meta) throws IOException, PGPException {
        HashingAlgorithm sigAlg = this.getSigningAlgorithm();
        this.log.trace("using signing algorithm {}", (Object)sigAlg);
        if (sigAlg == HashingAlgorithm.Unsigned) {
            return null;
        }
        Ring encRing = this.getRing();
        List<Key> signers = encRing.getSigningKeys();
        for (int i = signers.size() - 1; i >= 0; --i) {
            Key key = signers.get(i);
            Subkey subkey = key.getSigning();
            if (this.isUsableForSigning(subkey)) continue;
            this.log.info("not using signing key {}", (Object)subkey);
            signers.remove(i);
        }
        if (Util.isEmpty(signers)) {
            throw new PGPException("no suitable signing key found");
        }
        return new SigningOutputStream(out, signers, meta);
    }

    protected void copy(InputStream i, OutputStream o, SigningOutputStream s, FileMetadata meta) throws IOException, PGPException {
        byte[] buf = this.getCopyBuffer(meta);
        int len = i.read(buf);
        while (len != -1) {
            if (s != null) {
                s.update(buf, 0, len);
            }
            o.write(buf, 0, len);
            len = i.read(buf);
        }
    }

    protected PGPEncryptedDataGenerator buildEncryptor() {
        EncryptionAlgorithm encAlgo = this.getEncryptionAlgorithm();
        BcPGPDataEncryptorBuilder builder = new BcPGPDataEncryptorBuilder(encAlgo.ordinal());
        builder.setWithIntegrityPacket(true);
        return new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)builder);
    }

    protected PublicKeyKeyEncryptionMethodGenerator buildPublicKeyEncryptor(Key key) {
        this.log.info("using encryption key {}", (Object)key.getEncryption());
        PGPPublicKey publicKey = key.getEncryption().getPublicKey();
        return new BcPublicKeyKeyEncryptionMethodGenerator(publicKey);
    }

    protected PBEKeyEncryptionMethodGenerator buildSymmetricKeyEncryptor() throws PGPException {
        HashingAlgorithm kdAlgorithm = this.getKeyDeriviationAlgorithm();
        int workFactor = this.getKeyDeriviationWorkFactor();
        this.log.info("using symmetric encryption with {} hash, work factor {}", (Object)kdAlgorithm, (Object)workFactor);
        return new BcPBEKeyEncryptionMethodGenerator(this.getSymmetricPassphraseChars(), new BcPGPDigestCalculatorProvider().get(kdAlgorithm.ordinal()), workFactor);
    }

    protected boolean isUsableForSigning(Subkey subkey) {
        return subkey != null && subkey.isForSigning() && (subkey.isUnlocked() || !Util.isEmpty(subkey.passphraseChars));
    }

    protected PGPSignatureGenerator buildSigner(Key key, FileMetadata meta) throws PGPException {
        Subkey subkey = key.getSigning();
        this.log.info("using signing key {}", (Object)subkey);
        PGPContentSignerBuilder builder = this.buildSignerBuilder(subkey.getPublicKey().getAlgorithm(), this.signingAlgorithm.ordinal());
        PGPSignatureGenerator generator = new PGPSignatureGenerator(builder);
        generator.init(meta.getSignatureType(), subkey.getPrivateKey());
        String uid = key.getSigningUid();
        if (!Util.isEmpty(uid)) {
            this.log.debug("using signing uid {}", (Object)uid);
            PGPSignatureSubpacketGenerator signer = new PGPSignatureSubpacketGenerator();
            signer.setSignerUserID(false, uid);
            generator.setHashedSubpackets(signer.generate());
        }
        return generator;
    }

    protected PGPContentSignerBuilder buildSignerBuilder(int keyAlgorithm, int hashAlgorithm) {
        return new BcPGPContentSignerBuilder(keyAlgorithm, hashAlgorithm);
    }

    protected byte[] getEncryptionBuffer(FileMetadata meta) {
        return new byte[this.bestPacketSize(meta)];
    }

    protected byte[] getCompressionBuffer(FileMetadata meta) {
        return new byte[this.bestPacketSize(meta)];
    }

    protected byte[] getLiteralBuffer(FileMetadata meta) {
        return new byte[this.bestPacketSize(meta)];
    }

    protected byte[] getCopyBuffer(FileMetadata meta) {
        int len;
        int n = len = meta == null ? 0 : (int)meta.getLength();
        if (len <= 0 || len > 65536) {
            len = 65536;
        }
        return new byte[len];
    }

    protected int bestPacketSize(FileMetadata meta) {
        int len = (int)meta.getLength();
        if (len > 0) {
            len += 300;
            len = 1 << 32 - Integer.numberOfLeadingZeros(len);
        }
        if (len <= 0 || len > 65536) {
            len = 65536;
        }
        return len;
    }

    protected int estimateOutFileSize(long inFileSize) {
        int maxBufSize = this.getMaxFileBufferSize();
        if (inFileSize >= (long)maxBufSize) {
            return maxBufSize;
        }
        long outFileSize = inFileSize;
        outFileSize += (long)((this.getRing().getEncryptionKeys().size() + this.getRing().getSigningKeys().size() + 1) * 512);
        if (this.isAsciiArmored()) {
            outFileSize = (long)((float)outFileSize * (1.3333334f * ((64.0f + (float)Strings.lineSeparator().length()) / 64.0f)));
            outFileSize += 80L;
        }
        return (int)Math.min(outFileSize, (long)maxBufSize);
    }

    protected class SigningOutputStream
    extends FilterOutputStream {
        protected final AtomicBoolean finished;
        protected FileMetadata meta;
        protected List<PGPSignatureGenerator> sigs;

        public SigningOutputStream(OutputStream out, List<Key> keys, FileMetadata meta) throws IOException, PGPException {
            super(out);
            this.finished = new AtomicBoolean(false);
            this.meta = meta;
            this.init(keys);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            if (this.finished.getAndSet(true)) {
                return;
            }
            this.flush();
            try {
                this.finish();
            }
            catch (PGPException e) {
                throw new IOException(e);
            }
        }

        public void update(byte[] b, int off, int len) {
            for (PGPSignatureGenerator sig : this.sigs) {
                sig.update(b, off, len);
            }
        }

        protected void init(List<Key> keys) throws IOException, PGPException {
            this.sigs = new ArrayList<PGPSignatureGenerator>(keys.size());
            for (Key key : keys) {
                this.sigs.add(Encryptor.this.buildSigner(key, this.meta));
            }
            for (int i = 0; i < this.sigs.size(); ++i) {
                boolean nested = i != this.sigs.size() - 1;
                PGPSignatureGenerator generator = this.sigs.get(i);
                PGPOnePassSignature encoder = generator.generateOnePassVersion(nested);
                encoder.encode(this.out);
            }
        }

        protected void finish() throws IOException, PGPException {
            for (int i = this.sigs.size() - 1; i >= 0; --i) {
                PGPSignatureGenerator generator = this.sigs.get(i);
                PGPSignature encoder = generator.generate();
                encoder.encode(this.out);
            }
        }
    }

    protected static class EncryptorWrapperStream
    extends FilterOutputStream {
        protected final AtomicBoolean finished = new AtomicBoolean(false);
        protected final SigningOutputStream signingstream;
        protected final List<? extends OutputStream> stack;
        protected final byte[] oneByte = new byte[]{0};
        protected final boolean closeInitialStream;

        protected EncryptorWrapperStream(OutputStream ciphertext, SigningOutputStream signer, List<? extends OutputStream> wrappers, boolean closeOriginal) {
            super(ciphertext);
            this.signingstream = signer;
            this.stack = wrappers;
            this.closeInitialStream = closeOriginal;
        }

        @Override
        public void write(int b) throws IOException {
            this.oneByte[0] = (byte)b;
            this.write(this.oneByte, 0, 1);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.signingstream != null) {
                this.signingstream.update(b, off, len);
            }
            this.out.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            if (this.finished.getAndSet(true)) {
                return;
            }
            this.flush();
            this.finish();
        }

        protected void finish() throws IOException {
            IOException err = null;
            int minIndex = this.closeInitialStream ? 0 : 1;
            for (int i = this.stack.size() - 1; i >= minIndex; --i) {
                OutputStream outputStream = this.stack.get(i);
                try {
                    outputStream.close();
                    continue;
                }
                catch (IOException e) {
                    if (err == null) {
                        err = e;
                        continue;
                    }
                    err.addSuppressed(e);
                }
            }
            if (err != null) {
                throw err;
            }
        }
    }
}

