/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.logging.Level;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.config.LogLevelValue;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.NullPrintStream;
import org.apache.sshd.common.util.logging.SimplifiedLog;
import org.apache.sshd.common.util.logging.SimplifiedLoggerSkeleton;
import org.slf4j.Logger;

public class CliLogger
extends SimplifiedLoggerSkeleton {
    public static final DateFormat LOG_TIME_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private static final long serialVersionUID = -3785762030194772776L;
    private static final NullPrintStream NULL_PRINT_STREAM = new NullPrintStream();
    protected final Level threshold;
    protected final PrintStream logStream;

    protected CliLogger(String name, Level threshold, PrintStream logStream) {
        super(name);
        this.threshold = threshold;
        this.logStream = logStream;
    }

    public boolean isEnabledLevel(Level level) {
        return SimplifiedLog.isLoggable((Level)level, (Level)this.threshold);
    }

    public void log(Level level, Object msg, Throwable err) {
        if (this.isEnabledLevel(level)) {
            CliLogger.log(this.logStream, level, msg, err);
        }
    }

    public static void log(PrintStream logStream, Level level, Object msg) {
        CliLogger.log(logStream, level, msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(PrintStream logStream, Level level, Object msg, Throwable err) {
        String time;
        Date now = new Date();
        DateFormat dateFormat = LOG_TIME_FORMATTER;
        synchronized (dateFormat) {
            time = LOG_TIME_FORMATTER.format(now);
        }
        logStream.append(time).append(' ').append(level.getName()).append(' ').append(Thread.currentThread().getName()).append(' ').append(Objects.toString(msg)).println();
        CliLogger.printStackTrace(logStream, err);
    }

    public static Level resolveLoggingVerbosity(PropertyResolver resolver, String ... args) {
        String levelValue = PropertyResolverUtils.getString((PropertyResolver)resolver, (String)"LogLevel");
        if (GenericUtils.isEmpty((CharSequence)levelValue)) {
            return CliLogger.resolveLoggingVerbosity(args);
        }
        LogLevelValue level = LogLevelValue.fromName((String)levelValue);
        if (level == null) {
            throw new IllegalArgumentException("Unknown LogLevel option value: " + levelValue);
        }
        return level.getLoggingLevel();
    }

    public static Level resolveLoggingVerbosity(String ... args) {
        return CliLogger.resolveLoggingVerbosity(args, GenericUtils.length((Object[])args));
    }

    public static Level resolveLoggingVerbosity(String[] args, int maxIndex) {
        for (int index = 0; index < maxIndex; ++index) {
            String argName = args[index];
            if ("-v".equals(argName)) {
                return Level.INFO;
            }
            if ("-vv".equals(argName)) {
                return Level.FINE;
            }
            if (!"-vvv".equals(argName)) continue;
            return Level.FINEST;
        }
        return Level.CONFIG;
    }

    public static Logger resolveSystemLogger(Class<?> clazz, Level threshold) {
        return CliLogger.resolveSystemLogger(clazz.getName(), threshold);
    }

    public static Logger resolveSystemLogger(String name, Level threshold) {
        return CliLogger.resolveLogger(name, threshold, System.out, System.err);
    }

    public static Logger resolveLogger(Class<?> clazz, Level threshold, PrintStream stdout, PrintStream stderr) {
        return CliLogger.resolveLogger(clazz.getSimpleName(), threshold, stdout, stderr);
    }

    public static Logger resolveLogger(String name, Level threshold, PrintStream stdout, PrintStream stderr) {
        PrintStream logStream = CliLogger.resolvePrintStream(threshold, stdout, stderr);
        return CliLogger.getLogger(name, threshold, logStream);
    }

    public static boolean showError(PrintStream stderr, String message) {
        stderr.append("ERROR: ").println(message);
        return true;
    }

    public static boolean isEnabledVerbosityLogging(Level level) {
        return level != null && !Level.OFF.equals(level) && !Level.CONFIG.equals(level) && !Level.SEVERE.equals(level) && !Level.WARNING.equals(level);
    }

    public static PrintStream resolvePrintStream(Level threshold, PrintStream stdout, PrintStream stderr) {
        if (CliLogger.isEnabledVerbosityLogging(threshold)) {
            return Level.INFO.equals(threshold) ? stderr : stdout;
        }
        return NULL_PRINT_STREAM;
    }

    public static <T extends Throwable> T printStackTrace(Appendable out, T reason) {
        if (reason == null || out == null) {
            return reason;
        }
        if (out instanceof PrintStream) {
            reason.printStackTrace((PrintStream)out);
        } else if (out instanceof PrintWriter) {
            reason.printStackTrace((PrintWriter)out);
        }
        return reason;
    }

    public static Logger getSystemLogger(Class<?> clazz, Level threshold) {
        return CliLogger.getSystemLogger(clazz.getName(), threshold);
    }

    public static Logger getSystemLogger(String name, Level threshold) {
        return CliLogger.getLogger(name, threshold, CliLogger.resolveSystemPrintStream(threshold));
    }

    public static PrintStream resolveSystemPrintStream(Level threshold) {
        return CliLogger.resolvePrintStream(threshold, System.out, System.err);
    }

    public static Logger getLogger(Class<?> clazz, Level threshold, PrintStream logStream) {
        return CliLogger.getLogger(clazz.getSimpleName(), threshold, logStream);
    }

    public static Logger getLogger(String name, Level threshold, PrintStream logStream) {
        return threshold == null || Level.OFF.equals(threshold) ? SimplifiedLoggerSkeleton.EMPTY : new CliLogger(name, threshold, logStream);
    }
}

