/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.Future;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.netty.NettyIoAcceptor;
import org.apache.sshd.netty.NettyIoConnector;

public class NettyIoServiceFactory
extends AbstractCloseable
implements IoServiceFactory {
    protected final EventLoopGroup eventLoopGroup;
    protected final boolean closeEventLoopGroup;
    private IoServiceEventListener eventListener;

    public NettyIoServiceFactory() {
        this(null);
    }

    public NettyIoServiceFactory(EventLoopGroup group) {
        this.eventLoopGroup = group != null ? group : new NioEventLoopGroup();
        this.closeEventLoopGroup = group == null;
    }

    public IoServiceEventListener getIoServiceEventListener() {
        return this.eventListener;
    }

    public void setIoServiceEventListener(IoServiceEventListener listener) {
        this.eventListener = listener;
    }

    public IoConnector createConnector(IoHandler handler) {
        return new NettyIoConnector(this, handler);
    }

    public IoAcceptor createAcceptor(IoHandler handler) {
        return new NettyIoAcceptor(this, handler);
    }

    protected CloseFuture doCloseGracefully() {
        if (this.closeEventLoopGroup) {
            Future shutdownFuture = this.eventLoopGroup.shutdownGracefully();
            shutdownFuture.addListener(fut -> this.closeFuture.setClosed());
        } else {
            this.closeFuture.setClosed();
        }
        return this.closeFuture;
    }

    protected void doCloseImmediately() {
        this.doCloseGracefully();
        super.doCloseImmediately();
    }
}

